#include "dc_client.h"

static unsigned char right=0;	/* Socket of the person on our right */
static unsigned char left=0;	/* Socket of the person on our left */
static unsigned char conn=0;	/* Socket we receive new connections in */

void main (int argc, char **argv)
{
    int retval, first=0;
    struct sockaddr_in tmpsock;
    struct hostent *tmphostent;
    int c;
    extern char *optarg;
    extern int optind;
    int connect_port = 0;
    char right_partner[256];
    int right_port = 0;
    char left_partner[256];
    int left_port = 0;
    int errflg = 0;
    char tmpstr[256];
    int nbytes;
    unsigned char temp;

    clock();
    sigignore( SIGPIPE );

    while ((c = getopt (argc, argv, "fp:r:l:")) != EOF)
    {
	switch (c)
	{
	    case 'p':
		connect_port = atoi (optarg);
		break;
	    case 'l':
		strcpy( left_partner, optarg );
		break;
	    case 'r':
		strcpy( right_partner, optarg );
		break;
	    case 'f':
		first = 1;
		break;
	    case '?':
		errflg++;
	}
    }

    if (errflg)
    {
	printf ("usage: cmd [-p <port>] -r <right machine:port>"
		"-l <left machine:port> -f\n");
	exit (2);
    }

    if( connect_port == 0 )
	connect_port=6389;
    tmpsock.sin_family = AF_INET;
    tmpsock.sin_addr.s_addr = INADDR_ANY;
    tmpsock.sin_port = (unsigned short)connect_port;

    /* Open connections socket */
    retval = socket (AF_INET, SOCK_STREAM, 0);
    if ( retval == -1 )
    {
	printf ("Socket opening error occured!\n");
	cleanup( 10 );
    }
    conn = retval;

    retval = bind (conn, (struct sockaddr *) &tmpsock,
	    sizeof (tmpsock));
    if (retval != 0)
    {
	printf ("Bind failed: %d!  Try another port >5000.\n", errno);
	cleanup( 10 );
    }

    retval = listen( conn, 32 );
    if( retval == -1 )
    {
	printf( "Listen failed: %d!\n", errno );
	cleanup( 10 );
    }

    /* Set non-blocking */
    retval = fcntl( conn, F_SETFL,
	    fcntl( conn, F_GETFL ) | O_NONBLOCK );
    if( retval == -1 )
    {
	printf( "Fcntl failed: %d!\n", errno );
	cleanup( 10 );
    }

    if( first == 0 )
    {
	/* Connect to right host */
	strcpy( tmpstr, strchr(right_partner,':') );
	right_port = atoi( &tmpstr[1] );
	strchr(right_partner,':')[0] = '\0';
	tmphostent = gethostbyname( right_partner );
	if( tmphostent == NULL )
	{
	    printf( "Could not find host for right partner: %d!\n",errno);
	    cleanup( 10 );
	}
	(&tmpsock)->sin_addr.s_addr = *(unsigned long *)tmphostent->h_addr;
	(&tmpsock)->sin_port = (unsigned short)right_port;

	/* Open right partner socket */
	retval = socket (PF_INET, SOCK_STREAM, 0);
	if (retval == -1)
	{
	    printf ("Socket opening error occured!\n");
	    cleanup( 10 );
	}
	right = retval;
	retval = connect( right, (struct sockaddr *)&tmpsock, 
		sizeof( tmpsock ) );
	if( retval == -1 )
	{
	    printf( "Connection to right partner failed: %d!\n", errno );
	    cleanup( 10 );
	}

	printf( "Right machine: %lu, port: %hu.\n",
		(unsigned long)(&tmpsock)->sin_addr.s_addr, 
		(&tmpsock)->sin_port );
	temp = NEW_RIGHT;
	nbytes = write( right, &temp, 1 );
	if( nbytes <= 0 )
	{
	    printf( "Write failed, possible network error: %d?\n", errno );
	    cleanup( 10 );
	}


	/* Connect to left host */
	strcpy( tmpstr, strchr(left_partner,':') );
	left_port = atoi( &tmpstr[1] );
	strchr(left_partner,':')[0] = '\0';
	tmphostent = gethostbyname( left_partner );
	if( tmphostent == NULL )
	{
	    printf( "Could not find host for left partner: %d!\n",errno);
	    cleanup( 10 );
	}
	(&tmpsock)->sin_addr.s_addr = *(unsigned long *)tmphostent->h_addr;
	(&tmpsock)->sin_port = (unsigned short)left_port;

	/* Open left partner socket */
	retval = socket (PF_INET, SOCK_STREAM, 0);
	if (retval == -1)
	{
	    printf ("Socket opening error occured!\n");
	    cleanup( 10 );
	}
	left = retval;
	retval = connect( left, (struct sockaddr *)&tmpsock, 
		sizeof( tmpsock ) );
	if( retval == -1 )
	{
	    printf( "Connection to left partner failed: %d!\n", errno );
	    cleanup( 10 );
	}

	printf( "Left machine: %lu, port: %hu.\n",
		(unsigned long)(&tmpsock)->sin_addr.s_addr, 
		(&tmpsock)->sin_port );
	temp = NEW_LEFT;
	nbytes = write( left, &temp, 1 );
	if( nbytes <= 0 )
	{
	    printf( "Write failed, possible network error: %d?\n", errno );
	    cleanup( 10 );
	}
    }

    main_loop( first );

    cleanup( 0 );
}

void main_loop( unsigned char first )
{
    int nbytes, temp;
    unsigned char in_byte,type;
    unsigned char flipped=0,flip;
    unsigned char left_coin;
    unsigned char IV;
    unsigned char new=0;	/* Pointer to a new connection */
    unsigned char sent_reset = 0;
    int retval;
    unsigned char working_total=0,total=0,sent_total=0;
    struct sockaddr_in tmpsock;

    srand48( clock()^time(NULL) );

    /* Set blocking */
    retval = fcntl( right, F_SETFL,
	    fcntl( right, F_GETFL ) & ~O_NONBLOCK & ~O_NDELAY );
    if( retval == -1 )
    {
	printf( "Fcntl failed: %d!\n", errno );
	cleanup( 10 );
    }
    /* Set blocking */
    retval = fcntl( left, F_SETFL,
	    fcntl( left, F_GETFL ) & ~O_NONBLOCK & ~O_NDELAY );
    if( retval == -1 )
    {
	printf( "Fcntl failed: %d!\n", errno );
	cleanup( 10 );
    }
    /* Set stdin non-blocking */
    retval = fcntl( 0, F_SETFL,
	    fcntl( 0, F_GETFL ) | O_NONBLOCK | O_NDELAY );
    if( retval == -1 )
    {
	printf( "Fcntl failed: %d!\n", errno );
	cleanup( 10 );
    }

    while( 1 )
    {
	/* Test for new connections */
	temp = sizeof( tmpsock );
	retval = accept( conn, 
		(struct sockaddr *)&tmpsock, &temp );
	if( retval != -1 )
	{
	    printf( "New connection made.\n");
	    new = retval;
	    /* Set blocking */
	    retval = fcntl( new, F_SETFL,
		    fcntl( new, F_GETFL ) & ~O_NONBLOCK & ~O_NDELAY );
	    if( retval == -1 )
	    {
		printf( "Fcntl failed: %d!\n", errno );
		cleanup( 10 );
	    }
	}

	/* If we haven't made connections */
	if( left == 0 || right == 0 || new > 0 )
	{
	    if( new == 0 )
	    {
		sleep( 3 );
		continue;
	    }
	    else
	    {
		nbytes = read( new, (char *)&type, 1 );
		if( nbytes <= 0 )
		{
		    printf( "Read new failed, possible network error: %d.\n", 
			    errno );
		    cleanup( 10 );
		}
		/* Set non-blocking */
		retval = fcntl( conn, F_SETFL,
			fcntl( conn, F_GETFL ) | O_NONBLOCK | O_NDELAY );
		if( retval == -1 )
		{
		    printf( "Fcntl failed: %d!\n", errno );
		    cleanup( 10 );
		}
	    }
	}
	else
	{
	    /* Start things off */
	    if( first )
	    {
		if( flipped == 0 )
		{
		    send_flip( &flip );
		    flipped=1;
		}
		else
		{
		    if( working_total == 0 )
		    {
			total = IV;
			mod_from_input( &total, first );
			send_working_total( total );
			working_total = 1;
		    }
		    else
		    {
			if( sent_total == 0 )
			{
			    send_total( total );
			    add_to_output( total );
			    sent_total = 1;
			}
		    }
		}
	    }

	    if( left == 0 || right == 0 || new > 0 )
		continue;

	    nbytes = read( left, (char *)&type, 1 );
	    if( nbytes <= 0 )
	    {
		printf( "Read left failed, possible network error: %d.\n", 
			errno );
		left = 0;
		continue;
	    }

	    /* Get the data byte: no-one sends more than a byte right now */
	    nbytes = read( left, (char *)&in_byte, 1 );
	    if( nbytes <= 0 )
	    {
		printf( "Read left failed, possible network error: %d?\n", 
			errno );
		left = 0;
		continue;
	    }

	}

	if( (left == 0 || right == 0) && new == 0 )
	    continue;

	/* Process the message */
	switch( type )
	{
	    case YOURE_FIRST:
		first = 1;
		flipped = 0;
		working_total = 0;
		sent_total = 0;
		break;
	    case DISCONN:
		printf( "Left host disconnected.\n" );
		/* Get left host address and port */
		nbytes = read( left, &(&tmpsock)->sin_addr.s_addr, 
			sizeof( (&tmpsock)->sin_addr.s_addr )  );
		if( nbytes <= 0 )
		{
		    printf( "1Write failed, possible network error: %d?\n", errno );
		    right = 0;
		}

		nbytes = read( left, (unsigned short *)&(&tmpsock)->sin_port,
			sizeof( unsigned short ) );
		if( nbytes <= 0 )
		{
		    printf( "2Write failed, possible network error: %d?\n", errno );
		    right = 0;
		}

		printf( "Left machine: %lu, port: %d.\n",
			(unsigned long)(&tmpsock)->sin_addr.s_addr, 
			(&tmpsock)->sin_port );

		if( left > 0 )
		{
		    printf( "Closing left connection.\n");
		    close( left );
		}

		/* Connect to left host */
		tmpsock.sin_family = AF_INET;

		/* Open left partner socket */
		retval = socket (PF_INET, SOCK_STREAM, 0);
		if (retval == -1)
		{
		    printf ("Socket opening error occured!\n");
		    cleanup( 10 );
		}
		left = retval;
		retval = connect( left, (struct sockaddr *)&tmpsock, 
			sizeof( tmpsock ) );
		if( retval == -1 )
		{
		    printf( "Connection to left partner failed: %d!\n", errno );
		    cleanup( 10 );
		}

		printf( "New left partner.\n");
		type = NEW_LEFT;
		nbytes = write( left, &type, 1 );
		if( nbytes <= 0 )
		{
		    printf( "3Write failed, possible network error: %d?\n", errno );
		    cleanup( 10 );
		}
		printf( "Sending reset.\n");
		send_right( RESET, 0 );
		sent_reset++;
		flipped = 0;
		working_total = 0;
		sent_total = 0;
		break;
	    case RESET:
		flipped = 0;
		working_total = 0;
		sent_total = 0;
		if( sent_reset == 2 )
		{
		    printf( "Received extra reset, ignored.\n" );
		    sent_reset = 0;
		    break;
		}
		printf( "Received reset, waiting.\n" );
		sleep( 3 );
		printf( "Sending reset.\n");
		send_right( RESET, 0 );
		sent_reset++;
		printf( "Done waiting.\n" );
		break;
	    case NEW_RIGHT:
		printf( "Found a new left partner!\n");
		if( left > 0 )
		    close( left );
		left = new;
		/* Set blocking */
		retval = fcntl( left, F_SETFL,
			fcntl( left, F_GETFL ) & ~O_NONBLOCK & ~O_NDELAY );
		if( retval == -1 )
		{
		    printf( "Fcntl failed: %d!\n", errno );
		    cleanup( 10 );
		}
		new = 0;
		flipped = 0;
		working_total = 0;
		sent_total = 0;
		printf( "Sending reset.\n");
		send_right( RESET, 0 );
		sent_reset++;
		temp = sizeof( tmpsock );
		getpeername( left, (struct sockaddr *)&tmpsock, &temp );
		printf( "Left machine: %lu, port: %hu.\n",
			(unsigned long)(&tmpsock)->sin_addr.s_addr, 
			(&tmpsock)->sin_port );
		break;
	    case NEW_LEFT:
		printf( "Found a new right partner!\n");
		if( right > 0 )
		    close( right );
		right = new;
		/* Set blocking */
		retval = fcntl( right, F_SETFL,
			fcntl( right, F_GETFL ) & ~O_NONBLOCK & ~O_NDELAY );
		if( retval == -1 )
		{
		    printf( "Fcntl failed: %d!\n", errno );
		    cleanup( 10 );
		}
		new = 0;
		flipped = 0;
		working_total = 0;
		sent_total = 0;
		printf( "Sending reset.\n");
		send_right( RESET, 0 );
		sent_reset++;
		getpeername( right, (struct sockaddr *)&tmpsock, &temp );
		printf( "Right machine: %lu, port: %hu.\n",
			(unsigned long)(&tmpsock)->sin_addr.s_addr, 
			(&tmpsock)->sin_port );
		break;
	    case MY_COIN: 
		left_coin = in_byte;
		if( flipped == 0 )	send_flip( &flip );
		flipped=1;
		/*printf("Left coins: %x, My coins: %x.\n",left_coin,flip);*/

		IV=left_coin^flip;
		/*printf("Initial IV: %x.\n",IV);*/
		if( first == 1 )
		{
		    /*printf( "Got coin back. Next stage.\n" );*/
		}
		break;
	    case WORKING_TOTAL:
		if( working_total == 0 )
		{
		    /*printf("Received working total: %d.\n", in_byte );*/
		    total = IV^in_byte;
		    mod_from_input( &total, first );
		    send_working_total( total );
		    working_total = 1;
		}
		else
		{
		    if( first == 0 )
		    {
			printf( "Got two working totals! Somthing's wrong!\n");
			cleanup( 10 );
		    }
		    else
		    {
			total = in_byte;
			/*printf( "Got working total back. Next stage.\n" );*/
		    }
		}
		break;
	    case TOTAL:
		sent_reset=0;
		if( sent_total == 0 )
		{
		    total=in_byte;
		    /*printf("Received total: %d.\n",total);*/
		    send_total( total );
		    add_to_output( total );
		    flipped = 0;
		    working_total = 0;
		}
		else
		{
		    if( first == 0 )
		    {
			printf( "Got two totals! Somthing's wrong!\n");
			cleanup( 10 );
		    }
		    else
		    {
			/*printf( "Got total back. Restarting.\n" );*/
			flipped = 0;
			working_total = 0;
			sent_total = 0;
		    }
		}
		break;
	    default:
		printf( "Message type unknown: %d.\n", type );
		break;
	}
    }
}

void send_flip( unsigned char *flip )
{
    *flip = lrand48()&255;

    send_right( MY_COIN, *flip );
};

void send_right( unsigned char type, unsigned char val )
{
    int nbytes;

    /*printf( "Sending %d,%d.\n", type, val );*/
    nbytes = write( right, &type, 1 );
    if( nbytes <= 0 )
    {
	printf( "4Write failed, possible network error: %d?\n", errno );
	right = 0;
	return;
    }

    nbytes = write( right, &val, 1 );
    if( nbytes <= 0 )
    {
	printf( "5Write failed, possible network error: %d?\n", errno );
	right = 0;
	return;
    }
}

void send_working_total( unsigned char total )
{
    /*printf("Sending working total: %d.\n", total);*/
    send_right( WORKING_TOTAL, total );
}
void send_total( unsigned char total )
{
    /*printf("Sending total: %d.\n", total);*/
    send_right( TOTAL, total );
}

void mod_from_input( unsigned char *total, int first )
{
    static unsigned char input=0;
    int num;

    /* Read a byte of input, if available and nescessary */
    if( input == 0 )
    {
	num = read( 0, &input, 1 );
	if( num <= 0 )
	{
	    /* No input to work from, continue */
	    return;
	}
	if( input == 'X' )
	    disconnect( first );
    }

    /* XOR the byte of input into total */
    *total = *total^input;

    /*printf( "Input: %d.\n", input );*/
    input = 0;
}

void add_to_output( unsigned char total )
{
    int num;

    /* Something sent */
    if( total > 0 )
    {
	/*printf("total: %d.\n",total);*/
	num = write( 1, &total, 1 );
	if( num <= 0 )
	{
	    printf( "Stdout write error: %d!\n", errno );
	}
    }
}

void disconnect( int first )
{
    struct sockaddr_in tmpsock;
    int temp, retval, nbytes;

    send_right( DISCONN, 0 );

    /* Get left host address and port */
    temp = sizeof( tmpsock );
    retval = getpeername( left, (struct sockaddr *)&tmpsock, &temp );
    printf( "Sending machine: %lu, port: %hu.\n",
	    (unsigned long)(&tmpsock)->sin_addr.s_addr, 
	    (&tmpsock)->sin_port );
    if( retval == -1 )
    {
	printf( "Could not find host for left partner: %d!\n",errno);
	cleanup( 10 );
    }

    nbytes = write( right, &(&tmpsock)->sin_addr.s_addr, 
	    sizeof( (&tmpsock)->sin_addr.s_addr )  );
    if( nbytes <= 0 )
    {
	printf( "6Write failed, possible network error: %d?\n", errno );
	right = 0;
    }

    nbytes = write( right, (unsigned short *)&(&tmpsock)->sin_port,
	    sizeof( unsigned short ) );
    if( nbytes <= 0 )
    {
	printf( "7Write failed, possible network error: %d?\n", errno );
	right = 0;
    }

    if( first == 1 )
    {
	send_right( YOURE_FIRST, 0 );
    }

    cleanup(0);
}

void cleanup( int retval )
{
    printf( "Exiting!\n" );

    /* Set stdin blocking */
    retval = fcntl( 0, F_SETFL,
	    fcntl( 0, F_GETFL ) & ~O_NONBLOCK & ~O_NDELAY );
    if( retval == -1 )
    {
	printf( "Fcntl failed: %d!\n", errno );
	cleanup( 10 );
    }

    if( conn != 0 )
	close( conn );
    if( right != 0 )
	close( right );
    if( left != 0 )
	close( left );
    exit( retval );
}
