#!/usr/bin/env rune

# Copyright 2002 Combex, Inc. under the terms of the MIT X license
# found at http://www.opensource.org/licenses/mit-license.html ................

def leaves := <import:org.erights.e.tools.files.leaves>

/**
 * Change method-signature-based anchors to remove the spaces after
 * the argument-separating commas, in order to turn the URLs that
 * reference these anchors into more standards-conforming URLs.
 * <p>
 * These still aren't standards conforming, in that anchors may not
 * contain square brackets, but the anchors generated by javadoc use
 * these to represent "array of", and fixdoc.e doesn't currently
 * change it to something else.
 */
def fixAnchors(var text) :any {
    def result := "".diverge(char)
    while (text =~ `@left<A @attr="@value">@body</A>@right`) {
        def newValue := value.replaceAll(", ", ",")
        def legacyValue := value.replaceAll(", ", ",%20")
        result.append(switch (attr.toLowerCase()) {
            match `href` {
                `$left<A $attr="$newValue"$\n>$body</A>`
            }
            match `name` {
                `$left<A $attr="$newValue"
><A $attr="$legacyValue"
><A $attr="$value"
>$body</A></A></A>`
            }
        })
        text := right
    }
    result.append(text)
    result.snapshot()
}

/**
 * Give all erights javadoc pages the standard erights background
 */
def fix(filedir, level) :void {
    if (filedir.isDirectory()) {
        def subLevel := level+1
        stderr.lnPrint(`${" " * subLevel}${filedir.getName()}`)
        for sub in filedir {
            fix(sub, subLevel)
        }
    } else if (filedir.getName() =~ `@_.html`) {
        var text := filedir.getText()
        text := text.replaceAll("BODY BGCOLOR=\"white\"",
                                "BODY BGCOLOR=\"#FFEEDD\"")
        def buf := "".diverge(char)
        for line in text.split("\n") {
            if (line =~ `@{left}help-doc.html"><@pre>Help<@post></A>@right`) {
                buf.append(
`${left}help-doc.html"><$pre>Help<$post></A>$right
${left}../elib/legacy/api-legend.html"
><$pre><font color="#009000"><i>Legend</i></font><$post></A>$right
`)
            } else {
                buf.append(line)
                buf.append("\n")
            }
        }
        text := buf.snapshot()
        # Should no longer be necessary, except for headers and footers
        text := text.replaceAll("{@docroot}/",
                                "../" * level)
        text := fixAnchors(text)
        filedir.setText(text)
        stderr.print(".")
    }
}

for path in interp.getArgs() {
    def root := <file: path>
    def style := root["stylesheet.css"]
    style.setText(style.getText().replaceAll("-color: #FFFFFF",
                                             "-color: #FFEEDD"))
    fix(root, -1)
}
