#!/bin/sh

IFS='
'

run_sentence ()
{
    orig_sentence=$1

    sentence=`echo $orig_sentence | sed -e 's/GOOD/[032mGOOD[000m/' -e 's/BAD/[032mBAD[000m/'`
#    echo -n "*** Sentence: $sentence  "
    sentence=`echo $sentence | sed 's/.--..*//'`

    echo $sentence > /tmp/orig_sentence.$$
    echo $sentence | tr -dc "a-zA-Z'" | tr 'A-Z' 'a-z' > /tmp/orig_sentence.$$.2

    java_text_orig=`cat /tmp/orig_sentence.$$ | ~/bin/myparser -s -b`
    echo "$java_text_orig" | \
	tail -1 | sed -e 's/[a-zA-Z0-9]*=//g' | tr -d "()[]" | \
	sed -e 's/[         ][      ]*/ /g' > /tmp/javaout.$$
    diff -w /tmp/javaout.$$ /tmp/orig_sentence.$$ 2>&1 >/dev/null
    javares_orig=$?

    java_text_exp=`cat /tmp/orig_sentence.$$ | \
    /usr/local/java/bin/java -jar /tmp/exp.jar -s -b /dev/stdin`
    echo "$java_text_exp" | \
	tail -1 | sed -e 's/[a-zA-Z0-9]*=//g' | tr -d "()[]" | \
	sed -e 's/[         ][      ]*/ /g' > /tmp/javaout.$$
    diff -w /tmp/javaout.$$ /tmp/orig_sentence.$$ 2>&1 >/dev/null
    javares_exp=$?

#    echo "Sentence: $orig_sentence  "
#    echo "$javares_orig:$javares_exp"

    echo "$java_text_exp" >/tmp/javaout_exp.$$
    echo "$java_text_orig" >/tmp/javaout_orig$$

#	echo "Orig: `cat /tmp/javaout_orig$$`
#Expr: `cat /tmp/javaout_exp.$$`
#"
    if [ "`diff /tmp/javaout_exp.$$ /tmp/javaout_orig$$`" ]
    then
	good=0
    else
	good=1
    fi

    # If not good
    if [ $good -ne 1 ]
    then
	echo -n "*** Sentence: $orig_sentence  "
	echo "$javares_orig:$javares_exp"
	echo "MISMATCH!"
	echo "Orig: `cat /tmp/javaout_orig$$`
Expr: `cat /tmp/javaout_exp.$$`
"
    echo -n "Diff: "
    diff /tmp/javaout_exp.$$ /tmp/javaout_orig$$
    echo

    fi

    rm -f /tmp/parserout.*
    rm -f /tmp/fishout.*
    rm -f /tmp/javaout.*
}

for sentence in `cat ../test_sentences.txt`
do
    sentence=`echo $sentence | tr -d '()'`
    if [ "`echo $sentence | grep '[[]'`" ]
    then
	sentence_with=`echo $sentence | tr -d '[]'`
	sentence_with="$sentence_with -- WITH"
	sentence_without=`echo $sentence | sed 's/[[][^]]*[]] *//g'`
	sentence_without="$sentence_without -- WITHOUT"
	run_sentence $sentence_with
	run_sentence $sentence_without

	sentence_dots=`echo $sentence_with | tr ' ' '.'`
	sentence_dots="$sentence_dots -- DOTS"
	# Maybe try this again later
	##run_sentence $sentence_dots
    else
	run_sentence $sentence

	sentence_dots=`echo $sentence | tr ' ' '.'`
	sentence_dots="$sentence_dots -- DOTS"
	# Maybe try this again later
	##run_sentence $sentence_dots
    fi
done

