#!/usr/bin/perl -0p

sub make_big_latex
{
    $orig = $1;

    $latex = `echo "$orig" | myparser -l | tail -1`;

    $latex =~ s/^\s*\$/\\begin{displaymath}\n/gs;
    $latex =~ s/\$\s*$/\\footnote{$orig}\n\\end{displaymath}/gs;
    $latex =~ s/\$(.*?)\$/\\mbox{\1}/gs;

    return $latex;
}

sub make_latex
{
    $orig = $1;

    $latex = `echo "$orig" | myparser -l | tail -1`;
    $latex =~ s/\n$//sg;

    return "$latex\\footnote{$orig}";
}

s/\\jbomath\{([^}]*)}/make_latex($1);/esg;
s/\\jbobigmath\{([^}]*)}/make_big_latex($1);/esg;

