#!/usr/bin/zsh

IFS='
'

### Testing actual parses:
# echo <sentence> | myparser -f | sed 's/[^ ]*=//g' | sed "s/(\( *[a-z']* *\))/\1/g" | sed -e 's/^ ( //' -e 's/ ) $//' -e 's/  */ /g' -e 's/( /(/g' -e 's/ )/)/g' | grep '^\(' >\!/tmp/s2
# echo <sentence> | parser -e | tr '{}[]<>' '()()()' | tr -d '\n' >\!/tmp/s1; echo >>/tmp/s1
# echo <sentence> | jbofihe | tr '{}[]<>' '()()()' | sed -e ': label;s/(\([0-9]\)\(.*\))\1/(\2)/g;t label' -e 's/^(//' -e 's/)$//' >\!/tmp/s3

parse_diff ()
{
    parserres=$1
    fishres=$2
    javares=$3

    orig_sentence=$4

    sentence=`echo $orig_sentence | sed -e 's/GOOD/[032mGOOD[000m/' -e 's/BAD/[032mBAD[000m/'`
#    echo "*** Sentence: $sentence  "
    sentence=`echo $sentence | sed 's/.--..*//'`

    # If both the official parser and the java parser liked the sentence:
    if [ $parserres == 0 -a $javares == 0 ]
    then
	parser_tree $sentence
	java_tree $sentence

	diff -w -i /tmp/parser_tree.$$ /tmp/java_tree.$$ 
	diffres=$?

	if [ $diffres -ne 0 ]
	then
	    echo "Official and Java disagree.  Sentence was: $sentence"
	fi
    fi

    # If both jbofihe and the java parser liked the sentence:
    if [ $fishres == 0 -a $javares == 0 ]
    then
	fish_tree $sentence
	java_tree $sentence

	diff -w -i /tmp/fish_tree.$$ /tmp/java_tree.$$
	diffres=$?

	if [ $diffres -ne 0 ]
	then
	    echo "jbofihe and Java disagree.  Sentence was: $sentence"
	fi
    fi
}

parser_tree ()
{
    echo $1 | parser -e 2>/dev/null | tr '{}[]<>' '()()()' | \
    tr -d '\n' | \
    sed -e '/^ *[^(]/{s/^/(/;s/$/)/}' \
    >/tmp/parser_tree.$$
    echo >>/tmp/parser_tree.$$
}

fish_tree ()
{
    echo $1 | jbofihe 2>/dev/null | tr '{}[]<>' '()()()' | tr -d '\n' | \
    sed -e ': label;s/(\([0-9]\)\(.*\))\1/(\2)/g;t label' -e 's/^(//' \
    -e 's/)$//' | \
    sed -e '/^ *[^(]/{s/^/(/;s/$/)/}' \
    >/tmp/fish_tree.$$
    echo >>/tmp/fish_tree.$$
}

java_tree ()
{
    #### WARNING: SLOW.  Try to fix with coproc (see man zshall)
    echo $1 | myparser -f | sed 's/[^ ]*=//g' | \
    sed "s/(\( *[a-zA-Z']* *\))/\1/g" | sed -e 's/^ ( //' \
    -e 's/ ) $//' -e 's/  */ /g' -e 's/( /(/g' -e 's/ )/)/g' | \
    grep -v '^Flat layout' | grep -v 'Processing /dev/stdin' | \
    sed -e '/^ *[^(]/{s/^/(/;s/$/)/}' \
    >/tmp/java_tree.$$
}


run_sentence ()
{
    orig_sentence=$1

    sentence=`echo $orig_sentence | sed -e 's/GOOD/[032mGOOD[000m/' -e 's/BAD/[032mBAD[000m/'`
#    echo -n "*** Sentence: $sentence  "
    sentence=`echo $sentence | sed 's/.--..*//'`

    echo $sentence > /tmp/orig_sentence.$$
    echo $sentence | tr -dc "a-zA-Z'" | tr 'A-Z' 'a-z' > /tmp/orig_sentence.$$.2

    echo `cat /tmp/orig_sentence.$$ | parser -e 2>/dev/null | tr -d '\012' | tr -d '(){}[]<>'` >/tmp/parserout.$$
    diff -w /tmp/parserout.$$ /tmp/orig_sentence.$$.2 2>&1 >/dev/null
    parserres=$?
    rm /tmp/orig_sentence.$$.2

    cat /tmp/orig_sentence.$$ | jbofihe 2>/dev/null >/tmp/fishout.$$
    fishres=$?
    if [ $fishres -ge 1 ]
    then
	fishres=1
    fi
    cat /tmp/fishout.$$ | egrep '(^\(|ERROR)' | tail -1 | tr -d '(){}[]<>' >/tmp/fishout.$$.2
    mv /tmp/fishout.$$.2 /tmp/fishout.$$

    cat /tmp/orig_sentence.$$ >&p

    read -p -e -t 10 | sed -e 's/[a-zA-Z0-9]*=//g' | tr -d "()[]" | \
	sed -e 's/[         ][      ]*/ /g' > /tmp/javaout.$$
    diff -w /tmp/javaout.$$ /tmp/orig_sentence.$$ 2>&1 >/dev/null
    javares=$?

#    echo -n "$parserres:$fishres:[033m$javares"
#    echo "[000m"

    #parse_diff $parserres $fishres $javares $orig_sentence

    good=2
    if [ "`echo $orig_sentence | grep '[ .]BAD'`" ]
    then
	#echo "BAD $javares."
	if [ $javares -eq 1 ]
	then
	    good=1
	else
	    good=0
	fi
    fi
    #echo "Good1: $good"

    if [ "`echo $orig_sentence | grep '[ .]GOOD'`" ]
    then
	#echo "GOOD $javares."
	if [ $javares -eq 0 ]
	then
	    good=1
	else
	    good=0
	fi
    fi
    #echo "Good2: $good"

    # If not labelled good or bad, look for mismatch.
    if [ $good -eq 2 ]
    then
	if [ $parserres -ne $javares -o $fishres -ne $javares ]
	then
	    good=0
	else
	    good=1
	fi
    fi
    #echo "Good3: $good"

    # If not good
    if [ $good -ne 1 ]
    then
	echo -n "*** Sentence: $orig_sentence  "
	echo -n "$parserres:$fishres:[033m$javares"
	echo "[000m"
	echo "MISMATCH!"
	echo "Official: `cat /tmp/parserout.$$`
jbofi'he: `cat /tmp/fishout.$$`
pegbased: `cat /tmp/javaout.$$`
"
    fi

    setopt NULL_GLOB
    rm -f /tmp/parserout.* /tmp/fishout.* /tmp/javaout.* /tmp/parser_tree.* /tmp/fish_tree.* /tmp/java_tree.* /tmp/orig_sentence.*
}

coproc ~/bin/myparser -s -b -f &

while [ `read -p -e -t 10` ]
do
done

for sentence in `cat ../test_sentences.txt`
do
    sentence=`echo $sentence | tr -d '()'`
    if [ "`echo $sentence | grep '[[]'`" ]
    then
	sentence_with=`echo $sentence | tr -d '[]'`
	sentence_with="$sentence_with -- WITH"
	sentence_without=`echo $sentence | sed 's/[[][^]]*[]] *//g'`
	sentence_without="$sentence_without -- WITHOUT"
	run_sentence $sentence_with
	run_sentence $sentence_without

	sentence_dots=`echo $sentence_with | tr ' ' '.'`
	sentence_dots="$sentence_dots -- DOTS"
	# Maybe try this again later
	##run_sentence $sentence_dots
    else
	run_sentence $sentence

	sentence_dots=`echo $sentence | tr ' ' '.'`
	sentence_dots="$sentence_dots -- DOTS"
	# Maybe try this again later
	##run_sentence $sentence_dots
    fi
done

