-- Parser generated by Pappy - do not edit
module Java where

import Pos
import Parse

import Char
import System
import Numeric


-- Abstract syntax tree data types
type Identifier = String
type Name = [Identifier]

data Literal =	  LitInt Integer
		| LitLong Integer
		| LitFloat Float
		| LitDouble Double
		| LitChar Char
		| LitString String
		| LitBool Bool
		| LitNull

data Expression = ExpLiteral Literal
		| ExpIdent Identifier
		| ExpPrefix String Expression
		| ExpPostfix String Expression
		| ExpBinary String Expression Expression
		| ExpSelect Expression Expression
		| ExpInstanceof Expression DeclType
		| ExpNewClass [Identifier] [Expression] (Maybe [Declaration])
		| ExpNewArray DeclType [Expression] Int
		| ExpNewArrayInit DeclType Int [Initializer]
		| ExpCall Expression [Expression]
		| ExpArray Expression (Maybe Expression)
		| ExpCast DeclType Expression
		| ExpCond Expression Expression Expression
		| ExpThis
		| ExpSuper
		| ExpDotClass Expression
		| ExpVoidClass

data Modifier =   ModPublic
		| ModProtected
		| ModPrivate
		| ModStatic
		| ModAbstract
		| ModFinal
		| ModNative
		| ModSynchronized
		| ModTransient
		| ModVolatile
		| ModStrictfp

data DeclType =   DtByte
		| DtShort
		| DtChar
		| DtInt
		| DtLong
		| DtFloat
		| DtDouble
		| DtBoolean
		| DtName [Identifier]
		| DtArray DeclType Int

type Declarator = (Identifier, Int, Maybe Initializer)

data Declaration =
		  DeclSimple [Modifier] DeclType [Declarator]
		| DeclMethod [Modifier] (Maybe DeclType) Identifier
				[FormalParam] Int [Name]
				(Maybe [Statement])
		| DeclConstructor [Modifier] Identifier
				[FormalParam] [Name] [Statement]
		| DeclClass [Modifier] Identifier (Maybe DeclType) [DeclType]
				[Declaration]
		| DeclInterface [Modifier] Identifier [DeclType]
				[Declaration]
		| DeclBlock Bool [Statement]

-- formal parameter: "final" flag, type, parameter name, array dimension
type FormalParam = (Bool, DeclType, Identifier, Int)

data Initializer =
		  IniExpr Expression
		| IniList [Initializer]

data SwitchGroup =
		  SwCase Expression [Statement]
		| SwDefault [Statement]

data ForInit =	  FiExpr [Expression]
		| FiDecl Bool DeclType [Declarator]

data Statement =  StLabel Identifier Statement
		| StCase Expression Statement
		| StDefault Statement
		| StDecl Declaration
		| StExpr Expression
		| StBlock [Statement]
		| StIf Expression Statement (Maybe Statement)
		| StSwitch Expression [SwitchGroup]
		| StWhile Expression Statement
		| StDo Statement Expression
		| StFor ForInit (Maybe Expression)
			[Expression] Statement
		| StTry [Statement] [CatchClause] (Maybe [Statement])
		| StSynch Expression [Statement]
		| StContinue (Maybe Identifier)
		| StBreak (Maybe Identifier)
		| StReturn (Maybe Expression)
		| StThrow Expression
		| StNull

-- catch clause: 
type CatchClause = (FormalParam, [Statement])

-- import declaration: qualified name, ".*" flag
type ImportDecl = (Name, Bool)

-- compilation unit: package name, import declarations, type declarations
type CompUnit = (Maybe Name, [ImportDecl], [Declaration])


-- List of Java's reserved words, used in Keyword below
keywords = [
	"abstract",
	"boolean", "break", "byte",
	"case", "catch", "char", "class", "const", "continue",
	"default", "do", "double",
	"else", "extends",
	"final", "finally", "float", "for",
	"goto",
	"if", "implements", "import", "instanceof", "int", "interface",
	"long",
	"native", "new",
	"package", "private", "protected", "public",
	"return",
	"short", "static", "strictfp", "super", "switch", "synchronized",
	"this", "throw", "throws", "transient", "try",
	"void", "volatile",
	"while"
    ]



-- Preprocess unicode escapes and newlines before parsing
javaPrep :: String -> String
javaPrep [] = []
javaPrep ('\r':'\n':s) = '\n':javaPrep s
javaPrep ('\r':s) = '\n':javaPrep s
javaPrep ('\\':'\\':s) = '\\':'\\':javaPrep s
javaPrep ('\\':'u':s) = case s of
	h1:h2:h3:h4:s ->
		if isHexDigit h1 && isHexDigit h2 &&
		   isHexDigit h3 && isHexDigit h4
		then chr v4:javaPrep s
		else error "invalid Unicode escape sequence"
		where	v1 = digitToInt h1
			v2 = v1*16 + digitToInt h2
			v3 = v2*16 + digitToInt h3
			v4 = v3*16 + digitToInt h4
	_ -> error "incomplete Unicode escape sequence"
javaPrep (c:s) = c:javaPrep s


javaParseFile :: FilePath -> IO CompUnit
javaParseFile name =
	do	text <- readFile name
		let text' = javaPrep text
		    derivs = javaParse name text'
		case javaCompilationUnit derivs of
			Parsed cu _ _ -> return cu
			NoParse e -> fail (show e)



data JavaDerivs = JavaDerivs {
	javaSub0 :: JavaDerivs0,
	javaSub1 :: JavaDerivs1,
	javaSub2 :: JavaDerivs2,
	javaSub3 :: JavaDerivs3,
	javaChar :: Result JavaDerivs Char,
	javaPos :: Pos
}

instance Derivs JavaDerivs where
	dvChar d = javaChar d
	dvPos d = javaPos d

data JavaDerivs0 = JavaDerivs0 {
	javaSubStarRule0 :: Result JavaDerivs ([()]),
	javaSubStarRule1 :: Result JavaDerivs ([Char]),
	javaSubStarRule2 :: Result JavaDerivs ([Char]),
	javaSubIdentifier :: Result JavaDerivs (Identifier),
	javaSubStarRule3 :: Result JavaDerivs ([Char]),
	javaSubSym :: Result JavaDerivs (String),
	javaSubHexDigitsTail :: Result JavaDerivs ((Integer -> Integer)),
	javaSubOctalDigitsTail :: Result JavaDerivs ((Integer -> Integer)),
	javaSubDigitsTail :: Result JavaDerivs ((Integer -> Integer)),
	javaSubFractionPart :: Result JavaDerivs (Rational),
	javaSubExponentPart :: Result JavaDerivs (Integer),
	javaSubStarRule4 :: Result JavaDerivs ([Char]),
	javaSubEscapeSequence :: Result JavaDerivs (Char)}

data JavaDerivs1 = JavaDerivs1 {
	javaSubPrimitiveType :: Result JavaDerivs (DeclType),
	javaSubStarRule5 :: Result JavaDerivs ([Identifier]),
	javaSubDims :: Result JavaDerivs (Int),
	javaSubExpression :: Result JavaDerivs (Expression),
	javaSubCondExpr :: Result JavaDerivs (Expression),
	javaSubCondOrExprTail :: Result JavaDerivs ((Expression -> Expression)),
	javaSubCondAndExprTail :: Result JavaDerivs ((Expression -> Expression)),
	javaSubOrExprTail :: Result JavaDerivs ((Expression -> Expression)),
	javaSubXorExprTail :: Result JavaDerivs ((Expression -> Expression)),
	javaSubAndExprTail :: Result JavaDerivs ((Expression -> Expression)),
	javaSubEqExprTail :: Result JavaDerivs ((Expression -> Expression)),
	javaSubRelExprTail :: Result JavaDerivs ((Expression -> Expression)),
	javaSubShiftExprTail :: Result JavaDerivs ((Expression -> Expression))}

data JavaDerivs2 = JavaDerivs2 {
	javaSubAddExprTail :: Result JavaDerivs ((Expression -> Expression)),
	javaSubMultExprTail :: Result JavaDerivs ((Expression -> Expression)),
	javaSubUnaryExpr :: Result JavaDerivs (Expression),
	javaSubUnaryExprNotPlusMinus :: Result JavaDerivs (Expression),
	javaSubPostfixExprTail :: Result JavaDerivs ((Expression -> Expression)),
	javaSubPlusRule0 :: Result JavaDerivs ([Expression]),
	javaSubPrimExpr :: Result JavaDerivs (Expression),
	javaSubStarRule7 :: Result JavaDerivs ([Initializer]),
	javaSubStarRule8 :: Result JavaDerivs ([Initializer]),
	javaSubArrayInitializer :: Result JavaDerivs ([Initializer]),
	javaSubStarRule10 :: Result JavaDerivs ([CatchClause]),
	javaSubPlusRule1 :: Result JavaDerivs ([CatchClause]),
	javaSubStarRule11 :: Result JavaDerivs ([SwitchGroup])}

data JavaDerivs3 = JavaDerivs3 {
	javaSubStatement :: Result JavaDerivs (Statement),
	javaSubStarRule12 :: Result JavaDerivs ([Expression]),
	javaSubStarRule14 :: Result JavaDerivs ([Statement]),
	javaSubFormalParam :: Result JavaDerivs (FormalParam),
	javaSubStarRule15 :: Result JavaDerivs ([FormalParam]),
	javaSubStarRule16 :: Result JavaDerivs ([Declarator]),
	javaSubStarRule23 :: Result JavaDerivs ([Modifier]),
	javaSubStarRule24 :: Result JavaDerivs ([DeclType]),
	javaSubDeclaration :: Result JavaDerivs (Declaration),
	javaSubStarRule25 :: Result JavaDerivs ([[Identifier]]),
	javaSubStarRule26 :: Result JavaDerivs ([ImportDecl]),
	javaSubStarRule27 :: Result JavaDerivs ([Declaration])}

javaStarRule0 = javaSubStarRule0 . javaSub0
javaStarRule1 = javaSubStarRule1 . javaSub0
javaStarRule2 = javaSubStarRule2 . javaSub0
javaIdentifier = javaSubIdentifier . javaSub0
javaStarRule3 = javaSubStarRule3 . javaSub0
javaSym = javaSubSym . javaSub0
javaHexDigitsTail = javaSubHexDigitsTail . javaSub0
javaOctalDigitsTail = javaSubOctalDigitsTail . javaSub0
javaDigitsTail = javaSubDigitsTail . javaSub0
javaFractionPart = javaSubFractionPart . javaSub0
javaExponentPart = javaSubExponentPart . javaSub0
javaStarRule4 = javaSubStarRule4 . javaSub0
javaEscapeSequence = javaSubEscapeSequence . javaSub0
javaPrimitiveType = javaSubPrimitiveType . javaSub1
javaStarRule5 = javaSubStarRule5 . javaSub1
javaDims = javaSubDims . javaSub1
javaExpression = javaSubExpression . javaSub1
javaCondExpr = javaSubCondExpr . javaSub1
javaCondOrExprTail = javaSubCondOrExprTail . javaSub1
javaCondAndExprTail = javaSubCondAndExprTail . javaSub1
javaOrExprTail = javaSubOrExprTail . javaSub1
javaXorExprTail = javaSubXorExprTail . javaSub1
javaAndExprTail = javaSubAndExprTail . javaSub1
javaEqExprTail = javaSubEqExprTail . javaSub1
javaRelExprTail = javaSubRelExprTail . javaSub1
javaShiftExprTail = javaSubShiftExprTail . javaSub1
javaAddExprTail = javaSubAddExprTail . javaSub2
javaMultExprTail = javaSubMultExprTail . javaSub2
javaUnaryExpr = javaSubUnaryExpr . javaSub2
javaUnaryExprNotPlusMinus = javaSubUnaryExprNotPlusMinus . javaSub2
javaPostfixExprTail = javaSubPostfixExprTail . javaSub2
javaPlusRule0 = javaSubPlusRule0 . javaSub2
javaPrimExpr = javaSubPrimExpr . javaSub2
javaStarRule7 = javaSubStarRule7 . javaSub2
javaStarRule8 = javaSubStarRule8 . javaSub2
javaArrayInitializer = javaSubArrayInitializer . javaSub2
javaStarRule10 = javaSubStarRule10 . javaSub2
javaPlusRule1 = javaSubPlusRule1 . javaSub2
javaStarRule11 = javaSubStarRule11 . javaSub2
javaStatement = javaSubStatement . javaSub3
javaStarRule12 = javaSubStarRule12 . javaSub3
javaStarRule14 = javaSubStarRule14 . javaSub3
javaFormalParam = javaSubFormalParam . javaSub3
javaStarRule15 = javaSubStarRule15 . javaSub3
javaStarRule16 = javaSubStarRule16 . javaSub3
javaStarRule23 = javaSubStarRule23 . javaSub3
javaStarRule24 = javaSubStarRule24 . javaSub3
javaDeclaration = javaSubDeclaration . javaSub3
javaStarRule25 = javaSubStarRule25 . javaSub3
javaStarRule26 = javaSubStarRule26 . javaSub3
javaStarRule27 = javaSubStarRule27 . javaSub3

javaParse :: String -> String -> JavaDerivs
javaParse name text = javaDerivs (Pos name 1 1) text

javaDerivs :: Pos -> String -> JavaDerivs
javaDerivs pos text = dvs where
  dvs = JavaDerivs
    (javaDerivs0 dvs)
    (javaDerivs1 dvs)
    (javaDerivs2 dvs)
    (javaDerivs3 dvs)
    chr pos
  chr = case text of
    [] -> NoParse (eofError dvs)
    (c:cs) -> Parsed c (javaDerivs (nextPos pos c) cs) (nullError dvs)

javaDerivs0 dvs = JavaDerivs0
	(javaParseStarRule0 dvs)
	(javaParseStarRule1 dvs)
	(javaParseStarRule2 dvs)
	(javaParseIdentifier dvs)
	(javaParseStarRule3 dvs)
	(javaParseSym dvs)
	(javaParseHexDigitsTail dvs)
	(javaParseOctalDigitsTail dvs)
	(javaParseDigitsTail dvs)
	(javaParseFractionPart dvs)
	(javaParseExponentPart dvs)
	(javaParseStarRule4 dvs)
	(javaParseEscapeSequence dvs)

javaDerivs1 dvs = JavaDerivs1
	(javaParsePrimitiveType dvs)
	(javaParseStarRule5 dvs)
	(javaParseDims dvs)
	(javaParseExpression dvs)
	(javaParseCondExpr dvs)
	(javaParseCondOrExprTail dvs)
	(javaParseCondAndExprTail dvs)
	(javaParseOrExprTail dvs)
	(javaParseXorExprTail dvs)
	(javaParseAndExprTail dvs)
	(javaParseEqExprTail dvs)
	(javaParseRelExprTail dvs)
	(javaParseShiftExprTail dvs)

javaDerivs2 dvs = JavaDerivs2
	(javaParseAddExprTail dvs)
	(javaParseMultExprTail dvs)
	(javaParseUnaryExpr dvs)
	(javaParseUnaryExprNotPlusMinus dvs)
	(javaParsePostfixExprTail dvs)
	(javaParsePlusRule0 dvs)
	(javaParsePrimExpr dvs)
	(javaParseStarRule7 dvs)
	(javaParseStarRule8 dvs)
	(javaParseArrayInitializer dvs)
	(javaParseStarRule10 dvs)
	(javaParsePlusRule1 dvs)
	(javaParseStarRule11 dvs)

javaDerivs3 dvs = JavaDerivs3
	(javaParseStatement dvs)
	(javaParseStarRule12 dvs)
	(javaParseStarRule14 dvs)
	(javaParseFormalParam dvs)
	(javaParseStarRule15 dvs)
	(javaParseStarRule16 dvs)
	(javaParseStarRule23 dvs)
	(javaParseStarRule24 dvs)
	(javaParseDeclaration dvs)
	(javaParseStarRule25 dvs)
	(javaParseStarRule26 dvs)
	(javaParseStarRule27 dvs)

javaInputCharacter :: JavaDerivs -> Result JavaDerivs (Char)
javaInputCharacter d =
  case pappyResult1 of
    NoParse e1 ->
      case javaChar d of
        Parsed c d3 e3 ->
          Parsed (c) d3 (max e3 e1)
        NoParse e3 -> NoParse (max e3 e1)
    Parsed _ _ e1 -> NoParse e1
  where
    pappyResult1 =
      case javaChar d of
        r @ (Parsed '\n' _ _) -> r
        _ -> NoParse (ParseError (javaPos d) [])

javaParseStarRule0 :: JavaDerivs -> Result JavaDerivs ([()])
javaParseStarRule0 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case pappyResult3 of
        Parsed v d3 e3 ->
          case javaStarRule0 d3 of
            Parsed vs d5 e5 ->
              Parsed (v : vs) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
      where
        pappyResult3 =
          pappyAlt5_1 (ParseError (javaPos d) []) where
            pappyAlt5_1 e5 =
              case pappyResult7 of
                Parsed _ d7 e7 ->
                  Parsed (()) d7 (max e7 e5)
                NoParse e7 -> pappyAlt5_2 (max e7 e5)
              where
                pappyResult7 =
                  pappyAlt9_1 (ParseError (javaPos d) []) where
                    pappyAlt9_1 e9 =
                      case javaChar d of
                        r @ (Parsed ' ' _ _) -> r
                        _ -> pappyAlt9_2 e9
                    pappyAlt9_2 e9 =
                      case javaChar d of
                        r @ (Parsed '\t' _ _) -> r
                        _ -> pappyAlt9_3 e9
                    pappyAlt9_3 e9 =
                      case javaChar d of
                        r @ (Parsed '\f' _ _) -> r
                        _ -> pappyAlt9_4 e9
                    pappyAlt9_4 e9 =
                      case javaChar d of
                        r @ (Parsed '\n' _ _) -> r
                        _ -> pappyAlt9_5 e9
                    pappyAlt9_5 e9 = NoParse e9
            pappyAlt5_2 e5 =
              case pappyResult7 of
                Parsed _ d7 e7 ->
                  Parsed (()) d7 (max e7 e5)
                NoParse e7 -> pappyAlt5_3 (max e7 e5)
              where
                pappyResult7 =
                  case javaChar d of
                    Parsed '/' d9 _ ->
                      case javaChar d9 of
                        Parsed '*' d11 _ ->
                          case javaStarRule1 d11 of
                            Parsed _ d13 e13 ->
                              case javaChar d13 of
                                Parsed '*' d15 _ ->
                                  case javaChar d15 of
                                    Parsed '/' d17 _ ->
                                      Parsed (()) d17 e13
                                    _ -> NoParse e13
                                _ -> NoParse e13
                            NoParse e13 -> NoParse e13
                        Parsed '/' d11 _ ->
                          case javaStarRule2 d11 of
                            Parsed _ d13 e13 ->
                              case javaChar d13 of
                                Parsed '\n' d15 _ ->
                                  Parsed (()) d15 e13
                                _ -> NoParse e13
                            NoParse e13 -> NoParse e13
                        _ -> NoParse (ParseError (javaPos d9) [])
                    _ -> NoParse (ParseError (javaPos d) [])
            pappyAlt5_3 e5 = NoParse e5
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParseStarRule1 :: JavaDerivs -> Result JavaDerivs ([Char])
javaParseStarRule1 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case pappyResult3 of
        NoParse e3 ->
          case javaChar d of
            Parsed v d5 e5 ->
              case javaStarRule1 d5 of
                Parsed vs d7 e7 ->
                  Parsed (v : vs) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        Parsed _ _ e3 -> pappyAlt1_2 (max e3 e1)
      where
        pappyResult3 =
          case javaChar d of
            Parsed '*' d5 _ ->
              case javaChar d5 of
                Parsed '/' d7 _ ->
                  Parsed ("*/") d7 (ParseError (javaPos d7) [])
                _ -> NoParse (ParseError (javaPos d5) [])
            _ -> NoParse (ParseError (javaPos d) [])
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParseStarRule2 :: JavaDerivs -> Result JavaDerivs ([Char])
javaParseStarRule2 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case pappyResult3 of
        NoParse e3 ->
          case javaChar d of
            Parsed v d5 e5 ->
              case javaStarRule2 d5 of
                Parsed vs d7 e7 ->
                  Parsed (v : vs) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        Parsed _ _ e3 -> pappyAlt1_2 (max e3 e1)
      where
        pappyResult3 =
          case javaChar d of
            r @ (Parsed '\n' _ _) -> r
            _ -> NoParse (ParseError (javaPos d) [])
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParseIdentifier :: JavaDerivs -> Result JavaDerivs (Identifier)
javaParseIdentifier d =
  case pappyResult1 of
    NoParse e1 ->
      case javaBooleanLiteral d of
        NoParse e3 ->
          case pappyResult5 of
            NoParse e5 ->
              case javaWord d of
                Parsed s d7 e7 ->
                  Parsed (s) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> NoParse (maximum [e7,e5,e3,e1])
            Parsed _ _ e5 -> NoParse (maximum [e5,e3,e1])
          where
            pappyResult5 =
              case javaWord d of
                Parsed "null" d7 e7 ->
                  Parsed ( LitNull ) d7 e7
                _ -> NoParse (ParseError (javaPos d) [Expected "null"])
        Parsed _ _ e3 -> NoParse (max e3 e1)
    Parsed _ _ e1 -> NoParse e1
  where
    pappyResult1 =
      case javaWord d of
        Parsed s d3 e3 ->
          case (s `elem` keywords) of
            True ->
              Parsed (s) d3 e3
            False -> NoParse e3
        NoParse e3 -> NoParse e3

javaParseStarRule3 :: JavaDerivs -> Result JavaDerivs ([Char])
javaParseStarRule3 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case pappyResult3 of
        Parsed v d3 e3 ->
          case javaStarRule3 d3 of
            Parsed vs d5 e5 ->
              Parsed (v : vs) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
      where
        pappyResult3 =
          pappyAlt5_1 (ParseError (javaPos d) []) where
            pappyAlt5_1 e5 =
              case javaChar d of
                Parsed c d7 e7 ->
                  case (isAlphaNum c) of
                    True ->
                      Parsed (c) d7 (max e7 e5)
                    False -> pappyAlt5_2 (max e7 e5)
                NoParse e7 -> pappyAlt5_2 (max e7 e5)
            pappyAlt5_2 e5 =
              case javaChar d of
                r @ (Parsed '_' _ _) -> r
                _ -> pappyAlt5_3 e5
            pappyAlt5_3 e5 =
              case javaChar d of
                r @ (Parsed '$' _ _) -> r
                _ -> pappyAlt5_4 e5
            pappyAlt5_4 e5 = NoParse e5
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaWord :: JavaDerivs -> Result JavaDerivs (String)
javaWord d =
  case pappyResult1 of
    Parsed c d1 e1 ->
      case javaStarRule3 d1 of
        Parsed cs d3 e3 ->
          case javaStarRule0 d3 of
            Parsed _ d5 e5 ->
              Parsed (c : cs) d5 (maximum [e5,e3,e1])
            NoParse e5 -> NoParse (maximum [e5,e3,e1])
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1
  where
    pappyResult1 =
      pappyAlt3_1 (ParseError (javaPos d) []) where
        pappyAlt3_1 e3 =
          case javaChar d of
            Parsed c d5 e5 ->
              case (isAlpha c) of
                True ->
                  Parsed (c) d5 (max e5 e3)
                False -> pappyAlt3_2 (max e5 e3)
            NoParse e5 -> pappyAlt3_2 (max e5 e3)
        pappyAlt3_2 e3 =
          case javaChar d of
            r @ (Parsed '_' _ _) -> r
            _ -> pappyAlt3_3 e3
        pappyAlt3_3 e3 =
          case javaChar d of
            r @ (Parsed '$' _ _) -> r
            _ -> pappyAlt3_4 e3
        pappyAlt3_4 e3 = NoParse e3

javaParseSym :: JavaDerivs -> Result JavaDerivs (String)
javaParseSym d =
  case pappyResult1 of
    Parsed s d1 e1 ->
      case javaStarRule0 d1 of
        Parsed _ d3 e3 ->
          Parsed (s) d3 (max e3 e1)
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1
  where
    pappyResult1 =
      case javaChar d of
        Parsed '>' d3 _ ->
          case javaChar d3 of
            Parsed '>' d5 _ ->
              case javaChar d5 of
                Parsed '>' d7 _ ->
                  case javaChar d7 of
                    Parsed '=' d9 _ ->
                      Parsed (">>>=") d9 (ParseError (javaPos d9) [])
                    _ ->
                      Parsed (">>>") d7 (ParseError (javaPos d7) [])
                Parsed '=' d7 _ ->
                  Parsed (">>=") d7 (ParseError (javaPos d7) [])
                _ ->
                  Parsed (">>") d5 (ParseError (javaPos d5) [])
            Parsed '=' d5 _ ->
              Parsed (">=") d5 (ParseError (javaPos d5) [])
            _ ->
              Parsed (">") d3 (ParseError (javaPos d3) [])
        Parsed '<' d3 _ ->
          case javaChar d3 of
            Parsed '<' d5 _ ->
              case javaChar d5 of
                Parsed '=' d7 _ ->
                  Parsed ("<<=") d7 (ParseError (javaPos d7) [])
                _ ->
                  Parsed ("<<") d5 (ParseError (javaPos d5) [])
            Parsed '=' d5 _ ->
              Parsed ("<=") d5 (ParseError (javaPos d5) [])
            _ ->
              Parsed ("<") d3 (ParseError (javaPos d3) [])
        Parsed '+' d3 _ ->
          case javaChar d3 of
            Parsed '=' d5 _ ->
              Parsed ("+=") d5 (ParseError (javaPos d5) [])
            Parsed '+' d5 _ ->
              Parsed ("++") d5 (ParseError (javaPos d5) [])
            _ ->
              Parsed ("+") d3 (ParseError (javaPos d3) [])
        Parsed '-' d3 _ ->
          case javaChar d3 of
            Parsed '=' d5 _ ->
              Parsed ("-=") d5 (ParseError (javaPos d5) [])
            Parsed '-' d5 _ ->
              Parsed ("--") d5 (ParseError (javaPos d5) [])
            _ ->
              Parsed ("-") d3 (ParseError (javaPos d3) [])
        Parsed '*' d3 _ ->
          case javaChar d3 of
            Parsed '=' d5 _ ->
              Parsed ("*=") d5 (ParseError (javaPos d5) [])
            _ ->
              Parsed ("*") d3 (ParseError (javaPos d3) [])
        Parsed '/' d3 _ ->
          case javaChar d3 of
            Parsed '=' d5 _ ->
              Parsed ("/=") d5 (ParseError (javaPos d5) [])
            _ ->
              Parsed ("/") d3 (ParseError (javaPos d3) [])
        Parsed '%' d3 _ ->
          case javaChar d3 of
            Parsed '=' d5 _ ->
              Parsed ("%=") d5 (ParseError (javaPos d5) [])
            _ ->
              Parsed ("%") d3 (ParseError (javaPos d3) [])
        Parsed '&' d3 _ ->
          case javaChar d3 of
            Parsed '=' d5 _ ->
              Parsed ("&=") d5 (ParseError (javaPos d5) [])
            Parsed '&' d5 _ ->
              Parsed ("&&") d5 (ParseError (javaPos d5) [])
            _ ->
              Parsed ("&") d3 (ParseError (javaPos d3) [])
        Parsed '^' d3 _ ->
          case javaChar d3 of
            Parsed '=' d5 _ ->
              Parsed ("^=") d5 (ParseError (javaPos d5) [])
            _ ->
              Parsed ("^") d3 (ParseError (javaPos d3) [])
        Parsed '|' d3 _ ->
          case javaChar d3 of
            Parsed '=' d5 _ ->
              Parsed ("|=") d5 (ParseError (javaPos d5) [])
            Parsed '|' d5 _ ->
              Parsed ("||") d5 (ParseError (javaPos d5) [])
            _ ->
              Parsed ("|") d3 (ParseError (javaPos d3) [])
        Parsed '=' d3 _ ->
          case javaChar d3 of
            Parsed '=' d5 _ ->
              Parsed ("==") d5 (ParseError (javaPos d5) [])
            _ ->
              Parsed ("=") d3 (ParseError (javaPos d3) [])
        Parsed '!' d3 _ ->
          case javaChar d3 of
            Parsed '=' d5 _ ->
              Parsed ("!=") d5 (ParseError (javaPos d5) [])
            _ ->
              Parsed ("!") d3 (ParseError (javaPos d3) [])
        Parsed ';' d3 _ ->
          Parsed (";") d3 (ParseError (javaPos d3) [])
        Parsed ':' d3 _ ->
          Parsed (":") d3 (ParseError (javaPos d3) [])
        Parsed ',' d3 _ ->
          Parsed (",") d3 (ParseError (javaPos d3) [])
        Parsed '.' d3 _ ->
          Parsed (".") d3 (ParseError (javaPos d3) [])
        Parsed '{' d3 _ ->
          Parsed ("{") d3 (ParseError (javaPos d3) [])
        Parsed '}' d3 _ ->
          Parsed ("}") d3 (ParseError (javaPos d3) [])
        Parsed '(' d3 _ ->
          Parsed ("(") d3 (ParseError (javaPos d3) [])
        Parsed ')' d3 _ ->
          Parsed (")") d3 (ParseError (javaPos d3) [])
        Parsed '[' d3 _ ->
          Parsed ("[") d3 (ParseError (javaPos d3) [])
        Parsed ']' d3 _ ->
          Parsed ("]") d3 (ParseError (javaPos d3) [])
        Parsed '~' d3 _ ->
          Parsed ("~") d3 (ParseError (javaPos d3) [])
        Parsed '?' d3 _ ->
          Parsed ("?") d3 (ParseError (javaPos d3) [])
        _ -> NoParse (ParseError (javaPos d) [])

javaIntegerTypeSuffixOpt :: JavaDerivs -> Result JavaDerivs (Integer -> Literal)
javaIntegerTypeSuffixOpt d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case pappyResult3 of
        Parsed _ d3 e3 ->
          Parsed (LitLong) d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
      where
        pappyResult3 =
          pappyAlt5_1 (ParseError (javaPos d) []) where
            pappyAlt5_1 e5 =
              case javaChar d of
                r @ (Parsed 'l' _ _) -> r
                _ -> pappyAlt5_2 e5
            pappyAlt5_2 e5 =
              case javaChar d of
                r @ (Parsed 'L' _ _) -> r
                _ -> pappyAlt5_3 e5
            pappyAlt5_3 e5 = NoParse e5
    pappyAlt1_2 e1 =
      Parsed (LitInt) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParseHexDigitsTail :: JavaDerivs -> Result JavaDerivs ((Integer -> Integer))
javaParseHexDigitsTail d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaHexDigit d of
        Parsed d d3 e3 ->
          case javaHexDigitsTail d3 of
            Parsed pappyTail d5 e5 ->
              Parsed (\v -> pappyTail (v * 16 + toInteger d)) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      Parsed (\v -> v) d e1
    pappyAlt1_3 e1 = NoParse e1

javaHexDigit :: JavaDerivs -> Result JavaDerivs (Int)
javaHexDigit d =
  case javaChar d of
    Parsed c d1 e1 ->
      case (isHexDigit c) of
        True ->
          Parsed (digitToInt c) d1 e1
        False -> NoParse e1
    NoParse e1 -> NoParse e1

javaParseOctalDigitsTail :: JavaDerivs -> Result JavaDerivs ((Integer -> Integer))
javaParseOctalDigitsTail d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaOctalDigit d of
        Parsed d d3 e3 ->
          case javaOctalDigitsTail d3 of
            Parsed pappyTail d5 e5 ->
              Parsed (\v -> pappyTail (v * 8 + toInteger d)) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      Parsed (\v -> v) d e1
    pappyAlt1_3 e1 = NoParse e1

javaOctalDigit :: JavaDerivs -> Result JavaDerivs (Int)
javaOctalDigit d =
  case javaChar d of
    Parsed c d1 e1 ->
      case (isOctDigit c) of
        True ->
          Parsed (digitToInt c) d1 e1
        False -> NoParse e1
    NoParse e1 -> NoParse e1

javaParseDigitsTail :: JavaDerivs -> Result JavaDerivs ((Integer -> Integer))
javaParseDigitsTail d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaDigit d of
        Parsed d d3 e3 ->
          case javaDigitsTail d3 of
            Parsed pappyTail d5 e5 ->
              Parsed (\v -> pappyTail (v * 10 + toInteger d)) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      Parsed (\v -> v) d e1
    pappyAlt1_3 e1 = NoParse e1

javaDigits :: JavaDerivs -> Result JavaDerivs (Integer)
javaDigits d =
  case pappyResult1 of
    Parsed l d1 e1 ->
      case javaDigitsTail d1 of
        Parsed t d3 e3 ->
          Parsed (t l) d3 (max e3 e1)
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1
  where
    pappyResult1 =
      case javaDigit d of
        Parsed d d3 e3 ->
          Parsed (toInteger d) d3 e3
        NoParse e3 -> NoParse e3

javaDigit :: JavaDerivs -> Result JavaDerivs (Int)
javaDigit d =
  case javaChar d of
    Parsed c d1 e1 ->
      case (isDigit c) of
        True ->
          Parsed (digitToInt c) d1 e1
        False -> NoParse e1
    NoParse e1 -> NoParse e1

javaParseFractionPart :: JavaDerivs -> Result JavaDerivs (Rational)
javaParseFractionPart d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaDigit d of
        Parsed d d3 e3 ->
          Parsed ( toEnum d / 10.0 ) d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      case javaDigit d of
        Parsed d d3 e3 ->
          case javaFractionPart d3 of
            Parsed f d5 e5 ->
              Parsed ( (f + toEnum d) / 10.0 ) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_3 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_3 (max e3 e1)
    pappyAlt1_3 e1 = NoParse e1

javaExponentPartOpt :: JavaDerivs -> Result JavaDerivs (Integer)
javaExponentPartOpt d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaExponentPart d of
        Parsed e d3 e3 ->
          Parsed ( e ) d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      Parsed ( 0 ) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParseExponentPart :: JavaDerivs -> Result JavaDerivs (Integer)
javaParseExponentPart d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case pappyResult3 of
        Parsed _ d3 e3 ->
          case javaChar d3 of
            Parsed '-' d5 _ ->
              case javaDigits d5 of
                Parsed e d7 e7 ->
                  Parsed ( -e ) d7 (maximum [e7,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e3,e1])
            _ -> pappyAlt1_2 (max e3 e1)
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
      where
        pappyResult3 =
          pappyAlt5_1 (ParseError (javaPos d) []) where
            pappyAlt5_1 e5 =
              case javaChar d of
                r @ (Parsed 'e' _ _) -> r
                _ -> pappyAlt5_2 e5
            pappyAlt5_2 e5 =
              case javaChar d of
                r @ (Parsed 'E' _ _) -> r
                _ -> pappyAlt5_3 e5
            pappyAlt5_3 e5 = NoParse e5
    pappyAlt1_2 e1 =
      case pappyResult3 of
        Parsed _ d3 e3 ->
          case pappyResult5 of
            Parsed _ d5 e5 ->
              case javaDigits d5 of
                Parsed e d7 e7 ->
                  Parsed ( e ) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_3 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_3 (maximum [e5,e3,e1])
          where
            pappyResult5 =
              case pappyResult7 of
                Parsed v7 d7 e7 -> Parsed (Just v7) d7 e7
                NoParse e7 -> Parsed (Nothing) d3 e7
              where
                pappyResult7 =
                  case javaChar d3 of
                    r @ (Parsed '+' _ _) -> r
                    _ -> NoParse (ParseError (javaPos d3) [])
        NoParse e3 -> pappyAlt1_3 (max e3 e1)
      where
        pappyResult3 =
          pappyAlt5_1 (ParseError (javaPos d) []) where
            pappyAlt5_1 e5 =
              case javaChar d of
                r @ (Parsed 'e' _ _) -> r
                _ -> pappyAlt5_2 e5
            pappyAlt5_2 e5 =
              case javaChar d of
                r @ (Parsed 'E' _ _) -> r
                _ -> pappyAlt5_3 e5
            pappyAlt5_3 e5 = NoParse e5
    pappyAlt1_3 e1 = NoParse e1

javaFloatTypeSuffixOpt :: JavaDerivs -> Result JavaDerivs (Rational -> Literal)
javaFloatTypeSuffixOpt d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaFloatTypeSuffix d of
        Parsed v3 d3 e3 -> Parsed v3 d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      Parsed (\r -> LitDouble (fromRational r)) d e1
    pappyAlt1_3 e1 = NoParse e1

javaFloatTypeSuffix :: JavaDerivs -> Result JavaDerivs (Rational -> Literal)
javaFloatTypeSuffix d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case pappyResult3 of
        Parsed _ d3 e3 ->
          Parsed (\r -> LitFloat (fromRational r)) d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
      where
        pappyResult3 =
          pappyAlt5_1 (ParseError (javaPos d) []) where
            pappyAlt5_1 e5 =
              case javaChar d of
                r @ (Parsed 'f' _ _) -> r
                _ -> pappyAlt5_2 e5
            pappyAlt5_2 e5 =
              case javaChar d of
                r @ (Parsed 'F' _ _) -> r
                _ -> pappyAlt5_3 e5
            pappyAlt5_3 e5 = NoParse e5
    pappyAlt1_2 e1 =
      case pappyResult3 of
        Parsed _ d3 e3 ->
          Parsed (\r -> LitDouble (fromRational r)) d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_3 (max e3 e1)
      where
        pappyResult3 =
          pappyAlt5_1 (ParseError (javaPos d) []) where
            pappyAlt5_1 e5 =
              case javaChar d of
                r @ (Parsed 'd' _ _) -> r
                _ -> pappyAlt5_2 e5
            pappyAlt5_2 e5 =
              case javaChar d of
                r @ (Parsed 'D' _ _) -> r
                _ -> pappyAlt5_3 e5
            pappyAlt5_3 e5 = NoParse e5
    pappyAlt1_3 e1 = NoParse e1

javaBooleanLiteral :: JavaDerivs -> Result JavaDerivs (Literal)
javaBooleanLiteral d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaWord d of
        Parsed "true" d3 e3 ->
          Parsed ( LitBool True ) d3 (max e3 e1)
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "true"]) e1)
    pappyAlt1_2 e1 =
      case javaWord d of
        Parsed "false" d3 e3 ->
          Parsed ( LitBool False ) d3 (max e3 e1)
        _ -> pappyAlt1_3 (max (ParseError (javaPos d) [Expected "false"]) e1)
    pappyAlt1_3 e1 = NoParse e1

javaParseStarRule4 :: JavaDerivs -> Result JavaDerivs ([Char])
javaParseStarRule4 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case pappyResult3 of
        Parsed v d3 e3 ->
          case javaStarRule4 d3 of
            Parsed vs d5 e5 ->
              Parsed (v : vs) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
      where
        pappyResult3 =
          pappyAlt5_1 (ParseError (javaPos d) []) where
            pappyAlt5_1 e5 =
              case pappyResult7 of
                NoParse e7 ->
                  case pappyResult9 of
                    NoParse e9 ->
                      case javaInputCharacter d of
                        Parsed c d11 e11 ->
                          Parsed (c) d11 (maximum [e11,e9,e7,e5])
                        NoParse e11 -> pappyAlt5_2 (maximum [e11,e9,e7,e5])
                    Parsed _ _ e9 -> pappyAlt5_2 (maximum [e9,e7,e5])
                  where
                    pappyResult9 =
                      case javaChar d of
                        r @ (Parsed '\\' _ _) -> r
                        _ -> NoParse (ParseError (javaPos d) [])
                Parsed _ _ e7 -> pappyAlt5_2 (max e7 e5)
              where
                pappyResult7 =
                  case javaChar d of
                    r @ (Parsed '"' _ _) -> r
                    _ -> NoParse (ParseError (javaPos d) [])
            pappyAlt5_2 e5 =
              case javaEscapeSequence d of
                Parsed v7 d7 e7 -> Parsed v7 d7 (max e7 e5)
                NoParse e7 -> pappyAlt5_3 (max e7 e5)
            pappyAlt5_3 e5 = NoParse e5
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParseEscapeSequence :: JavaDerivs -> Result JavaDerivs (Char)
javaParseEscapeSequence d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaChar d of
        Parsed '\\' d3 _ ->
          pappyAlt5_1 e1 where
            pappyAlt5_1 e5 =
              case javaChar d3 of
                Parsed 'b' d7 _ ->
                  Parsed ('\b') d7 e5
                Parsed 't' d7 _ ->
                  Parsed ('\t') d7 e5
                Parsed 'n' d7 _ ->
                  Parsed ('\n') d7 e5
                Parsed 'f' d7 _ ->
                  Parsed ('\f') d7 e5
                Parsed 'r' d7 _ ->
                  Parsed ('\r') d7 e5
                Parsed '"' d7 _ ->
                  Parsed ('\"') d7 e5
                _ -> pappyAlt5_2 e5
            pappyAlt5_2 e5 =
              case javaChar d3 of
                Parsed '\'' d7 _ ->
                  Parsed ('\'') d7 e5
                Parsed '\\' d7 _ ->
                  Parsed ('\\') d7 e5
                _ -> pappyAlt5_3 e5
            pappyAlt5_3 e5 = pappyAlt1_2 e5
        _ -> pappyAlt1_2 e1
    pappyAlt1_2 e1 =
      case javaChar d of
        Parsed '\\' d3 _ ->
          pappyAlt5_1 e1 where
            pappyAlt5_1 e5 =
              case pappyResult7 of
                Parsed x d7 e7 ->
                  case javaOctalDigit d7 of
                    Parsed y d9 e9 ->
                      case javaOctalDigit d9 of
                        Parsed z d11 e11 ->
                          Parsed (chr (x*8*8 + y*8 + z)) d11 (maximum [e11,e9,e7,e5])
                        NoParse e11 -> pappyAlt5_2 (maximum [e11,e9,e7,e5])
                    NoParse e9 -> pappyAlt5_2 (maximum [e9,e7,e5])
                NoParse e7 -> pappyAlt5_2 (max e7 e5)
              where
                pappyResult7 =
                  case javaChar d3 of
                    Parsed '0' d9 _ ->
                      Parsed (0) d9 (ParseError (javaPos d9) [])
                    Parsed '1' d9 _ ->
                      Parsed (1) d9 (ParseError (javaPos d9) [])
                    Parsed '2' d9 _ ->
                      Parsed (2) d9 (ParseError (javaPos d9) [])
                    Parsed '3' d9 _ ->
                      Parsed (3) d9 (ParseError (javaPos d9) [])
                    _ -> NoParse (ParseError (javaPos d3) [])
            pappyAlt5_2 e5 =
              case javaOctalDigit d3 of
                Parsed y d7 e7 ->
                  case javaOctalDigit d7 of
                    Parsed z d9 e9 ->
                      Parsed (chr (y*8 + z)) d9 (maximum [e9,e7,e5])
                    NoParse e9 -> pappyAlt5_3 (maximum [e9,e7,e5])
                NoParse e7 -> pappyAlt5_3 (max e7 e5)
            pappyAlt5_3 e5 =
              case javaOctalDigit d3 of
                Parsed z d7 e7 ->
                  Parsed (chr (z)) d7 (max e7 e5)
                NoParse e7 -> pappyAlt5_4 (max e7 e5)
            pappyAlt5_4 e5 = pappyAlt1_3 e5
        _ -> pappyAlt1_3 e1
    pappyAlt1_3 e1 = NoParse e1

javaTypeSpec :: JavaDerivs -> Result JavaDerivs (DeclType)
javaTypeSpec d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaTypeName d of
        Parsed t d3 e3 ->
          case javaDims d3 of
            Parsed d d5 e5 ->
              Parsed (DtArray t d) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      case javaTypeName d of
        Parsed v3 d3 e3 -> Parsed v3 d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_3 (max e3 e1)
    pappyAlt1_3 e1 = NoParse e1

javaTypeName :: JavaDerivs -> Result JavaDerivs (DeclType)
javaTypeName d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaPrimitiveType d of
        Parsed v3 d3 e3 -> Parsed v3 d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      case javaQualifiedName d of
        Parsed n d3 e3 ->
          Parsed (DtName n) d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_3 (max e3 e1)
    pappyAlt1_3 e1 = NoParse e1

javaParsePrimitiveType :: JavaDerivs -> Result JavaDerivs (DeclType)
javaParsePrimitiveType d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaWord d of
        Parsed "byte" d3 e3 ->
          Parsed (DtByte) d3 (max e3 e1)
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "byte"]) e1)
    pappyAlt1_2 e1 =
      case javaWord d of
        Parsed "short" d3 e3 ->
          Parsed (DtShort) d3 (max e3 e1)
        _ -> pappyAlt1_3 (max (ParseError (javaPos d) [Expected "short"]) e1)
    pappyAlt1_3 e1 =
      case javaWord d of
        Parsed "char" d3 e3 ->
          Parsed (DtChar) d3 (max e3 e1)
        _ -> pappyAlt1_4 (max (ParseError (javaPos d) [Expected "char"]) e1)
    pappyAlt1_4 e1 =
      case javaWord d of
        Parsed "int" d3 e3 ->
          Parsed (DtInt) d3 (max e3 e1)
        _ -> pappyAlt1_5 (max (ParseError (javaPos d) [Expected "int"]) e1)
    pappyAlt1_5 e1 =
      case javaWord d of
        Parsed "long" d3 e3 ->
          Parsed (DtLong) d3 (max e3 e1)
        _ -> pappyAlt1_6 (max (ParseError (javaPos d) [Expected "long"]) e1)
    pappyAlt1_6 e1 =
      case javaWord d of
        Parsed "float" d3 e3 ->
          Parsed (DtFloat) d3 (max e3 e1)
        _ -> pappyAlt1_7 (max (ParseError (javaPos d) [Expected "float"]) e1)
    pappyAlt1_7 e1 =
      case javaWord d of
        Parsed "double" d3 e3 ->
          Parsed (DtDouble) d3 (max e3 e1)
        _ -> pappyAlt1_8 (max (ParseError (javaPos d) [Expected "double"]) e1)
    pappyAlt1_8 e1 =
      case javaWord d of
        Parsed "boolean" d3 e3 ->
          Parsed (DtBoolean) d3 (max e3 e1)
        _ -> pappyAlt1_9 (max (ParseError (javaPos d) [Expected "boolean"]) e1)
    pappyAlt1_9 e1 = NoParse e1

javaParseStarRule5 :: JavaDerivs -> Result JavaDerivs ([Identifier])
javaParseStarRule5 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "." d3 e3 ->
          case javaIdentifier d3 of
            Parsed v d5 e5 ->
              case javaStarRule5 d5 of
                Parsed vs d7 e7 ->
                  Parsed (v : vs) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "."]) e1)
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaQualifiedName :: JavaDerivs -> Result JavaDerivs ([Identifier])
javaQualifiedName d =
  case javaIdentifier d of
    Parsed i d1 e1 ->
      case javaStarRule5 d1 of
        Parsed is d3 e3 ->
          Parsed (i : is) d3 (max e3 e1)
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1

javaDimsOpt :: JavaDerivs -> Result JavaDerivs (Int)
javaDimsOpt d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaDims d of
        Parsed v3 d3 e3 -> Parsed v3 d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      Parsed (0) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParseDims :: JavaDerivs -> Result JavaDerivs (Int)
javaParseDims d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "[" d3 e3 ->
          case javaSym d3 of
            Parsed "]" d5 e5 ->
              case javaDims d5 of
                Parsed d d7 e7 ->
                  Parsed (d+1) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            _ -> pappyAlt1_2 (maximum [(ParseError (javaPos d3) [Expected "]"]),e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "["]) e1)
    pappyAlt1_2 e1 =
      case javaSym d of
        Parsed "[" d3 e3 ->
          case javaSym d3 of
            Parsed "]" d5 e5 ->
              Parsed (1) d5 (maximum [e5,e3,e1])
            _ -> pappyAlt1_3 (maximum [(ParseError (javaPos d3) [Expected "]"]),e3,e1])
        _ -> pappyAlt1_3 (max (ParseError (javaPos d) [Expected "["]) e1)
    pappyAlt1_3 e1 = NoParse e1

javaParseExpression :: JavaDerivs -> Result JavaDerivs (Expression)
javaParseExpression d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaCondExpr d of
        Parsed l d3 e3 ->
          case pappyResult5 of
            Parsed op d5 e5 ->
              case javaExpression d5 of
                Parsed r d7 e7 ->
                  Parsed (ExpBinary op l r) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
          where
            pappyResult5 =
              pappyAlt7_1 (ParseError (javaPos d3) []) where
                pappyAlt7_1 e7 =
                  case javaSym d3 of
                    Parsed "=" d9 e9 ->
                      Parsed ("=") d9 (max e9 e7)
                    _ -> pappyAlt7_2 (max (ParseError (javaPos d3) [Expected "="]) e7)
                pappyAlt7_2 e7 =
                  case javaSym d3 of
                    Parsed "+=" d9 e9 ->
                      Parsed ("+=") d9 (max e9 e7)
                    _ -> pappyAlt7_3 (max (ParseError (javaPos d3) [Expected "+="]) e7)
                pappyAlt7_3 e7 =
                  case javaSym d3 of
                    Parsed "-=" d9 e9 ->
                      Parsed ("-=") d9 (max e9 e7)
                    _ -> pappyAlt7_4 (max (ParseError (javaPos d3) [Expected "-="]) e7)
                pappyAlt7_4 e7 =
                  case javaSym d3 of
                    Parsed "*=" d9 e9 ->
                      Parsed ("*=") d9 (max e9 e7)
                    _ -> pappyAlt7_5 (max (ParseError (javaPos d3) [Expected "*="]) e7)
                pappyAlt7_5 e7 =
                  case javaSym d3 of
                    Parsed "/=" d9 e9 ->
                      Parsed ("/=") d9 (max e9 e7)
                    _ -> pappyAlt7_6 (max (ParseError (javaPos d3) [Expected "/="]) e7)
                pappyAlt7_6 e7 =
                  case javaSym d3 of
                    Parsed "%=" d9 e9 ->
                      Parsed ("%=") d9 (max e9 e7)
                    _ -> pappyAlt7_7 (max (ParseError (javaPos d3) [Expected "%="]) e7)
                pappyAlt7_7 e7 =
                  case javaSym d3 of
                    Parsed "&=" d9 e9 ->
                      Parsed ("&=") d9 (max e9 e7)
                    _ -> pappyAlt7_8 (max (ParseError (javaPos d3) [Expected "&="]) e7)
                pappyAlt7_8 e7 =
                  case javaSym d3 of
                    Parsed "|=" d9 e9 ->
                      Parsed ("|=") d9 (max e9 e7)
                    _ -> pappyAlt7_9 (max (ParseError (javaPos d3) [Expected "|="]) e7)
                pappyAlt7_9 e7 =
                  case javaSym d3 of
                    Parsed "^=" d9 e9 ->
                      Parsed ("^=") d9 (max e9 e7)
                    _ -> pappyAlt7_10 (max (ParseError (javaPos d3) [Expected "^="]) e7)
                pappyAlt7_10 e7 =
                  case javaSym d3 of
                    Parsed "<<=" d9 e9 ->
                      Parsed ("<<=") d9 (max e9 e7)
                    _ -> pappyAlt7_11 (max (ParseError (javaPos d3) [Expected "<<="]) e7)
                pappyAlt7_11 e7 =
                  case javaSym d3 of
                    Parsed ">>=" d9 e9 ->
                      Parsed (">>=") d9 (max e9 e7)
                    _ -> pappyAlt7_12 (max (ParseError (javaPos d3) [Expected ">>="]) e7)
                pappyAlt7_12 e7 =
                  case javaSym d3 of
                    Parsed ">>>=" d9 e9 ->
                      Parsed (">>>=") d9 (max e9 e7)
                    _ -> pappyAlt7_13 (max (ParseError (javaPos d3) [Expected ">>>="]) e7)
                pappyAlt7_13 e7 = NoParse e7
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      case javaCondExpr d of
        Parsed v3 d3 e3 -> Parsed v3 d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_3 (max e3 e1)
    pappyAlt1_3 e1 = NoParse e1

javaParseCondExpr :: JavaDerivs -> Result JavaDerivs (Expression)
javaParseCondExpr d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaCondOrExpr d of
        Parsed c d3 e3 ->
          case javaSym d3 of
            Parsed "?" d5 e5 ->
              case javaExpression d5 of
                Parsed t d7 e7 ->
                  case javaSym d7 of
                    Parsed ":" d9 e9 ->
                      case javaCondExpr d9 of
                        Parsed f d11 e11 ->
                          Parsed (ExpCond c t f) d11 (maximum [e11,e9,e7,e5,e3,e1])
                        NoParse e11 -> pappyAlt1_2 (maximum [e11,e9,e7,e5,e3,e1])
                    _ -> pappyAlt1_2 (maximum [(ParseError (javaPos d7) [Expected ":"]),e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            _ -> pappyAlt1_2 (maximum [(ParseError (javaPos d3) [Expected "?"]),e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      case javaCondOrExpr d of
        Parsed v3 d3 e3 -> Parsed v3 d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_3 (max e3 e1)
    pappyAlt1_3 e1 = NoParse e1

javaParseCondOrExprTail :: JavaDerivs -> Result JavaDerivs ((Expression -> Expression))
javaParseCondOrExprTail d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "||" d3 e3 ->
          case javaCondAndExpr d3 of
            Parsed r d5 e5 ->
              case javaCondOrExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary "||" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "||"]) e1)
    pappyAlt1_2 e1 =
      Parsed (\v -> v) d e1
    pappyAlt1_3 e1 = NoParse e1

javaCondOrExpr :: JavaDerivs -> Result JavaDerivs (Expression)
javaCondOrExpr d =
  case javaCondAndExpr d of
    Parsed l d1 e1 ->
      case javaCondOrExprTail d1 of
        Parsed t d3 e3 ->
          Parsed (t l) d3 (max e3 e1)
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1

javaParseCondAndExprTail :: JavaDerivs -> Result JavaDerivs ((Expression -> Expression))
javaParseCondAndExprTail d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "&&" d3 e3 ->
          case javaOrExpr d3 of
            Parsed r d5 e5 ->
              case javaCondAndExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary "&&" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "&&"]) e1)
    pappyAlt1_2 e1 =
      Parsed (\v -> v) d e1
    pappyAlt1_3 e1 = NoParse e1

javaCondAndExpr :: JavaDerivs -> Result JavaDerivs (Expression)
javaCondAndExpr d =
  case javaOrExpr d of
    Parsed l d1 e1 ->
      case javaCondAndExprTail d1 of
        Parsed t d3 e3 ->
          Parsed (t l) d3 (max e3 e1)
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1

javaParseOrExprTail :: JavaDerivs -> Result JavaDerivs ((Expression -> Expression))
javaParseOrExprTail d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "|" d3 e3 ->
          case javaXorExpr d3 of
            Parsed r d5 e5 ->
              case javaOrExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary "|" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "|"]) e1)
    pappyAlt1_2 e1 =
      Parsed (\v -> v) d e1
    pappyAlt1_3 e1 = NoParse e1

javaOrExpr :: JavaDerivs -> Result JavaDerivs (Expression)
javaOrExpr d =
  case javaXorExpr d of
    Parsed l d1 e1 ->
      case javaOrExprTail d1 of
        Parsed t d3 e3 ->
          Parsed (t l) d3 (max e3 e1)
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1

javaParseXorExprTail :: JavaDerivs -> Result JavaDerivs ((Expression -> Expression))
javaParseXorExprTail d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "^" d3 e3 ->
          case javaAndExpr d3 of
            Parsed r d5 e5 ->
              case javaXorExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary "^" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "^"]) e1)
    pappyAlt1_2 e1 =
      Parsed (\v -> v) d e1
    pappyAlt1_3 e1 = NoParse e1

javaXorExpr :: JavaDerivs -> Result JavaDerivs (Expression)
javaXorExpr d =
  case javaAndExpr d of
    Parsed l d1 e1 ->
      case javaXorExprTail d1 of
        Parsed t d3 e3 ->
          Parsed (t l) d3 (max e3 e1)
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1

javaParseAndExprTail :: JavaDerivs -> Result JavaDerivs ((Expression -> Expression))
javaParseAndExprTail d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "&" d3 e3 ->
          case javaEqExpr d3 of
            Parsed r d5 e5 ->
              case javaAndExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary "&" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "&"]) e1)
    pappyAlt1_2 e1 =
      Parsed (\v -> v) d e1
    pappyAlt1_3 e1 = NoParse e1

javaAndExpr :: JavaDerivs -> Result JavaDerivs (Expression)
javaAndExpr d =
  case javaEqExpr d of
    Parsed l d1 e1 ->
      case javaAndExprTail d1 of
        Parsed t d3 e3 ->
          Parsed (t l) d3 (max e3 e1)
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1

javaParseEqExprTail :: JavaDerivs -> Result JavaDerivs ((Expression -> Expression))
javaParseEqExprTail d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "==" d3 e3 ->
          case javaRelExpr d3 of
            Parsed r d5 e5 ->
              case javaEqExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary "==" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "=="]) e1)
    pappyAlt1_2 e1 =
      case javaSym d of
        Parsed "!=" d3 e3 ->
          case javaRelExpr d3 of
            Parsed r d5 e5 ->
              case javaEqExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary "!=" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_3 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_3 (maximum [e5,e3,e1])
        _ -> pappyAlt1_3 (max (ParseError (javaPos d) [Expected "!="]) e1)
    pappyAlt1_3 e1 =
      Parsed (\v -> v) d e1
    pappyAlt1_4 e1 = NoParse e1

javaEqExpr :: JavaDerivs -> Result JavaDerivs (Expression)
javaEqExpr d =
  case javaRelExpr d of
    Parsed l d1 e1 ->
      case javaEqExprTail d1 of
        Parsed t d3 e3 ->
          Parsed (t l) d3 (max e3 e1)
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1

javaParseRelExprTail :: JavaDerivs -> Result JavaDerivs ((Expression -> Expression))
javaParseRelExprTail d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "<=" d3 e3 ->
          case javaShiftExpr d3 of
            Parsed r d5 e5 ->
              case javaRelExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary "<=" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "<="]) e1)
    pappyAlt1_2 e1 =
      case javaSym d of
        Parsed ">=" d3 e3 ->
          case javaShiftExpr d3 of
            Parsed r d5 e5 ->
              case javaRelExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary ">=" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_3 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_3 (maximum [e5,e3,e1])
        _ -> pappyAlt1_3 (max (ParseError (javaPos d) [Expected ">="]) e1)
    pappyAlt1_3 e1 =
      case javaSym d of
        Parsed "<" d3 e3 ->
          case javaShiftExpr d3 of
            Parsed r d5 e5 ->
              case javaRelExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary "<" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_4 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_4 (maximum [e5,e3,e1])
        _ -> pappyAlt1_4 (max (ParseError (javaPos d) [Expected "<"]) e1)
    pappyAlt1_4 e1 =
      case javaSym d of
        Parsed ">" d3 e3 ->
          case javaShiftExpr d3 of
            Parsed r d5 e5 ->
              case javaRelExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary ">" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_5 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_5 (maximum [e5,e3,e1])
        _ -> pappyAlt1_5 (max (ParseError (javaPos d) [Expected ">"]) e1)
    pappyAlt1_5 e1 =
      case javaWord d of
        Parsed "instanceof" d3 e3 ->
          case javaTypeSpec d3 of
            Parsed t d5 e5 ->
              case javaRelExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpInstanceof l t)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_6 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_6 (maximum [e5,e3,e1])
        _ -> pappyAlt1_6 (max (ParseError (javaPos d) [Expected "instanceof"]) e1)
    pappyAlt1_6 e1 =
      Parsed (\v -> v) d e1
    pappyAlt1_7 e1 = NoParse e1

javaRelExpr :: JavaDerivs -> Result JavaDerivs (Expression)
javaRelExpr d =
  case javaShiftExpr d of
    Parsed l d1 e1 ->
      case javaRelExprTail d1 of
        Parsed t d3 e3 ->
          Parsed (t l) d3 (max e3 e1)
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1

javaParseShiftExprTail :: JavaDerivs -> Result JavaDerivs ((Expression -> Expression))
javaParseShiftExprTail d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "<<" d3 e3 ->
          case javaAddExpr d3 of
            Parsed r d5 e5 ->
              case javaShiftExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary "<<" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "<<"]) e1)
    pappyAlt1_2 e1 =
      case javaSym d of
        Parsed ">>" d3 e3 ->
          case javaAddExpr d3 of
            Parsed r d5 e5 ->
              case javaShiftExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary ">>" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_3 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_3 (maximum [e5,e3,e1])
        _ -> pappyAlt1_3 (max (ParseError (javaPos d) [Expected ">>"]) e1)
    pappyAlt1_3 e1 =
      case javaSym d of
        Parsed ">>>" d3 e3 ->
          case javaAddExpr d3 of
            Parsed r d5 e5 ->
              case javaShiftExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary ">>>" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_4 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_4 (maximum [e5,e3,e1])
        _ -> pappyAlt1_4 (max (ParseError (javaPos d) [Expected ">>>"]) e1)
    pappyAlt1_4 e1 =
      Parsed (\v -> v) d e1
    pappyAlt1_5 e1 = NoParse e1

javaShiftExpr :: JavaDerivs -> Result JavaDerivs (Expression)
javaShiftExpr d =
  case javaAddExpr d of
    Parsed l d1 e1 ->
      case javaShiftExprTail d1 of
        Parsed t d3 e3 ->
          Parsed (t l) d3 (max e3 e1)
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1

javaParseAddExprTail :: JavaDerivs -> Result JavaDerivs ((Expression -> Expression))
javaParseAddExprTail d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "+" d3 e3 ->
          case javaMultExpr d3 of
            Parsed r d5 e5 ->
              case javaAddExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary "+" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "+"]) e1)
    pappyAlt1_2 e1 =
      case javaSym d of
        Parsed "-" d3 e3 ->
          case javaMultExpr d3 of
            Parsed r d5 e5 ->
              case javaAddExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary "-" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_3 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_3 (maximum [e5,e3,e1])
        _ -> pappyAlt1_3 (max (ParseError (javaPos d) [Expected "-"]) e1)
    pappyAlt1_3 e1 =
      Parsed (\v -> v) d e1
    pappyAlt1_4 e1 = NoParse e1

javaAddExpr :: JavaDerivs -> Result JavaDerivs (Expression)
javaAddExpr d =
  case javaMultExpr d of
    Parsed l d1 e1 ->
      case javaAddExprTail d1 of
        Parsed t d3 e3 ->
          Parsed (t l) d3 (max e3 e1)
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1

javaParseMultExprTail :: JavaDerivs -> Result JavaDerivs ((Expression -> Expression))
javaParseMultExprTail d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "*" d3 e3 ->
          case javaUnaryExpr d3 of
            Parsed r d5 e5 ->
              case javaMultExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary "*" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "*"]) e1)
    pappyAlt1_2 e1 =
      case javaSym d of
        Parsed "/" d3 e3 ->
          case javaUnaryExpr d3 of
            Parsed r d5 e5 ->
              case javaMultExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary "/" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_3 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_3 (maximum [e5,e3,e1])
        _ -> pappyAlt1_3 (max (ParseError (javaPos d) [Expected "/"]) e1)
    pappyAlt1_3 e1 =
      case javaSym d of
        Parsed "%" d3 e3 ->
          case javaUnaryExpr d3 of
            Parsed r d5 e5 ->
              case javaMultExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpBinary "%" l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_4 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_4 (maximum [e5,e3,e1])
        _ -> pappyAlt1_4 (max (ParseError (javaPos d) [Expected "%"]) e1)
    pappyAlt1_4 e1 =
      Parsed (\v -> v) d e1
    pappyAlt1_5 e1 = NoParse e1

javaMultExpr :: JavaDerivs -> Result JavaDerivs (Expression)
javaMultExpr d =
  case javaUnaryExpr d of
    Parsed l d1 e1 ->
      case javaMultExprTail d1 of
        Parsed t d3 e3 ->
          Parsed (t l) d3 (max e3 e1)
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1

javaParseUnaryExpr :: JavaDerivs -> Result JavaDerivs (Expression)
javaParseUnaryExpr d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "++" d3 e3 ->
          case javaUnaryExpr d3 of
            Parsed e d5 e5 ->
              Parsed (ExpPrefix "++" e) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "++"]) e1)
    pappyAlt1_2 e1 =
      case javaSym d of
        Parsed "--" d3 e3 ->
          case javaUnaryExpr d3 of
            Parsed e d5 e5 ->
              Parsed (ExpPrefix "--" e) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_3 (maximum [e5,e3,e1])
        _ -> pappyAlt1_3 (max (ParseError (javaPos d) [Expected "--"]) e1)
    pappyAlt1_3 e1 =
      case javaSym d of
        Parsed "+" d3 e3 ->
          case javaUnaryExpr d3 of
            Parsed e d5 e5 ->
              Parsed (ExpPrefix "+" e) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_4 (maximum [e5,e3,e1])
        _ -> pappyAlt1_4 (max (ParseError (javaPos d) [Expected "+"]) e1)
    pappyAlt1_4 e1 =
      case javaSym d of
        Parsed "-" d3 e3 ->
          case javaUnaryExpr d3 of
            Parsed e d5 e5 ->
              Parsed (ExpPrefix "-" e) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_5 (maximum [e5,e3,e1])
        _ -> pappyAlt1_5 (max (ParseError (javaPos d) [Expected "-"]) e1)
    pappyAlt1_5 e1 =
      case javaUnaryExprNotPlusMinus d of
        Parsed v3 d3 e3 -> Parsed v3 d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_6 (max e3 e1)
    pappyAlt1_6 e1 = NoParse e1

javaParseUnaryExprNotPlusMinus :: JavaDerivs -> Result JavaDerivs (Expression)
javaParseUnaryExprNotPlusMinus d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "~" d3 e3 ->
          case javaUnaryExpr d3 of
            Parsed e d5 e5 ->
              Parsed (ExpPrefix "~" e) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "~"]) e1)
    pappyAlt1_2 e1 =
      case javaSym d of
        Parsed "!" d3 e3 ->
          case javaUnaryExpr d3 of
            Parsed e d5 e5 ->
              Parsed (ExpPrefix "!" e) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_3 (maximum [e5,e3,e1])
        _ -> pappyAlt1_3 (max (ParseError (javaPos d) [Expected "!"]) e1)
    pappyAlt1_3 e1 =
      case javaSym d of
        Parsed "(" d3 e3 ->
          case javaTypeName d3 of
            Parsed t d5 e5 ->
              case javaDims d5 of
                Parsed d d7 e7 ->
                  case javaSym d7 of
                    Parsed ")" d9 e9 ->
                      case javaUnaryExpr d9 of
                        Parsed e d11 e11 ->
                          Parsed (ExpCast (DtArray t d) e) d11 (maximum [e11,e9,e7,e5,e3,e1])
                        NoParse e11 -> pappyAlt1_4 (maximum [e11,e9,e7,e5,e3,e1])
                    _ -> pappyAlt1_4 (maximum [(ParseError (javaPos d7) [Expected ")"]),e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_4 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_4 (maximum [e5,e3,e1])
        _ -> pappyAlt1_4 (max (ParseError (javaPos d) [Expected "("]) e1)
    pappyAlt1_4 e1 =
      case javaSym d of
        Parsed "(" d3 e3 ->
          case javaPrimitiveType d3 of
            Parsed t d5 e5 ->
              case javaSym d5 of
                Parsed ")" d7 e7 ->
                  case javaUnaryExpr d7 of
                    Parsed e d9 e9 ->
                      Parsed (ExpCast t e) d9 (maximum [e9,e7,e5,e3,e1])
                    NoParse e9 -> pappyAlt1_5 (maximum [e9,e7,e5,e3,e1])
                _ -> pappyAlt1_5 (maximum [(ParseError (javaPos d5) [Expected ")"]),e5,e3,e1])
            NoParse e5 -> pappyAlt1_5 (maximum [e5,e3,e1])
        _ -> pappyAlt1_5 (max (ParseError (javaPos d) [Expected "("]) e1)
    pappyAlt1_5 e1 =
      case javaSym d of
        Parsed "(" d3 e3 ->
          case javaTypeName d3 of
            Parsed t d5 e5 ->
              case javaSym d5 of
                Parsed ")" d7 e7 ->
                  case javaUnaryExprNotPlusMinus d7 of
                    Parsed e d9 e9 ->
                      Parsed (ExpCast t e) d9 (maximum [e9,e7,e5,e3,e1])
                    NoParse e9 -> pappyAlt1_6 (maximum [e9,e7,e5,e3,e1])
                _ -> pappyAlt1_6 (maximum [(ParseError (javaPos d5) [Expected ")"]),e5,e3,e1])
            NoParse e5 -> pappyAlt1_6 (maximum [e5,e3,e1])
        _ -> pappyAlt1_6 (max (ParseError (javaPos d) [Expected "("]) e1)
    pappyAlt1_6 e1 =
      case javaPrimExpr d of
        Parsed l d3 e3 ->
          case javaPostfixExprTail d3 of
            Parsed t d5 e5 ->
              Parsed (t l) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_7 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_7 (max e3 e1)
    pappyAlt1_7 e1 = NoParse e1

javaParsePostfixExprTail :: JavaDerivs -> Result JavaDerivs ((Expression -> Expression))
javaParsePostfixExprTail d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "[" d3 e3 ->
          case pappyResult5 of
            Parsed r d5 e5 ->
              case javaSym d5 of
                Parsed "]" d7 e7 ->
                  case javaPostfixExprTail d7 of
                    Parsed pappyTail d9 e9 ->
                      Parsed (\l -> pappyTail (ExpArray l r)) d9 (maximum [e9,e7,e5,e3,e1])
                    NoParse e9 -> pappyAlt1_2 (maximum [e9,e7,e5,e3,e1])
                _ -> pappyAlt1_2 (maximum [(ParseError (javaPos d5) [Expected "]"]),e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
          where
            pappyResult5 =
              case javaExpression d3 of
                Parsed v7 d7 e7 -> Parsed (Just v7) d7 e7
                NoParse e7 -> Parsed (Nothing) d3 e7
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "["]) e1)
    pappyAlt1_2 e1 =
      case javaArguments d of
        Parsed a d3 e3 ->
          case javaPostfixExprTail d3 of
            Parsed pappyTail d5 e5 ->
              Parsed (\l -> pappyTail (ExpCall l a)) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_3 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_3 (max e3 e1)
    pappyAlt1_3 e1 =
      case javaSym d of
        Parsed "." d3 e3 ->
          case javaPrimExpr d3 of
            Parsed r d5 e5 ->
              case javaPostfixExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpSelect l r)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_4 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_4 (maximum [e5,e3,e1])
        _ -> pappyAlt1_4 (max (ParseError (javaPos d) [Expected "."]) e1)
    pappyAlt1_4 e1 =
      case javaSym d of
        Parsed "." d3 e3 ->
          case javaWord d3 of
            Parsed "class" d5 e5 ->
              case javaPostfixExprTail d5 of
                Parsed pappyTail d7 e7 ->
                  Parsed (\l -> pappyTail (ExpDotClass l)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_5 (maximum [e7,e5,e3,e1])
            _ -> pappyAlt1_5 (maximum [(ParseError (javaPos d3) [Expected "class"]),e3,e1])
        _ -> pappyAlt1_5 (max (ParseError (javaPos d) [Expected "."]) e1)
    pappyAlt1_5 e1 =
      case javaSym d of
        Parsed "++" d3 e3 ->
          case javaPostfixExprTail d3 of
            Parsed pappyTail d5 e5 ->
              Parsed (\l -> pappyTail (ExpPostfix "++" l)) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_6 (maximum [e5,e3,e1])
        _ -> pappyAlt1_6 (max (ParseError (javaPos d) [Expected "++"]) e1)
    pappyAlt1_6 e1 =
      case javaSym d of
        Parsed "--" d3 e3 ->
          case javaPostfixExprTail d3 of
            Parsed pappyTail d5 e5 ->
              Parsed (\l -> pappyTail (ExpPostfix "--" l)) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_7 (maximum [e5,e3,e1])
        _ -> pappyAlt1_7 (max (ParseError (javaPos d) [Expected "--"]) e1)
    pappyAlt1_7 e1 =
      Parsed (\v -> v) d e1
    pappyAlt1_8 e1 = NoParse e1

javaParsePlusRule0 :: JavaDerivs -> Result JavaDerivs ([Expression])
javaParsePlusRule0 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaDimExpr d of
        Parsed v d3 e3 ->
          case javaPlusRule0 d3 of
            Parsed vs d5 e5 ->
              Parsed (v : vs) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      case javaDimExpr d of
        Parsed v d3 e3 ->
          Parsed ([v]) d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_3 (max e3 e1)
    pappyAlt1_3 e1 = NoParse e1

javaParsePrimExpr :: JavaDerivs -> Result JavaDerivs (Expression)
javaParsePrimExpr d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case pappyResult3 of
        Parsed l d3 e3 ->
          Parsed (ExpLiteral l) d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
      where
        pappyResult3 =
          pappyAlt5_1 (ParseError (javaPos d) []) where
            pappyAlt5_1 e5 =
              case javaDigits d of
                Parsed m d7 e7 ->
                  case javaChar d7 of
                    Parsed '.' d9 _ ->
                      case pappyResult11 of
                        Parsed f d11 e11 ->
                          case javaExponentPartOpt d11 of
                            Parsed e d13 e13 ->
                              case javaFloatTypeSuffixOpt d13 of
                                Parsed t d15 e15 ->
                                  case javaStarRule0 d15 of
                                    Parsed _ d17 e17 ->
                                      Parsed (t (fromRational ((fromInteger m + f) * 10.0 ^^ e))) d17 (maximum [e17,e15,e13,e11,e7,e5])
                                    NoParse e17 -> pappyAlt5_2 (maximum [e17,e15,e13,e11,e7,e5])
                                NoParse e15 -> pappyAlt5_2 (maximum [e15,e13,e11,e7,e5])
                            NoParse e13 -> pappyAlt5_2 (maximum [e13,e11,e7,e5])
                        NoParse e11 -> pappyAlt5_2 (maximum [e11,e7,e5])
                      where
                        pappyResult11 =
                          pappyAlt13_1 (ParseError (javaPos d9) []) where
                            pappyAlt13_1 e13 =
                              case javaFractionPart d9 of
                                Parsed f d15 e15 ->
                                  Parsed (f) d15 (max e15 e13)
                                NoParse e15 -> pappyAlt13_2 (max e15 e13)
                            pappyAlt13_2 e13 =
                              Parsed (0.0) d9 e13
                            pappyAlt13_3 e13 = NoParse e13
                    _ -> pappyAlt5_2 (max e7 e5)
                NoParse e7 -> pappyAlt5_2 (max e7 e5)
            pappyAlt5_2 e5 =
              case javaChar d of
                Parsed '.' d7 _ ->
                  case javaFractionPart d7 of
                    Parsed f d9 e9 ->
                      case javaExponentPartOpt d9 of
                        Parsed e d11 e11 ->
                          case javaFloatTypeSuffixOpt d11 of
                            Parsed t d13 e13 ->
                              case javaStarRule0 d13 of
                                Parsed _ d15 e15 ->
                                  Parsed (t (fromRational (f * 10.0 ^^ e))) d15 (maximum [e15,e13,e11,e9,e5])
                                NoParse e15 -> pappyAlt5_3 (maximum [e15,e13,e11,e9,e5])
                            NoParse e13 -> pappyAlt5_3 (maximum [e13,e11,e9,e5])
                        NoParse e11 -> pappyAlt5_3 (maximum [e11,e9,e5])
                    NoParse e9 -> pappyAlt5_3 (max e9 e5)
                _ -> pappyAlt5_3 e5
            pappyAlt5_3 e5 =
              case javaDigits d of
                Parsed m d7 e7 ->
                  case javaExponentPart d7 of
                    Parsed e d9 e9 ->
                      case javaFloatTypeSuffixOpt d9 of
                        Parsed t d11 e11 ->
                          case javaStarRule0 d11 of
                            Parsed _ d13 e13 ->
                              Parsed (t (fromInteger m * 10.0 ^^ e)) d13 (maximum [e13,e11,e9,e7,e5])
                            NoParse e13 -> pappyAlt5_4 (maximum [e13,e11,e9,e7,e5])
                        NoParse e11 -> pappyAlt5_4 (maximum [e11,e9,e7,e5])
                    NoParse e9 -> pappyAlt5_4 (maximum [e9,e7,e5])
                NoParse e7 -> pappyAlt5_4 (max e7 e5)
            pappyAlt5_4 e5 =
              case javaDigits d of
                Parsed m d7 e7 ->
                  case javaExponentPartOpt d7 of
                    Parsed e d9 e9 ->
                      case javaFloatTypeSuffix d9 of
                        Parsed t d11 e11 ->
                          case javaStarRule0 d11 of
                            Parsed _ d13 e13 ->
                              Parsed (t (fromInteger m * 10.0 ^^ e)) d13 (maximum [e13,e11,e9,e7,e5])
                            NoParse e13 -> pappyAlt5_5 (maximum [e13,e11,e9,e7,e5])
                        NoParse e11 -> pappyAlt5_5 (maximum [e11,e9,e7,e5])
                    NoParse e9 -> pappyAlt5_5 (maximum [e9,e7,e5])
                NoParse e7 -> pappyAlt5_5 (max e7 e5)
            pappyAlt5_5 e5 =
              pappyAlt7_1 e5 where
                pappyAlt7_1 e7 =
                  case pappyResult9 of
                    Parsed v d9 e9 ->
                      case javaIntegerTypeSuffixOpt d9 of
                        Parsed t d11 e11 ->
                          case javaStarRule0 d11 of
                            Parsed _ d13 e13 ->
                              Parsed (t v) d13 (maximum [e13,e11,e9,e7])
                            NoParse e13 -> pappyAlt7_2 (maximum [e13,e11,e9,e7])
                        NoParse e11 -> pappyAlt7_2 (maximum [e11,e9,e7])
                    NoParse e9 -> pappyAlt7_2 (max e9 e7)
                  where
                    pappyResult9 =
                      case pappyResult11 of
                        Parsed _ d11 e11 ->
                          case pappyResult13 of
                            Parsed v d13 e13 ->
                              Parsed (v) d13 (max e13 e11)
                            NoParse e13 -> NoParse (max e13 e11)
                          where
                            pappyResult13 =
                              case pappyResult15 of
                                Parsed l d15 e15 ->
                                  case javaHexDigitsTail d15 of
                                    Parsed t d17 e17 ->
                                      Parsed (t l) d17 (max e17 e15)
                                    NoParse e17 -> NoParse (max e17 e15)
                                NoParse e15 -> NoParse e15
                              where
                                pappyResult15 =
                                  case javaHexDigit d11 of
                                    Parsed d d17 e17 ->
                                      Parsed (toInteger d) d17 e17
                                    NoParse e17 -> NoParse e17
                        NoParse e11 -> NoParse e11
                      where
                        pappyResult11 =
                          case javaChar d of
                            Parsed '0' d13 _ ->
                              case javaChar d13 of
                                Parsed 'x' d15 _ ->
                                  Parsed ("0x") d15 (ParseError (javaPos d15) [])
                                Parsed 'X' d15 _ ->
                                  Parsed ("0X") d15 (ParseError (javaPos d15) [])
                                _ -> NoParse (ParseError (javaPos d13) [])
                            _ -> NoParse (ParseError (javaPos d) [])
                pappyAlt7_2 e7 =
                  case pappyResult9 of
                    Parsed v d9 e9 ->
                      case javaIntegerTypeSuffixOpt d9 of
                        Parsed t d11 e11 ->
                          case javaStarRule0 d11 of
                            Parsed _ d13 e13 ->
                              Parsed (t v) d13 (maximum [e13,e11,e9,e7])
                            NoParse e13 -> pappyAlt7_3 (maximum [e13,e11,e9,e7])
                        NoParse e11 -> pappyAlt7_3 (maximum [e11,e9,e7])
                    NoParse e9 -> pappyAlt7_3 (max e9 e7)
                  where
                    pappyResult9 =
                      case javaChar d of
                        Parsed '0' d11 _ ->
                          case pappyResult13 of
                            Parsed v d13 e13 ->
                              Parsed (v) d13 e13
                            NoParse e13 -> NoParse e13
                          where
                            pappyResult13 =
                              case pappyResult15 of
                                Parsed l d15 e15 ->
                                  case javaOctalDigitsTail d15 of
                                    Parsed t d17 e17 ->
                                      Parsed (t l) d17 (max e17 e15)
                                    NoParse e17 -> NoParse (max e17 e15)
                                NoParse e15 -> NoParse e15
                              where
                                pappyResult15 =
                                  case javaOctalDigit d11 of
                                    Parsed d d17 e17 ->
                                      Parsed (toInteger d) d17 e17
                                    NoParse e17 -> NoParse e17
                        _ -> NoParse (ParseError (javaPos d) [])
                pappyAlt7_3 e7 =
                  case pappyResult9 of
                    Parsed v d9 e9 ->
                      case javaIntegerTypeSuffixOpt d9 of
                        Parsed t d11 e11 ->
                          case javaStarRule0 d11 of
                            Parsed _ d13 e13 ->
                              Parsed (t v) d13 (maximum [e13,e11,e9,e7])
                            NoParse e13 -> pappyAlt7_4 (maximum [e13,e11,e9,e7])
                        NoParse e11 -> pappyAlt7_4 (maximum [e11,e9,e7])
                    NoParse e9 -> pappyAlt7_4 (max e9 e7)
                  where
                    pappyResult9 =
                      case javaDigits d of
                        Parsed v d11 e11 ->
                          Parsed (v) d11 e11
                        NoParse e11 -> NoParse e11
                pappyAlt7_4 e7 = pappyAlt5_6 e7
            pappyAlt5_6 e5 =
              case javaBooleanLiteral d of
                Parsed v7 d7 e7 -> Parsed v7 d7 (max e7 e5)
                NoParse e7 -> pappyAlt5_7 (max e7 e5)
            pappyAlt5_7 e5 =
              case javaChar d of
                Parsed '\'' d7 _ ->
                  pappyAlt9_1 e5 where
                    pappyAlt9_1 e9 =
                      case pappyResult11 of
                        NoParse e11 ->
                          case pappyResult13 of
                            NoParse e13 ->
                              case javaInputCharacter d7 of
                                Parsed c d15 e15 ->
                                  case javaChar d15 of
                                    Parsed '\'' d17 _ ->
                                      case javaStarRule0 d17 of
                                        Parsed _ d19 e19 ->
                                          Parsed ( LitChar c ) d19 (maximum [e19,e15,e13,e11,e9])
                                        NoParse e19 -> pappyAlt9_2 (maximum [e19,e15,e13,e11,e9])
                                    _ -> pappyAlt9_2 (maximum [e15,e13,e11,e9])
                                NoParse e15 -> pappyAlt9_2 (maximum [e15,e13,e11,e9])
                            Parsed _ _ e13 -> pappyAlt9_2 (maximum [e13,e11,e9])
                          where
                            pappyResult13 =
                              case javaChar d7 of
                                Parsed '\\' d15 _ ->
                                  Parsed ("\\") d15 (ParseError (javaPos d15) [])
                                _ -> NoParse (ParseError (javaPos d7) [])
                        Parsed _ _ e11 -> pappyAlt9_2 (max e11 e9)
                      where
                        pappyResult11 =
                          case javaChar d7 of
                            Parsed '\'' d13 _ ->
                              Parsed ("'") d13 (ParseError (javaPos d13) [])
                            _ -> NoParse (ParseError (javaPos d7) [])
                    pappyAlt9_2 e9 =
                      case javaEscapeSequence d7 of
                        Parsed c d11 e11 ->
                          case javaChar d11 of
                            Parsed '\'' d13 _ ->
                              case javaStarRule0 d13 of
                                Parsed _ d15 e15 ->
                                  Parsed ( LitChar c ) d15 (maximum [e15,e11,e9])
                                NoParse e15 -> pappyAlt9_3 (maximum [e15,e11,e9])
                            _ -> pappyAlt9_3 (max e11 e9)
                        NoParse e11 -> pappyAlt9_3 (max e11 e9)
                    pappyAlt9_3 e9 = pappyAlt5_8 e9
                _ -> pappyAlt5_8 e5
            pappyAlt5_8 e5 =
              case javaChar d of
                Parsed '"' d7 _ ->
                  case javaStarRule4 d7 of
                    Parsed s d9 e9 ->
                      case javaChar d9 of
                        Parsed '"' d11 _ ->
                          case javaStarRule0 d11 of
                            Parsed _ d13 e13 ->
                              Parsed ( LitString s ) d13 (maximum [e13,e9,e5])
                            NoParse e13 -> pappyAlt5_9 (maximum [e13,e9,e5])
                        _ -> pappyAlt5_9 (max e9 e5)
                    NoParse e9 -> pappyAlt5_9 (max e9 e5)
                _ -> pappyAlt5_9 e5
            pappyAlt5_9 e5 =
              case javaWord d of
                Parsed "null" d7 e7 ->
                  Parsed ( LitNull ) d7 (max e7 e5)
                _ -> pappyAlt5_10 (max (ParseError (javaPos d) [Expected "null"]) e5)
            pappyAlt5_10 e5 = NoParse e5
    pappyAlt1_2 e1 =
      case javaIdentifier d of
        Parsed i d3 e3 ->
          Parsed (ExpIdent i) d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_3 (max e3 e1)
    pappyAlt1_3 e1 =
      case javaSym d of
        Parsed "(" d3 e3 ->
          case javaExpression d3 of
            Parsed e d5 e5 ->
              case javaSym d5 of
                Parsed ")" d7 e7 ->
                  Parsed (e) d7 (maximum [e7,e5,e3,e1])
                _ -> pappyAlt1_4 (maximum [(ParseError (javaPos d5) [Expected ")"]),e5,e3,e1])
            NoParse e5 -> pappyAlt1_4 (maximum [e5,e3,e1])
        _ -> pappyAlt1_4 (max (ParseError (javaPos d) [Expected "("]) e1)
    pappyAlt1_4 e1 =
      case javaWord d of
        Parsed "this" d3 e3 ->
          Parsed (ExpThis) d3 (max e3 e1)
        _ -> pappyAlt1_5 (max (ParseError (javaPos d) [Expected "this"]) e1)
    pappyAlt1_5 e1 =
      case javaWord d of
        Parsed "super" d3 e3 ->
          Parsed (ExpSuper) d3 (max e3 e1)
        _ -> pappyAlt1_6 (max (ParseError (javaPos d) [Expected "super"]) e1)
    pappyAlt1_6 e1 =
      case javaWord d of
        Parsed "new" d3 e3 ->
          case javaQualifiedName d3 of
            Parsed n d5 e5 ->
              case javaArguments d5 of
                Parsed a d7 e7 ->
                  case pappyResult9 of
                    Parsed b d9 e9 ->
                      Parsed (ExpNewClass n a b) d9 (maximum [e9,e7,e5,e3,e1])
                    NoParse e9 -> pappyAlt1_7 (maximum [e9,e7,e5,e3,e1])
                  where
                    pappyResult9 =
                      case javaClassBody d7 of
                        Parsed v11 d11 e11 -> Parsed (Just v11) d11 e11
                        NoParse e11 -> Parsed (Nothing) d7 e11
                NoParse e7 -> pappyAlt1_7 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_7 (maximum [e5,e3,e1])
        _ -> pappyAlt1_7 (max (ParseError (javaPos d) [Expected "new"]) e1)
    pappyAlt1_7 e1 =
      case javaWord d of
        Parsed "new" d3 e3 ->
          case javaTypeName d3 of
            Parsed t d5 e5 ->
              case javaPlusRule0 d5 of
                Parsed de d7 e7 ->
                  case javaDimsOpt d7 of
                    Parsed d d9 e9 ->
                      Parsed (ExpNewArray t de d) d9 (maximum [e9,e7,e5,e3,e1])
                    NoParse e9 -> pappyAlt1_8 (maximum [e9,e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_8 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_8 (maximum [e5,e3,e1])
        _ -> pappyAlt1_8 (max (ParseError (javaPos d) [Expected "new"]) e1)
    pappyAlt1_8 e1 =
      case javaWord d of
        Parsed "new" d3 e3 ->
          case javaTypeName d3 of
            Parsed t d5 e5 ->
              case javaDims d5 of
                Parsed d d7 e7 ->
                  case javaArrayInitializer d7 of
                    Parsed i d9 e9 ->
                      Parsed (ExpNewArrayInit t d i) d9 (maximum [e9,e7,e5,e3,e1])
                    NoParse e9 -> pappyAlt1_9 (maximum [e9,e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_9 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_9 (maximum [e5,e3,e1])
        _ -> pappyAlt1_9 (max (ParseError (javaPos d) [Expected "new"]) e1)
    pappyAlt1_9 e1 =
      case javaWord d of
        Parsed "void" d3 e3 ->
          case javaSym d3 of
            Parsed "." d5 e5 ->
              case javaWord d5 of
                Parsed "class" d7 e7 ->
                  Parsed (ExpVoidClass) d7 (maximum [e7,e5,e3,e1])
                _ -> pappyAlt1_10 (maximum [(ParseError (javaPos d5) [Expected "class"]),e5,e3,e1])
            _ -> pappyAlt1_10 (maximum [(ParseError (javaPos d3) [Expected "."]),e3,e1])
        _ -> pappyAlt1_10 (max (ParseError (javaPos d) [Expected "void"]) e1)
    pappyAlt1_10 e1 = NoParse e1

javaArguments :: JavaDerivs -> Result JavaDerivs ([Expression])
javaArguments d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "(" d3 e3 ->
          case javaExpression d3 of
            Parsed e d5 e5 ->
              case javaStarRule12 d5 of
                Parsed es d7 e7 ->
                  case javaSym d7 of
                    Parsed ")" d9 e9 ->
                      Parsed (e : es) d9 (maximum [e9,e7,e5,e3,e1])
                    _ -> pappyAlt1_2 (maximum [(ParseError (javaPos d7) [Expected ")"]),e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "("]) e1)
    pappyAlt1_2 e1 =
      case javaSym d of
        Parsed "(" d3 e3 ->
          case javaSym d3 of
            Parsed ")" d5 e5 ->
              Parsed ([]) d5 (maximum [e5,e3,e1])
            _ -> pappyAlt1_3 (maximum [(ParseError (javaPos d3) [Expected ")"]),e3,e1])
        _ -> pappyAlt1_3 (max (ParseError (javaPos d) [Expected "("]) e1)
    pappyAlt1_3 e1 = NoParse e1

javaDimExpr :: JavaDerivs -> Result JavaDerivs (Expression)
javaDimExpr d =
  case javaSym d of
    Parsed "[" d1 e1 ->
      case javaExpression d1 of
        Parsed e d3 e3 ->
          case javaSym d3 of
            Parsed "]" d5 e5 ->
              Parsed (e) d5 (maximum [e5,e3,e1])
            _ -> NoParse (maximum [(ParseError (javaPos d3) [Expected "]"]),e3,e1])
        NoParse e3 -> NoParse (max e3 e1)
    _ -> NoParse (ParseError (javaPos d) [Expected "["])

javaParseStarRule7 :: JavaDerivs -> Result JavaDerivs ([Initializer])
javaParseStarRule7 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaInitializer d of
        Parsed v d3 e3 ->
          case javaSym d3 of
            Parsed "," d5 e5 ->
              case javaStarRule7 d5 of
                Parsed vs d7 e7 ->
                  Parsed (v : vs) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            _ -> pappyAlt1_2 (maximum [(ParseError (javaPos d3) [Expected ","]),e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParseStarRule8 :: JavaDerivs -> Result JavaDerivs ([Initializer])
javaParseStarRule8 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "," d3 e3 ->
          case javaInitializer d3 of
            Parsed v d5 e5 ->
              case javaStarRule8 d5 of
                Parsed vs d7 e7 ->
                  Parsed (v : vs) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected ","]) e1)
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParseArrayInitializer :: JavaDerivs -> Result JavaDerivs ([Initializer])
javaParseArrayInitializer d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "{" d3 e3 ->
          case javaStarRule7 d3 of
            Parsed is d5 e5 ->
              case javaSym d5 of
                Parsed "}" d7 e7 ->
                  Parsed (is) d7 (maximum [e7,e5,e3,e1])
                _ -> pappyAlt1_2 (maximum [(ParseError (javaPos d5) [Expected "}"]),e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "{"]) e1)
    pappyAlt1_2 e1 =
      case javaSym d of
        Parsed "{" d3 e3 ->
          case javaInitializer d3 of
            Parsed i d5 e5 ->
              case javaStarRule8 d5 of
                Parsed is d7 e7 ->
                  case javaSym d7 of
                    Parsed "}" d9 e9 ->
                      Parsed (i : is) d9 (maximum [e9,e7,e5,e3,e1])
                    _ -> pappyAlt1_3 (maximum [(ParseError (javaPos d7) [Expected "}"]),e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_3 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_3 (maximum [e5,e3,e1])
        _ -> pappyAlt1_3 (max (ParseError (javaPos d) [Expected "{"]) e1)
    pappyAlt1_3 e1 = NoParse e1

javaInitializer :: JavaDerivs -> Result JavaDerivs (Initializer)
javaInitializer d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaArrayInitializer d of
        Parsed ai d3 e3 ->
          Parsed (IniList ai) d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      case javaExpression d of
        Parsed e d3 e3 ->
          Parsed (IniExpr e) d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_3 (max e3 e1)
    pappyAlt1_3 e1 = NoParse e1

javaBlock :: JavaDerivs -> Result JavaDerivs ([Statement])
javaBlock d =
  case javaSym d of
    Parsed "{" d1 e1 ->
      case javaStarRule14 d1 of
        Parsed ss d3 e3 ->
          case javaSym d3 of
            Parsed "}" d5 e5 ->
              Parsed (ss) d5 (maximum [e5,e3,e1])
            _ -> NoParse (maximum [(ParseError (javaPos d3) [Expected "}"]),e3,e1])
        NoParse e3 -> NoParse (max e3 e1)
    _ -> NoParse (ParseError (javaPos d) [Expected "{"])

javaParseStarRule10 :: JavaDerivs -> Result JavaDerivs ([CatchClause])
javaParseStarRule10 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaCatchClause d of
        Parsed v d3 e3 ->
          case javaStarRule10 d3 of
            Parsed vs d5 e5 ->
              Parsed (v : vs) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParsePlusRule1 :: JavaDerivs -> Result JavaDerivs ([CatchClause])
javaParsePlusRule1 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaCatchClause d of
        Parsed v d3 e3 ->
          case javaPlusRule1 d3 of
            Parsed vs d5 e5 ->
              Parsed (v : vs) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      case javaCatchClause d of
        Parsed v d3 e3 ->
          Parsed ([v]) d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_3 (max e3 e1)
    pappyAlt1_3 e1 = NoParse e1

javaParseStarRule11 :: JavaDerivs -> Result JavaDerivs ([SwitchGroup])
javaParseStarRule11 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case pappyResult3 of
        Parsed v d3 e3 ->
          case javaStarRule11 d3 of
            Parsed vs d5 e5 ->
              Parsed (v : vs) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
      where
        pappyResult3 =
          pappyAlt5_1 (ParseError (javaPos d) []) where
            pappyAlt5_1 e5 =
              case javaWord d of
                Parsed "case" d7 e7 ->
                  case javaExpression d7 of
                    Parsed e d9 e9 ->
                      case javaSym d9 of
                        Parsed ":" d11 e11 ->
                          case javaStarRule14 d11 of
                            Parsed ss d13 e13 ->
                              Parsed (SwCase e ss) d13 (maximum [e13,e11,e9,e7,e5])
                            NoParse e13 -> pappyAlt5_2 (maximum [e13,e11,e9,e7,e5])
                        _ -> pappyAlt5_2 (maximum [(ParseError (javaPos d9) [Expected ":"]),e9,e7,e5])
                    NoParse e9 -> pappyAlt5_2 (maximum [e9,e7,e5])
                _ -> pappyAlt5_2 (max (ParseError (javaPos d) [Expected "case"]) e5)
            pappyAlt5_2 e5 =
              case javaWord d of
                Parsed "default" d7 e7 ->
                  case javaSym d7 of
                    Parsed ":" d9 e9 ->
                      case javaStarRule14 d9 of
                        Parsed ss d11 e11 ->
                          Parsed (SwDefault ss) d11 (maximum [e11,e9,e7,e5])
                        NoParse e11 -> pappyAlt5_3 (maximum [e11,e9,e7,e5])
                    _ -> pappyAlt5_3 (maximum [(ParseError (javaPos d7) [Expected ":"]),e7,e5])
                _ -> pappyAlt5_3 (max (ParseError (javaPos d) [Expected "default"]) e5)
            pappyAlt5_3 e5 = NoParse e5
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParseStatement :: JavaDerivs -> Result JavaDerivs (Statement)
javaParseStatement d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaBlock d of
        Parsed b d3 e3 ->
          Parsed (StBlock b) d3 (max e3 e1)
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      case javaWord d of
        Parsed "if" d3 e3 ->
          case javaParExpr d3 of
            Parsed e d5 e5 ->
              case javaStatement d5 of
                Parsed t d7 e7 ->
                  case pappyResult9 of
                    Parsed f d9 e9 ->
                      Parsed (StIf e t f) d9 (maximum [e9,e7,e5,e3,e1])
                    NoParse e9 -> pappyAlt1_3 (maximum [e9,e7,e5,e3,e1])
                  where
                    pappyResult9 =
                      case pappyResult11 of
                        Parsed v11 d11 e11 -> Parsed (Just v11) d11 e11
                        NoParse e11 -> Parsed (Nothing) d7 e11
                      where
                        pappyResult11 =
                          case javaWord d7 of
                            Parsed "else" d13 e13 ->
                              case javaStatement d13 of
                                Parsed s d15 e15 ->
                                  Parsed (s) d15 (max e15 e13)
                                NoParse e15 -> NoParse (max e15 e13)
                            _ -> NoParse (ParseError (javaPos d7) [Expected "else"])
                NoParse e7 -> pappyAlt1_3 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_3 (maximum [e5,e3,e1])
        _ -> pappyAlt1_3 (max (ParseError (javaPos d) [Expected "if"]) e1)
    pappyAlt1_3 e1 =
      case javaWord d of
        Parsed "for" d3 e3 ->
          case javaSym d3 of
            Parsed "(" d5 e5 ->
              case pappyResult7 of
                Parsed i d7 e7 ->
                  case javaSym d7 of
                    Parsed ";" d9 e9 ->
                      case pappyResult11 of
                        Parsed c d11 e11 ->
                          case javaSym d11 of
                            Parsed ";" d13 e13 ->
                              case javaExpressionsOpt d13 of
                                Parsed n d15 e15 ->
                                  case javaSym d15 of
                                    Parsed ")" d17 e17 ->
                                      case javaStatement d17 of
                                        Parsed b d19 e19 ->
                                          Parsed (StFor i c n b) d19 (maximum [e19,e17,e15,e13,e11,e9,e7,e5,e3,e1])
                                        NoParse e19 -> pappyAlt1_4 (maximum [e19,e17,e15,e13,e11,e9,e7,e5,e3,e1])
                                    _ -> pappyAlt1_4 (maximum [(ParseError (javaPos d15) [Expected ")"]),e15,e13,e11,e9,e7,e5,e3,e1])
                                NoParse e15 -> pappyAlt1_4 (maximum [e15,e13,e11,e9,e7,e5,e3,e1])
                            _ -> pappyAlt1_4 (maximum [(ParseError (javaPos d11) [Expected ";"]),e11,e9,e7,e5,e3,e1])
                        NoParse e11 -> pappyAlt1_4 (maximum [e11,e9,e7,e5,e3,e1])
                      where
                        pappyResult11 =
                          case javaExpression d9 of
                            Parsed v13 d13 e13 -> Parsed (Just v13) d13 e13
                            NoParse e13 -> Parsed (Nothing) d9 e13
                    _ -> pappyAlt1_4 (maximum [(ParseError (javaPos d7) [Expected ";"]),e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_4 (maximum [e7,e5,e3,e1])
              where
                pappyResult7 =
                  pappyAlt9_1 (ParseError (javaPos d5) []) where
                    pappyAlt9_1 e9 =
                      case javaFinalOpt d5 of
                        Parsed f d11 e11 ->
                          case javaTypeSpec d11 of
                            Parsed t d13 e13 ->
                              case javaDeclarators d13 of
                                Parsed d d15 e15 ->
                                  Parsed (FiDecl f t d) d15 (maximum [e15,e13,e11,e9])
                                NoParse e15 -> pappyAlt9_2 (maximum [e15,e13,e11,e9])
                            NoParse e13 -> pappyAlt9_2 (maximum [e13,e11,e9])
                        NoParse e11 -> pappyAlt9_2 (max e11 e9)
                    pappyAlt9_2 e9 =
                      case javaExpressionsOpt d5 of
                        Parsed e d11 e11 ->
                          Parsed (FiExpr e) d11 (max e11 e9)
                        NoParse e11 -> pappyAlt9_3 (max e11 e9)
                    pappyAlt9_3 e9 = NoParse e9
            _ -> pappyAlt1_4 (maximum [(ParseError (javaPos d3) [Expected "("]),e3,e1])
        _ -> pappyAlt1_4 (max (ParseError (javaPos d) [Expected "for"]) e1)
    pappyAlt1_4 e1 =
      case javaWord d of
        Parsed "while" d3 e3 ->
          case javaParExpr d3 of
            Parsed e d5 e5 ->
              case javaStatement d5 of
                Parsed b d7 e7 ->
                  Parsed (StWhile e b) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_5 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_5 (maximum [e5,e3,e1])
        _ -> pappyAlt1_5 (max (ParseError (javaPos d) [Expected "while"]) e1)
    pappyAlt1_5 e1 =
      case javaWord d of
        Parsed "do" d3 e3 ->
          case javaStatement d3 of
            Parsed b d5 e5 ->
              case javaWord d5 of
                Parsed "while" d7 e7 ->
                  case javaParExpr d7 of
                    Parsed e d9 e9 ->
                      case javaSym d9 of
                        Parsed ";" d11 e11 ->
                          Parsed (StDo b e) d11 (maximum [e11,e9,e7,e5,e3,e1])
                        _ -> pappyAlt1_6 (maximum [(ParseError (javaPos d9) [Expected ";"]),e9,e7,e5,e3,e1])
                    NoParse e9 -> pappyAlt1_6 (maximum [e9,e7,e5,e3,e1])
                _ -> pappyAlt1_6 (maximum [(ParseError (javaPos d5) [Expected "while"]),e5,e3,e1])
            NoParse e5 -> pappyAlt1_6 (maximum [e5,e3,e1])
        _ -> pappyAlt1_6 (max (ParseError (javaPos d) [Expected "do"]) e1)
    pappyAlt1_6 e1 =
      case javaWord d of
        Parsed "try" d3 e3 ->
          case javaBlock d3 of
            Parsed b d5 e5 ->
              case javaStarRule10 d5 of
                Parsed c d7 e7 ->
                  case javaWord d7 of
                    Parsed "finally" d9 e9 ->
                      case javaBlock d9 of
                        Parsed f d11 e11 ->
                          Parsed (StTry b c (Just f)) d11 (maximum [e11,e9,e7,e5,e3,e1])
                        NoParse e11 -> pappyAlt1_7 (maximum [e11,e9,e7,e5,e3,e1])
                    _ -> pappyAlt1_7 (maximum [(ParseError (javaPos d7) [Expected "finally"]),e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_7 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_7 (maximum [e5,e3,e1])
        _ -> pappyAlt1_7 (max (ParseError (javaPos d) [Expected "try"]) e1)
    pappyAlt1_7 e1 =
      case javaWord d of
        Parsed "try" d3 e3 ->
          case javaBlock d3 of
            Parsed b d5 e5 ->
              case javaPlusRule1 d5 of
                Parsed c d7 e7 ->
                  Parsed (StTry b c Nothing) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_8 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_8 (maximum [e5,e3,e1])
        _ -> pappyAlt1_8 (max (ParseError (javaPos d) [Expected "try"]) e1)
    pappyAlt1_8 e1 =
      case javaWord d of
        Parsed "switch" d3 e3 ->
          case javaParExpr d3 of
            Parsed e d5 e5 ->
              case javaSym d5 of
                Parsed "{" d7 e7 ->
                  case javaStarRule11 d7 of
                    Parsed b d9 e9 ->
                      case javaSym d9 of
                        Parsed "}" d11 e11 ->
                          Parsed (StSwitch e b) d11 (maximum [e11,e9,e7,e5,e3,e1])
                        _ -> pappyAlt1_9 (maximum [(ParseError (javaPos d9) [Expected "}"]),e9,e7,e5,e3,e1])
                    NoParse e9 -> pappyAlt1_9 (maximum [e9,e7,e5,e3,e1])
                _ -> pappyAlt1_9 (maximum [(ParseError (javaPos d5) [Expected "{"]),e5,e3,e1])
            NoParse e5 -> pappyAlt1_9 (maximum [e5,e3,e1])
        _ -> pappyAlt1_9 (max (ParseError (javaPos d) [Expected "switch"]) e1)
    pappyAlt1_9 e1 =
      case javaWord d of
        Parsed "synchronized" d3 e3 ->
          case javaParExpr d3 of
            Parsed e d5 e5 ->
              case javaBlock d5 of
                Parsed b d7 e7 ->
                  Parsed (StSynch e b) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_10 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_10 (maximum [e5,e3,e1])
        _ -> pappyAlt1_10 (max (ParseError (javaPos d) [Expected "synchronized"]) e1)
    pappyAlt1_10 e1 =
      case javaWord d of
        Parsed "return" d3 e3 ->
          case pappyResult5 of
            Parsed e d5 e5 ->
              case javaSym d5 of
                Parsed ";" d7 e7 ->
                  Parsed (StReturn e) d7 (maximum [e7,e5,e3,e1])
                _ -> pappyAlt1_11 (maximum [(ParseError (javaPos d5) [Expected ";"]),e5,e3,e1])
            NoParse e5 -> pappyAlt1_11 (maximum [e5,e3,e1])
          where
            pappyResult5 =
              case javaExpression d3 of
                Parsed v7 d7 e7 -> Parsed (Just v7) d7 e7
                NoParse e7 -> Parsed (Nothing) d3 e7
        _ -> pappyAlt1_11 (max (ParseError (javaPos d) [Expected "return"]) e1)
    pappyAlt1_11 e1 =
      case javaWord d of
        Parsed "throw" d3 e3 ->
          case javaExpression d3 of
            Parsed e d5 e5 ->
              case javaSym d5 of
                Parsed ";" d7 e7 ->
                  Parsed (StThrow e) d7 (maximum [e7,e5,e3,e1])
                _ -> pappyAlt1_12 (maximum [(ParseError (javaPos d5) [Expected ";"]),e5,e3,e1])
            NoParse e5 -> pappyAlt1_12 (maximum [e5,e3,e1])
        _ -> pappyAlt1_12 (max (ParseError (javaPos d) [Expected "throw"]) e1)
    pappyAlt1_12 e1 =
      case javaWord d of
        Parsed "break" d3 e3 ->
          case pappyResult5 of
            Parsed i d5 e5 ->
              case javaSym d5 of
                Parsed ";" d7 e7 ->
                  Parsed (StBreak i) d7 (maximum [e7,e5,e3,e1])
                _ -> pappyAlt1_13 (maximum [(ParseError (javaPos d5) [Expected ";"]),e5,e3,e1])
            NoParse e5 -> pappyAlt1_13 (maximum [e5,e3,e1])
          where
            pappyResult5 =
              case javaIdentifier d3 of
                Parsed v7 d7 e7 -> Parsed (Just v7) d7 e7
                NoParse e7 -> Parsed (Nothing) d3 e7
        _ -> pappyAlt1_13 (max (ParseError (javaPos d) [Expected "break"]) e1)
    pappyAlt1_13 e1 =
      case javaWord d of
        Parsed "continue" d3 e3 ->
          case pappyResult5 of
            Parsed i d5 e5 ->
              case javaSym d5 of
                Parsed ";" d7 e7 ->
                  Parsed (StContinue i) d7 (maximum [e7,e5,e3,e1])
                _ -> pappyAlt1_14 (maximum [(ParseError (javaPos d5) [Expected ";"]),e5,e3,e1])
            NoParse e5 -> pappyAlt1_14 (maximum [e5,e3,e1])
          where
            pappyResult5 =
              case javaIdentifier d3 of
                Parsed v7 d7 e7 -> Parsed (Just v7) d7 e7
                NoParse e7 -> Parsed (Nothing) d3 e7
        _ -> pappyAlt1_14 (max (ParseError (javaPos d) [Expected "continue"]) e1)
    pappyAlt1_14 e1 =
      case javaIdentifier d of
        Parsed l d3 e3 ->
          case javaSym d3 of
            Parsed ":" d5 e5 ->
              case javaStatement d5 of
                Parsed s d7 e7 ->
                  Parsed (StLabel l s) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_15 (maximum [e7,e5,e3,e1])
            _ -> pappyAlt1_15 (maximum [(ParseError (javaPos d3) [Expected ":"]),e3,e1])
        NoParse e3 -> pappyAlt1_15 (max e3 e1)
    pappyAlt1_15 e1 =
      case javaExpression d of
        Parsed e d3 e3 ->
          case javaSym d3 of
            Parsed ";" d5 e5 ->
              Parsed (StExpr e) d5 (maximum [e5,e3,e1])
            _ -> pappyAlt1_16 (maximum [(ParseError (javaPos d3) [Expected ";"]),e3,e1])
        NoParse e3 -> pappyAlt1_16 (max e3 e1)
    pappyAlt1_16 e1 =
      case javaSym d of
        Parsed ";" d3 e3 ->
          Parsed (StNull) d3 (max e3 e1)
        _ -> pappyAlt1_17 (max (ParseError (javaPos d) [Expected ";"]) e1)
    pappyAlt1_17 e1 = NoParse e1

javaParExpr :: JavaDerivs -> Result JavaDerivs (Expression)
javaParExpr d =
  case javaSym d of
    Parsed "(" d1 e1 ->
      case javaExpression d1 of
        Parsed e d3 e3 ->
          case javaSym d3 of
            Parsed ")" d5 e5 ->
              Parsed (e) d5 (maximum [e5,e3,e1])
            _ -> NoParse (maximum [(ParseError (javaPos d3) [Expected ")"]),e3,e1])
        NoParse e3 -> NoParse (max e3 e1)
    _ -> NoParse (ParseError (javaPos d) [Expected "("])

javaFinalOpt :: JavaDerivs -> Result JavaDerivs (Bool)
javaFinalOpt d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaWord d of
        Parsed "final" d3 e3 ->
          Parsed (True) d3 (max e3 e1)
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "final"]) e1)
    pappyAlt1_2 e1 =
      Parsed (False) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParseStarRule12 :: JavaDerivs -> Result JavaDerivs ([Expression])
javaParseStarRule12 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "," d3 e3 ->
          case javaExpression d3 of
            Parsed v d5 e5 ->
              case javaStarRule12 d5 of
                Parsed vs d7 e7 ->
                  Parsed (v : vs) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected ","]) e1)
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaExpressionsOpt :: JavaDerivs -> Result JavaDerivs ([Expression])
javaExpressionsOpt d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaExpression d of
        Parsed e d3 e3 ->
          case javaStarRule12 d3 of
            Parsed es d5 e5 ->
              Parsed (e : es) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaCatchClause :: JavaDerivs -> Result JavaDerivs (CatchClause)
javaCatchClause d =
  case javaWord d of
    Parsed "catch" d1 e1 ->
      case javaSym d1 of
        Parsed "(" d3 e3 ->
          case javaFormalParam d3 of
            Parsed p d5 e5 ->
              case javaSym d5 of
                Parsed ")" d7 e7 ->
                  case javaBlock d7 of
                    Parsed b d9 e9 ->
                      Parsed ((p, b)) d9 (maximum [e9,e7,e5,e3,e1])
                    NoParse e9 -> NoParse (maximum [e9,e7,e5,e3,e1])
                _ -> NoParse (maximum [(ParseError (javaPos d5) [Expected ")"]),e5,e3,e1])
            NoParse e5 -> NoParse (maximum [e5,e3,e1])
        _ -> NoParse (max (ParseError (javaPos d1) [Expected "("]) e1)
    _ -> NoParse (ParseError (javaPos d) [Expected "catch"])

javaParseStarRule14 :: JavaDerivs -> Result JavaDerivs ([Statement])
javaParseStarRule14 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case pappyResult3 of
        Parsed v d3 e3 ->
          case javaStarRule14 d3 of
            Parsed vs d5 e5 ->
              Parsed (v : vs) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
      where
        pappyResult3 =
          pappyAlt5_1 (ParseError (javaPos d) []) where
            pappyAlt5_1 e5 =
              case javaDeclaration d of
                Parsed d d7 e7 ->
                  Parsed (StDecl d) d7 (max e7 e5)
                NoParse e7 -> pappyAlt5_2 (max e7 e5)
            pappyAlt5_2 e5 =
              case javaStatement d of
                Parsed v7 d7 e7 -> Parsed v7 d7 (max e7 e5)
                NoParse e7 -> pappyAlt5_3 (max e7 e5)
            pappyAlt5_3 e5 = NoParse e5
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParseFormalParam :: JavaDerivs -> Result JavaDerivs (FormalParam)
javaParseFormalParam d =
  case javaFinalOpt d of
    Parsed f d1 e1 ->
      case javaTypeSpec d1 of
        Parsed t d3 e3 ->
          case javaIdentifier d3 of
            Parsed i d5 e5 ->
              case javaDimsOpt d5 of
                Parsed d d7 e7 ->
                  Parsed ((f, t, i, d)) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> NoParse (maximum [e7,e5,e3,e1])
            NoParse e5 -> NoParse (maximum [e5,e3,e1])
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1

javaParseStarRule15 :: JavaDerivs -> Result JavaDerivs ([FormalParam])
javaParseStarRule15 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "," d3 e3 ->
          case javaFormalParam d3 of
            Parsed v d5 e5 ->
              case javaStarRule15 d5 of
                Parsed vs d7 e7 ->
                  Parsed (v : vs) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected ","]) e1)
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaFormalParams :: JavaDerivs -> Result JavaDerivs ([FormalParam])
javaFormalParams d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "(" d3 e3 ->
          case javaFormalParam d3 of
            Parsed p d5 e5 ->
              case javaStarRule15 d5 of
                Parsed ps d7 e7 ->
                  case javaSym d7 of
                    Parsed ")" d9 e9 ->
                      Parsed (p : ps) d9 (maximum [e9,e7,e5,e3,e1])
                    _ -> pappyAlt1_2 (maximum [(ParseError (javaPos d7) [Expected ")"]),e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "("]) e1)
    pappyAlt1_2 e1 =
      case javaSym d of
        Parsed "(" d3 e3 ->
          case javaSym d3 of
            Parsed ")" d5 e5 ->
              Parsed ([]) d5 (maximum [e5,e3,e1])
            _ -> pappyAlt1_3 (maximum [(ParseError (javaPos d3) [Expected ")"]),e3,e1])
        _ -> pappyAlt1_3 (max (ParseError (javaPos d) [Expected "("]) e1)
    pappyAlt1_3 e1 = NoParse e1

javaParseStarRule16 :: JavaDerivs -> Result JavaDerivs ([Declarator])
javaParseStarRule16 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "," d3 e3 ->
          case javaDeclarator d3 of
            Parsed v d5 e5 ->
              case javaStarRule16 d5 of
                Parsed vs d7 e7 ->
                  Parsed (v : vs) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected ","]) e1)
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaDeclarators :: JavaDerivs -> Result JavaDerivs ([Declarator])
javaDeclarators d =
  case javaDeclarator d of
    Parsed d d1 e1 ->
      case javaStarRule16 d1 of
        Parsed ds d3 e3 ->
          Parsed (d : ds) d3 (max e3 e1)
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1

javaDeclarator :: JavaDerivs -> Result JavaDerivs (Declarator)
javaDeclarator d =
  case javaIdentifier d of
    Parsed id d1 e1 ->
      case javaDimsOpt d1 of
        Parsed dim d3 e3 ->
          case pappyResult5 of
            Parsed init d5 e5 ->
              Parsed ((id, dim, init)) d5 (maximum [e5,e3,e1])
            NoParse e5 -> NoParse (maximum [e5,e3,e1])
          where
            pappyResult5 =
              case pappyResult7 of
                Parsed v7 d7 e7 -> Parsed (Just v7) d7 e7
                NoParse e7 -> Parsed (Nothing) d3 e7
              where
                pappyResult7 =
                  case javaSym d3 of
                    Parsed "=" d9 e9 ->
                      case javaInitializer d9 of
                        Parsed i d11 e11 ->
                          Parsed (i) d11 (max e11 e9)
                        NoParse e11 -> NoParse (max e11 e9)
                    _ -> NoParse (ParseError (javaPos d3) [Expected "="])
        NoParse e3 -> NoParse (max e3 e1)
    NoParse e1 -> NoParse e1

javaClassBody :: JavaDerivs -> Result JavaDerivs ([Declaration])
javaClassBody d =
  case javaSym d of
    Parsed "{" d1 e1 ->
      case javaStarRule27 d1 of
        Parsed ds d3 e3 ->
          case javaSym d3 of
            Parsed "}" d5 e5 ->
              Parsed (ds) d5 (maximum [e5,e3,e1])
            _ -> NoParse (maximum [(ParseError (javaPos d3) [Expected "}"]),e3,e1])
        NoParse e3 -> NoParse (max e3 e1)
    _ -> NoParse (ParseError (javaPos d) [Expected "{"])

javaParseStarRule23 :: JavaDerivs -> Result JavaDerivs ([Modifier])
javaParseStarRule23 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case pappyResult3 of
        Parsed v d3 e3 ->
          case javaStarRule23 d3 of
            Parsed vs d5 e5 ->
              Parsed (v : vs) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
      where
        pappyResult3 =
          pappyAlt5_1 (ParseError (javaPos d) []) where
            pappyAlt5_1 e5 =
              case javaWord d of
                Parsed "public" d7 e7 ->
                  Parsed (ModPublic) d7 (max e7 e5)
                _ -> pappyAlt5_2 (max (ParseError (javaPos d) [Expected "public"]) e5)
            pappyAlt5_2 e5 =
              case javaWord d of
                Parsed "protected" d7 e7 ->
                  Parsed (ModProtected) d7 (max e7 e5)
                _ -> pappyAlt5_3 (max (ParseError (javaPos d) [Expected "protected"]) e5)
            pappyAlt5_3 e5 =
              case javaWord d of
                Parsed "private" d7 e7 ->
                  Parsed (ModPrivate) d7 (max e7 e5)
                _ -> pappyAlt5_4 (max (ParseError (javaPos d) [Expected "private"]) e5)
            pappyAlt5_4 e5 =
              case javaWord d of
                Parsed "static" d7 e7 ->
                  Parsed (ModStatic) d7 (max e7 e5)
                _ -> pappyAlt5_5 (max (ParseError (javaPos d) [Expected "static"]) e5)
            pappyAlt5_5 e5 =
              case javaWord d of
                Parsed "abstract" d7 e7 ->
                  Parsed (ModAbstract) d7 (max e7 e5)
                _ -> pappyAlt5_6 (max (ParseError (javaPos d) [Expected "abstract"]) e5)
            pappyAlt5_6 e5 =
              case javaWord d of
                Parsed "final" d7 e7 ->
                  Parsed (ModFinal) d7 (max e7 e5)
                _ -> pappyAlt5_7 (max (ParseError (javaPos d) [Expected "final"]) e5)
            pappyAlt5_7 e5 =
              case javaWord d of
                Parsed "native" d7 e7 ->
                  Parsed (ModNative) d7 (max e7 e5)
                _ -> pappyAlt5_8 (max (ParseError (javaPos d) [Expected "native"]) e5)
            pappyAlt5_8 e5 =
              case javaWord d of
                Parsed "synchronized" d7 e7 ->
                  Parsed (ModSynchronized) d7 (max e7 e5)
                _ -> pappyAlt5_9 (max (ParseError (javaPos d) [Expected "synchronized"]) e5)
            pappyAlt5_9 e5 =
              case javaWord d of
                Parsed "transient" d7 e7 ->
                  Parsed (ModTransient) d7 (max e7 e5)
                _ -> pappyAlt5_10 (max (ParseError (javaPos d) [Expected "transient"]) e5)
            pappyAlt5_10 e5 =
              case javaWord d of
                Parsed "volatile" d7 e7 ->
                  Parsed (ModVolatile) d7 (max e7 e5)
                _ -> pappyAlt5_11 (max (ParseError (javaPos d) [Expected "volatile"]) e5)
            pappyAlt5_11 e5 =
              case javaWord d of
                Parsed "strictfp" d7 e7 ->
                  Parsed (ModStrictfp) d7 (max e7 e5)
                _ -> pappyAlt5_12 (max (ParseError (javaPos d) [Expected "strictfp"]) e5)
            pappyAlt5_12 e5 = NoParse e5
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParseStarRule24 :: JavaDerivs -> Result JavaDerivs ([DeclType])
javaParseStarRule24 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "," d3 e3 ->
          case javaTypeSpec d3 of
            Parsed v d5 e5 ->
              case javaStarRule24 d5 of
                Parsed vs d7 e7 ->
                  Parsed (v : vs) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected ","]) e1)
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParseDeclaration :: JavaDerivs -> Result JavaDerivs (Declaration)
javaParseDeclaration d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaStarRule23 d of
        Parsed ms d3 e3 ->
          case javaTypeSpec d3 of
            Parsed t d5 e5 ->
              case javaDeclarators d5 of
                Parsed ds d7 e7 ->
                  case javaSym d7 of
                    Parsed ";" d9 e9 ->
                      Parsed (DeclSimple ms t ds) d9 (maximum [e9,e7,e5,e3,e1])
                    _ -> pappyAlt1_2 (maximum [(ParseError (javaPos d7) [Expected ";"]),e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      case javaStarRule23 d of
        Parsed mods d3 e3 ->
          case pappyResult5 of
            Parsed typ d5 e5 ->
              case javaIdentifier d5 of
                Parsed id d7 e7 ->
                  case javaFormalParams d7 of
                    Parsed ps d9 e9 ->
                      case javaDimsOpt d9 of
                        Parsed dim d11 e11 ->
                          case javaThrowsOpt d11 of
                            Parsed th d13 e13 ->
                              case pappyResult15 of
                                Parsed body d15 e15 ->
                                  Parsed (DeclMethod mods typ id ps dim th body) d15 (maximum [e15,e13,e11,e9,e7,e5,e3,e1])
                                NoParse e15 -> pappyAlt1_3 (maximum [e15,e13,e11,e9,e7,e5,e3,e1])
                              where
                                pappyResult15 =
                                  pappyAlt17_1 (ParseError (javaPos d13) []) where
                                    pappyAlt17_1 e17 =
                                      case javaBlock d13 of
                                        Parsed b d19 e19 ->
                                          Parsed (Just b) d19 (max e19 e17)
                                        NoParse e19 -> pappyAlt17_2 (max e19 e17)
                                    pappyAlt17_2 e17 =
                                      case javaSym d13 of
                                        Parsed ";" d19 e19 ->
                                          Parsed (Nothing) d19 (max e19 e17)
                                        _ -> pappyAlt17_3 (max (ParseError (javaPos d13) [Expected ";"]) e17)
                                    pappyAlt17_3 e17 = NoParse e17
                            NoParse e13 -> pappyAlt1_3 (maximum [e13,e11,e9,e7,e5,e3,e1])
                        NoParse e11 -> pappyAlt1_3 (maximum [e11,e9,e7,e5,e3,e1])
                    NoParse e9 -> pappyAlt1_3 (maximum [e9,e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_3 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_3 (maximum [e5,e3,e1])
          where
            pappyResult5 =
              pappyAlt7_1 (ParseError (javaPos d3) []) where
                pappyAlt7_1 e7 =
                  case javaTypeSpec d3 of
                    Parsed t d9 e9 ->
                      Parsed (Just t) d9 (max e9 e7)
                    NoParse e9 -> pappyAlt7_2 (max e9 e7)
                pappyAlt7_2 e7 =
                  case javaWord d3 of
                    Parsed "void" d9 e9 ->
                      Parsed (Nothing) d9 (max e9 e7)
                    _ -> pappyAlt7_3 (max (ParseError (javaPos d3) [Expected "void"]) e7)
                pappyAlt7_3 e7 = NoParse e7
        NoParse e3 -> pappyAlt1_3 (max e3 e1)
    pappyAlt1_3 e1 =
      case javaStarRule23 d of
        Parsed mods d3 e3 ->
          case javaIdentifier d3 of
            Parsed id d5 e5 ->
              case javaFormalParams d5 of
                Parsed ps d7 e7 ->
                  case javaThrowsOpt d7 of
                    Parsed th d9 e9 ->
                      case javaBlock d9 of
                        Parsed body d11 e11 ->
                          Parsed (DeclConstructor mods id ps th body) d11 (maximum [e11,e9,e7,e5,e3,e1])
                        NoParse e11 -> pappyAlt1_4 (maximum [e11,e9,e7,e5,e3,e1])
                    NoParse e9 -> pappyAlt1_4 (maximum [e9,e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_4 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_4 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_4 (max e3 e1)
    pappyAlt1_4 e1 =
      case javaStarRule23 d of
        Parsed mods d3 e3 ->
          case javaWord d3 of
            Parsed "class" d5 e5 ->
              case javaIdentifier d5 of
                Parsed id d7 e7 ->
                  case pappyResult9 of
                    Parsed ext d9 e9 ->
                      case pappyResult11 of
                        Parsed imp d11 e11 ->
                          case javaClassBody d11 of
                            Parsed body d13 e13 ->
                              Parsed (DeclClass mods id ext imp body) d13 (maximum [e13,e11,e9,e7,e5,e3,e1])
                            NoParse e13 -> pappyAlt1_5 (maximum [e13,e11,e9,e7,e5,e3,e1])
                        NoParse e11 -> pappyAlt1_5 (maximum [e11,e9,e7,e5,e3,e1])
                      where
                        pappyResult11 =
                          pappyAlt13_1 (ParseError (javaPos d9) []) where
                            pappyAlt13_1 e13 =
                              case javaWord d9 of
                                Parsed "implements" d15 e15 ->
                                  case javaTypeSpec d15 of
                                    Parsed t d17 e17 ->
                                      case javaStarRule24 d17 of
                                        Parsed ts d19 e19 ->
                                          Parsed (t:ts) d19 (maximum [e19,e17,e15,e13])
                                        NoParse e19 -> pappyAlt13_2 (maximum [e19,e17,e15,e13])
                                    NoParse e17 -> pappyAlt13_2 (maximum [e17,e15,e13])
                                _ -> pappyAlt13_2 (max (ParseError (javaPos d9) [Expected "implements"]) e13)
                            pappyAlt13_2 e13 =
                              Parsed ([]) d9 e13
                            pappyAlt13_3 e13 = NoParse e13
                    NoParse e9 -> pappyAlt1_5 (maximum [e9,e7,e5,e3,e1])
                  where
                    pappyResult9 =
                      case pappyResult11 of
                        Parsed v11 d11 e11 -> Parsed (Just v11) d11 e11
                        NoParse e11 -> Parsed (Nothing) d7 e11
                      where
                        pappyResult11 =
                          case javaWord d7 of
                            Parsed "extends" d13 e13 ->
                              case javaTypeSpec d13 of
                                Parsed t d15 e15 ->
                                  Parsed (t) d15 (max e15 e13)
                                NoParse e15 -> NoParse (max e15 e13)
                            _ -> NoParse (ParseError (javaPos d7) [Expected "extends"])
                NoParse e7 -> pappyAlt1_5 (maximum [e7,e5,e3,e1])
            _ -> pappyAlt1_5 (maximum [(ParseError (javaPos d3) [Expected "class"]),e3,e1])
        NoParse e3 -> pappyAlt1_5 (max e3 e1)
    pappyAlt1_5 e1 =
      case javaStarRule23 d of
        Parsed mods d3 e3 ->
          case javaWord d3 of
            Parsed "interface" d5 e5 ->
              case javaIdentifier d5 of
                Parsed id d7 e7 ->
                  case pappyResult9 of
                    Parsed ext d9 e9 ->
                      case javaClassBody d9 of
                        Parsed body d11 e11 ->
                          Parsed (DeclInterface mods id ext body) d11 (maximum [e11,e9,e7,e5,e3,e1])
                        NoParse e11 -> pappyAlt1_6 (maximum [e11,e9,e7,e5,e3,e1])
                    NoParse e9 -> pappyAlt1_6 (maximum [e9,e7,e5,e3,e1])
                  where
                    pappyResult9 =
                      pappyAlt11_1 (ParseError (javaPos d7) []) where
                        pappyAlt11_1 e11 =
                          case javaWord d7 of
                            Parsed "extends" d13 e13 ->
                              case javaTypeSpec d13 of
                                Parsed t d15 e15 ->
                                  case javaStarRule24 d15 of
                                    Parsed ts d17 e17 ->
                                      Parsed (t:ts) d17 (maximum [e17,e15,e13,e11])
                                    NoParse e17 -> pappyAlt11_2 (maximum [e17,e15,e13,e11])
                                NoParse e15 -> pappyAlt11_2 (maximum [e15,e13,e11])
                            _ -> pappyAlt11_2 (max (ParseError (javaPos d7) [Expected "extends"]) e11)
                        pappyAlt11_2 e11 =
                          Parsed ([]) d7 e11
                        pappyAlt11_3 e11 = NoParse e11
                NoParse e7 -> pappyAlt1_6 (maximum [e7,e5,e3,e1])
            _ -> pappyAlt1_6 (maximum [(ParseError (javaPos d3) [Expected "interface"]),e3,e1])
        NoParse e3 -> pappyAlt1_6 (max e3 e1)
    pappyAlt1_6 e1 =
      case pappyResult3 of
        Parsed st d3 e3 ->
          case javaBlock d3 of
            Parsed b d5 e5 ->
              Parsed (DeclBlock st b) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_7 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_7 (max e3 e1)
      where
        pappyResult3 =
          pappyAlt5_1 (ParseError (javaPos d) []) where
            pappyAlt5_1 e5 =
              case javaWord d of
                Parsed "static" d7 e7 ->
                  Parsed (True) d7 (max e7 e5)
                _ -> pappyAlt5_2 (max (ParseError (javaPos d) [Expected "static"]) e5)
            pappyAlt5_2 e5 =
              Parsed (False) d e5
            pappyAlt5_3 e5 = NoParse e5
    pappyAlt1_7 e1 = NoParse e1

javaParseStarRule25 :: JavaDerivs -> Result JavaDerivs ([[Identifier]])
javaParseStarRule25 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaSym d of
        Parsed "," d3 e3 ->
          case javaQualifiedName d3 of
            Parsed v d5 e5 ->
              case javaStarRule25 d5 of
                Parsed vs d7 e7 ->
                  Parsed (v : vs) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected ","]) e1)
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaThrowsOpt :: JavaDerivs -> Result JavaDerivs ([Name])
javaThrowsOpt d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaWord d of
        Parsed "throws" d3 e3 ->
          case javaQualifiedName d3 of
            Parsed n d5 e5 ->
              case javaStarRule25 d5 of
                Parsed ns d7 e7 ->
                  Parsed (n : ns) d7 (maximum [e7,e5,e3,e1])
                NoParse e7 -> pappyAlt1_2 (maximum [e7,e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        _ -> pappyAlt1_2 (max (ParseError (javaPos d) [Expected "throws"]) e1)
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParseStarRule26 :: JavaDerivs -> Result JavaDerivs ([ImportDecl])
javaParseStarRule26 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case pappyResult3 of
        Parsed v d3 e3 ->
          case javaStarRule26 d3 of
            Parsed vs d5 e5 ->
              Parsed (v : vs) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
      where
        pappyResult3 =
          case javaWord d of
            Parsed "import" d5 e5 ->
              case javaQualifiedName d5 of
                Parsed name d7 e7 ->
                  case pappyResult9 of
                    Parsed allflag d9 e9 ->
                      case javaSym d9 of
                        Parsed ";" d11 e11 ->
                          Parsed ((name, allflag)) d11 (maximum [e11,e9,e7,e5])
                        _ -> NoParse (maximum [(ParseError (javaPos d9) [Expected ";"]),e9,e7,e5])
                    NoParse e9 -> NoParse (maximum [e9,e7,e5])
                  where
                    pappyResult9 =
                      pappyAlt11_1 (ParseError (javaPos d7) []) where
                        pappyAlt11_1 e11 =
                          case javaSym d7 of
                            Parsed "." d13 e13 ->
                              case javaSym d13 of
                                Parsed "*" d15 e15 ->
                                  Parsed (True) d15 (maximum [e15,e13,e11])
                                _ -> pappyAlt11_2 (maximum [(ParseError (javaPos d13) [Expected "*"]),e13,e11])
                            _ -> pappyAlt11_2 (max (ParseError (javaPos d7) [Expected "."]) e11)
                        pappyAlt11_2 e11 =
                          Parsed (False) d7 e11
                        pappyAlt11_3 e11 = NoParse e11
                NoParse e7 -> NoParse (max e7 e5)
            _ -> NoParse (ParseError (javaPos d) [Expected "import"])
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaParseStarRule27 :: JavaDerivs -> Result JavaDerivs ([Declaration])
javaParseStarRule27 d =
  pappyAlt1_1 (ParseError (javaPos d) []) where
    pappyAlt1_1 e1 =
      case javaDeclaration d of
        Parsed v d3 e3 ->
          case javaStarRule27 d3 of
            Parsed vs d5 e5 ->
              Parsed (v : vs) d5 (maximum [e5,e3,e1])
            NoParse e5 -> pappyAlt1_2 (maximum [e5,e3,e1])
        NoParse e3 -> pappyAlt1_2 (max e3 e1)
    pappyAlt1_2 e1 =
      Parsed ([]) d e1
    pappyAlt1_3 e1 = NoParse e1

javaCompilationUnit :: JavaDerivs -> Result JavaDerivs (CompUnit)
javaCompilationUnit d =
  case javaStarRule0 d of
    Parsed _ d1 e1 ->
      case pappyResult3 of
        Parsed pkg d3 e3 ->
          case javaStarRule26 d3 of
            Parsed imps d5 e5 ->
              case javaStarRule27 d5 of
                Parsed decls d7 e7 ->
                  case javaChar d7 of
                    NoParse e9 ->
                      Parsed ((pkg, imps, decls)) d7 (maximum [e9,e7,e5,e3,e1])
                    Parsed _ _ e9 -> NoParse (maximum [e9,e7,e5,e3,e1])
                NoParse e7 -> NoParse (maximum [e7,e5,e3,e1])
            NoParse e5 -> NoParse (maximum [e5,e3,e1])
        NoParse e3 -> NoParse (max e3 e1)
      where
        pappyResult3 =
          pappyAlt5_1 (ParseError (javaPos d1) []) where
            pappyAlt5_1 e5 =
              case javaWord d1 of
                Parsed "package" d7 e7 ->
                  case javaQualifiedName d7 of
                    Parsed n d9 e9 ->
                      case javaSym d9 of
                        Parsed ";" d11 e11 ->
                          Parsed (Just n) d11 (maximum [e11,e9,e7,e5])
                        _ -> pappyAlt5_2 (maximum [(ParseError (javaPos d9) [Expected ";"]),e9,e7,e5])
                    NoParse e9 -> pappyAlt5_2 (maximum [e9,e7,e5])
                _ -> pappyAlt5_2 (max (ParseError (javaPos d1) [Expected "package"]) e5)
            pappyAlt5_2 e5 =
              Parsed (Nothing) d1 e5
            pappyAlt5_3 e5 = NoParse e5
    NoParse e1 -> NoParse e1

