#!/usr/bin/env rune

# Copyright 2004 Kevin Reid.
# This source code and related files are distributed under the MIT License, as described in the document named "License.txt" which should be provided with this source distribution.

# rune -cpa lojban_peg_parser.jar -cpa pircbot.jar -cpa . jbokaj.e
# e__quasiParser(<file:jbokaj.e>.getText()).eval(privilegedScope)

def makePircBot      := <unsafe:EPircBot>
def makeLojbanParser := <unsafe:xtc.parser.PParser>

def bot

bind bot := makePircBot(def handlerForwarder {
  match msg {
    print("Loading; ")
    def handler := <import:jbokaj-handler>(bot, println, makeLojbanParser)
    println("Handling.")
    E.callWithPair(handler, msg)
    println("Done.")
  }
}, true, false)

bot.setConnectName("jbokaj")
bot.connect("irc.freenode.net")
bot.joinChannel("#jbokaj")
#bot.joinChannel("#jbosnu")
#bot.joinChannel("#lojban")

interp.blockAtTop()
#bot