// Copyright 2004 Kevin Reid.
// This source code and related files are distributed under the MIT License, as described in the document named "License.txt" which should be provided with this source distribution.

import org.jibble.pircbot.*;
import org.erights.e.elib.prim.E;
import org.erights.e.elib.ref.Ref;
import org.erights.e.elib.vat.Vat;

public class EPircBot extends PircBot {

    // I don't have the source for PircBot, but I'm pretty sure that the onFoo methods are called in a different vat. Therefore, we remember what vat we're in.
    Vat myVat;
    
    
    Object myHandler;

    public EPircBot(Object handler, boolean verbose, boolean startIdentServer) {
      super();
      myHandler = handler;
      myVat = Vat.getCurrentVat();
      
      // So that PircBot instances don't grant authority to do these things, these methods are disabled in the safej file.
      
      
      setVerbose(verbose);
      if (startIdentServer) {
        startIdentServer();
      }
    }
    
    /** PircBot.setName is protected */
    public void setConnectName(String name) {
      super.setName(name);
    }
    
    private void handle(String verb, Object[] args) {
      myVat.qSendAllOnly(myHandler, false, verb, args);
    }
    
    public void onMessage(String a, String b, String c, String d, String e) {
      handle("onMessage", new Object[]{ a, b, c, d, e });
    }
    
    public void onPrivateMessage(String a, String b, String c, String d) {
      handle("onPrivateMessage", new Object[]{ a, b, c, d });
    }
}

