#!/usr/bin/zsh

IFS='
'

run_sentence ()
{
    orig_sentence=$1

    sentence=`echo $orig_sentence | sed -e 's/GOOD/[032mGOOD[000m/' -e 's/BAD/[032mBAD[000m/'`
    # echo -n "*** Sentence: $sentence  "
    sentence=`echo $sentence | sed -e 's/.--..*//' | tr -d '!?+>-'`

    echo $sentence > /tmp/orig_sentence.$$
    echo $sentence | tr -dc "a-zA-Z'" | tr 'A-Z' 'a-z' > /tmp/orig_sentence.$$.2

    cat /tmp/orig_sentence.$$ >&p

    #read -p -e -t 10 | sed -e 's/[a-zA-Z0-9]*=//g' | tr -d "()[]" | \
	#sed -e 's/[         ][      ]*/ /g' > /tmp/javaout.$$
    read -p -e -t 60 > /tmp/javaout.$$
    read -p -e -t 60 >> /tmp/javaout.$$
    read -p -e -t 0 >> /tmp/javaout.$$
    read -p -e -t 0 >> /tmp/javaout.$$

    cat /tmp/javaout.$$ | grep 'Morphology pass:' > /tmp/javaout.$$.2

    mv /tmp/javaout.$$.2 /tmp/javaout.$$

    cat /tmp/javaout.$$ | sed -e 's/Morphology pass: //' -e 's/\.//g' \
    -e 's/\([A-Za-z]*=\)(  */\1/g' \
    -e 's/CMAVO/-/g' -e 's/\([ =]\)Y=/\1-/g' -e 's/CMENE/+/g' -e 's/BRIVLA/!/g' \
    -e 's/nonLojbanWord/>/g' -e 's/[=A-Za-z]*=//g' -e 's/ *) *//g' \
    -e 's/\([-+!>]\)/ \1/g' -e 's/+\([^ ]*\)/\1./g' -e 's/!\([^ ]*\)/(\1)/g' \
    -e 's/>\([^ ]*\)/>\1</g' -e 's/^  *//' -e 's/- -\([yY]*\)\([bB][uU]\)/-\1 -\2/' \
    > /tmp/javaout.$$.2

    mv /tmp/javaout.$$.2 /tmp/javaout.$$

    #sed -e "s/CMAVO=(  *[A-Za-z]*=(  *\([A-Za-z']*\)  *)  *)/-\1/g" \
    #-e "s/CMENE=(  *[A-Za-z]*=(  *\([A-Za-z']*\)  *)  *)/\1./g" \
    #-e "s/BRIVLA=(  *[A-Za-z]*=(  *\([A-Za-z']*\)  *)  *)/(\1)/g" \
    #-e "s/nonLojbanWord=(  *\([^)]*\)  *)/>\1</g" \
    #-e ": sub;s/spaces=(\([^)]*[^-y]\)\(yy*[^)]*\))/spaces=(\1-\2)/g;t sub" \
    #-e "s/BY=( y[^a-zA-Z']*bu )/-y -bu/" \
    #-e 's/[^ =]*=(//g' -e 's/  *)//g' -e 's/  */ /g' \
    #-e 's/Morphology pass: //' > /tmp/javaout.$$

    cat /tmp/orig_sentence.$$ | valfendi -als 2>&1 >/tmp/valfendiout.$$
    #sed 's/>[^<]*<//g' | tr -d '()-' >/tmp/valfendiout.$$

    # echo -n "$valfendires"
    # echo "[000m"

    diff -w /tmp/javaout.$$ /tmp/valfendiout.$$ 2>&1 >/dev/null
    valfendires=$?

    good=2
    if [ "`echo $orig_sentence | grep '[ .]BAD'`" ]
    then
	#echo "BAD $javares."
	if [ $javares -eq 1 ]
	then
	    good=1
	else
	    good=0
	fi
    fi
    #echo "Good1: $good"

    if [ "`echo $orig_sentence | grep '[ .]GOOD'`" ]
    then
	#echo "GOOD $javares."
	if [ $javares -eq 0 ]
	then
	    good=1
	else
	    good=0
	fi
    fi
    #echo "Good2: $good"

    # If not labelled good or bad, look for mismatch.
    if [ $good -eq 2 ]
    then
	if [ $valfendires -eq 1 ]
	then
	    good=0
	else
	    good=1
	fi
    fi
    #echo "Good3: $good"

    # If not good
    if [ $good -ne 1 ]
    then
	echo -n "*** Sentence: $orig_sentence  "
	echo -n "[033m$valfendires"
	echo "[000m"
	echo "MISMATCH!"
	echo "valfendi: `cat /tmp/valfendiout.$$`
pegbased: `cat /tmp/javaout.$$`
"
    fi

    setopt NULL_GLOB
    rm -f /tmp/parserout.* /tmp/fishout.* /tmp/javaout.* /tmp/parser_tree.* /tmp/fish_tree.* /tmp/java_tree.* /tmp/orig_sentence.* /tmp/valfendiout*
}

coproc ~/bin/myparser -M -s -b -f &

while [ `read -p -e -t 10` ]
do
done

for sentence in `cat ../morph_test_sentences.txt | grep -v '^#' | grep -v '[0-9]'`
do
    sentence=`echo $sentence | tr -d '()' | sed -e 's/,[ 	][ 	]$/ /g' -e 's/,$//'`
    if [ "`echo $sentence | grep '[[]'`" ]
    then
	sentence_with=`echo $sentence | tr -d '[]'`
	sentence_with="$sentence_with -- WITH"
	sentence_without=`echo $sentence | sed 's/[[][^]]*[]] *//g'`
	sentence_without="$sentence_without -- WITHOUT"
	run_sentence $sentence_with
	run_sentence $sentence_without

	sentence_dots=`echo $sentence_with | tr ' ' '.'`
	sentence_dots="$sentence_dots -- DOTS"
	# Maybe try this again later
	##run_sentence $sentence_dots
    else
	run_sentence $sentence

	sentence_dots=`echo $sentence | tr ' ' '.'`
	sentence_dots="$sentence_dots -- DOTS"
	# Maybe try this again later
	##run_sentence $sentence_dots
    fi
done

