    public static void main (String [] args) {
        PParser parser;
        String filename = null;
        long initTime = 0;
        long parseTime = 0;
        long startTime = 0;
        long stopTime = 0;
        if (args.length == 1)
        {
            filename = args[0];
            System.out.println("Java Parser Version 1.1 (for Java1.4 code):  Reading from file " + filename + " . . .");
            try
            {
                startTime = System.currentTimeMillis();
                parser = new PParser(new java.io.FileReader(filename), filename);
                stopTime = System.currentTimeMillis();
                initTime = stopTime - startTime;
            } catch (java.io.FileNotFoundException e)
            {
                System.out.println("Java Parser Version 1.1 (for Java1.4 code):  File " + filename + " not found.");
                return;
            }
        } else
        {
            System.out.println("Java Parser Version 1.1 (for Java1.4 code):  Usage is one of:");
            System.out.println("         java PParser inputfile");
            return;
        }

	try {
	    startTime = System.currentTimeMillis();
	    Result result = parser.ptext();
	    if (! result.hasValue()) {
		ParseError      err    = (ParseError)result;
		System.err.println();
		//Utilities.msg(err.msg, err.parser.location(), source);
		return;
	    }
	    stopTime = System.currentTimeMillis();
	    parseTime = stopTime - startTime;
	    System.out.println("   Lojban parser parsed " + filename + " successfully in " + (initTime + parseTime) + " ms.");
	    System.out.println("      parser initialization time was " + initTime + " ms.");
	    System.out.println("      parser parse time was " + parseTime + " ms.");
	    System.out.println("Value: " + result.semanticValue());
	} catch (Throwable x) {
	    while (null != x.getCause()) {
		x = x.getCause();
	    }
/*
	    if (x instanceof FileNotFoundException) {
		System.err.println(x.getMessage());
	    } else {
*/
		x.printStackTrace();
//	    }
	}
    }
