#!/usr/bin/perl

print "parser Lojban:
{
    import Char
    iport System	
}
top Text
";

while(<STDIN>)
{
    if( /^;/ ) # If comment
    {
	s/^;/--/;
	print;
	next;
    }

    # Add type and change <- to =
    s/^(\S)(\S+) <- /\u\1\2 :: String = /;

    # Fix - and _
    s/[-_](.)/\u$1/g;

    print;
}

print "
{
lojbanParseFile :: FilePath -> IO CompUnit
lojbanParseFile name =
    do	text <- readFile name
	case lojbanText text of
	    Parsed cu _ _ -> return cu
	    NoParse e -> fail (show e)

}
";
