module Main where

import IO
import System
import Lojban

processArgs =
	do	args <- getArgs
		case args of
			[inname] -> return (inname, mkoutname inname)
			[inname, outname] -> return (inname, outname)
			_ -> usage

	where
	mkoutname inname =
		case reverse inname of
			'y':'p':'p':'a':'p':'.':inr ->
				reverse inr ++ ".hs"
			_ -> inname ++ ".hs"

	usage = fail "Usage: pappy <infile> [<outfile>]"


processFile inname outname =
	do	string <- lojbanParseFile inname
		putStrLn ("Output: " ++ string)

main = do	(inname, outname) <- processArgs
		processFile inname outname

