/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import xtc.tree.Annotation;
import xtc.tree.Node;
import xtc.tree.VisitingException;
import xtc.tree.VisitorException;

public abstract class Visitor {
    private static final int CACHE_SIZE = 300;
    private static final int CACHE_CAPACITY = 400;
    private static final float CACHE_LOAD = 0.75f;
    private static final LinkedHashMap cache = new LinkedHashMap(400, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 300;
        }
    };
    private static final CacheKey key = new CacheKey(null, null);
    private static final Object[] arguments = new Object[]{null};
    private static final Class[] types = new Class[]{null};
    static /* synthetic */ Class class$xtc$tree$GNode;
    static /* synthetic */ Class class$xtc$tree$Node;
    static /* synthetic */ Class class$java$lang$Object;

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public Object visit(Annotation annotation) {
        return this.dispatch(annotation.node);
    }

    public final Object dispatch(Node node) {
        if (null == node) {
            return null;
        }
        Visitor.key.visitor = this;
        Visitor.key.node = node.isGeneric() ? node.getName() : node.getClass();
        CacheValue cacheValue = (CacheValue)cache.get(key);
        if (null == cacheValue) {
            cacheValue = Visitor.determineValue(this, node);
            cache.put(new CacheKey(this, Visitor.key.node), cacheValue);
        }
        try {
            if (cacheValue.visit) {
                Visitor.arguments[0] = node;
                Object object = cacheValue.method.invoke((Object)this, arguments);
                return cacheValue.returnsVoid ? node : object;
            }
            Visitor.arguments[0] = this;
            Object object = cacheValue.method.invoke((Object)node, arguments);
            return cacheValue.returnsVoid ? node : object;
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof VisitingException) {
                throw (VisitingException)throwable;
            }
            if (throwable instanceof VisitorException) {
                throw (VisitorException)throwable;
            }
            String string = "Unable to visit node " + node + " with visitor " + this;
            if (null != throwable) {
                throw new VisitingException(string, throwable);
            }
            throw new VisitingException(string, exception);
        }
    }

    private static CacheValue determineValue(Visitor visitor, Node node) {
        Class<?> clazz = visitor.getClass();
        Class<?> clazz2 = node.getClass();
        boolean bl = false;
        Method method = null;
        if (node.isGeneric()) {
            method = Visitor.findMethod(clazz, "visit" + node.getName(), class$xtc$tree$GNode == null ? (class$xtc$tree$GNode = Visitor.class$("xtc.tree.GNode")) : class$xtc$tree$GNode, false);
            if (null == method && null == (method = Visitor.findMethod(clazz, "visit", class$xtc$tree$GNode == null ? (class$xtc$tree$GNode = Visitor.class$("xtc.tree.GNode")) : class$xtc$tree$GNode, false))) {
                method = Visitor.findMethod(clazz, "visit", class$xtc$tree$Node == null ? (class$xtc$tree$Node = Visitor.class$("xtc.tree.Node")) : class$xtc$tree$Node, false);
            }
            bl = true;
        } else {
            method = Visitor.findMethod(clazz2, "visitWith", clazz, true);
            if (null == method) {
                method = Visitor.findMethod(clazz, "visit", clazz2, true);
                bl = true;
            }
        }
        if (null == method) {
            throw new VisitorException("No method to visit node " + node + " with visitor " + visitor);
        }
        return new CacheValue(bl, method);
    }

    private static Method findMethod(Class clazz, String string, Class clazz2, boolean bl) {
        Method method = null;
        do {
            Visitor.types[0] = clazz2;
            try {
                method = clazz.getMethod(string, types);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!bl) continue;
                Class<?>[] classArray = clazz2.getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    Visitor.types[0] = classArray[i];
                    try {
                        method = clazz.getMethod(string, types);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        // empty catch block
                    }
                    if (null != method) break;
                }
                clazz2 = clazz2.getSuperclass();
            }
        } while (bl && null == method && (class$java$lang$Object == null ? Visitor.class$("java.lang.Object") : class$java$lang$Object) != clazz2);
        return method;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class CacheValue {
        public final boolean visit;
        public final boolean returnsVoid;
        public final Method method;

        public CacheValue(boolean bl, Method method) {
            this.visit = bl;
            this.method = method;
            this.returnsVoid = method.getReturnType().equals(Void.TYPE);
        }
    }

    static final class CacheKey {
        public Visitor visitor;
        public Object node;

        public CacheKey(Visitor visitor, Object object) {
            this.visitor = visitor;
            this.node = object;
        }

        public int hashCode() {
            return 37 * this.visitor.hashCode() + this.node.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            if (!this.visitor.equals(cacheKey.visitor)) {
                return false;
            }
            return this.node.equals(cacheKey.node);
        }
    }
}

