/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GrammarVisitor;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.Production;
import xtc.parser.Rats;
import xtc.tree.Node;

public class RootFinder
extends GrammarVisitor {
    public static final String ROOT = "xtc.parser.RootFinder.Root";
    protected Set topLevel = new HashSet();

    public RootFinder(Analyzer analyzer) {
        super(analyzer);
    }

    public Object visit(Module module) {
        Node node;
        if (module.hasProperty(ROOT)) {
            return null;
        }
        this.analyzer.register(this);
        this.analyzer.init(module);
        this.topLevel.clear();
        Iterator iterator = module.productions.iterator();
        while (iterator.hasNext()) {
            node = (Production)iterator.next();
            if (!node.hasAttribute(Constants.ATT_PUBLIC)) continue;
            this.topLevel.add(node.qName);
        }
        if (1 == this.topLevel.size()) {
            module.setProperty(ROOT, this.topLevel.toArray()[0]);
            return null;
        }
        iterator = this.topLevel.iterator();
        while (iterator.hasNext()) {
            this.analyzer.unmarkAll();
            this.analyzer.mark(this.topLevel);
            node = (NonTerminal)iterator.next();
            this.analyzer.notWorkingOnAny();
            this.dispatch(node);
            if (this.analyzer.hasMarked()) continue;
            if (Rats.optionVerbose) {
                System.err.println("[Recognizing " + node + " as real root]");
            }
            module.setProperty(ROOT, node);
            break;
        }
        return null;
    }

    public Element visit(NonTerminal nonTerminal) {
        FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
        if (!this.analyzer.isBeingWorkedOn(fullProduction.qName)) {
            this.analyzer.workingOn(fullProduction.qName);
            this.analyzer.unmark(fullProduction.qName);
            this.dispatch(fullProduction);
        }
        return nonTerminal;
    }
}

