/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.parser.Action;
import xtc.parser.ActionBaseValue;
import xtc.parser.AlternativeAddition;
import xtc.parser.AlternativeRemoval;
import xtc.parser.AnyChar;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharClass;
import xtc.parser.CharLiteral;
import xtc.parser.CharRange;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.FollowedBy;
import xtc.parser.FullProduction;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.ModuleDependency;
import xtc.parser.ModuleImport;
import xtc.parser.ModuleInstantiation;
import xtc.parser.ModuleList;
import xtc.parser.ModuleModification;
import xtc.parser.ModuleName;
import xtc.parser.NonTerminal;
import xtc.parser.NotFollowedBy;
import xtc.parser.NullValue;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.ProductionOverride;
import xtc.parser.ProperListValue;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.SequenceName;
import xtc.parser.SingletonListValue;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.StringValue;
import xtc.parser.TextValue;
import xtc.parser.VoidedElement;
import xtc.tree.Attribute;
import xtc.tree.Comment;
import xtc.tree.Printer;
import xtc.tree.Visitor;

public class PrettyPrinter
extends Visitor {
    public static final boolean MARK_CHOICE = true;
    protected Printer printer;
    protected boolean newline;
    protected boolean parenChoice;
    protected boolean parenSequence;

    protected PrettyPrinter() {
    }

    public PrettyPrinter(Printer printer) {
        this.printer = printer;
        printer.register(this);
    }

    protected int stringEscapes() {
        return 8;
    }

    protected int regexEscapes() {
        return 12;
    }

    public void flush() {
        this.printer.flush();
    }

    public void visit(Attribute attribute) {
        this.printer.p(attribute.name);
        if (null != attribute.value) {
            this.printer.p('(').p(attribute.value.toString()).p(')');
        }
    }

    public void visit(Grammar grammar) {
        Iterator iterator = grammar.modules.iterator();
        while (iterator.hasNext()) {
            this.dispatch((Module)iterator.next());
        }
    }

    protected void printDocumentation(Module module) {
        Comment comment = module.documentation;
        if (null == comment) {
            return;
        }
        int n = comment.text.size();
        if (0 != n) {
            if (1 == n) {
                this.printer.indent().p("/** ").p((String)comment.text.get(0)).pln(" */");
            } else {
                this.printer.indent().pln("/**");
                for (int i = 0; i < n; ++i) {
                    this.printer.indent().p(" * ").pln((String)comment.text.get(i));
                }
                this.printer.indent().pln(" */");
            }
        }
    }

    protected void printModule(Module module) {
        this.printer.indent().p("module ").p(module.name);
        if (null != module.parameters && 0 < module.parameters.length()) {
            this.printer.p(module.parameters);
        }
        if (module.name.hasProperty("xtc.Constants.Original") || module.hasProperty("xtc.Constants.Arguments")) {
            ModuleName moduleName = module.name.hasProperty("xtc.Constants.Original") ? (ModuleName)module.name.getProperty("xtc.Constants.Original") : module.name;
            ModuleList moduleList = (ModuleList)module.getProperty("xtc.Constants.Arguments");
            this.printer.p(" /* = ").p(moduleName);
            if (null == moduleList) {
                this.printer.p("()");
            } else {
                this.printer.p(moduleList);
            }
            this.printer.p(" */ ");
        }
        this.printer.pln(';');
    }

    protected void printActions(Module module) {
        if (null != module.header) {
            this.printer.pln().indent().p("header ").p(module.header);
            if (1 == module.header.code.size()) {
                this.printer.pln();
            }
        }
        if (null != module.body) {
            this.printer.pln().indent().p("body ").p(module.body);
            if (1 == module.body.code.size()) {
                this.printer.pln();
            }
        }
        if (null != module.footer) {
            this.printer.pln().indent().p("footer ").p(module.footer);
            if (1 == module.footer.code.size()) {
                this.printer.pln();
            }
        }
    }

    protected void printOption(Module module) {
        if (null != module.attributes && 0 < module.attributes.size()) {
            this.printer.pln().indent().p("option ");
            Iterator iterator = module.attributes.iterator();
            while (iterator.hasNext()) {
                this.printer.buffer().p((Attribute)iterator.next());
                if (iterator.hasNext()) {
                    this.printer.p(", ");
                } else {
                    this.printer.p(';');
                }
                this.printer.fitMore();
            }
            this.printer.pln();
        }
    }

    public void visit(Module module) {
        Iterator iterator;
        this.printer.sep();
        this.printer.indent().p("// Generated by Rats!, version ").p("1.7.1").p(", ").pln("(C) 2004-2005 Robert Grimm");
        this.printer.sep();
        this.printer.pln();
        this.printDocumentation(module);
        this.printModule(module);
        if (null != module.dependencies && 0 < module.dependencies.size()) {
            this.printer.pln();
            iterator = module.dependencies.iterator();
            while (iterator.hasNext()) {
                this.printer.p((ModuleDependency)iterator.next());
            }
        }
        this.printActions(module);
        this.printOption(module);
        this.printer.pln();
        iterator = module.productions.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Production)iterator.next());
        }
        this.printer.sep().pln();
    }

    protected void print(ModuleDependency moduleDependency, String string) {
        this.printer.indent().p(string).p(' ').p(moduleDependency.module);
        if (0 != moduleDependency.arguments.length()) {
            this.printer.p(moduleDependency.arguments);
        }
        if (null != moduleDependency.target) {
            this.printer.buffer().p(" as ").p(moduleDependency.target).fitMore();
        }
        this.printer.pln(';');
    }

    public void visit(ModuleImport moduleImport) {
        this.print(moduleImport, "import");
    }

    public void visit(ModuleInstantiation moduleInstantiation) {
        this.print(moduleInstantiation, "instantiate");
    }

    public void visit(ModuleModification moduleModification) {
        this.print(moduleModification, "modify");
    }

    public void visit(ModuleList moduleList) {
        this.printer.p('(');
        Iterator iterator = moduleList.names.iterator();
        while (iterator.hasNext()) {
            this.printer.buffer().p((ModuleName)iterator.next());
            if (iterator.hasNext()) {
                this.printer.p(", ");
            }
            this.printer.fitMore();
        }
        this.printer.p(')');
    }

    public void visit(ModuleName moduleName) {
        this.printer.p(moduleName.name);
    }

    protected void enter(Production production) {
        Object object;
        if (production.hasProperty("xtc.parser.DuplicateProductionFolder.Duplicates")) {
            object = (List)production.getProperty("xtc.parser.DuplicateProductionFolder.Duplicates");
            this.printer.indent().pln("/*");
            this.printer.indent().p(" * The following production is the result of ").p("folding duplicates ");
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.printer.buffer();
                if (1 < object.size() && !iterator.hasNext()) {
                    this.printer.p("and ");
                }
                this.printer.p(string);
                if (2 == object.size() && iterator.hasNext()) {
                    this.printer.p(' ');
                } else if (iterator.hasNext()) {
                    this.printer.p(", ");
                } else {
                    this.printer.p('.');
                }
                this.printer.fit(" * ");
            }
            this.printer.pln();
            this.printer.indent().pln(" */");
        }
        this.printer.indent();
        if (null != production.attributes && 0 < production.attributes.size()) {
            object = production.attributes.iterator();
            while (object.hasNext()) {
                this.printer.p((Attribute)object.next()).p(' ');
            }
        }
        this.printer.p(production.type).p(' ').p(production.name.name);
        this.parenChoice = false;
        this.parenSequence = false;
    }

    protected void exit(Production production) {
        this.printer.pln();
    }

    public void visit(AlternativeAddition alternativeAddition) {
        this.enter(alternativeAddition);
        this.printer.p(" += ");
        if (!alternativeAddition.isBefore) {
            this.printer.pln().indentMore().p(alternativeAddition.sequence).pln(" ...");
            this.printer.indentMore().p("/ ");
        }
        this.printer.p(alternativeAddition.element);
        if (alternativeAddition.isBefore) {
            this.printer.indentMore().p("/ ").p(alternativeAddition.sequence).pln(" ...");
        }
        this.printer.indentMore().pln(';');
        this.exit(alternativeAddition);
    }

    public void visit(AlternativeRemoval alternativeRemoval) {
        this.enter(alternativeRemoval);
        this.printer.pln(" -=").incr().indent();
        Iterator iterator = alternativeRemoval.sequences.iterator();
        while (iterator.hasNext()) {
            this.printer.buffer().p((SequenceName)iterator.next());
            if (iterator.hasNext()) {
                this.printer.p(", ");
            }
            this.printer.fit();
        }
        this.printer.pln().indent().pln(';').decr();
        this.exit(alternativeRemoval);
    }

    public void visit(ProductionOverride productionOverride) {
        this.enter(productionOverride);
        this.printer.p(" := ");
        if (null == productionOverride.element) {
            this.printer.pln("... ;");
        } else if (productionOverride.isComplete) {
            this.printer.p(productionOverride.element).indentMore().pln(';');
        } else {
            this.printer.pln().indentMore().pln("...").indentMore().p("/ ");
            this.printer.p(productionOverride.element).indentMore().pln(';');
        }
        this.exit(productionOverride);
    }

    public void visit(FullProduction fullProduction) {
        this.enter(fullProduction);
        this.printer.p(" = ").p(fullProduction.element).indentMore().pln(';');
        this.exit(fullProduction);
    }

    protected void print(List list, String string) {
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        if (bl) {
            this.printer.p("( ");
        }
        this.printer.p("/* ").p(string).p(" */ ");
        this.printer.pln().incr();
        Iterator iterator = list.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            if (bl3) {
                bl3 = false;
                this.printer.indent();
            } else {
                this.printer.indent().p("/ ");
            }
            this.parenChoice = true;
            this.parenSequence = false;
            this.newline = false;
            this.printer.p((Element)iterator.next());
            if (this.newline) continue;
            this.printer.pln();
        }
        this.printer.decr();
        if (bl) {
            this.printer.indent().p(')');
        }
        this.parenChoice = bl;
        this.parenSequence = bl2;
        this.newline = false;
    }

    public void visit(OrderedChoice orderedChoice) {
        this.print(orderedChoice.alternatives, "Choice");
    }

    public void visit(Repetition repetition) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.buffer().p(repetition.element);
        if (repetition.once) {
            this.printer.p('+');
        } else {
            this.printer.p('*');
        }
        this.printer.fit();
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(Option option) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.buffer().p(option.element).p('?').fit();
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(SequenceName sequenceName) {
        this.printer.p('<').p(sequenceName.name).p('>');
    }

    public void visit(Sequence sequence) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        Iterator iterator = sequence.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            if (bl3) {
                bl3 = false;
                if (bl2) {
                    this.printer.p('(');
                }
                if (null != sequence.name) {
                    this.printer.p(sequence.name).p(' ');
                }
            } else {
                this.printer.p(' ');
            }
            this.printer.p((Element)iterator.next());
        }
        if (bl2) {
            this.printer.p(')');
        }
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(FollowedBy followedBy) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.buffer().p('&').p(followedBy.element).fit();
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(NotFollowedBy notFollowedBy) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.buffer().p('!').p(notFollowedBy.element).fit();
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(SemanticPredicate semanticPredicate) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.buffer().p('&').p(semanticPredicate.element).fit();
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(VoidedElement voidedElement) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("void:").p(voidedElement.element).fit();
    }

    public void visit(Binding binding) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p(binding.name).p(':').p(binding.element).fit();
    }

    public void visit(StringMatch stringMatch) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p('\"').escape(stringMatch.text, this.stringEscapes()).p("\":").p(stringMatch.element).fit();
    }

    public void visit(NonTerminal nonTerminal) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p(nonTerminal.name).fit();
    }

    public void visit(StringLiteral stringLiteral) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p('\"').escape(stringLiteral.text, this.stringEscapes()).p('\"').fit();
    }

    public void visit(AnyChar anyChar) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p('_').fit();
    }

    public void visit(CharLiteral charLiteral) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p('\'').escape(charLiteral.c, this.stringEscapes()).p('\'').fit();
    }

    public void visit(CharRange charRange) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        if (charRange.first == charRange.last) {
            this.printer.escape(charRange.first, this.regexEscapes());
        } else {
            this.printer.escape(charRange.first, this.regexEscapes()).p('-').escape(charRange.last, this.regexEscapes());
        }
    }

    public void visit(CharClass charClass) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer();
        if (charClass.exclusive) {
            this.printer.p("/* Exclusive */ !");
        }
        this.printer.p('[');
        Iterator iterator = charClass.ranges.iterator();
        while (iterator.hasNext()) {
            this.printer.p((CharRange)iterator.next());
        }
        this.printer.p(']');
        if (charClass.exclusive) {
            this.printer.p(" .");
        }
        this.printer.fit();
    }

    public void visit(CharCase charCase) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.p(charCase.klass).p(' ').p(charCase.element);
    }

    public void visit(CharSwitch charSwitch) {
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        if (bl) {
            this.printer.p("( ");
        }
        this.printer.pln("/* Switch */").incr();
        Iterator iterator = charSwitch.cases.iterator();
        boolean bl3 = true;
        boolean bl4 = false;
        CharClass charClass = null;
        while (iterator.hasNext()) {
            CharCase charCase = (CharCase)iterator.next();
            if (null == charCase.element) {
                if (null == charClass) {
                    charClass = new CharClass(new ArrayList());
                }
                charClass.ranges.addAll(charCase.klass.ranges);
                continue;
            }
            if (bl3) {
                bl3 = false;
                this.printer.indent();
            } else {
                this.printer.indent().p("/ ");
            }
            this.parenChoice = true;
            this.parenSequence = false;
            this.newline = false;
            this.printer.p(charCase);
            if (!this.newline) {
                this.printer.pln();
            }
            bl4 = true;
        }
        if (null != charClass || null != charSwitch.base) {
            this.printer.indent();
            if (bl4) {
                this.printer.p("/ ");
            }
            if (null != charClass) {
                this.newline = false;
                this.printer.p('!').p(charClass).p(' ');
            }
            if (null != charSwitch.base) {
                this.parenChoice = true;
                this.parenSequence = false;
                this.newline = false;
                this.printer.p(". ").p(charSwitch.base);
            }
            if (!this.newline) {
                this.printer.pln();
            }
        }
        this.printer.decr();
        if (bl) {
            this.printer.indent().p(')');
        }
        this.parenChoice = bl;
        this.parenSequence = bl2;
        this.newline = false;
    }

    protected void print(String string) {
        this.printer.p(string);
    }

    protected void print(Action action, boolean bl) {
        if (this.newline) {
            this.printer.indent();
        }
        if (0 == action.code.size()) {
            this.newline = false;
        } else if (1 == action.code.size()) {
            this.newline = false;
            this.printer.buffer();
            if (bl) {
                this.printer.p('^');
            }
            this.printer.p("{ ");
            this.print((String)action.code.get(0));
            this.printer.p(" }").fit();
        } else {
            this.newline = true;
            if (bl) {
                this.printer.p('^');
            }
            int n = this.printer.level();
            this.printer.pln('{').incr();
            int n2 = 0;
            Iterator iterator = action.code.iterator();
            Iterator iterator2 = action.indent.iterator();
            while (iterator.hasNext()) {
                int n3;
                int n4 = (Integer)iterator2.next();
                int n5 = n4 - n2;
                n2 = n4;
                if (0 < n5) {
                    for (n3 = 0; n3 < n5; ++n3) {
                        this.printer.incr();
                    }
                } else {
                    for (n3 = 0; n3 > n5; --n3) {
                        this.printer.decr();
                    }
                }
                this.printer.indent();
                this.print((String)iterator.next());
                this.printer.pln();
            }
            this.printer.setLevel(n).indent().pln('}');
        }
    }

    public void visit(Action action) {
        this.print(action, false);
    }

    public void visit(ParserAction parserAction) {
        this.print((Action)parserAction.element, true);
    }

    public void visit(NullValue nullValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = null; */").fit();
    }

    public void visit(StringValue stringValue) {
        if (this.newline) {
            this.printer.indent();
        }
        if (-1 == stringValue.text.indexOf("*/")) {
            this.newline = false;
            this.printer.buffer().p("/* value = \"").escape(stringValue.text, this.stringEscapes()).p("\"; */").fit();
        } else {
            this.newline = true;
            this.printer.buffer().p("// value = \"").escape(stringValue.text, this.stringEscapes()).p("\";").fit().pln();
        }
    }

    public void visit(TextValue textValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = <text>; */").fit();
    }

    public void visit(EmptyListValue emptyListValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = []; */").fit();
    }

    public void visit(SingletonListValue singletonListValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = [").p(singletonListValue.value).p("]; */").fit();
    }

    public void visit(ProperListValue properListValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = ").p(properListValue.value).p(':').p(properListValue.list).p("; */").fit();
    }

    public void visit(ActionBaseValue actionBaseValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = Action.run(").p(actionBaseValue.list).p(", ").p(actionBaseValue.seed).p("); */").fit();
    }

    public void visit(GenericNodeValue genericNodeValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = GNode(").p(genericNodeValue.name).p(", [");
        Iterator iterator = genericNodeValue.children.iterator();
        while (iterator.hasNext()) {
            this.printer.p(((Binding)iterator.next()).name);
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p("]); */").fit();
    }

    public void visit(GenericActionValue genericActionValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = Action->GNode(").p(genericActionValue.name).p(", [");
        Iterator iterator = genericActionValue.children.iterator();
        this.printer.p(genericActionValue.first);
        if (iterator.hasNext()) {
            this.printer.p(", ");
        }
        while (iterator.hasNext()) {
            this.printer.p(((Binding)iterator.next()).name);
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p("]) */").fit();
    }

    public void visit(GenericRecursionValue genericRecursionValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = Action->GNode(").p(genericRecursionValue.name).p(", [");
        Iterator iterator = genericRecursionValue.children.iterator();
        this.printer.p(genericRecursionValue.first);
        if (iterator.hasNext()) {
            this.printer.p(", ");
        }
        while (iterator.hasNext()) {
            this.printer.p(((Binding)iterator.next()).name);
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p("]):").p(genericRecursionValue.list).p(" */").fit();
    }
}

