/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.Iterator;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.StringMatch;
import xtc.parser.VoidedElement;
import xtc.tree.Visitor;

public abstract class GrammarVisitor
extends Visitor {
    protected final Analyzer analyzer;
    protected boolean isTopLevel;
    protected boolean isVoided;
    protected boolean isBound;
    protected boolean isLastElement;
    protected boolean isPredicate;
    protected boolean isRepeatedOnce;
    protected boolean needsSequence;
    protected boolean transformInPlace;

    public GrammarVisitor(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Object visit(Grammar grammar) {
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        Iterator iterator = grammar.modules.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            this.analyzer.process(module);
            Iterator iterator2 = module.productions.iterator();
            while (iterator2.hasNext()) {
                this.analyzer.process((Production)iterator2.next());
            }
        }
        return null;
    }

    public Object visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        Iterator iterator = module.productions.iterator();
        while (iterator.hasNext()) {
            this.analyzer.process((Production)iterator.next());
        }
        return null;
    }

    public Production visit(Production production) {
        Object object = this.analyzer.enter(production);
        this.isTopLevel = true;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        this.isPredicate = false;
        this.isRepeatedOnce = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        production.element = (Element)this.dispatch(production.element);
        this.analyzer.exit(object);
        return production;
    }

    public Element visit(OrderedChoice orderedChoice) {
        boolean bl = this.isTopLevel;
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        boolean bl2 = this.isLastElement;
        this.transformInPlace = false;
        int n = orderedChoice.alternatives.size();
        for (int i = 0; i < n; ++i) {
            this.isLastElement = bl || bl2;
            this.needsSequence = true;
            orderedChoice.alternatives.set(i, this.dispatch((Element)orderedChoice.alternatives.get(i)));
        }
        this.isLastElement = false;
        this.needsSequence = false;
        return orderedChoice;
    }

    public Element visit(Repetition repetition) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        boolean bl = this.isRepeatedOnce;
        this.isRepeatedOnce = repetition.once;
        this.needsSequence = false;
        this.transformInPlace = false;
        repetition.element = (Element)this.dispatch(repetition.element);
        this.isRepeatedOnce = bl;
        return repetition;
    }

    public Element visit(Option option) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        option.element = (Element)this.dispatch(option.element);
        return option;
    }

    public Element visit(Sequence sequence) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        boolean bl = this.isLastElement;
        this.needsSequence = false;
        this.transformInPlace = false;
        int n = sequence.length();
        for (int i = 0; i < n; ++i) {
            this.isLastElement = bl && i == n - 1;
            sequence.elements.set(i, this.dispatch(sequence.get(i)));
        }
        this.isLastElement = false;
        return sequence;
    }

    public Element visit(Predicate predicate) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        boolean bl = this.needsSequence;
        this.needsSequence = true;
        this.transformInPlace = false;
        boolean bl2 = this.isPredicate;
        this.isPredicate = true;
        predicate.element = (Element)this.dispatch(predicate.element);
        this.isPredicate = bl2;
        this.needsSequence = bl;
        return predicate;
    }

    public Element visit(SemanticPredicate semanticPredicate) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        semanticPredicate.element = (Element)this.dispatch(semanticPredicate.element);
        return semanticPredicate;
    }

    public Element visit(VoidedElement voidedElement) {
        this.isTopLevel = false;
        this.isVoided = true;
        this.isBound = false;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        voidedElement.element = (Element)this.dispatch(voidedElement.element);
        return voidedElement;
    }

    public Element visit(Binding binding) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = true;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        binding.element = (Element)this.dispatch(binding.element);
        return binding;
    }

    public Element visit(StringMatch stringMatch) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = true;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        stringMatch.element = (Element)this.dispatch(stringMatch.element);
        return stringMatch;
    }

    public CharCase visit(CharCase charCase) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        charCase.element = (Element)this.dispatch(charCase.element);
        return charCase;
    }

    public Element visit(CharSwitch charSwitch) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        int n = charSwitch.cases.size();
        for (int i = 0; i < n; ++i) {
            charSwitch.cases.set(i, this.dispatch((CharCase)charSwitch.cases.get(i)));
        }
        charSwitch.base = (Element)this.dispatch(charSwitch.base);
        return charSwitch;
    }

    public Element visit(ParserAction parserAction) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        parserAction.element = (Element)this.dispatch(parserAction.element);
        return parserAction;
    }

    public Element visit(Element element) {
        this.isTopLevel = false;
        this.isVoided = false;
        this.isBound = false;
        this.isLastElement = false;
        this.needsSequence = false;
        this.transformInPlace = false;
        return element;
    }
}

