/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GenericNodeValue;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.Rats;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.Type;
import xtc.tree.Visitor;

public class Generifier
extends Visitor {
    public static final String GENERIC = "xtc.parser.Generifier.Generic";
    public static final String TAG_NODE = "node";
    public static final String TAG_RECURSION = "recursion";
    public static final String MARKER = "g";
    protected final Analyzer analyzer;
    protected boolean isTopLevel;
    protected boolean seenChoice;
    protected List children;

    public Generifier(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.children = new ArrayList();
    }

    protected Binding bind(Element element) {
        Binding binding = new Binding(this.analyzer.variable(MARKER), element);
        this.children.add(binding);
        return binding;
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        Iterator iterator = module.productions.iterator();
        while (iterator.hasNext()) {
            FullProduction fullProduction = (FullProduction)iterator.next();
            if (!Generifier.isGenericNode(fullProduction)) continue;
            this.analyzer.process(fullProduction);
        }
    }

    public void visit(FullProduction fullProduction) {
        this.isTopLevel = true;
        this.seenChoice = false;
        this.analyzer.hasSimpleValue(fullProduction.element);
        fullProduction.element = (Element)this.dispatch(fullProduction.element);
        fullProduction.type = Type.genericNodeT();
        Generifier.markGenericNode(fullProduction);
    }

    public Element visit(OrderedChoice orderedChoice) {
        boolean bl = this.isTopLevel;
        this.isTopLevel = false;
        int n = orderedChoice.alternatives.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)orderedChoice.alternatives.get(i);
            if (element.getBooleanProperty("xtc.parser.Analyzer.SimpleValue")) continue;
            orderedChoice.alternatives.set(i, this.dispatch(element));
        }
        this.seenChoice = true;
        return orderedChoice;
    }

    public Element visit(Repetition repetition) {
        this.isTopLevel = false;
        return this.bind(repetition);
    }

    public Element visit(Option option) {
        this.isTopLevel = false;
        return this.bind(option);
    }

    public Element visit(Sequence sequence) {
        this.isTopLevel = false;
        int n = this.children.size();
        int n2 = sequence.length();
        for (int i = 0; i < n2; ++i) {
            sequence.elements.set(i, this.dispatch(sequence.get(i)));
        }
        if (this.seenChoice) {
            this.seenChoice = false;
        } else {
            sequence.add(new GenericNodeValue(this.analyzer.current().name.unqualify().name, new ArrayList(this.children)));
        }
        if (0 == n) {
            this.children.clear();
        } else {
            this.children.subList(n, this.children.size()).clear();
        }
        return sequence;
    }

    public Element visit(Binding binding) {
        this.isTopLevel = false;
        this.children.add(binding);
        return binding;
    }

    public Element visit(StringMatch stringMatch) {
        this.isTopLevel = false;
        return this.bind(stringMatch);
    }

    public Element visit(NonTerminal nonTerminal) {
        this.isTopLevel = false;
        FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
        if (Type.isVoidT(fullProduction.type)) {
            return nonTerminal;
        }
        return this.bind(nonTerminal);
    }

    public Element visit(StringLiteral stringLiteral) {
        this.isTopLevel = false;
        return this.bind(stringLiteral);
    }

    public Element visit(Element element) {
        this.isTopLevel = false;
        return element;
    }

    public static void markGenericNode(FullProduction fullProduction) {
        if (Rats.optionVerbose) {
            System.err.println("[Recognizing " + fullProduction.qName + " as generic node]");
        }
        fullProduction.setProperty(GENERIC, TAG_NODE);
    }

    public static void markGenericRecursion(FullProduction fullProduction) {
        if (Rats.optionVerbose) {
            System.err.println("[Recognizing " + fullProduction.qName + " as generic recursion]");
        }
        fullProduction.setProperty(GENERIC, TAG_RECURSION);
    }

    public static boolean isGeneric(FullProduction fullProduction) {
        if (fullProduction.hasProperty(GENERIC)) {
            Object object = fullProduction.getProperty(GENERIC);
            return TAG_NODE.equals(object) || TAG_RECURSION.equals(object);
        }
        return Type.isGenericT(fullProduction.type);
    }

    public static boolean isGenericNode(FullProduction fullProduction) {
        if (fullProduction.hasProperty(GENERIC)) {
            return TAG_NODE.equals(fullProduction.getProperty(GENERIC));
        }
        return Type.isGenericT(fullProduction.type) && !DirectLeftRecurser.isTransformable(fullProduction);
    }

    public static boolean isGenericRecursion(FullProduction fullProduction) {
        if (fullProduction.hasProperty(GENERIC)) {
            return TAG_RECURSION.equals(fullProduction.getProperty(GENERIC));
        }
        return Type.isGenericT(fullProduction.type) && DirectLeftRecurser.isTransformable(fullProduction);
    }
}

