/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import xtc.parser.ActionBaseValue;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.ProperListValue;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.SingletonListValue;
import xtc.parser.StringMatch;
import xtc.parser.UnaryOperator;
import xtc.tree.AttributeList;
import xtc.tree.Visitor;

public class EquivalenceTester
extends Visitor {
    protected Map nts = new HashMap();
    protected Map vars = new HashMap();
    protected Element e2;

    public boolean areEquivalent(Production production, Production production2) {
        if (!AttributeList.areEquivalent(production.attributes, production2.attributes)) {
            return false;
        }
        if (!production.type.equals(production2.type)) {
            return false;
        }
        this.nts.put(production2.name, production.name);
        boolean bl = this.areEquivalent(production.element, production2.element);
        this.nts.remove(production2.name);
        return bl;
    }

    public boolean areEquivalent(Element element, Element element2) {
        if (null == element || null == element2) {
            return element == element2;
        }
        if (!element.getClass().equals(element2.getClass())) {
            return false;
        }
        this.e2 = element2;
        return (Boolean)this.dispatch(element);
    }

    public Boolean visit(OrderedChoice orderedChoice) {
        OrderedChoice orderedChoice2 = (OrderedChoice)this.e2;
        int n = orderedChoice.alternatives.size();
        if (n != orderedChoice2.alternatives.size()) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < n; ++i) {
            if (this.areEquivalent((Element)orderedChoice.alternatives.get(i), (Element)orderedChoice2.alternatives.get(i))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean visit(Repetition repetition) {
        Repetition repetition2 = (Repetition)this.e2;
        if (repetition.once != repetition2.once) {
            return Boolean.FALSE;
        }
        return EquivalenceTester.box(this.areEquivalent(repetition.element, repetition2.element));
    }

    public Boolean visit(Sequence sequence) {
        Sequence sequence2 = (Sequence)this.e2;
        int n = sequence.elements.size();
        if (n != sequence2.elements.size()) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < n; ++i) {
            if (this.areEquivalent((Element)sequence.elements.get(i), (Element)sequence2.elements.get(i))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean visit(Binding binding) {
        Binding binding2 = (Binding)this.e2;
        if (binding.name.equals(binding2.name)) {
            return EquivalenceTester.box(this.areEquivalent(binding.element, binding2.element));
        }
        String string = (String)this.vars.get(binding2.name);
        if (null == string) {
            this.vars.put(binding2.name, binding.name);
            boolean bl = this.areEquivalent(binding.element, binding2.element);
            this.vars.remove(binding2.name);
            return EquivalenceTester.box(bl);
        }
        if (!binding.name.equals(string)) {
            return Boolean.FALSE;
        }
        return EquivalenceTester.box(this.areEquivalent(binding.element, binding2.element));
    }

    public Boolean visit(StringMatch stringMatch) {
        StringMatch stringMatch2 = (StringMatch)this.e2;
        return EquivalenceTester.box(stringMatch.text.equals(stringMatch2.text) && this.areEquivalent(stringMatch.element, stringMatch2.element));
    }

    public Boolean visit(NonTerminal nonTerminal) {
        NonTerminal nonTerminal2 = (NonTerminal)this.e2;
        return EquivalenceTester.box(nonTerminal.equals(nonTerminal2) || nonTerminal.equals(this.nts.get(nonTerminal2)));
    }

    public Boolean visit(CharSwitch charSwitch) {
        CharSwitch charSwitch2 = (CharSwitch)this.e2;
        int n = charSwitch.cases.size();
        if (n != charSwitch2.cases.size()) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < n; ++i) {
            CharCase charCase = (CharCase)charSwitch.cases.get(i);
            CharCase charCase2 = (CharCase)charSwitch2.cases.get(i);
            if (!this.areEquivalent(charCase.klass, charCase2.klass)) {
                return Boolean.FALSE;
            }
            if (this.areEquivalent(charCase.element, charCase2.element)) continue;
            return Boolean.FALSE;
        }
        if (null == charSwitch.base) {
            return EquivalenceTester.box(null == charSwitch2.base);
        }
        if (null == charSwitch2.base) {
            return Boolean.FALSE;
        }
        return EquivalenceTester.box(this.areEquivalent(charSwitch.base, charSwitch2.base));
    }

    public Boolean visit(SingletonListValue singletonListValue) {
        SingletonListValue singletonListValue2 = (SingletonListValue)this.e2;
        return EquivalenceTester.box(singletonListValue.value.equals(singletonListValue2.value) || singletonListValue.value.equals(this.vars.get(singletonListValue2.value)));
    }

    public Boolean visit(ProperListValue properListValue) {
        ProperListValue properListValue2 = (ProperListValue)this.e2;
        return EquivalenceTester.box(!(!properListValue.list.equals(properListValue2.list) && !properListValue.list.equals(this.vars.get(properListValue2.list)) || !properListValue.value.equals(properListValue2.value) && !properListValue.value.equals(this.vars.get(properListValue2.value))));
    }

    public Boolean visit(ActionBaseValue actionBaseValue) {
        ActionBaseValue actionBaseValue2 = (ActionBaseValue)this.e2;
        return EquivalenceTester.box(!(!actionBaseValue.list.equals(actionBaseValue2.list) && !actionBaseValue.list.equals(this.vars.get(actionBaseValue2.list)) || !actionBaseValue.seed.equals(actionBaseValue2.seed) && !actionBaseValue.seed.equals(this.vars.get(actionBaseValue2.seed))));
    }

    public Boolean visit(GenericNodeValue genericNodeValue) {
        GenericNodeValue genericNodeValue2 = (GenericNodeValue)this.e2;
        if (genericNodeValue.children.size() != genericNodeValue2.children.size()) {
            return Boolean.FALSE;
        }
        Iterator iterator = genericNodeValue.children.iterator();
        Iterator iterator2 = genericNodeValue2.children.iterator();
        while (iterator.hasNext()) {
            String string = ((Binding)iterator.next()).name;
            String string2 = ((Binding)iterator2.next()).name;
            if (string.equals(string2) || string.equals(this.vars.get(string2))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean visit(GenericActionValue genericActionValue) {
        GenericActionValue genericActionValue2 = (GenericActionValue)this.e2;
        NonTerminal nonTerminal = new NonTerminal(genericActionValue.name);
        NonTerminal nonTerminal2 = new NonTerminal(genericActionValue2.name);
        if (!nonTerminal.equals(nonTerminal2) && !nonTerminal.equals(this.nts.get(nonTerminal2))) {
            return Boolean.FALSE;
        }
        if (!genericActionValue.first.equals(genericActionValue2.first) && !genericActionValue.first.equals(this.vars.get(genericActionValue2.first))) {
            return Boolean.FALSE;
        }
        if (genericActionValue.children.size() != genericActionValue2.children.size()) {
            return Boolean.FALSE;
        }
        Iterator iterator = genericActionValue.children.iterator();
        Iterator iterator2 = genericActionValue2.children.iterator();
        while (iterator.hasNext()) {
            String string = ((Binding)iterator.next()).name;
            String string2 = ((Binding)iterator2.next()).name;
            if (string.equals(string2) || string.equals(this.vars.get(string2))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean visit(GenericRecursionValue genericRecursionValue) {
        GenericRecursionValue genericRecursionValue2 = (GenericRecursionValue)this.e2;
        NonTerminal nonTerminal = new NonTerminal(genericRecursionValue.name);
        NonTerminal nonTerminal2 = new NonTerminal(genericRecursionValue2.name);
        if (!nonTerminal.equals(nonTerminal2) && !nonTerminal.equals(this.nts.get(nonTerminal2))) {
            return Boolean.FALSE;
        }
        if (!genericRecursionValue.first.equals(genericRecursionValue2.first) && !genericRecursionValue.first.equals(this.vars.get(genericRecursionValue2.first))) {
            return Boolean.FALSE;
        }
        if (genericRecursionValue.children.size() != genericRecursionValue2.children.size()) {
            return Boolean.FALSE;
        }
        Iterator iterator = genericRecursionValue.children.iterator();
        Iterator iterator2 = genericRecursionValue2.children.iterator();
        while (iterator.hasNext()) {
            String string = ((Binding)iterator.next()).name;
            String string2 = ((Binding)iterator2.next()).name;
            if (string.equals(string2) || string.equals(this.vars.get(string2))) continue;
            return Boolean.FALSE;
        }
        return EquivalenceTester.box(genericRecursionValue.list.equals(genericRecursionValue2.list) || genericRecursionValue.list.equals(this.vars.get(genericRecursionValue2.list)));
    }

    public Boolean visit(UnaryOperator unaryOperator) {
        UnaryOperator unaryOperator2 = (UnaryOperator)this.e2;
        return EquivalenceTester.box(this.areEquivalent(unaryOperator.element, unaryOperator2.element));
    }

    public Boolean visit(Element element) {
        return EquivalenceTester.box(element.equals(this.e2));
    }

    protected static final Boolean box(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }
}

