/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.util.Iterator;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Visitor;

public class JavaPrinter
extends Visitor {
    public static final int PREC_BASE = 0;
    public static final int PREC_LIST = 11;
    public static final int PREC_CONSTANT = 1;
    public static final int STMT_ANY = 0;
    public static final int STMT_IF = 1;
    public static final int STMT_IF_ELSE = 2;
    protected final Printer printer;
    protected boolean isDeclaration;
    protected boolean isStatement;
    protected boolean isOpenLine;
    protected boolean isNested;
    protected boolean isFieldDeclaration;
    protected boolean isIfElse;
    protected int precedence;

    public JavaPrinter(Printer printer) {
        this.printer = printer;
        printer.register(this);
    }

    protected boolean isLongDeclaration(GNode gNode) {
        if (gNode.hasName("ConstructorDeclaration") || gNode.hasName("ClassDeclaration") || gNode.hasName("InterfaceDeclaration") || gNode.hasName("BlockDeclaration")) {
            return true;
        }
        return gNode.hasName("MethodDeclaration") && null != gNode.getNode(6);
    }

    protected boolean isShortDeclaration(GNode gNode) {
        if (gNode.hasName("FieldDeclaration")) {
            return true;
        }
        return gNode.hasName("MethodDeclaration") && null == gNode.getNode(6);
    }

    protected void formatAsTruthValue(Node node) {
        if (GNode.cast(node).hasName("AssignmentExpression")) {
            this.printer.p('(').p(node).p(')');
        } else {
            this.printer.p(node);
        }
    }

    protected boolean startStatement(int n) {
        if (this.isIfElse && (1 == n || 2 == n)) {
            this.isNested = false;
        } else {
            if (this.isDeclaration || this.isOpenLine) {
                this.printer.pln();
            }
            if (this.isNested) {
                this.printer.incr();
            }
        }
        this.isOpenLine = false;
        boolean bl = this.isNested;
        this.isNested = false;
        return bl;
    }

    protected void prepareNested() {
        this.isDeclaration = false;
        this.isStatement = false;
        this.isOpenLine = true;
        this.isNested = true;
    }

    protected void endStatement(boolean bl) {
        if (bl) {
            this.printer.decr();
        }
        this.isDeclaration = false;
        this.isStatement = true;
    }

    protected int enterContext(int n) {
        int n2 = this.precedence;
        this.precedence = n;
        return n2;
    }

    protected int enterContext() {
        int n = this.precedence++;
        return n;
    }

    protected void exitContext(int n) {
        this.precedence = n;
    }

    protected int startExpression(int n) {
        if (n < this.precedence) {
            this.printer.p('(');
        }
        int n2 = this.precedence;
        this.precedence = n;
        return n2;
    }

    protected void endExpression(int n) {
        if (this.precedence < n) {
            this.printer.p(')');
        }
        this.precedence = n;
    }

    public void visitCompilationUnit(GNode gNode) {
        this.isDeclaration = false;
        this.isStatement = false;
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
        this.precedence = 0;
        int n = 0;
        Iterator iterator = gNode.children();
        while (iterator.hasNext()) {
            GNode gNode2 = GNode.cast(iterator.next());
            if (null != gNode2 && (this.isLongDeclaration(gNode2) || this.isShortDeclaration(gNode2))) {
                this.printer.pln();
            }
            this.printer.p(gNode2).pln();
            ++n;
        }
    }

    public void visitPackageDeclaration(GNode gNode) {
        this.printer.p("package ").p(gNode.getNode(0)).p(';').pln();
    }

    public void visitImportDeclaration(GNode gNode) {
        this.printer.p("import ").p(gNode.getNode(0));
        if (null != gNode.getNode(1)) {
            this.printer.p(gNode.getNode(1));
        }
        this.printer.p(';');
    }

    public void visitDotStarTail(GNode gNode) {
        this.printer.p(".*");
    }

    public void visitModifiers(GNode gNode) {
        Iterator iterator = gNode.children();
        while (iterator.hasNext()) {
            this.printer.p((String)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(' ');
        }
    }

    public void visitFormalParameter(GNode gNode) {
        if (null != gNode.getNode(0)) {
            this.printer.p(gNode.getNode(0)).p(' ');
        }
        this.printer.p(gNode.getNode(1)).p(' ').p(gNode.getString(2));
        if (null != gNode.getNode(3)) {
            this.printer.p(' ').p(gNode.getNode(3));
        }
    }

    public void visitFinalClause(GNode gNode) {
        this.printer.p("final");
    }

    public void visitFormalParameters(GNode gNode) {
        this.printer.p('(');
        Iterator iterator = gNode.children();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p(')');
    }

    public void visitDeclarator(GNode gNode) {
        this.printer.p(gNode.getString(0));
        if (null != gNode.getNode(1)) {
            this.printer.p(' ').p(gNode.getNode(1));
        }
        if (null != gNode.getNode(2)) {
            this.printer.p(" = ").p(gNode.getNode(2));
        }
    }

    public void visitDeclarators(GNode gNode) {
        Iterator iterator = gNode.children();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitClassBody(GNode gNode) {
        if (this.isOpenLine) {
            this.printer.pln(" {").incr();
        } else {
            this.printer.indent().pln('{').incr();
        }
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
        Iterator iterator = gNode.children();
        while (iterator.hasNext()) {
            GNode gNode2 = GNode.cast(iterator.next());
            if (this.isLongDeclaration(gNode2)) {
                this.printer.pln().indent().p(gNode2).pln();
                continue;
            }
            this.printer.p(gNode2);
        }
        if (this.isOpenLine) {
            this.printer.pln();
        }
        this.printer.decr().indent().p('}');
        this.isOpenLine = true;
        this.isNested = false;
        this.isIfElse = false;
    }

    public void visitFieldDeclaration(GNode gNode) {
        this.printer.indent();
        if (GNode.cast(gNode.getNode(0)).hasChildren()) {
            this.printer.p(gNode.getNode(0)).p(' ');
        }
        this.printer.p(gNode.getNode(1)).p(' ').p(gNode.getNode(2)).p(';').pln();
        this.isDeclaration = false;
    }

    public void visitMethodDeclaration(GNode gNode) {
        this.printer.p(gNode.getNode(0)).p(' ').p(gNode.getNode(1)).p(' ').p(gNode.getString(2)).p(gNode.getNode(3));
        if (null != gNode.getNode(4)) {
            this.printer.p(' ').p(gNode.getNode(4));
        }
        if (null != gNode.getNode(5)) {
            this.printer.p(' ').p(gNode.getNode(5));
        }
        if (null != gNode.getNode(6)) {
            this.printer.p(gNode.getNode(6));
            this.isDeclaration = true;
        } else {
            this.printer.p(';').pln();
            this.isDeclaration = false;
        }
    }

    public void visitConstructorDeclaration(GNode gNode) {
        this.printer.p(gNode.getNode(0)).p(' ').p(gNode.getString(1)).p(gNode.getNode(2));
        if (null != gNode.getNode(3)) {
            this.printer.p(gNode.getNode(3));
        }
        this.printer.p(gNode.getNode(4));
        this.isDeclaration = true;
    }

    public void visitClassDeclaration(GNode gNode) {
        if (null != gNode.getNode(0)) {
            this.printer.p(gNode.getNode(0)).p(' ');
        }
        this.printer.p("class ").p(gNode.getString(1)).p(' ');
        if (null != gNode.getNode(2)) {
            this.printer.p(gNode.getNode(2)).p(' ');
        }
        if (null != gNode.getNode(3)) {
            this.printer.p(gNode.getNode(3)).p(' ');
        }
        this.printer.p(gNode.getNode(4));
        this.isDeclaration = true;
    }

    public void visitInterfaceDeclaration(GNode gNode) {
        this.printer.p(gNode.getNode(0)).p(" interface ").p(gNode.getString(1));
        if (null != gNode.getNode(2)) {
            this.printer.p(gNode.getNode(2)).p(' ');
        }
        this.printer.p(gNode.getNode(3));
        this.isDeclaration = true;
    }

    public void visitBlockDeclaration(GNode gNode) {
        if (null != gNode.getNode(0)) {
            this.printer.p(gNode.getNode(0)).p(' ');
        }
        this.printer.p(gNode.getNode(1));
        this.isDeclaration = true;
    }

    public void visitStaticClause(GNode gNode) {
    }

    public void visitOptionalThrowsClause(GNode gNode) {
        this.printer.p("throws ");
        Iterator iterator = gNode.children();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitExtension(GNode gNode) {
        this.printer.p("extends ");
        Iterator iterator = gNode.children();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitImplementation(GNode gNode) {
        this.printer.p("implements ");
        Iterator iterator = gNode.children();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitBlock(GNode gNode) {
        if (this.isOpenLine) {
            this.printer.pln(" {").incr();
        } else {
            this.printer.p(' ').pln('{').incr();
        }
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
        this.isDeclaration = false;
        Iterator iterator = gNode.children();
        GNode gNode2 = null;
        while (iterator.hasNext()) {
            GNode gNode3 = GNode.cast(iterator.next());
            if (null != gNode2 && this.isShortDeclaration(gNode3) && !this.isShortDeclaration(gNode2)) {
                this.printer.pln().p(gNode3);
            } else {
                this.printer.p(gNode3);
            }
            gNode2 = gNode3;
        }
        if (this.isOpenLine) {
            this.printer.pln();
        }
        this.printer.decr().indent().p('}');
        this.isOpenLine = true;
        this.isNested = false;
        this.isIfElse = false;
    }

    public void visitIfElseStatement(GNode gNode) {
        boolean bl = this.startStatement(2);
        if (this.isIfElse) {
            this.printer.p(' ');
        } else {
            this.printer.indent();
        }
        this.printer.p("if ");
        this.formatAsTruthValue(gNode.getNode(0));
        this.prepareNested();
        this.printer.p(gNode.getNode(1));
        if (this.isOpenLine) {
            this.printer.p(" else");
        } else {
            this.printer.indent().p("else");
        }
        this.prepareNested();
        boolean bl2 = this.isIfElse;
        this.isIfElse = true;
        this.printer.p(gNode.getNode(2));
        this.isIfElse = bl2;
        this.endStatement(bl);
    }

    public void visitIfStatement(GNode gNode) {
        boolean bl = this.startStatement(1);
        if (this.isIfElse) {
            this.printer.p(' ');
        } else {
            this.printer.indent();
        }
        this.printer.p("if ");
        this.formatAsTruthValue(gNode.getNode(0));
        this.prepareNested();
        this.printer.p(gNode.getNode(1));
        this.endStatement(bl);
    }

    public void visitForStatement(GNode gNode) {
        int n;
        boolean bl = this.startStatement(0);
        this.printer.indent().p("for(");
        if (null != gNode.get(0)) {
            n = this.enterContext(0);
            this.printer.p(gNode.getNode(0));
            this.exitContext(n);
        }
        if (null != gNode.get(1)) {
            n = this.enterContext(0);
            this.printer.p(' ');
            this.formatAsTruthValue(gNode.getNode(1));
            this.exitContext(n);
        }
        this.printer.p(';');
        if (null != gNode.get(2)) {
            n = this.enterContext(0);
            this.printer.p(' ').p(gNode.getNode(2));
            this.exitContext(n);
        }
        this.printer.p(')');
        this.prepareNested();
        this.printer.p(gNode.getNode(3));
        this.endStatement(bl);
    }

    public void visitForInit(GNode gNode) {
        Iterator iterator = gNode.children();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(' ');
        }
        this.printer.p(';');
    }

    public void visitWhileStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("while ");
        this.formatAsTruthValue(gNode.getNode(0));
        this.prepareNested();
        this.printer.p(gNode.getNode(1));
        this.endStatement(bl);
    }

    public void visitDoWhileStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("do");
        this.prepareNested();
        this.printer.p(gNode.getNode(0));
        if (this.isOpenLine) {
            this.printer.p(' ');
        } else {
            this.printer.indent();
        }
        this.printer.p("while ");
        this.formatAsTruthValue(gNode.getNode(1));
        this.printer.pln(";");
        this.endStatement(bl);
    }

    public void visitParExpression(GNode gNode) {
        this.printer.p('(').p(gNode.getNode(0)).p(')');
    }

    public void visitTryCatchFinallyStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("try").p(gNode.getNode(0)).p(' ');
        Iterator iterator = gNode.children();
        iterator.next();
        while (iterator.hasNext()) {
            GNode gNode2 = GNode.cast(iterator.next());
            if (gNode2.hasName("CatchClause")) {
                this.printer.p(gNode2).p(' ');
                continue;
            }
            this.printer.p("finally ").p(gNode2);
        }
        this.endStatement(bl);
    }

    public void visitTryCatchStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("try").p(gNode.getNode(0)).p(' ');
        Iterator iterator = gNode.children();
        iterator.next();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.pln();
        }
        this.endStatement(bl);
    }

    public void visitCatchClause(GNode gNode) {
        this.printer.p("catch(").p(gNode.getNode(0)).p(")").p(gNode.getNode(1));
    }

    public void visitSwitchStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("switch ").p(gNode.getNode(0));
        if (null != gNode.getNode(1)) {
            Iterator iterator = gNode.children();
            iterator.next();
            while (iterator.hasNext()) {
                this.prepareNested();
                this.printer.p((Node)iterator.next());
            }
            this.endStatement(bl);
        }
    }

    public void visitCaseExpression(GNode gNode) {
        boolean bl = this.startStatement(0);
        int n = this.enterContext(1);
        this.printer.indent().p("case: ").p(gNode.getNode(0));
        if (1 < GNode.cast(gNode).size()) {
            this.printer.pln().indent().incr();
            Iterator iterator = gNode.children();
            iterator.next();
            this.isOpenLine = false;
            this.isNested = false;
            this.isIfElse = false;
            while (iterator.hasNext()) {
                this.printer.p((Node)iterator.next());
            }
            this.printer.decr();
            this.isOpenLine = true;
            this.isNested = false;
            this.isIfElse = false;
        }
        this.exitContext(n);
        this.endStatement(bl);
    }

    public void visitDefaultExpression(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("default:");
        if (GNode.cast(gNode).hasChildren()) {
            this.printer.pln().indent().incr();
            this.isOpenLine = false;
            this.isNested = false;
            this.isIfElse = false;
            Iterator iterator = gNode.children();
            while (iterator.hasNext()) {
                this.printer.p((Node)iterator.next());
            }
            this.printer.decr();
            this.isOpenLine = true;
            this.isNested = false;
            this.isIfElse = false;
        }
        this.printer.pln();
        this.endStatement(bl);
    }

    public void visitSynchronizedStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("synchronized ").p(gNode.getNode(0)).p(' ').p(gNode.getNode(1));
        this.endStatement(bl);
    }

    public void visitReturnStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("return");
        if (null != gNode.getNode(0)) {
            this.printer.p(' ').p(gNode.getNode(0));
        }
        this.printer.pln(';');
        this.endStatement(bl);
    }

    public void visitThrowStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("throw").p(' ').p(gNode.getNode(0));
        this.printer.pln(';');
        this.endStatement(bl);
    }

    public void visitBreakStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("break");
        if (gNode.getString(0) != null) {
            this.printer.p(' ').p(gNode.getString(0));
        }
        this.printer.p(';');
        this.endStatement(bl);
    }

    public void visitContinueStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("continue");
        if (null != gNode.getString(0)) {
            this.printer.p(' ').p(gNode.getString(0));
        }
        this.printer.p(';').pln();
        this.endStatement(bl);
    }

    public void visitiLabeledStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p(gNode.getString(0)).p(" : ").p(gNode.getNode(1)).pln(';');
        this.endStatement(bl);
    }

    public void visitExpressionStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p(gNode.getNode(0)).pln(';');
        this.endStatement(bl);
    }

    public void visitVoidStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().pln(';');
        this.endStatement(bl);
    }

    public void visitExpressionList(GNode gNode) {
        Iterator iterator = gNode.children();
        while (iterator.hasNext()) {
            int n = this.enterContext(11);
            this.printer.p((Node)iterator.next());
            this.exitContext(n);
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitExpression(GNode gNode) {
        int n = this.startExpression(10);
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(0));
        this.exitContext(n2);
        this.printer.p(' ').p(gNode.getString(1)).p(' ').p(gNode.getNode(2));
        this.endExpression(n);
    }

    public void visitConditionalExpression(GNode gNode) {
        int n = this.startExpression(20);
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(0)).p(" ? ");
        this.exitContext(n2);
        n2 = this.enterContext();
        if (null != gNode.get(1)) {
            this.printer.p(gNode.getNode(1)).p(" : ");
        } else {
            this.printer.p(" /* Empty */ : ");
        }
        this.exitContext(n2);
        this.printer.p(gNode.getNode(2));
        this.endExpression(n);
    }

    public void visitConditionalOrExpression(GNode gNode) {
        int n = this.startExpression(30);
        this.printer.p(gNode.getNode(0));
        this.printer.p(" || ");
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(1));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitConditionalAndExpression(GNode gNode) {
        int n = this.startExpression(40);
        this.printer.p(gNode.getNode(0));
        this.printer.p(" && ");
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(1));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitInclusiveOrExpression(GNode gNode) {
        int n = this.startExpression(50);
        this.printer.p(gNode.getNode(0));
        this.printer.p(" | ");
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(1));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitExclusiveOrExpression(GNode gNode) {
        int n = this.startExpression(60);
        this.printer.p(gNode.getNode(0));
        this.printer.p(" ^ ");
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(1));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitAndExpression(GNode gNode) {
        int n = this.startExpression(70);
        this.printer.p(gNode.getNode(0)).p(" & ");
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(1));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitEqualityExpression(GNode gNode) {
        int n = this.startExpression(80);
        this.printer.p(gNode.getNode(0)).p(' ').p(gNode.getString(1)).p(' ');
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(2));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitInstanceOfExpression(GNode gNode) {
        int n = this.startExpression(90);
        this.printer.p(gNode.getNode(0)).p(' ').p("instanceof").p(' ');
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(1));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitRelationalExpression(GNode gNode) {
        int n = this.startExpression(100);
        this.printer.p(gNode.getNode(0)).p(' ').p(gNode.getString(1)).p(' ');
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(2));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitShiftExpression(GNode gNode) {
        int n = this.startExpression(110);
        this.printer.p(gNode.getNode(0));
        this.printer.p(' ').p(gNode.getString(1)).p(' ');
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(2));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitAdditiveExpression(GNode gNode) {
        int n = this.startExpression(120);
        this.printer.p(gNode.getNode(0)).p(' ').p(gNode.getString(1)).p(' ');
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(2));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitMultiplicativeExpression(GNode gNode) {
        int n = this.startExpression(130);
        this.printer.p(gNode.getNode(0)).p(' ').p(gNode.getString(1)).p(' ');
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(2));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitUnaryExpression(GNode gNode) {
        int n = this.startExpression(150);
        this.printer.p(gNode.getString(0)).p(gNode.getNode(1));
        this.endExpression(n);
    }

    public void visitBitwiseNegationExpression(GNode gNode) {
        int n = this.startExpression(150);
        this.printer.p('~').p(gNode.getNode(0));
        this.endExpression(n);
    }

    public void visitLogicalNegationExpression(GNode gNode) {
        int n = this.startExpression(150);
        this.printer.p('!').p(gNode.getNode(0));
        this.endExpression(n);
    }

    public void visitBasicCastExpression(GNode gNode) {
        int n = this.startExpression(140);
        this.printer.p('(').p(gNode.getString(0));
        if (null != gNode.getNode(1)) {
            this.printer.p(gNode.getNode(1));
        }
        this.printer.p(')').p(gNode.getNode(2));
        this.endExpression(n);
    }

    public void visitCastExpression(GNode gNode) {
        int n = this.startExpression(140);
        this.printer.p('(').p(gNode.getNode(0)).p(')').p(gNode.getNode(1));
        this.endExpression(n);
    }

    public void visitPostfixExpression(GNode gNode) {
        int n = this.startExpression(160);
        Iterator iterator = gNode.children();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
        }
        this.exitContext(n);
    }

    public void visitSubscriptExpression(GNode gNode) {
        this.printer.p('[');
        if (null != gNode.getNode(0)) {
            this.printer.p(gNode.getNode(0));
        }
        this.printer.p(']');
    }

    public void visitPrimaryExpressionTail(GNode gNode) {
        this.printer.p('.').p(gNode.getNode(0));
    }

    public void visitClassTail(GNode gNode) {
        this.printer.p('.').p("class");
    }

    public void visitPostincrementExpression(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p("++");
        this.endExpression(n);
    }

    public void visitPostdecrementExpression(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p("--");
        this.endExpression(n);
    }

    public void visitPrimaryIdentifier(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitNestedExpression(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getNode(0));
        this.endExpression(n);
    }

    public void visitThisExpression(GNode gNode) {
        this.printer.p("this");
    }

    public void visitSuperExpression(GNode gNode) {
        this.printer.p("super");
    }

    public void visitNewExpression(GNode gNode) {
        this.printer.p("new ");
        this.printer.p(gNode.getNode(0));
        if (null != gNode.getNode(1)) {
            this.printer.p(gNode.getNode(1));
        }
        if (null != gNode.getNode(2)) {
            if (!gNode.getNode(1).hasName("DimensionExpressions")) {
                this.printer.p(' ');
            }
            this.printer.p(gNode.getNode(2));
        }
    }

    public void visitVoidClassExpression(GNode gNode) {
        this.printer.p("void").p('.').p("class");
    }

    public void visitDimensionExpressions(GNode gNode) {
        Iterator iterator = gNode.children();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
        }
    }

    public void visitDimensionExpression(GNode gNode) {
        this.printer.p("[ ").p(gNode.getNode(0)).p(" ]");
    }

    public void visitArguments(GNode gNode) {
        if (gNode.hasChildren()) {
            this.printer.p("(").p(gNode.getNode(0)).p(")");
        } else {
            this.printer.p("()");
        }
    }

    public void visitArrayInitializer(GNode gNode) {
        if (gNode.hasChildren()) {
            this.printer.pln('{').incr().indent();
            Iterator iterator = gNode.children();
            while (iterator.hasNext()) {
                this.printer.buffer().p((Node)iterator.next());
                if (iterator.hasNext()) {
                    this.printer.p(", ");
                }
                this.printer.fit();
            }
            this.printer.pln().decr().indent().p('}');
        } else {
            this.printer.p("{ }");
        }
    }

    public void visitVoidTypeSpecifier(GNode gNode) {
        this.printer.p("void");
    }

    public void visitType(GNode gNode) {
        this.printer.p(gNode.getNode(0));
        if (null != gNode.getNode(1)) {
            this.printer.p(' ').p(gNode.getNode(1)).p(' ');
        }
    }

    public void visitTypeName(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitDimensions(GNode gNode) {
        Iterator iterator = gNode.children();
        while (iterator.hasNext()) {
            this.printer.p((String)iterator.next()).p(']');
        }
    }

    public void visitIntegerLiteral(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitFloatingPointLiteral(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitCharacterLiteralNode(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitStringLiteralNode(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitBooleanLiteral(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitNullLiteral(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p("null");
        this.endExpression(n);
    }

    public void visitQualifiedIdentifier(GNode gNode) {
        int n = this.startExpression(160);
        if (1 == gNode.size()) {
            this.printer.p(gNode.getString(0));
        } else {
            Iterator iterator = gNode.children();
            int n2 = this.printer.column();
            while (iterator.hasNext()) {
                this.printer.p((String)iterator.next());
                if (!iterator.hasNext()) continue;
                this.printer.p('.');
            }
        }
        this.endExpression(n);
    }
}

