/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import antlr.TokenStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import xtc.lang.JavaPackratParser;
import xtc.lang.JavaPrinter;
import xtc.lang.JavaTreeParser;
import xtc.lang.antlr.JavaLexer;
import xtc.lang.antlr.JavaRecognizer;
import xtc.lang.javacc.JavaParser;
import xtc.lang.javacc.ParseException;
import xtc.parser.ParseError;
import xtc.parser.SemanticValue;
import xtc.tree.GNode;
import xtc.tree.Printer;
import xtc.util.Statistics;

public final class JavaDriver {
    private static final int WARM_UP_RUNS = 2;
    private static final int TOTAL_RUNS = 22;
    private static boolean error = false;
    private static boolean optionGC = false;
    private static boolean optionJavaCC = false;
    private static boolean optionANTLR = false;
    private static boolean optionPrintAST = false;
    private static boolean optionPrintSource = false;
    private static boolean optionStats = false;
    private static boolean optionTable = false;
    private static boolean optionPrintTable = false;
    private static Statistics fileSizes = null;
    private static Statistics latencies = null;
    private static Statistics heapSizes = null;
    private static Method dump = null;
    static /* synthetic */ Class class$xtc$tree$Printer;
    static /* synthetic */ Class class$xtc$lang$JavaPackratParser;

    private JavaDriver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void parse(String var0) throws Exception {
        block33: {
            block32: {
                block31: {
                    var1_1 = new File(var0).length();
                    var3_2 = null;
                    if (0x7FFFFFFFL < var1_1) {
                        throw new IllegalArgumentException("File too large");
                    }
                    try {
                        var4_3 = null;
                        var5_4 = null;
                        var6_5 = 1;
                        if (JavaDriver.optionStats) {
                            var4_3 = new Statistics();
                            var5_4 = new Statistics();
                            var6_5 = 22;
                            JavaDriver.fileSizes.add((double)var1_1 / 1024.0);
                        }
                        for (var7_6 = 0; var7_6 < var6_5; ++var7_6) {
                            var3_2 = new BufferedReader(new FileReader(var0));
                            if (JavaDriver.optionGC) {
                                System.gc();
                            }
                            var8_8 = 0L;
                            var10_9 = 0L;
                            if (JavaDriver.optionStats) {
                                var10_9 = Runtime.getRuntime().freeMemory();
                                var8_8 = System.currentTimeMillis();
                            }
                            if (JavaDriver.optionJavaCC) {
                                var12_10 = new JavaParser(var3_2);
                                try {
                                    var12_10.CompilationUnit();
                                }
                                catch (ParseException var13_13) {
                                    System.err.println();
                                    System.err.println(var13_13.getMessage());
                                    JavaDriver.error = true;
                                    var17_19 = null;
                                    if (null == var3_2) return;
                                    try {
                                        var3_2.close();
                                        return;
                                    }
                                    catch (Exception var18_25) {
                                        // empty catch block
                                    }
                                    return;
                                }
                            }
                            if (JavaDriver.optionANTLR) {
                                var12_10 = new JavaLexer(var3_2);
                                var13_12 = new JavaRecognizer((TokenStream)var12_10);
                                try {
                                    var13_12.compilationUnit();
                                }
                                catch (Exception var14_14) {
                                    System.err.println();
                                    System.err.println(var14_14.getMessage());
                                    JavaDriver.error = true;
                                    var17_20 = null;
                                    if (null == var3_2) return;
                                    ** try [egrp 3[TRYBLOCK] [8 : 959->966)] { 
lbl55:
                                    // 1 sources

                                    var3_2.close();
                                    return;
lbl57:
                                    // 1 sources

                                    catch (Exception var18_26) {
                                        // empty catch block
                                    }
                                    return;
                                }
                            }
                            if (JavaDriver.optionPrintAST || JavaDriver.optionPrintSource) {
                                var12_10 = new JavaTreeParser(var3_2, var0, (int)var1_1);
                                var13_12 = var12_10.pCompilationUnit(0);
                                if (!var13_12.hasValue()) {
                                    System.err.println();
                                    var12_10.print((ParseError)var13_12);
                                    JavaDriver.error = true;
                                    var17_21 = null;
                                    if (null == var3_2) return;
                                    break block31;
                                }
                                var14_15 = (GNode)((SemanticValue)var13_12).value;
                                var15_18 = new Printer(new BufferedWriter(new OutputStreamWriter(System.out)));
                                if (JavaDriver.optionPrintAST) {
                                    var15_18.format(var14_15).pln();
                                }
                                if (JavaDriver.optionPrintSource) {
                                    new JavaPrinter(var15_18).dispatch(var14_15);
                                }
                                var15_18.flush();
                            } else {
                                var12_10 = new JavaPackratParser(var3_2, var0, (int)var1_1);
                                var13_12 = var12_10.pCompilationUnit(0);
                                if (!var13_12.hasValue()) {
                                    System.err.println();
                                    var12_10.print((ParseError)var13_12);
                                    JavaDriver.error = true;
                                    break block32;
                                }
                                if (JavaDriver.optionPrintTable) {
                                    var14_16 = new Printer(new BufferedWriter(new OutputStreamWriter(System.out)));
                                    JavaDriver.dump.invoke(var12_10, new Object[]{var14_16});
                                    var14_16.flush();
                                }
                            }
                            if (JavaDriver.optionStats) {
                                var12_11 = System.currentTimeMillis();
                                var14_17 = Runtime.getRuntime().freeMemory();
                                if (var7_6 >= 2) {
                                    var4_3.add(var12_11 - var8_8);
                                    var5_4.add(var10_9 - var14_17);
                                }
                            }
                            var3_2.close();
                        }
                        if (!JavaDriver.optionStats) break block33;
                        var7_7 = var4_3.mean();
                        var9_31 = var5_4.mean();
                        JavaDriver.latencies.add(var7_7);
                        JavaDriver.heapSizes.add(var9_31 / 1024.0);
                        if (JavaDriver.optionTable) {
                            System.out.println(var0 + " " + var1_1 + " " + Statistics.round(var7_7) + " " + var4_3.median() + " " + Statistics.round(var4_3.stdev()) + " " + Statistics.round(var9_31) + " " + var5_4.median() + " " + Statistics.round(var5_4.stdev()));
                            break block33;
                        } else {
                            System.out.println("  file size     : " + var1_1);
                            System.out.println("  time   mean   : " + Statistics.round(var7_7));
                            System.out.println("  time   median : " + var4_3.median());
                            System.out.println("  time   stdev  : " + Statistics.round(var4_3.stdev()));
                            System.out.println("  memory mean   : " + Statistics.round(var9_31));
                            System.out.println("  memory median : " + var5_4.median());
                            System.out.println("  memory stdev  : " + Statistics.round(var5_4.stdev()));
                        }
                        break block33;
                    }
                    catch (Throwable var16_32) {
                        var17_24 = null;
                        if (null == var3_2) throw var16_32;
                        ** try [egrp 3[TRYBLOCK] [8 : 959->966)] { 
lbl126:
                        // 1 sources

                        var3_2.close();
                        throw var16_32;
lbl128:
                        // 1 sources

                        catch (Exception var18_30) {
                            // empty catch block
                        }
                        throw var16_32;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [8 : 959->966)] { 
lbl133:
                // 1 sources

                var3_2.close();
                return;
lbl135:
                // 1 sources

                catch (Exception var18_27) {
                    // empty catch block
                }
                return;
            }
            var17_22 = null;
            if (null == var3_2) return;
            ** try [egrp 3[TRYBLOCK] [8 : 959->966)] { 
lbl142:
            // 1 sources

            var3_2.close();
            return;
lbl144:
            // 1 sources

            catch (Exception var18_28) {
                // empty catch block
            }
            return;
        }
        var17_23 = null;
        if (null == var3_2) return;
        try {}
        catch (Exception var18_29) {
            return;
        }
        var3_2.close();
    }

    public static void main(String[] stringArray) {
        int n;
        System.out.print("Java Parser Driver   Version ");
        System.out.print("1.7.1");
        System.out.print("   ");
        System.out.println("(C) 2004-2005 Robert Grimm");
        if (null == stringArray || 0 == stringArray.length) {
            System.out.println();
            System.out.println("Usage: <option>* <file-name>+");
            System.out.println();
            System.out.println("Options are:");
            System.out.println("  -javacc   Use the JavaCC generated parser.");
            System.out.println("  -antlr    Use the ANTLR generated parser.");
            System.out.println("  -ast      Print AST in generic form.");
            System.out.println("  -source   Print AST in Java source form.");
            System.out.println("  -gc       Perform GC before parsing each file.");
            System.out.println("  -stats    Collect and print parsing statistics.");
            System.out.println("  -table    Print statistics as a table.");
            System.out.println("  -memo     Print the memoization table.");
            System.out.println();
            System.exit(1);
        }
        int n2 = -1;
        error = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].startsWith("-")) {
                if ("-javacc".equals(stringArray[n])) {
                    optionJavaCC = true;
                    continue;
                }
                if ("-antlr".equals(stringArray[n])) {
                    optionANTLR = true;
                    continue;
                }
                if ("-ast".equals(stringArray[n])) {
                    optionPrintAST = true;
                    continue;
                }
                if ("-source".equals(stringArray[n])) {
                    optionPrintSource = true;
                    continue;
                }
                if ("-gc".equals(stringArray[n])) {
                    optionGC = true;
                    continue;
                }
                if ("-stats".equals(stringArray[n])) {
                    optionStats = true;
                    continue;
                }
                if ("-table".equals(stringArray[n])) {
                    optionTable = true;
                    continue;
                }
                if ("-memo".equals(stringArray[n])) {
                    try {
                        dump = (class$xtc$lang$JavaPackratParser == null ? JavaDriver.class$("xtc.lang.JavaPackratParser") : class$xtc$lang$JavaPackratParser).getMethod("dump", class$xtc$tree$Printer == null ? JavaDriver.class$("xtc.tree.Printer") : class$xtc$tree$Printer);
                    }
                    catch (Exception exception) {
                        System.err.println("Parser cannot print memoization table. Rebuild with dumpTable option.");
                        error = true;
                    }
                    optionPrintTable = true;
                    continue;
                }
                System.err.println("Unrecognized option " + stringArray[n]);
                error = true;
                continue;
            }
            n2 = n;
            break;
        }
        if (optionPrintAST && (optionJavaCC || optionANTLR)) {
            System.err.println("AST only printable for Rats!-generated parser");
            error = true;
        }
        if (optionPrintSource && (optionJavaCC || optionANTLR)) {
            System.err.println("Java source only printable for Rats!-generated parser");
            error = true;
        }
        if (optionPrintTable && (optionJavaCC || optionANTLR)) {
            System.err.println("Memoization table only printable for Rats!-generated parser");
            error = true;
        }
        if (-1 == n2) {
            System.err.println("No file names specified");
            error = true;
        }
        if (error) {
            System.exit(1);
        }
        if (optionStats) {
            fileSizes = new Statistics();
            latencies = new Statistics();
            heapSizes = new Statistics();
            if (optionTable) {
                System.out.println("Legend: File, size, time (ave, med, stdev), memory (ave, med, stdev)");
                System.out.println();
            }
        }
        error = false;
        for (n = n2; n < stringArray.length; ++n) {
            if (!optionStats || !optionTable) {
                System.out.println("Processing " + stringArray[n] + " ...");
            }
            try {
                JavaDriver.parse(stringArray[n]);
                continue;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                error = true;
                while (null != throwable2.getCause()) {
                    throwable2 = throwable2.getCause();
                }
                if (throwable2 instanceof FileNotFoundException) {
                    System.err.println(throwable2.getMessage());
                    continue;
                }
                throwable2.printStackTrace();
            }
        }
        if (optionStats) {
            double d = 1000.0 / Statistics.fitSlope(fileSizes, latencies);
            double d2 = Statistics.fitSlope(fileSizes, heapSizes);
            System.out.println();
            System.out.println("Overall performance      : " + Statistics.round(d) + " KB/s");
            System.out.println("Overall heap utilization : " + Statistics.round(d2) + ":1");
        }
        if (error) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

