/*
 * Decompiled with CFR 0.152.
 */
package xtc.xform;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.xform.Function;
import xtc.xform.Item;
import xtc.xform.Query;

public class Engine {
    final int FOCUS_ROOT = 0;
    final int FOCUS_ALL = 1;
    final int FOCUS_IMPLICIT = 3;
    final int FOCUS_LAST = 4;
    final int FOCUS_INSIDE_OUT = 5;
    int focus_flag;
    boolean modified_flag = false;
    boolean bad_breadth_flag = true;
    Sequence bfs_sequence;
    Environment environment = null;
    GNode source_ast;
    Item item_tree;
    QueryVisitor visitor;
    String directory_file_name;
    HashMap function_table = new HashMap();

    public Engine() {
        this.visitor = new QueryVisitor();
    }

    private void addFunction(Function function) {
        this.function_table.put(function.getName(), function);
    }

    private List callFunction(String string, ArrayList arrayList) throws IllegalArgumentException {
        Function function = (Function)this.function_table.get(string);
        if (null == function) {
            throw new IllegalArgumentException();
        }
        return function.apply(arrayList);
    }

    public List run(Query query, GNode gNode) {
        this.environment = new Environment();
        this.environment.pushScope();
        this.source_ast = gNode;
        this.item_tree = this.genItemTree(this.source_ast, null, 0);
        return this.createObjectList((List)this.visitor.dispatch(query.ast));
    }

    private List createObjectList(List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Item) {
                arrayList.add(((Item)e).object);
                continue;
            }
            arrayList.add(this.createObjectList((List)e));
        }
        return arrayList;
    }

    public GNode getASTRoot() {
        return this.modified_flag ? (GNode)this.genFinalTree(this.item_tree) : this.source_ast;
    }

    private Item genItemTree(Object object, Item item, int n) {
        Item item2 = new Item(object, item, n);
        if (object instanceof GNode) {
            int n2 = 0;
            Iterator iterator = ((GNode)object).children();
            while (iterator.hasNext()) {
                item2.addChild(this.genItemTree(iterator.next(), item2, n2));
                ++n2;
            }
        }
        return item2;
    }

    private Object genFinalTree(Item item) {
        Object object = item.object;
        if (object instanceof GNode) {
            object = new GNode(((GNode)object).getName());
            if (null != item.children) {
                Iterator iterator = item.children.iterator();
                while (iterator.hasNext()) {
                    ((GNode)object).add(this.genFinalTree((Item)iterator.next()));
                }
            }
        }
        return object;
    }

    public class QueryVisitor
    extends Visitor {
        public List visitXForm(GNode gNode) {
            if (0 == gNode.size()) {
                return new ArrayList();
            }
            GNode gNode2 = (GNode)gNode.get(0);
            if (null != gNode2) {
                this.dispatch(gNode2);
            }
            return (List)this.dispatch((GNode)gNode.get(1));
        }

        public void visitImportStatement(GNode gNode) {
            String string = "";
            Iterator iterator = gNode.children();
            while (iterator.hasNext()) {
                Object object;
                try {
                    GNode gNode2 = (GNode)iterator.next();
                    string = (String)((Item)this.dispatch((Node)gNode2)).object;
                    object = Class.forName(string);
                    Object t = ((Class)object).newInstance();
                    Engine.this.addFunction((Function)t);
                }
                catch (Exception exception) {
                    object = "Error: Unable to load class \"" + string + "\".";
                    throw new RuntimeException((String)object);
                }
            }
        }

        public Sequence visitCompoundExpression(GNode gNode) {
            Sequence sequence = new Sequence();
            int n = 0;
            Iterator iterator = gNode.children();
            while (iterator.hasNext()) {
                Sequence sequence2 = (Sequence)this.dispatch((GNode)iterator.next());
                sequence.add(sequence2);
                Engine.this.environment.pushFocus(sequence2);
                ++n;
            }
            while (0 != n) {
                Engine.this.environment.popFocus();
                --n;
            }
            return sequence;
        }

        public Sequence visitLetExpression(GNode gNode) {
            Engine.this.environment.pushScope();
            this.dispatch((GNode)gNode.get(0));
            Sequence sequence = (Sequence)this.dispatch((GNode)gNode.get(1));
            Engine.this.environment.popScope();
            return sequence;
        }

        public void visitLetBindingList(GNode gNode) {
            Iterator iterator = gNode.children();
            while (iterator.hasNext()) {
                this.dispatch((GNode)iterator.next());
            }
        }

        public void visitLetBinding(GNode gNode) {
            GNode gNode2 = (GNode)gNode.get(0);
            String string = (String)gNode2.get(0);
            Sequence sequence = (Sequence)this.dispatch((GNode)gNode.get(1));
            Engine.this.environment.setVariable(string, sequence);
        }

        public Sequence visitForExpression(GNode gNode) {
            int n;
            Engine.this.environment.pushScope();
            ArrayList arrayList = (ArrayList)this.dispatch((GNode)gNode.get(0));
            ArrayList<Iterator> arrayList2 = new ArrayList<Iterator>(arrayList.size());
            Sequence sequence = new Sequence();
            for (n = 0; n < arrayList.size(); ++n) {
                arrayList2.add(((Variable)arrayList.get((int)n)).value.flatIterator());
            }
            while (true) {
                for (n = arrayList2.size() - 1; n >= 0; --n) {
                    Iterator iterator = (Iterator)arrayList2.get(n);
                    if (iterator.hasNext()) {
                        Sequence sequence2 = new Sequence();
                        sequence2.add(iterator.next());
                        Engine.this.environment.setVariable(((Variable)arrayList.get((int)n)).name, sequence2);
                        break;
                    }
                    if (0 == n) {
                        Engine.this.environment.popScope();
                        return sequence;
                    }
                    arrayList2.set(n, ((Variable)arrayList.get((int)n)).value.flatIterator());
                }
                sequence.addAll((List)this.dispatch((GNode)gNode.get(1)));
            }
        }

        public Sequence visitCForExpression(GNode gNode) {
            int n;
            Engine.this.environment.pushScope();
            ArrayList arrayList = (ArrayList)this.dispatch((GNode)gNode.get(0));
            ArrayList<Iterator> arrayList2 = new ArrayList<Iterator>(arrayList.size());
            Sequence sequence = new Sequence();
            for (n = 0; n < arrayList.size(); ++n) {
                arrayList2.add(((Variable)arrayList.get((int)n)).value.flatIterator());
            }
            while (true) {
                for (n = 0; n < arrayList2.size(); ++n) {
                    Iterator iterator = (Iterator)arrayList2.get(n);
                    if (!iterator.hasNext()) {
                        Engine.this.environment.popScope();
                        return sequence;
                    }
                    Sequence sequence2 = new Sequence();
                    sequence2.add(iterator.next());
                    Engine.this.environment.setVariable(((Variable)arrayList.get((int)n)).name, sequence2);
                }
                sequence.addAll((List)this.dispatch((GNode)gNode.get(1)));
            }
        }

        public ArrayList visitIterativeBindingList(GNode gNode) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = gNode.children();
            while (iterator.hasNext()) {
                arrayList.add(this.dispatch((GNode)iterator.next()));
            }
            return arrayList;
        }

        public Variable visitIterativeBinding(GNode gNode) {
            return new Variable((String)((GNode)gNode.get(0)).get(0), (Sequence)this.dispatch((GNode)gNode.get(1)));
        }

        public Sequence visitReplacementExpression(GNode gNode) {
            Sequence sequence = (Sequence)this.dispatch((GNode)gNode.get(0));
            if (sequence.isEmpty()) {
                return sequence;
            }
            Sequence sequence2 = (Sequence)this.dispatch((GNode)gNode.get(1));
            return this.replace(sequence, sequence2);
        }

        private Sequence replace(Sequence sequence, Sequence sequence2) {
            Engine.this.modified_flag = true;
            Engine.this.bad_breadth_flag = true;
            Sequence sequence3 = new Sequence();
            Iterator iterator = sequence.flatIterator();
            while (iterator.hasNext()) {
                Item item = (Item)iterator.next();
                Item item2 = item.parent;
                if (null == item2) {
                    if (1 < sequence2.size()) {
                        throw new RuntimeException("Error: Tree root can only be replaced by a single item.");
                    }
                    Engine.this.item_tree = (Item)sequence2.get(0);
                    sequence3.add(Engine.this.item_tree);
                    continue;
                }
                int n = item.index;
                if (1 == sequence2.size()) {
                    Item item3 = (Item)sequence2.get(0);
                    item2.replaceChild(n, item3);
                    sequence3.add(item3);
                    continue;
                }
                item2.replaceChild(n, sequence2);
                sequence3.addAll(sequence2);
            }
            return sequence2;
        }

        public Sequence visitIfExpression(GNode gNode) {
            Sequence sequence = (Sequence)this.dispatch((GNode)gNode.get(0));
            if (!sequence.isEmpty()) {
                return (Sequence)this.dispatch((GNode)gNode.get(1));
            }
            return (Sequence)this.dispatch((GNode)gNode.get(2));
        }

        public Sequence visitNewItemExpression(GNode gNode) {
            Sequence sequence = new Sequence();
            sequence.add((Item)this.dispatch((GNode)gNode.get(0)));
            return sequence;
        }

        public Item visitNewNodeExpression(GNode gNode) {
            GNode gNode2 = new GNode((String)this.dispatch((GNode)gNode.get(0)));
            Item item = new Item(gNode2, null, 0);
            Sequence sequence = (Sequence)this.dispatch((GNode)gNode.get(1));
            int n = 0;
            Iterator iterator = sequence.flatIterator();
            while (iterator.hasNext()) {
                item.addChild((Item)iterator.next());
                ++n;
            }
            return item;
        }

        public Sequence visitChildren(GNode gNode) {
            Sequence sequence = new Sequence();
            Iterator iterator = gNode.children();
            while (iterator.hasNext()) {
                GNode gNode2 = (GNode)iterator.next();
                if (!gNode2.hasChildren()) continue;
                Object object = this.dispatch((GNode)gNode2.get(0));
                if (null != object && object instanceof List) {
                    sequence.addAll((List)object);
                    continue;
                }
                sequence.add(object);
            }
            return sequence;
        }

        public Item visitNull(GNode gNode) {
            return new Item(null, null, 0);
        }

        public Item visitStringLiteral(GNode gNode) {
            String string = gNode.getString(0).substring(1, gNode.getString(0).length() - 1);
            return new Item(string, null, 0);
        }

        public Sequence visitPathExpression(GNode gNode) {
            if (1 == gNode.size()) {
                Engine.this.focus_flag = 3;
                return (Sequence)this.dispatch((GNode)gNode.get(0));
            }
            String string = (String)gNode.get(0);
            if (null != string && "/".equals(string)) {
                Engine.this.focus_flag = 0;
                return (Sequence)this.dispatch((GNode)gNode.get(1));
            }
            Engine.this.focus_flag = null == string ? 1 : 5;
            return (Sequence)this.dispatch((GNode)gNode.get(2));
        }

        public Sequence visitRelativePathExpression(GNode gNode) {
            if (1 == gNode.size()) {
                return (Sequence)this.dispatch((GNode)gNode.get(0));
            }
            Sequence sequence = (Sequence)this.dispatch((GNode)gNode.get(0));
            Engine.this.environment.pushFocus(sequence);
            String string = (String)gNode.get(1);
            Engine.this.focus_flag = "/".equals(string) ? 4 : 1;
            Sequence sequence2 = (Sequence)this.dispatch((GNode)gNode.get(2));
            Engine.this.environment.popFocus();
            return sequence2;
        }

        public Sequence visitStepExpression(GNode gNode) {
            GNode gNode2 = (GNode)gNode.get(0);
            GNode gNode3 = null;
            if (2 == gNode.size()) {
                gNode3 = (GNode)gNode.get(1);
            }
            Sequence sequence = this.collect(gNode2);
            if (null == gNode3) {
                return sequence;
            }
            Engine.this.environment.pushFocus(sequence);
            sequence = (Sequence)this.dispatch(gNode3);
            Engine.this.environment.popFocus();
            return sequence;
        }

        public Sequence visitPredicateList(GNode gNode) {
            Sequence sequence = Engine.this.environment.peekFocus();
            Iterator iterator = gNode.children();
            while (iterator.hasNext() && !(sequence = this.intersection(sequence, (Sequence)this.dispatch((GNode)iterator.next()))).isEmpty()) {
                Engine.this.environment.popFocus();
                Engine.this.environment.pushFocus(sequence);
            }
            return sequence;
        }

        public Sequence visitPredicate(GNode gNode) {
            Object object = this.dispatch((GNode)gNode.get(0));
            if (object instanceof Integer) {
                int n = (Integer)object;
                Sequence sequence = Engine.this.environment.peekFocus();
                if (1 <= n && n <= sequence.size()) {
                    Sequence sequence2 = new Sequence();
                    sequence2.add(sequence.get(n - 1));
                    return sequence2;
                }
                String string = "Error, Line " + gNode.location.line + ": invalid index.";
                throw new RuntimeException(string);
            }
            return (Sequence)object;
        }

        private Sequence collect(GNode gNode) {
            String string = gNode.getName();
            Sequence sequence = null;
            if (Engine.this.focus_flag == 0 || Engine.this.focus_flag == 1) {
                sequence = new Sequence();
                sequence.add(Engine.this.item_tree);
            } else if (Engine.this.focus_flag == 5) {
                if (!Engine.this.bad_breadth_flag) {
                    sequence = Engine.this.bfs_sequence;
                } else {
                    sequence = Engine.this.bfs_sequence = this.reverse_bft(Engine.this.item_tree);
                    Engine.this.bad_breadth_flag = false;
                }
            } else if (3 == Engine.this.focus_flag && !"ContextItem".equals(string)) {
                if ("VariableReference".equals(string)) {
                    Sequence sequence2 = Engine.this.environment.getVariable((String)gNode.get(0));
                    if (null == sequence2) {
                        String string2 = "Error, Line " + gNode.location.line + ": Variable " + (String)gNode.get(0) + " not initialized.";
                        throw new RuntimeException(string2);
                    }
                    return sequence2;
                }
                if ("ParenthesizedExpression".equals(string)) {
                    return (Sequence)this.dispatch(gNode);
                }
                if ("FunctionCall".equals(string)) {
                    Sequence sequence3 = new Sequence();
                    sequence3.addAll((List)this.dispatch(gNode));
                    return sequence3;
                }
            } else {
                try {
                    sequence = Engine.this.environment.peekFocus();
                }
                catch (NoSuchElementException noSuchElementException) {
                    String string3 = "Error, Line " + gNode.location.line + ": Attempted to evaluate a path expression without focus.";
                    throw new RuntimeException(string3);
                }
            }
            Sequence sequence4 = new Sequence();
            if (1 == Engine.this.focus_flag) {
                return this.test(gNode, sequence);
            }
            if ("ContextItem".equals(string)) {
                return sequence;
            }
            if ("FunctionCall".equals(string)) {
                return (Sequence)this.dispatch(gNode);
            }
            if ("ReverseStep" == string) {
                Sequence sequence5 = new Sequence();
                Iterator iterator = sequence.flatIterator();
                while (iterator.hasNext()) {
                    Item item = ((Item)iterator.next()).parent;
                    if (null == item) {
                        String string4 = "Error, Line " + gNode.location.line + ": Item has no parent.";
                        throw new RuntimeException(string4);
                    }
                    sequence5.add(item);
                }
                sequence4.addAll(sequence5);
            } else {
                Sequence sequence6 = new Sequence();
                Iterator iterator = sequence.flatIterator();
                while (iterator.hasNext()) {
                    Item item = (Item)iterator.next();
                    if (null == item.object || !(item.object instanceof GNode) || null == item.children) continue;
                    Iterator iterator2 = item.children.iterator();
                    while (iterator2.hasNext()) {
                        Item item2 = (Item)iterator2.next();
                        sequence6 = (Sequence)item2.addToList(sequence6);
                    }
                }
                sequence4 = this.union(sequence4, this.test(gNode, sequence6));
            }
            return sequence4;
        }

        private Sequence test(GNode gNode, Sequence sequence) {
            Object object;
            Object object2;
            Sequence sequence2 = new Sequence();
            String string = gNode.getName();
            Iterator iterator = null;
            if ("ReverseStep".equals(string)) {
                iterator = sequence.flatIterator();
                while (iterator.hasNext()) {
                    object2 = ((Item)iterator.next()).parent;
                    if (null == object2) {
                        String string2 = "Error, Line " + gNode.location.line + ": Item has no parent.";
                        throw new RuntimeException(string2);
                    }
                    sequence2 = (Sequence)((Item)object2).addToList(sequence2);
                }
            } else if ("Wildcard".equals(string)) {
                sequence2 = sequence;
            } else if ("ContextItem".equals(string)) {
                sequence2 = sequence;
            } else if ("Identifier".equals(string)) {
                iterator = sequence.flatIterator();
                while (iterator.hasNext()) {
                    object2 = (Item)iterator.next();
                    if (null == ((Item)object2).object || !(((Item)object2).object instanceof GNode) || !((String)(object = ((GNode)((Item)object2).object).getName())).equals((String)gNode.get(0))) continue;
                    sequence2 = (Sequence)((Item)object2).addToList(sequence2);
                }
            } else if ("StringLiteral".equals(string)) {
                object2 = (String)gNode.get(0);
                object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                iterator = sequence.flatIterator();
                while (iterator.hasNext()) {
                    object = (Item)iterator.next();
                    if (null == ((Item)object).object || !(((Item)object).object instanceof String) || !((String)object2).equals((String)((Item)object).object)) continue;
                    sequence2 = (Sequence)((Item)object).addToList(sequence2);
                }
            } else if ("FunctionCall".equals(string)) {
                Engine.this.environment.pushFocus(sequence);
                sequence2 = (Sequence)this.dispatch(gNode);
                Engine.this.environment.popFocus();
            } else {
                object2 = null;
                if ("VariableReference".equals(string)) {
                    object = Engine.this.environment.getVariable((String)gNode.get(0));
                    if (null == object) {
                        String string3 = "Error, Line " + gNode.location.line + ": Variable " + (String)gNode.get(0) + " not initialized.";
                        throw new RuntimeException(string3);
                    }
                    object2 = object;
                } else {
                    object2 = (Sequence)this.dispatch(gNode);
                }
                sequence2 = this.intersection(sequence, (Sequence)object2);
            }
            if (1 == Engine.this.focus_flag) {
                object2 = new Sequence();
                iterator = sequence.flatIterator();
                while (iterator.hasNext()) {
                    object = (Item)iterator.next();
                    if (null == ((Item)object).object || !(((Item)object).object instanceof GNode) || null == ((Item)object).children) continue;
                    Iterator iterator2 = ((Item)object).children.iterator();
                    while (iterator2.hasNext()) {
                        ((Sequence)object2).add(iterator2.next());
                    }
                }
                if (!((AbstractCollection)object2).isEmpty()) {
                    sequence2 = this.union(sequence2, this.test(gNode, (Sequence)object2));
                }
            }
            return sequence2;
        }

        public Sequence visitParenthesizedExpression(GNode gNode) {
            int n = Engine.this.focus_flag;
            Sequence sequence = (Sequence)this.dispatch((GNode)gNode.get(0));
            Engine.this.focus_flag = n;
            return sequence == null ? new Sequence() : sequence;
        }

        public Integer visitIntegerLiteral(GNode gNode) {
            return new Integer(Integer.parseInt((String)gNode.get(0), 10));
        }

        public String visitIdentifier(GNode gNode) {
            return (String)gNode.get(0);
        }

        public List visitFunctionCall(GNode gNode) {
            String string = (String)this.dispatch((GNode)gNode.get(0));
            GNode gNode2 = (GNode)gNode.get(1);
            ArrayList arrayList = null;
            if (null != gNode2) {
                arrayList = (ArrayList)this.dispatch((GNode)gNode.get(1));
            }
            try {
                return Engine.this.callFunction(string, arrayList);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = "Error, Line " + gNode.location.line + ": External function " + string + " not found.";
                throw new IllegalArgumentException(string2);
            }
        }

        public ArrayList visitArgumentList(GNode gNode) {
            int n = gNode.size();
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            Iterator iterator = gNode.children();
            while (iterator.hasNext()) {
                arrayList.add(this.dispatch((GNode)iterator.next()));
            }
            return arrayList;
        }

        public Sequence visitIntersectionExpression(GNode gNode) {
            Sequence sequence = (Sequence)this.dispatch((GNode)gNode.get(0));
            Sequence sequence2 = (Sequence)this.dispatch((GNode)gNode.get(1));
            return this.intersection(sequence, sequence2);
        }

        public Sequence visitUnionExpression(GNode gNode) {
            Sequence sequence = (Sequence)this.dispatch((GNode)gNode.get(0));
            Sequence sequence2 = (Sequence)this.dispatch((GNode)gNode.get(1));
            return this.union(sequence, sequence2);
        }

        public Sequence visitOrExpression(GNode gNode) {
            Sequence sequence = null;
            Iterator iterator = gNode.children();
            while (iterator.hasNext()) {
                sequence = (Sequence)this.dispatch((GNode)iterator.next());
                if (sequence.isEmpty()) continue;
                return sequence;
            }
            return sequence;
        }

        public Sequence visitAndExpression(GNode gNode) {
            Sequence sequence = null;
            Sequence sequence2 = new Sequence();
            Iterator iterator = gNode.children();
            while (iterator.hasNext()) {
                sequence = (Sequence)this.dispatch((GNode)iterator.next());
                if (sequence.isEmpty()) {
                    return sequence;
                }
                sequence2.addAll(sequence);
            }
            return sequence2;
        }

        private Sequence union(Sequence sequence, Sequence sequence2) {
            Sequence sequence3 = new Sequence();
            if (null != sequence) {
                sequence3.addAll(sequence);
            }
            if (null != sequence2) {
                Iterator iterator = sequence2.flatIterator();
                while (iterator.hasNext()) {
                    Item item = (Item)iterator.next();
                    sequence3 = (Sequence)item.addToList(sequence3);
                }
            }
            return sequence3;
        }

        private Sequence intersection(Sequence sequence, Sequence sequence2) {
            Sequence sequence3 = new Sequence();
            if (null != sequence && null != sequence2) {
                Iterator iterator = sequence.flatIterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!sequence2.contains(e)) continue;
                    sequence3.add(e);
                }
            }
            return sequence3;
        }

        private Sequence reverse_bft(Item item) {
            Sequence sequence = new Sequence();
            Sequence sequence2 = new Sequence();
            sequence.add(item);
            while (!sequence.isEmpty()) {
                item = (Item)sequence.removeFirst();
                if (item.object instanceof GNode && null != item.children) {
                    Iterator iterator = item.children.iterator();
                    while (iterator.hasNext()) {
                        Item item2 = (Item)iterator.next();
                        sequence.addFirst(item2);
                    }
                }
                sequence2.addFirst(item);
            }
            return sequence2;
        }
    }

    static class Variable {
        String name;
        Sequence value;

        public Variable(String string, Sequence sequence) {
            this.name = string;
            this.value = sequence;
        }
    }

    static class Environment {
        private LinkedList stack_frames = new LinkedList();
        private LinkedList focus_stack = new LinkedList();

        public void pushScope() {
            this.stack_frames.add(new Frame());
        }

        public void popScope() {
            if (0 != this.stack_frames.size()) {
                this.stack_frames.removeLast();
            }
        }

        public Sequence getVariable(String string) {
            Sequence sequence = null;
            for (int i = this.stack_frames.size() - 1; i >= 0 && null == (sequence = ((Frame)this.stack_frames.get(i)).getVariable(string)); --i) {
            }
            return sequence;
        }

        public void setVariable(String string, Sequence sequence) {
            if (0 == this.stack_frames.size()) {
                this.pushScope();
            }
            ((Frame)this.stack_frames.getLast()).setVariable(string, sequence);
        }

        public void pushFocus(Sequence sequence) {
            this.focus_stack.add(sequence);
        }

        public Sequence popFocus() throws NoSuchElementException {
            Sequence sequence = (Sequence)this.focus_stack.getLast();
            this.focus_stack.removeLast();
            return sequence;
        }

        public Sequence peekFocus() throws NoSuchElementException {
            return (Sequence)this.focus_stack.getLast();
        }

        static class Frame {
            private HashMap symbols = new HashMap();

            public void setVariable(String string, Sequence sequence) {
                this.symbols.put(string, sequence);
            }

            public Sequence getVariable(String string) {
                return (Sequence)this.symbols.get(string);
            }
        }
    }

    static class Sequence
    extends LinkedList {
        Sequence() {
        }

        public boolean add(Object object) {
            if (!(object instanceof List) || 0 != ((List)object).size()) {
                return super.add(object);
            }
            return false;
        }

        public boolean contains(Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!object.equals(e)) continue;
                return true;
            }
            return false;
        }

        public Iterator flatIterator() {
            return new FlatIterator(this.iterator());
        }

        static class FlatIterator
        implements Iterator {
            private LinkedList iterator_stack = new LinkedList();

            public FlatIterator(Iterator iterator) {
                this.iterator_stack.add(iterator);
            }

            public boolean hasNext() {
                boolean bl = ((Iterator)this.iterator_stack.getLast()).hasNext();
                while (!bl) {
                    this.iterator_stack.removeLast();
                    if (0 == this.iterator_stack.size()) break;
                    bl = ((Iterator)this.iterator_stack.getLast()).hasNext();
                }
                return bl;
            }

            public Object next() {
                Iterator iterator = (Iterator)this.iterator_stack.getLast();
                Object e = iterator.next();
                if (e instanceof List) {
                    iterator = ((List)e).iterator();
                    e = iterator.next();
                    this.iterator_stack.add(iterator);
                    return e;
                }
                return e;
            }

            public void remove() {
                ((Iterator)this.iterator_stack.getLast()).remove();
            }
        }
    }
}

