/*
 * Decompiled with CFR 0.152.
 */
package xtc.xform;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import xtc.lang.CParser;
import xtc.lang.CPrinter;
import xtc.parser.ParseError;
import xtc.parser.Result;
import xtc.parser.SemanticValue;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.xform.Engine;
import xtc.xform.Query;

public final class Driver {
    private static boolean option_print_ast = false;
    private static boolean option_query_ast = false;
    private static boolean option_print_sequence = false;
    private static boolean option_prettyprint = false;
    private static boolean option_debug = false;
    private static boolean option_directory = false;
    private static boolean option_verbose = false;

    private Driver() {
    }

    private static void process(List list) throws IOException {
        int n = 0;
        String string = (String)list.get(n);
        ++n;
        String string2 = null;
        if (1 < list.size()) {
            string2 = (String)list.get(n);
            ++n;
            option_query_ast = true;
        } else if (option_prettyprint || option_print_sequence) {
            Driver.printMenu();
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error: XForm source file " + string + " not found!");
            return;
        }
        Query query = null;
        try {
            query = new Query(bufferedReader);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Error: XForm query is malformed.");
            return;
        }
        if (option_print_ast && 1 == list.size()) {
            Driver.printAST(query.ast);
            return;
        }
        if (option_query_ast) {
            if (null == string2) {
                System.err.println("Error: Please specify a C source file.");
                return;
            }
            BufferedReader bufferedReader2 = null;
            try {
                bufferedReader2 = new BufferedReader(new FileReader(string2));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Error: C source file " + string2 + " not found.");
                return;
            }
            if (option_verbose) {
                System.err.println("Parsing " + string2 + "...");
            }
            long l = new File(string2).length();
            CParser cParser = new CParser(bufferedReader2, string2, (int)l);
            Result result = null;
            try {
                result = cParser.pTranslationUnit(0);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                return;
            }
            Node node = (Node)((SemanticValue)result).value;
            if (!result.hasValue()) {
                ParseError parseError = (ParseError)result;
                System.err.println("Error: C source file could not be parsed.");
                return;
            }
            Engine engine = new Engine();
            GNode gNode = null;
            if (option_verbose) {
                System.err.println("Performing query...");
            }
            try {
                List list2 = engine.run(query, (GNode)node.strip());
                gNode = engine.getASTRoot();
                if (option_print_sequence) {
                    Driver.printSequence(list2);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                while (null != throwable2.getCause()) {
                    throwable2 = throwable2.getCause();
                }
                System.err.println(throwable2.getMessage());
                if (option_debug) {
                    throwable2.printStackTrace();
                }
                return;
            }
            if (option_prettyprint) {
                try {
                    Printer printer = new Printer(new BufferedWriter(new OutputStreamWriter(System.out)));
                    new CPrinter(printer).dispatch(gNode);
                    System.err.println();
                    System.err.println();
                    printer.flush();
                }
                catch (Throwable throwable) {
                    Throwable throwable3;
                    System.err.print("Error pretty-printing C source: ");
                    while (null != throwable3.getCause()) {
                        throwable3 = throwable3.getCause();
                    }
                    System.err.println(throwable3.getMessage());
                    if (option_debug) {
                        throwable3.printStackTrace();
                    }
                    return;
                }
            }
            if (option_print_ast) {
                Driver.printAST(gNode);
            }
        }
    }

    public static void main(String[] stringArray) {
        System.err.print("XForm AST Transformation Language   Version ");
        System.err.print("1.7.1");
        System.err.print("   ");
        System.err.println("(C) 2004-2005 Robert Grimm");
        if (null == stringArray || 0 == stringArray.length) {
            Driver.printMenu();
            return;
        }
        try {
            int n;
            LinkedList<String> linkedList = new LinkedList<String>();
            for (n = 0; stringArray.length > n; ++n) {
                String string = stringArray[n];
                if (string.equals("-source")) {
                    option_prettyprint = true;
                    continue;
                }
                if (string.equals("-s")) {
                    option_print_sequence = true;
                    continue;
                }
                if (string.equals("-ast")) {
                    option_print_ast = true;
                    continue;
                }
                if (string.equals("-debug")) {
                    option_debug = true;
                    continue;
                }
                if (string.equals("-v")) {
                    option_verbose = true;
                    continue;
                }
                if (!string.startsWith("-")) break;
                Driver.printMenu();
                return;
            }
            if (0 == n) {
                Driver.printMenu();
                return;
            }
            while (stringArray.length > n) {
                linkedList.add(stringArray[n]);
                ++n;
            }
            if (linkedList.isEmpty()) {
                Driver.printMenu();
                return;
            }
            Driver.process(linkedList);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    private static void printMenu() {
        System.err.println();
        System.err.print("Usage: ");
        System.err.println("  <option>+ <file name>+");
        System.err.println();
        System.err.println("Options are:");
        System.err.println("  -s                Print the value of the query.\n  -ast              Print the AST of the xform query, or of\n                    the post-query C source (If a C source-file\n                    has been specified).\n  -source           Pretty-print the post-query C source.\n  -debug            Print a stack trace in the even of a runtime error.  -v                Print verbose output.\n");
        System.err.println();
    }

    private static void printSequence(List list) {
        System.err.println();
        if (option_verbose) {
            System.err.println("Printing resulting sequence to stdout...");
            System.err.println();
        }
        System.err.print("(");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            System.out.print(e);
            if (!iterator.hasNext()) continue;
            System.out.print(",");
        }
        System.out.println(")");
        System.out.println();
    }

    public static void printAST(GNode gNode) {
        System.err.println();
        System.err.println("Printing AST to stdout...");
        System.err.println();
        try {
            Printer printer = new Printer(System.out);
            printer.format(gNode).pln();
            printer.flush();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            System.err.print("Error: Unable to print AST: ");
            while (null != throwable2.getCause()) {
                throwable2 = throwable2.getCause();
            }
            System.err.println(throwable2.getMessage());
            return;
        }
    }
}

