/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Statistics {
    private List numbers = new ArrayList();

    public void reset() {
        this.numbers.clear();
    }

    public void add(double d) {
        this.numbers.add(new Double(d));
    }

    public int size() {
        return this.numbers.size();
    }

    private static double get(int n, List list) {
        return (Double)list.get(n);
    }

    public double get(int n) {
        return Statistics.get(n, this.numbers);
    }

    public double mean() {
        double d = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            d += (this.get(i) - d) / (double)(i + 1);
        }
        return d;
    }

    public double median() {
        if (0 == this.size()) {
            return 0.0;
        }
        ArrayList arrayList = new ArrayList(this.numbers);
        Collections.sort(arrayList);
        return Statistics.get(this.size() / 2, arrayList);
    }

    public double stdev() {
        double d = this.mean();
        double d2 = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            double d3 = this.get(i) - d;
            d2 += (d3 * d3 - d2) / (double)(i + 1);
        }
        return Math.sqrt(d2);
    }

    public static double round(double d) {
        return Math.floor(d * 100.0 + 0.5) / 100.0;
    }

    public static double fitSlope(Statistics statistics, Statistics statistics2) {
        int n;
        if (statistics.size() != statistics2.size()) {
            throw new IllegalArgumentException("Inconsistent collection sizes");
        }
        if (0 == statistics.size()) {
            throw new IllegalArgumentException("Empty collections");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = statistics.size();
        for (n = 0; n < n2; ++n) {
            d += (statistics.get(n) - d) / (double)(n + 1);
            d2 += (statistics2.get(n) - d2) / (double)(n + 1);
        }
        for (n = 0; n < n2; ++n) {
            double d5 = statistics.get(n) - d;
            double d6 = statistics2.get(n) - d2;
            d3 += (d5 * d5 - d3) / (double)(n + 1);
            d4 += (d5 * d6 - d4) / (double)(n + 1);
        }
        return (d * d2 + d4) / (d * d + d3);
    }
}

