/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.FullProduction;
import xtc.parser.Generifier;
import xtc.parser.GrammarVisitor;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.NullValue;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.ProperListValue;
import xtc.parser.Rats;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.SingletonListValue;
import xtc.parser.StringValue;
import xtc.parser.TextTester;
import xtc.parser.TextValue;
import xtc.parser.Type;
import xtc.tree.AttributeList;
import xtc.tree.Node;
import xtc.util.Utilities;

public class Transformer
extends GrammarVisitor {
    protected IdentityHashMap sources = new IdentityHashMap();
    protected boolean isTextOnly;
    protected boolean isGeneric;
    protected boolean isVoid;
    protected boolean isDirectLeft;

    public Transformer(Analyzer analyzer) {
        super(analyzer);
    }

    protected boolean repeatable() {
        return Rats.optimizeRepeated && this.analyzer.current().hasAttribute(Constants.ATT_TRANSIENT);
    }

    protected Sequence reprocess(Sequence sequence) {
        Binding binding = this.analyzer.getBinding(sequence);
        if (null != binding && (binding.element instanceof Repetition || binding.element instanceof Option)) {
            sequence = (Sequence)this.dispatch(sequence);
        }
        return sequence;
    }

    public Object visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        this.sources.clear();
        for (int i = 0; i < module.productions.size(); ++i) {
            FullProduction fullProduction = (FullProduction)module.productions.get(i);
            this.isTextOnly = TextTester.isTextOnly(fullProduction);
            this.isGeneric = Generifier.isGeneric(fullProduction);
            this.isVoid = Type.isVoidT(fullProduction.type);
            this.isDirectLeft = DirectLeftRecurser.isTransformable(fullProduction);
            this.analyzer.startAdding();
            this.analyzer.process(fullProduction);
            i += this.analyzer.addNewProductionsAt(i + 1);
        }
        return null;
    }

    public Element visit(OrderedChoice orderedChoice) {
        Element element;
        boolean bl = this.isGeneric;
        this.isGeneric = this.isGeneric && (this.isTopLevel || this.isLastElement);
        boolean bl2 = this.isTopLevel;
        this.isTopLevel = false;
        boolean bl3 = this.isLastElement;
        this.isLastElement = false;
        this.isVoided = false;
        boolean bl4 = this.isBound;
        this.isBound = false;
        boolean bl5 = this.transformInPlace;
        this.transformInPlace = false;
        if (bl2 && !bl && !this.isDirectLeft && 1 == orderedChoice.alternatives.size()) {
            element = Analyzer.strip((Element)orderedChoice.alternatives.get(0));
            if (!this.repeatable() && element instanceof Repetition || !Rats.optimizeOptional && element instanceof Option) {
                if (Rats.optionVerbose) {
                    System.err.print("[Transforming top-level ");
                    if (element instanceof Repetition) {
                        System.err.print("repetition");
                    } else {
                        System.err.print("option");
                    }
                    System.err.println(" in " + this.analyzer.current().qName + " in place]");
                }
                this.isLastElement = true;
                this.transformInPlace = true;
                element = (Element)this.dispatch(element);
                this.isGeneric = bl;
                return element;
            }
        }
        element = bl2 || bl5 || bl3 && !this.isPredicate && !bl4 ? this.analyzer.current().name : this.analyzer.choice();
        String string = null;
        int n = orderedChoice.alternatives.size();
        for (int i = 0; i < n; ++i) {
            if (bl2 || bl3) {
                this.isLastElement = true;
            }
            Sequence sequence = Sequence.ensure((Element)this.dispatch((Element)orderedChoice.alternatives.get(i)));
            if (!(bl5 || !sequence.isEmpty() && sequence.get(sequence.length() - 1) instanceof OrderedChoice)) {
                Object object;
                if (this.isTextOnly) {
                    if (!this.isDirectLeft || !bl2) {
                        if (bl2 || bl4) {
                            object = this.analyzer.matchingText(sequence);
                            if (null == object || !Rats.optimizeTerminals) {
                                sequence.add(TextValue.VALUE);
                            } else {
                                sequence.add(new StringValue((String)object));
                            }
                            string = Type.stringT();
                        } else if (bl3 && !this.isPredicate) {
                            sequence.add(TextValue.VALUE);
                            string = Type.stringT();
                        } else {
                            sequence.add(NullValue.VALUE);
                            string = Type.voidT();
                        }
                    }
                } else if (this.isVoid && !bl4) {
                    if (!this.isDirectLeft || !bl2) {
                        sequence.add(NullValue.VALUE);
                        string = Type.voidT();
                    }
                } else if (!(bl && bl2 || bl3)) {
                    object = this.analyzer.bind(sequence);
                    sequence = this.reprocess(sequence);
                    if (null != object) {
                        ((Binding)object).name = "yyValue";
                        string = null == string ? Type.type(((Binding)object).element, this.analyzer) : Type.unify(string, Type.type(((Binding)object).element, this.analyzer));
                    } else {
                        string = Type.rootT();
                    }
                }
            }
            orderedChoice.alternatives.set(i, sequence);
        }
        if (bl2 || bl5 || bl3 && !this.isPredicate && !bl4) {
            this.isGeneric = bl;
            return orderedChoice;
        }
        FullProduction fullProduction = new FullProduction(new AttributeList((Collection)this.analyzer.current().attributes), string, (NonTerminal)element, orderedChoice);
        fullProduction.qName = fullProduction.name.qualify(this.analyzer.module().name.name);
        fullProduction.attributes.remove(Constants.ATT_STATEFUL);
        fullProduction.attributes.remove(Constants.ATT_RESETTING);
        if (this.isTextOnly && Type.isStringT(string)) {
            TextTester.markTextOnly(fullProduction);
        }
        this.analyzer.add(fullProduction);
        this.isGeneric = bl;
        return element;
    }

    public Element visit(Repetition repetition) {
        Node node;
        Object object;
        Element element;
        ArrayList<Element> arrayList;
        Element element2;
        Element element3;
        boolean bl = this.isGeneric;
        this.isGeneric = false;
        this.isTopLevel = false;
        this.isLastElement = false;
        boolean bl2 = this.isVoided;
        this.isVoided = false;
        boolean bl3 = this.isBound;
        this.isBound = false;
        boolean bl4 = this.transformInPlace;
        boolean bl5 = this.transformInPlace = (this.isTextOnly || this.isVoid) && !bl3;
        if ((bl3 || bl) && !bl2 && !this.isTextOnly && repetition.element instanceof Sequence) {
            element3 = this.analyzer.bind((Sequence)repetition.element, "el");
            if (null == element3) {
                element2 = new OrderedChoice(new ArrayList(1));
                ((OrderedChoice)element2).alternatives.add(repetition.element);
                ((OrderedChoice)element2).location = repetition.element.location;
                repetition.element = element2;
            } else if ("yyValue".equals(((Binding)element3).name)) {
                ((Binding)element3).name = this.analyzer.variable("el");
            }
        }
        element3 = (Element)this.dispatch(repetition.element);
        if (this.repeatable()) {
            repetition.element = Sequence.ensure(element3);
            if ((bl3 || bl) && !bl2 && !this.isTextOnly) {
                element2 = this.analyzer.bind((Sequence)repetition.element, "el");
                if (null == element2) {
                    if (!this.sources.containsKey(repetition)) {
                        Utilities.msg("warning: repeated element without bindable element", element3.location, this.analyzer.current().qName.name, null);
                        this.sources.put(repetition, Boolean.TRUE);
                    }
                } else if ("yyValue".equals(((Binding)element2).name)) {
                    ((Binding)element2).name = this.analyzer.variable("el");
                }
            }
            this.isGeneric = bl;
            return repetition;
        }
        if (bl4) {
            element2 = this.analyzer.current().name;
        } else {
            NonTerminal nonTerminal = element2 = repetition.once ? this.analyzer.plus() : this.analyzer.star();
        }
        if (element3 instanceof OrderedChoice) {
            arrayList = ((OrderedChoice)element3).alternatives;
        } else {
            arrayList = new ArrayList<Element>(1);
            arrayList.add(element3);
        }
        ArrayList<Element> arrayList2 = new ArrayList<Element>(arrayList.size() + (repetition.once ? arrayList.size() : 1));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            element = repetition.once ? new Sequence((Element)iterator.next()) : Sequence.ensure((Element)iterator.next());
            if (this.isTextOnly) {
                ((Sequence)element).add(element2);
                if (bl3 || bl4) {
                    ((Sequence)element).add(TextValue.VALUE);
                } else {
                    ((Sequence)element).add(NullValue.VALUE);
                }
            } else if (this.isVoid && !bl3) {
                ((Sequence)element).add(element2).add(NullValue.VALUE);
            } else {
                object = this.analyzer.bind((Sequence)element);
                element = this.reprocess((Sequence)element);
                node = new Binding(this.analyzer.variable(), element2);
                ((Sequence)element).add((Element)node).add(new ProperListValue(null == object ? "yyValue" : ((Binding)object).name, node.name));
            }
            arrayList2.add(element);
        }
        if (repetition.once) {
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                element = Sequence.ensure(this.analyzer.copy((Element)iterator.next()));
                if (this.isTextOnly) {
                    if (bl3 || bl4) {
                        ((Sequence)element).add(TextValue.VALUE);
                    } else {
                        ((Sequence)element).add(NullValue.VALUE);
                    }
                } else if (this.isVoid && !bl3) {
                    ((Sequence)element).add(NullValue.VALUE);
                } else {
                    object = this.analyzer.bind((Sequence)element);
                    element = this.reprocess((Sequence)element);
                    ((Sequence)element).add(new SingletonListValue(null == object ? "yyValue" : ((Binding)object).name));
                }
                arrayList2.add(element);
            }
        } else {
            element = new Sequence();
            if (this.isTextOnly) {
                if (bl3 || bl4) {
                    ((Sequence)element).add(TextValue.VALUE);
                } else {
                    ((Sequence)element).add(NullValue.VALUE);
                }
            } else if (this.isVoid && !bl3) {
                ((Sequence)element).add(NullValue.VALUE);
            } else {
                ((Sequence)element).add(EmptyListValue.VALUE);
            }
            arrayList2.add(element);
        }
        element = new OrderedChoice(arrayList2);
        if (bl4) {
            this.isGeneric = bl;
            return element;
        }
        object = this.isTextOnly ? (bl3 ? Type.stringT() : Type.voidT()) : (this.isVoid && !bl3 ? Type.voidT() : Type.listT());
        node = new FullProduction(new AttributeList((Collection)this.analyzer.current().attributes), (String)object, (NonTerminal)element2, element);
        ((FullProduction)node).qName = ((FullProduction)node).name.qualify(this.analyzer.module().name.name);
        ((FullProduction)node).attributes.remove(Constants.ATT_STATEFUL);
        ((FullProduction)node).attributes.remove(Constants.ATT_RESETTING);
        if (this.isTextOnly && Type.isStringT((String)object)) {
            TextTester.markTextOnly((Production)node);
        }
        this.analyzer.add((FullProduction)node);
        this.isGeneric = bl;
        return element2;
    }

    public Element visit(Option option) {
        Element element;
        Sequence sequence;
        ArrayList<Element> arrayList;
        Element element2;
        Element element3;
        boolean bl = this.isGeneric;
        this.isGeneric = false;
        this.isTopLevel = false;
        this.isLastElement = false;
        boolean bl2 = this.isVoided;
        this.isVoided = false;
        boolean bl3 = this.isBound;
        this.isBound = false;
        boolean bl4 = this.transformInPlace;
        this.transformInPlace = true;
        if ((bl3 || bl) && !bl2 && !this.isTextOnly && option.element instanceof Sequence) {
            element3 = this.analyzer.bind((Sequence)option.element, "el");
            if (null == element3) {
                element2 = new OrderedChoice(new ArrayList(1));
                ((OrderedChoice)element2).alternatives.add(option.element);
                ((OrderedChoice)element2).location = option.element.location;
                option.element = element2;
            } else if ("yyValue".equals(((Binding)element3).name)) {
                ((Binding)element3).name = this.analyzer.variable("el");
            }
        }
        if (Rats.optimizeOptional && (bl3 || bl) && option.element instanceof OrderedChoice) {
            this.transformInPlace = false;
        }
        element3 = (Element)this.dispatch(option.element);
        if (Rats.optimizeOptional) {
            option.element = Sequence.ensure(element3);
            if ((bl3 || bl) && !bl2 && !this.isTextOnly) {
                element2 = this.analyzer.bind((Sequence)option.element, "el");
                if (null == element2) {
                    if (!this.sources.containsKey(option)) {
                        Utilities.msg("warning: optional element without bindable element", element3.location, this.analyzer.current().qName.name, null);
                        this.sources.put(option, Boolean.TRUE);
                    }
                } else if ("yyValue".equals(((Binding)element2).name)) {
                    ((Binding)element2).name = this.analyzer.variable("el");
                }
            }
            this.isGeneric = bl;
            return option;
        }
        NonTerminal nonTerminal = element2 = bl4 ? this.analyzer.current().name : this.analyzer.option();
        if (element3 instanceof OrderedChoice) {
            arrayList = ((OrderedChoice)element3).alternatives;
        } else {
            arrayList = new ArrayList<Element>(1);
            arrayList.add(element3);
        }
        ArrayList<Sequence> arrayList2 = new ArrayList<Sequence>(arrayList.size() + 1);
        String string = null;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            sequence = Sequence.ensure((Element)iterator.next());
            if (this.isTextOnly) {
                if (bl3 || bl4) {
                    sequence.add(TextValue.VALUE);
                    string = Type.stringT();
                } else {
                    sequence.add(NullValue.VALUE);
                    string = Type.voidT();
                }
            } else if (this.isVoid && !bl3) {
                sequence.add(NullValue.VALUE);
                string = Type.voidT();
            } else {
                element = this.analyzer.bind(sequence);
                sequence = this.reprocess(sequence);
                if (null != element) {
                    element.name = "yyValue";
                    string = null == string ? Type.type(element.element, this.analyzer) : Type.unify(string, Type.type(element.element, this.analyzer));
                } else {
                    string = Type.rootT();
                }
            }
            arrayList2.add(sequence);
        }
        sequence = new Sequence();
        if (this.isTextOnly && (bl3 || bl4)) {
            sequence.add(TextValue.VALUE);
        } else {
            sequence.add(NullValue.VALUE);
        }
        arrayList2.add(sequence);
        element = new OrderedChoice(arrayList2);
        if (bl4) {
            this.isGeneric = bl;
            return element;
        }
        FullProduction fullProduction = new FullProduction(new AttributeList((Collection)this.analyzer.current().attributes), string, (NonTerminal)element2, element);
        fullProduction.qName = fullProduction.name.qualify(this.analyzer.module().name.name);
        fullProduction.attributes.remove(Constants.ATT_STATEFUL);
        fullProduction.attributes.remove(Constants.ATT_RESETTING);
        if (this.isTextOnly && Type.isStringT(string)) {
            TextTester.markTextOnly(fullProduction);
        }
        this.analyzer.add(fullProduction);
        this.isGeneric = bl;
        return element2;
    }

    public Element visit(Predicate predicate) {
        boolean bl = this.isGeneric;
        this.isGeneric = false;
        boolean bl2 = this.isPredicate;
        this.isPredicate = true;
        this.isTopLevel = false;
        this.isLastElement = false;
        this.isVoided = false;
        this.isBound = false;
        this.transformInPlace = false;
        predicate.element = Sequence.ensure((Element)this.dispatch(predicate.element));
        this.isPredicate = bl2;
        this.isGeneric = bl;
        return predicate;
    }
}

