/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GrammarVisitor;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.NullValue;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.Rats;
import xtc.parser.Type;
import xtc.parser.ValueElement;
import xtc.parser.VoidedElement;

public class ProductionVoider
extends GrammarVisitor {
    public ProductionVoider(Analyzer analyzer) {
        super(analyzer);
    }

    public Object visit(Module module) {
        boolean bl;
        do {
            bl = false;
            Tester tester = new Tester(this.analyzer);
            tester.dispatch(module);
            Set set = tester.voidable();
            this.analyzer.register(this);
            this.analyzer.init(module);
            Iterator iterator = module.productions.iterator();
            while (iterator.hasNext()) {
                Production production = (Production)iterator.next();
                if (!set.contains(production.qName)) continue;
                if (Rats.optionVerbose) {
                    System.err.println("[Voiding " + production.qName + "]");
                }
                this.analyzer.process(production);
                bl = true;
                production.type = Type.voidT();
            }
        } while (bl);
        return null;
    }

    public Element visit(VoidedElement voidedElement) {
        voidedElement.element = (Element)this.dispatch(voidedElement.element);
        return voidedElement.element;
    }

    public Element visit(Binding binding) {
        binding.element = (Element)this.dispatch(binding.element);
        if (this.analyzer.isSynthetic(binding.name)) {
            return binding.element;
        }
        return binding;
    }

    public Element visit(ValueElement valueElement) {
        return NullValue.VALUE;
    }

    public static class Tester
    extends GrammarVisitor {
        protected boolean secondPhase;
        protected boolean voidable;

        public Tester(Analyzer analyzer) {
            super(analyzer);
        }

        public Set voidable() {
            return new HashSet(this.analyzer.marked());
        }

        public Object visit(Module module) {
            Production production;
            this.analyzer.register(this);
            this.analyzer.init(module);
            this.secondPhase = false;
            Iterator iterator = module.productions.iterator();
            while (iterator.hasNext()) {
                production = (Production)iterator.next();
                if (production.hasAttribute(Constants.ATT_PUBLIC) || Type.isVoidT(production.type)) continue;
                this.voidable = true;
                this.analyzer.process(production);
                if (!this.voidable) continue;
                this.analyzer.mark(production.qName);
            }
            this.secondPhase = true;
            iterator = module.productions.iterator();
            while (iterator.hasNext()) {
                production = (Production)iterator.next();
                this.analyzer.process(production);
            }
            return null;
        }

        public Element visit(Binding binding) {
            if ("yyValue".equals(binding.name)) {
                this.voidable = false;
            }
            this.isBound = true;
            binding.element = (Element)this.dispatch(binding.element);
            return binding;
        }

        public Element visit(NonTerminal nonTerminal) {
            if (this.secondPhase && this.isBound) {
                FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
                if (this.analyzer.current() != fullProduction) {
                    this.analyzer.unmark(fullProduction.qName);
                }
            }
            this.isBound = false;
            return nonTerminal;
        }

        public Element visit(Action action) {
            this.isBound = false;
            this.voidable = false;
            return action;
        }

        public Element visit(ParserAction parserAction) {
            this.isBound = false;
            this.voidable = false;
            return parserAction;
        }
    }
}

