/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.Iterator;
import java.util.List;
import xtc.parser.ActionBaseValue;
import xtc.parser.Analyzer;
import xtc.parser.AnyChar;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.FollowedBy;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericValue;
import xtc.parser.MetaData;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.NotFollowedBy;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.Rats;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.Terminal;
import xtc.parser.Type;
import xtc.parser.VoidedElement;
import xtc.tree.Visitor;

public class MetaDataSetter
extends Visitor {
    protected final Analyzer analyzer;
    protected boolean usesActions;
    protected boolean usesGNodes;
    protected boolean requiresChar;
    protected boolean requiresIndex;
    protected boolean requiresResult;
    protected boolean requiresPredIndex;
    protected boolean requiresPredResult;
    protected boolean requiresPredMatch;
    protected boolean requiresBaseIndex;
    protected List repetitions;
    protected List boundRepetitions;
    protected List options;
    protected boolean isTopLevel;
    protected boolean firstElement;
    protected boolean isBound;
    protected boolean predicate;
    protected boolean notFollowedBy;
    protected int repetitionLevel;
    protected int optionLevel;

    public MetaDataSetter(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        this.usesActions = false;
        this.usesGNodes = false;
        Iterator iterator = module.productions.iterator();
        while (iterator.hasNext()) {
            this.dispatch((Production)iterator.next());
        }
        if (this.usesActions) {
            module.setProperty("xtc.parser.DirectLeftRecurser.Recursive", Boolean.TRUE);
        }
        if (this.usesGNodes) {
            module.setProperty("xtc.parser.Generifier.Generic", Boolean.TRUE);
        }
    }

    public void visit(Production production) {
        MetaData metaData = (MetaData)production.getProperty("xtc.parser.MetaData");
        this.requiresChar = false;
        this.requiresIndex = false;
        this.requiresResult = false;
        this.requiresPredIndex = false;
        this.requiresPredResult = false;
        this.requiresPredMatch = false;
        this.requiresBaseIndex = false;
        this.repetitions = metaData.repetitions;
        this.boundRepetitions = metaData.boundRepetitions;
        this.options = metaData.options;
        this.isTopLevel = true;
        this.firstElement = false;
        this.isBound = false;
        this.predicate = false;
        this.notFollowedBy = false;
        this.repetitionLevel = 0;
        this.optionLevel = 0;
        this.dispatch(production.element);
        metaData.requiresChar = this.requiresChar;
        metaData.requiresIndex = this.requiresIndex;
        metaData.requiresResult = this.requiresResult;
        metaData.requiresPredIndex = this.requiresPredIndex;
        metaData.requiresPredResult = this.requiresPredResult;
        metaData.requiresPredMatch = this.requiresPredMatch;
        metaData.requiresBaseIndex = this.requiresBaseIndex;
    }

    public void visit(OrderedChoice orderedChoice) {
        boolean bl = this.isTopLevel;
        this.isTopLevel = false;
        Iterator iterator = orderedChoice.alternatives.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                this.firstElement = true;
            }
            this.dispatch((Sequence)iterator.next());
        }
    }

    public void visit(Repetition repetition) {
        this.isTopLevel = false;
        this.firstElement = false;
        boolean bl = this.isBound;
        this.isBound = false;
        ++this.repetitionLevel;
        if (this.repetitions.size() < this.repetitionLevel) {
            this.repetitions.add(Boolean.FALSE);
            this.boundRepetitions.add(Boolean.FALSE);
        }
        if (repetition.once) {
            this.repetitions.set(this.repetitionLevel - 1, Boolean.TRUE);
        }
        if (bl) {
            this.boundRepetitions.set(this.repetitionLevel - 1, Boolean.TRUE);
        }
        this.dispatch(repetition.element);
        --this.repetitionLevel;
    }

    public void visit(Option option) {
        this.isTopLevel = false;
        this.firstElement = false;
        boolean bl = this.isBound;
        this.isBound = false;
        ++this.optionLevel;
        if (this.options.size() < this.optionLevel) {
            this.options.add(null);
        }
        if (bl) {
            Binding binding = this.analyzer.getBinding((Sequence)option.element);
            String string = null == binding ? Type.rootT() : Type.type(binding.element, this.analyzer);
            String string2 = Type.unify(string, (String)this.options.get(this.optionLevel - 1));
            this.options.set(this.optionLevel - 1, string2);
        }
        this.dispatch(option.element);
        --this.optionLevel;
    }

    public void visit(Sequence sequence) {
        this.isTopLevel = false;
        this.isBound = false;
        Iterator iterator = sequence.iterator();
        while (iterator.hasNext()) {
            this.dispatch((Element)iterator.next());
        }
    }

    public void visit(FollowedBy followedBy) {
        this.isTopLevel = false;
        this.isBound = false;
        boolean bl = this.firstElement;
        this.predicate = true;
        this.notFollowedBy = false;
        this.dispatch(followedBy.element);
        this.predicate = false;
        this.firstElement = bl;
    }

    protected boolean notFollowedBy() {
        return this.predicate && this.notFollowedBy;
    }

    public void visit(NotFollowedBy notFollowedBy) {
        this.isTopLevel = false;
        this.isBound = false;
        this.requiresPredMatch = true;
        boolean bl = this.firstElement;
        this.predicate = true;
        this.notFollowedBy = true;
        this.dispatch(notFollowedBy.element);
        this.predicate = false;
        this.firstElement = bl;
    }

    public void visit(SemanticPredicate semanticPredicate) {
        this.isTopLevel = false;
        this.isBound = false;
        this.dispatch(semanticPredicate.element);
    }

    public void visit(VoidedElement voidedElement) {
        this.isTopLevel = false;
        this.isBound = false;
        this.dispatch(voidedElement.element);
    }

    public void visit(Binding binding) {
        this.isTopLevel = false;
        this.isBound = true;
        this.dispatch(binding.element);
    }

    public void visit(StringMatch stringMatch) {
        this.isTopLevel = false;
        this.isBound = false;
        if (!(this.notFollowedBy() || Rats.optimizeErrors1 && this.firstElement)) {
            this.requiresBaseIndex = true;
        }
        this.firstElement = false;
        this.dispatch(stringMatch.element);
    }

    public void visit(NonTerminal nonTerminal) {
        this.isTopLevel = false;
        this.firstElement = false;
        this.isBound = false;
        if (this.predicate) {
            this.requiresPredResult = true;
        } else {
            this.requiresResult = true;
        }
    }

    public void visit(AnyChar anyChar) {
        this.isTopLevel = false;
        this.firstElement = false;
        this.isBound = false;
        this.requiresChar = true;
        if (this.predicate) {
            this.requiresPredIndex = true;
        } else {
            this.requiresIndex = true;
        }
    }

    public void visit(StringLiteral stringLiteral) {
        this.isTopLevel = false;
        this.isBound = false;
        if (!(this.notFollowedBy() || Rats.optimizeErrors1 && this.firstElement)) {
            this.requiresBaseIndex = true;
        }
        this.firstElement = false;
        this.requiresChar = true;
        if (this.predicate) {
            this.requiresPredIndex = true;
        } else {
            this.requiresIndex = true;
        }
    }

    public void visit(CharCase charCase) {
        if (null != charCase.element) {
            this.dispatch(charCase.element);
        }
    }

    public void visit(CharSwitch charSwitch) {
        this.isTopLevel = false;
        this.firstElement = false;
        this.isBound = false;
        this.requiresChar = true;
        if (this.predicate) {
            this.requiresPredIndex = true;
        } else {
            this.requiresIndex = true;
        }
        Iterator iterator = charSwitch.cases.iterator();
        while (iterator.hasNext()) {
            this.dispatch((CharCase)iterator.next());
        }
        this.dispatch(charSwitch.base);
    }

    public void visit(Terminal terminal) {
        this.isTopLevel = false;
        this.firstElement = false;
        this.isBound = false;
        this.requiresChar = true;
        if (this.predicate) {
            this.requiresPredIndex = true;
        } else {
            this.requiresIndex = true;
        }
    }

    public void visit(ParserAction parserAction) {
        this.isTopLevel = false;
        this.firstElement = false;
        this.isBound = false;
        this.requiresBaseIndex = true;
    }

    public void visit(ActionBaseValue actionBaseValue) {
        this.isTopLevel = false;
        this.isBound = false;
        this.usesActions = true;
    }

    public void visit(GenericValue genericValue) {
        this.isTopLevel = false;
        this.isBound = false;
        this.usesGNodes = true;
    }

    public void visit(GenericActionValue genericActionValue) {
        this.isTopLevel = false;
        this.isBound = false;
        this.usesActions = true;
        this.usesGNodes = true;
    }

    public void visit(Element element) {
        this.isTopLevel = false;
        this.isBound = false;
    }
}

