/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.Iterator;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CostEstimator;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Generifier;
import xtc.parser.GrammarVisitor;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.Production;
import xtc.parser.Rats;
import xtc.parser.TextTester;
import xtc.parser.Type;
import xtc.tree.Visitor;

public class Inliner
extends GrammarVisitor {
    public static final int MAX_COST = 1;
    public static final boolean INLINE_PERSISTENT = true;
    protected boolean attributeState;
    protected boolean inlined;

    public Inliner(Analyzer analyzer) {
        super(analyzer);
    }

    protected boolean isBasic(Production production) {
        return Type.isVoidT(production.type) || TextTester.isTextOnly(production);
    }

    protected void inlined(Production production) {
        this.inlined = true;
        if (Rats.optionVerbose) {
            System.err.println("[Inlining " + production.qName + " into " + this.analyzer.current().qName + "]");
        }
    }

    public Object visit(Module module) {
        Visitor visitor = null;
        boolean bl = false;
        if (Rats.optimizeCost) {
            visitor = new CostEstimator(this.analyzer);
        }
        do {
            if (Rats.optimizeCost) {
                visitor.dispatch(module);
            }
            this.analyzer.register(this);
            this.analyzer.init(module);
            this.attributeState = module.hasAttribute(Constants.ATT_STATEFUL.name);
            this.inlined = false;
            Iterator iterator = module.productions.iterator();
            while (iterator.hasNext()) {
                this.analyzer.process((Production)iterator.next());
            }
            if (!this.inlined) continue;
            bl = true;
        } while (this.inlined);
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Element visit(NonTerminal nonTerminal) {
        boolean bl = this.isBound;
        this.isBound = false;
        FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
        if (Generifier.isGeneric(fullProduction) || this.attributeState && (fullProduction.hasAttribute(Constants.ATT_STATEFUL) || fullProduction.hasAttribute(Constants.ATT_RESETTING))) {
            return nonTerminal;
        }
        Element element = Analyzer.strip(fullProduction.element);
        if (element instanceof NonTerminal) {
            if (fullProduction.hasAttribute(Constants.ATT_TRANSIENT)) {
                this.inlined(fullProduction);
                return element;
            }
            return nonTerminal;
        }
        if (element instanceof Binding) {
            Binding binding = (Binding)element;
            Element element2 = Analyzer.strip(binding.element);
            if ("yyValue".equals(binding.name) && element2 instanceof NonTerminal) {
                if (fullProduction.hasAttribute(Constants.ATT_TRANSIENT)) {
                    this.inlined(fullProduction);
                    return element2;
                }
                return nonTerminal;
            }
        }
        if (!this.isBasic(this.analyzer.current()) || bl) {
            return nonTerminal;
        }
        if (Rats.optimizeCost && 1 >= CostEstimator.cost(fullProduction)) {
            this.inlined(fullProduction);
            return this.analyzer.copy(fullProduction.element);
        }
        return nonTerminal;
    }
}

