/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.Iterator;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GrammarVisitor;
import xtc.parser.MetaData;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.NullValue;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Rats;
import xtc.parser.Sequence;
import xtc.parser.TextTester;
import xtc.parser.TextValue;
import xtc.parser.Type;
import xtc.parser.ValueElement;

public class ChoiceExpander
extends GrammarVisitor {
    public static final int MODE_INLINE = 1;
    public static final int MODE_RM_VALUES = 2;
    public static final int MODE_VOID_VALUES = 3;
    public static final int MODE_TEXT_VALUES = 4;
    protected boolean hasState;
    protected int mode;

    public ChoiceExpander(Analyzer analyzer) {
        super(analyzer);
    }

    protected NonTerminal candidate(Element element, boolean bl) {
        Element element2 = Analyzer.strip(element);
        if (element2 instanceof Binding) {
            Binding binding = (Binding)element2;
            if (bl && "yyValue".equals(binding.name) && binding.element instanceof NonTerminal) {
                return (NonTerminal)binding.element;
            }
        } else if (Type.isVoidT(this.analyzer.current().type) || TextTester.isTextOnly(this.analyzer.current())) {
            Sequence sequence;
            if (element2 instanceof NonTerminal) {
                return (NonTerminal)element2;
            }
            if (element2 instanceof Sequence && 2 == (sequence = (Sequence)element2).length() && sequence.get(0) instanceof NonTerminal && sequence.get(1) instanceof ValueElement) {
                return (NonTerminal)sequence.get(0);
            }
        }
        return null;
    }

    protected void inlined(Production production) {
        if (Rats.optionVerbose) {
            System.err.println("[Inlining " + production.qName + " into " + this.analyzer.current().qName + "]");
        }
    }

    public Object visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        this.hasState = module.hasAttribute(Constants.ATT_STATEFUL.name);
        Iterator iterator = module.productions.iterator();
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            this.mode = 1;
            if (!Rats.optimizeChoices2 && !Type.isVoidT(production.type) && !TextTester.isTextOnly(production)) continue;
            this.analyzer.process(production);
        }
        return null;
    }

    public Element visit(OrderedChoice orderedChoice) {
        boolean bl = this.isTopLevel;
        this.isTopLevel = false;
        boolean bl2 = this.isLastElement;
        this.isLastElement = false;
        for (int i = 0; i < orderedChoice.alternatives.size(); ++i) {
            NonTerminal nonTerminal;
            Element element = (Element)orderedChoice.alternatives.get(i);
            if (1 == this.mode && null != (nonTerminal = this.candidate(element, bl))) {
                FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
                MetaData metaData = MetaData.get(fullProduction);
                if (fullProduction.hasAttribute(Constants.ATT_TRANSIENT) && 0 == metaData.selfCount && (!this.hasState || !fullProduction.hasAttribute(Constants.ATT_STATEFUL) && !fullProduction.hasAttribute(Constants.ATT_RESETTING)) && (Rats.optimizeChoices2 || Type.isVoidT(fullProduction.type) || TextTester.isTextOnly(fullProduction))) {
                    OrderedChoice orderedChoice2 = (OrderedChoice)this.analyzer.copy(fullProduction.element);
                    if (!bl && !bl2) {
                        this.mode = 2;
                        orderedChoice2 = (OrderedChoice)this.dispatch(orderedChoice2);
                        this.mode = 1;
                    } else if (Type.isVoidT(this.analyzer.current().type)) {
                        this.mode = 3;
                        orderedChoice2 = (OrderedChoice)this.dispatch(orderedChoice2);
                        this.mode = 1;
                    } else if (TextTester.isTextOnly(this.analyzer.current()) && !bl) {
                        this.mode = 4;
                        orderedChoice2 = (OrderedChoice)this.dispatch(orderedChoice2);
                        this.mode = 1;
                    }
                    orderedChoice.alternatives.remove(i);
                    orderedChoice.alternatives.addAll(i, orderedChoice2.alternatives);
                    this.inlined(fullProduction);
                    --i;
                    continue;
                }
            }
            if (bl || bl2) {
                this.isLastElement = true;
            }
            orderedChoice.alternatives.set(i, this.dispatch(element));
        }
        return orderedChoice;
    }

    public Element visit(Sequence sequence) {
        this.isTopLevel = false;
        boolean bl = this.isLastElement;
        int n = sequence.length();
        if (2 == this.mode && sequence.get(n - 1) instanceof ValueElement) {
            sequence.elements.remove(n - 1);
            --n;
        }
        for (int i = 0; i < n; ++i) {
            this.isLastElement = bl && i == n - 1;
            sequence.elements.set(i, this.dispatch(sequence.get(i)));
        }
        this.isLastElement = false;
        return sequence;
    }

    public Element visit(ValueElement valueElement) {
        this.isTopLevel = false;
        this.isLastElement = false;
        if (3 == this.mode) {
            return NullValue.VALUE;
        }
        if (4 == this.mode) {
            return TextValue.VALUE;
        }
        return valueElement;
    }
}

