/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import xtc.tree.Location;

public final class Utilities {
    private static final int BUFFER_SIZE = 4096;
    private static char[] charBuffer = null;
    public static final Pattern SPLIT = Pattern.compile("\r\n|\r|\n");
    public static final int ESCAPE_DOUBLE = 1;
    public static final int ESCAPE_REGEX = 2;
    public static final int ESCAPE_UNICODE = 4;
    public static final int C_ESCAPES = 0;
    public static final int JAVA_ESCAPES = 4;
    public static final int FULL_ESCAPES = 6;

    private Utilities() {
    }

    public static void pump(Reader reader, Writer writer) throws IOException {
        if (null == charBuffer) {
            charBuffer = new char[4096];
        }
        int n = reader.read(charBuffer);
        while (-1 != n) {
            writer.write(charBuffer, 0, n);
            n = reader.read(charBuffer);
        }
    }

    public static boolean useDoubleEscapes(int n) {
        return 0 != (1 & n);
    }

    public static boolean useRegexEscapes(int n) {
        return 0 != (2 & n);
    }

    public static boolean useUnicodeEscapes(int n) {
        return 0 != (4 & n);
    }

    public static void escape(char c, StringBuffer stringBuffer, int n) {
        boolean bl = Utilities.useDoubleEscapes(n);
        boolean bl2 = Utilities.useRegexEscapes(n);
        boolean bl3 = Utilities.useUnicodeEscapes(n);
        switch (c) {
            case '\b': {
                if (bl) {
                    stringBuffer.append("\\\\b");
                    break;
                }
                stringBuffer.append("\\b");
                break;
            }
            case '\t': {
                if (bl) {
                    stringBuffer.append("\\\\t");
                    break;
                }
                stringBuffer.append("\\t");
                break;
            }
            case '\n': {
                if (bl) {
                    stringBuffer.append("\\\\n");
                    break;
                }
                stringBuffer.append("\\n");
                break;
            }
            case '\f': {
                if (bl) {
                    stringBuffer.append("\\\\f");
                    break;
                }
                stringBuffer.append("\\f");
                break;
            }
            case '\r': {
                if (bl) {
                    stringBuffer.append("\\\\r");
                    break;
                }
                stringBuffer.append("\\r");
                break;
            }
            case '\"': {
                if (bl) {
                    stringBuffer.append("\\\\\\\"");
                    break;
                }
                stringBuffer.append("\\\"");
                break;
            }
            case '\'': {
                if (bl) {
                    stringBuffer.append("\\\\\\'");
                    break;
                }
                stringBuffer.append("\\'");
                break;
            }
            case '-': {
                if (bl2) {
                    if (bl) {
                        stringBuffer.append("\\\\-");
                        break;
                    }
                    stringBuffer.append("\\-");
                    break;
                }
                stringBuffer.append('-');
                break;
            }
            case '[': {
                if (bl2) {
                    if (bl) {
                        stringBuffer.append("\\\\[");
                        break;
                    }
                    stringBuffer.append("\\[");
                    break;
                }
                stringBuffer.append('[');
                break;
            }
            case '\\': {
                if (bl) {
                    stringBuffer.append("\\\\\\\\");
                    break;
                }
                stringBuffer.append("\\\\");
                break;
            }
            case ']': {
                if (bl2) {
                    if (bl) {
                        stringBuffer.append("\\\\]");
                        break;
                    }
                    stringBuffer.append("\\]");
                    break;
                }
                stringBuffer.append(']');
                break;
            }
            default: {
                if (bl3 && (' ' > c || '~' < c)) {
                    String string;
                    String string2 = Integer.toHexString(c);
                    switch (string2.length()) {
                        case 1: {
                            string = "000";
                            break;
                        }
                        case 2: {
                            string = "00";
                            break;
                        }
                        case 3: {
                            string = "0";
                            break;
                        }
                        default: {
                            string = "";
                        }
                    }
                    if (bl) {
                        stringBuffer.append("\\\\");
                    } else {
                        stringBuffer.append("\\");
                    }
                    stringBuffer.append('u');
                    stringBuffer.append(string);
                    stringBuffer.append(string2);
                    break;
                }
                stringBuffer.append(c);
            }
        }
    }

    public static void escape(String string, StringBuffer stringBuffer, int n) {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            Utilities.escape(string.charAt(i), stringBuffer, n);
        }
    }

    public static String escape(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer(1);
        Utilities.escape(c, stringBuffer, n);
        return stringBuffer.toString();
    }

    public static String escape(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        Utilities.escape(string, stringBuffer, n);
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        if (-1 == string.indexOf(92)) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block16: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ('\\' != c) {
                stringBuffer.append(c);
                continue;
            }
            c = string.charAt(++i);
            switch (c) {
                case 'b': {
                    stringBuffer.append('\b');
                    continue block16;
                }
                case 't': {
                    stringBuffer.append('\t');
                    continue block16;
                }
                case 'n': {
                    stringBuffer.append('\n');
                    continue block16;
                }
                case 'f': {
                    stringBuffer.append('\f');
                    continue block16;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    continue block16;
                }
                case '\"': {
                    stringBuffer.append('\"');
                    continue block16;
                }
                case '\'': {
                    stringBuffer.append('\'');
                    continue block16;
                }
                case '-': {
                    stringBuffer.append('-');
                    continue block16;
                }
                case '[': {
                    stringBuffer.append('[');
                    continue block16;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    continue block16;
                }
                case ']': {
                    stringBuffer.append(']');
                    continue block16;
                }
                case 'u': {
                    int n2;
                    i += 4;
                    try {
                        n2 = Integer.parseInt(string.substring(i - 3, i + 1), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Illegal Unicode escape ('\\u" + string.substring(i - 3, i + 1) + "')");
                    }
                    stringBuffer.append((char)n2);
                    continue block16;
                }
                default: {
                    throw new IllegalArgumentException("Illegal escaped character ('\\" + c + "')");
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String format(List list) {
        int n = list.size();
        if (0 == n) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (2 == n) {
            stringBuffer.append(list.get(0));
            stringBuffer.append(" and ");
            stringBuffer.append(list.get(1));
        } else {
            boolean bl = true;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (bl) {
                    bl = false;
                } else if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                } else {
                    stringBuffer.append(", and ");
                }
                stringBuffer.append(e);
            }
        }
        return stringBuffer.toString();
    }

    public static String toDescription(String string) {
        int n = string.indexOf(36);
        if (-1 != n) {
            string = string.substring(0, n);
        }
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            ++n3;
        }
        if (0 == n3 || n2 == n3) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2 + n3);
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                if (0 != i) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(Character.toLowerCase(c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static void msg(String string, Location location, String[] stringArray) {
        Utilities.msg(string, location, null, stringArray);
    }

    public static void msg(String string, Location location, String string2, String[] stringArray) {
        if (null != location) {
            System.err.print(location.toString());
            System.err.print(": ");
        } else if (null != string2) {
            System.err.print(string2);
            System.err.print(": ");
        }
        System.err.println(string);
        if (null != location && null != stringArray) {
            String string3;
            try {
                string3 = stringArray[location.line - 1];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string3 = "";
            }
            System.err.println(string3);
            for (int i = 0; i < location.column; ++i) {
                System.err.print(' ');
            }
            System.err.println('^');
        }
    }
}

