/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Utility;
import xtc.util.Utilities;

public class Printer
extends Utility {
    public static final int SEPARATOR_LENGTH = System.getProperty("line.separator").length();
    protected PrintWriter out;
    protected int indent = 0;
    protected int printed = 0;

    public Printer(OutputStream outputStream) {
        this(new PrintWriter(outputStream, true));
    }

    public Printer(Writer writer) {
        this(new PrintWriter(writer, true));
    }

    public Printer(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public Printer incr() {
        this.indent += 2;
        return this;
    }

    public Printer decr() {
        this.indent -= 2;
        return this;
    }

    public Printer indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.out.print(' ');
        }
        this.printed = this.indent;
        return this;
    }

    public Printer indentLess() {
        int n = this.indent - 2;
        if (0 > n) {
            n = 0;
        }
        for (int i = 0; i < n; ++i) {
            this.out.print(' ');
        }
        this.printed = n;
        return this;
    }

    public Printer p(char c) {
        this.out.print(c);
        this.printed = 1;
        return this;
    }

    public Printer p(int n) {
        return this.p(Integer.toString(n));
    }

    public Printer p(String string) {
        this.out.print(string);
        this.printed = string.length();
        return this;
    }

    public Printer pln(char c) {
        this.out.println(c);
        this.printed = 1 + SEPARATOR_LENGTH;
        return this;
    }

    public Printer pln(int n) {
        return this.pln(Integer.toString(n));
    }

    public Printer pln(String string) {
        this.out.println(string);
        this.printed = string.length() + SEPARATOR_LENGTH;
        return this;
    }

    public Printer pln() {
        this.out.println();
        this.printed = SEPARATOR_LENGTH;
        return this;
    }

    public Printer align(int n, int n2) {
        int n3 = n2 - n;
        if (0 >= n3) {
            n3 = 1;
        }
        for (int i = 0; i < n3; ++i) {
            this.out.write(32);
        }
        n = n3;
        return this;
    }

    public Printer align(int n) {
        return this.align(this.printed, n);
    }

    public Printer escape(char c, int n) {
        return this.p(Utilities.escape(c, n));
    }

    public Printer escape(String string, int n) {
        return this.p(Utilities.escape(string, n));
    }

    public Printer sep() {
        this.indent().p("// ");
        int n = 80 - this.indent - 3 - 3;
        for (int i = 0; i < n; ++i) {
            this.out.print('=');
        }
        this.out.println();
        this.printed = 77 + SEPARATOR_LENGTH;
        return this;
    }

    public Printer p(Node node) {
        if (null != node) {
            node.accept(this.visitor);
        }
        return this;
    }

    public Printer p(Collection collection) {
        if (null != collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.p((Node)iterator.next());
            }
        }
        return this;
    }

    public Printer p(Collection collection, String string, String string2) {
        if (null != collection) {
            boolean bl = true;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    this.p(string);
                    bl = false;
                } else {
                    this.p(string2);
                }
                this.p((Node)iterator.next());
            }
        }
        return this;
    }

    public Printer p(GNode gNode) {
        if (null != gNode) {
            if (null == this.visitor) {
                gNode.print(this);
            } else {
                gNode.accept(this.visitor);
            }
        }
        return this;
    }

    public Printer loc(Node node) {
        if (null == node.location) {
            return this;
        }
        return this.p(node.location.file).p(':').p(node.location.line).p(',').p(node.location.column);
    }

    public Printer flush() {
        this.out.flush();
        return this;
    }
}

