/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.HashSet;
import java.util.Set;
import xtc.parser.Analyzer;
import xtc.parser.CharTerminal;
import xtc.parser.Element;
import xtc.parser.NonTerminal;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;

public class Type {
    private static Set PRIMITIVE = new HashSet();
    private static Set NOT_A_NODE;

    private Type() {
    }

    public static String voidT() {
        return "void";
    }

    public static boolean isVoidT(String string) {
        return Type.voidT().equals(string);
    }

    public static String booleanT() {
        return "boolean";
    }

    public static String charT() {
        return "char";
    }

    public static String rootT() {
        return "Object";
    }

    public static String voidRefT() {
        return "Void";
    }

    public static String charRefT() {
        return "Character";
    }

    public static String stringT() {
        return "String";
    }

    public static boolean isStringT(String string) {
        return Type.stringT().equals(string);
    }

    public static String listT() {
        return "Pair";
    }

    public static String genericT() {
        return "GNode";
    }

    public static boolean isPrimitive(String string) {
        return PRIMITIVE.contains(string);
    }

    public static boolean isNotANode(String string) {
        return string.startsWith("java.") || string.startsWith("javax.") || NOT_A_NODE.contains(string);
    }

    public static String type(Element element, Analyzer analyzer) {
        if (element instanceof OrderedChoice || element instanceof Repetition || element instanceof Option || element instanceof Sequence) {
            return Type.rootT();
        }
        if (element instanceof NonTerminal) {
            return analyzer.lookup((NonTerminal)((NonTerminal)element)).type;
        }
        if (element instanceof StringLiteral) {
            return Type.stringT();
        }
        if (element instanceof CharTerminal) {
            return Type.charRefT();
        }
        if (element instanceof StringMatch) {
            return Type.stringT();
        }
        throw new IllegalArgumentException(element.toString() + " cannot be typed");
    }

    public static String unify(String string, String string2) {
        if (string.equals(string2)) {
            return string;
        }
        return Type.rootT();
    }

    static {
        PRIMITIVE.add("byte");
        PRIMITIVE.add("short");
        PRIMITIVE.add("int");
        PRIMITIVE.add("long");
        PRIMITIVE.add("float");
        PRIMITIVE.add("double");
        PRIMITIVE.add("char");
        PRIMITIVE.add("boolean");
        NOT_A_NODE = new HashSet();
        NOT_A_NODE.add("void");
        NOT_A_NODE.add("Boolean");
        NOT_A_NODE.add("Byte");
        NOT_A_NODE.add("Character");
        NOT_A_NODE.add("Class");
        NOT_A_NODE.add("Double");
        NOT_A_NODE.add("Float");
        NOT_A_NODE.add("Integer");
        NOT_A_NODE.add("Long");
        NOT_A_NODE.add("Number");
        NOT_A_NODE.add("Short");
        NOT_A_NODE.add("String");
        NOT_A_NODE.add("StringBuffer");
        NOT_A_NODE.add("Pair");
        NOT_A_NODE.add("xtc.util.Pair");
    }
}

