/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.Iterator;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.Grammar;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Rats;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.Terminal;
import xtc.parser.Type;
import xtc.parser.UnaryOperator;
import xtc.tree.Visitor;

public class TextTester
extends Visitor {
    public static final String TEXT_ONLY = "xtc.parser.TextTester.TextOnly";
    protected final Analyzer analyzer;
    protected boolean isTextOnly;

    public TextTester(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void visit(Grammar grammar) {
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        Iterator iterator = grammar.productions.iterator();
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            if (this.analyzer.isProcessed(production.nonTerminal)) continue;
            if (!Type.isStringT(production.type)) {
                this.analyzer.processed(production.nonTerminal);
                continue;
            }
            this.isTextOnly = true;
            this.analyzer.process(production);
            if (this.isTextOnly) {
                Iterator iterator2 = this.analyzer.working().iterator();
                while (iterator2.hasNext()) {
                    Production production2 = this.analyzer.lookup((NonTerminal)iterator2.next());
                    TextTester.markTextOnly(production2);
                    this.analyzer.processed(production2.nonTerminal);
                }
                continue;
            }
            this.analyzer.processed(production.nonTerminal);
        }
    }

    public void visit(Production production) {
        this.analyzer.workingOn(production.nonTerminal);
        production.element.accept(this);
    }

    public void visit(OrderedChoice orderedChoice) {
        Iterator iterator = orderedChoice.options.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).accept(this);
            if (this.isTextOnly) continue;
            return;
        }
    }

    public void visit(Sequence sequence) {
        Iterator iterator = sequence.elements.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).accept(this);
            if (this.isTextOnly) continue;
            return;
        }
    }

    public void visit(SemanticPredicate semanticPredicate) {
    }

    public void visit(Binding binding) {
        if ("yyValue".equals(binding.name)) {
            this.isTextOnly = false;
        } else {
            binding.element.accept(this);
        }
    }

    public void visit(NonTerminal nonTerminal) {
        if (this.analyzer.isProcessed(nonTerminal)) {
            if (!TextTester.isTextOnly(this.analyzer.lookup(nonTerminal))) {
                this.isTextOnly = false;
            }
        } else if (!this.analyzer.isBeingWorkedOn(nonTerminal)) {
            Production production = this.analyzer.lookup(nonTerminal);
            if (Type.isStringT(production.type)) {
                production.accept(this);
            } else {
                this.isTextOnly = false;
            }
        }
    }

    public void visit(CharCase charCase) {
        if (null != charCase.element) {
            charCase.element.accept(this);
        }
    }

    public void visit(CharSwitch charSwitch) {
        Iterator iterator = charSwitch.cases.iterator();
        while (iterator.hasNext()) {
            ((CharCase)iterator.next()).accept(this);
            if (this.isTextOnly) continue;
            return;
        }
        if (null != charSwitch.base) {
            charSwitch.base.accept(this);
        }
    }

    public void visit(Terminal terminal) {
    }

    public void visit(UnaryOperator unaryOperator) {
        unaryOperator.element.accept(this);
    }

    public void visit(Element element) {
        this.isTextOnly = false;
    }

    public static void markTextOnly(Production production) {
        if (Rats.optionVerbose) {
            System.out.println("[Recognizing as text-only production " + production.nonTerminal.name + "]");
        }
        production.setProperty(TEXT_ONLY, Boolean.TRUE);
    }

    public static boolean isTextOnly(Production production) {
        return production.getBooleanProperty(TEXT_ONLY);
    }
}

