/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.IOException;
import java.io.Reader;
import xtc.parser.ParseError;
import xtc.parser.Result;
import xtc.parser.SemanticValue;
import xtc.tree.Location;

public abstract class PackratParser
extends Result {
    public static final PackratParser DUMMY = new PackratParser(){

        public PackratParser next() {
            throw new IllegalStateException("Dummy packrat parser");
        }
    };
    protected final Reader yyReader;
    protected final int yyCount;
    protected String yyFile;
    protected boolean yySeenCR;
    protected int yyLine;
    protected int yyColumn;
    private int yyChar;

    private PackratParser() {
        this.yyReader = null;
        this.yyCount = -1;
        this.yyFile = "*** Not a file! ***";
        this.yySeenCR = false;
        this.yyLine = -1;
        this.yyColumn = -1;
        this.yyChar = -2;
    }

    public PackratParser(Reader reader, String string) {
        this.yyReader = reader;
        this.yyCount = 0;
        this.yyFile = string;
        this.yySeenCR = false;
        this.yyLine = 1;
        this.yyColumn = 0;
        this.yyChar = -2;
    }

    protected PackratParser(PackratParser packratParser) {
        this.yyReader = packratParser.yyReader;
        this.yyCount = packratParser.yyCount + 1;
        this.yyChar = -2;
    }

    protected abstract PackratParser next();

    private void updateLocation(PackratParser packratParser) {
        this.yyFile = packratParser.yyFile;
        switch (packratParser.yyChar) {
            case 9: {
                this.yySeenCR = false;
                this.yyLine = packratParser.yyLine;
                this.yyColumn = (packratParser.yyColumn >> 3) + 1 << 3;
                return;
            }
            case 10: {
                this.yySeenCR = false;
                if (packratParser.yySeenCR) {
                    this.yyLine = packratParser.yyLine;
                    this.yyColumn = packratParser.yyColumn;
                } else {
                    this.yyLine = packratParser.yyLine + 1;
                    this.yyColumn = 0;
                }
                return;
            }
            case 13: {
                this.yySeenCR = true;
                this.yyLine = packratParser.yyLine + 1;
                this.yyColumn = 0;
                return;
            }
        }
        this.yySeenCR = false;
        this.yyLine = packratParser.yyLine;
        this.yyColumn = packratParser.yyColumn + 1;
    }

    protected final Result character() throws IOException {
        switch (this.yyChar) {
            case -2: {
                this.yyChar = this.yyReader.read();
                if (0 <= this.yyChar) {
                    this.parser = this.next();
                    this.parser.updateLocation(this);
                    return this;
                }
            }
            case -1: {
                return new ParseError("End-of-file", this);
            }
        }
        return this;
    }

    public boolean hasValue() {
        return 0 <= this.yyChar;
    }

    public char charValue() {
        if (0 <= this.yyChar) {
            return (char)this.yyChar;
        }
        throw new IllegalStateException("No character value available");
    }

    public Object semanticValue() {
        throw new IllegalStateException("No semantic value available");
    }

    public ParseError parseError() {
        return ParseError.DUMMY;
    }

    public SemanticValue createValue(Object object, ParseError parseError) {
        return new SemanticValue(object, this.parser, parseError);
    }

    protected final String getDifference(PackratParser packratParser) {
        int n;
        PackratParser packratParser2;
        if (this.yyCount < packratParser.yyCount) {
            packratParser2 = this;
            n = packratParser.yyCount - this.yyCount;
        } else if (this.yyCount > packratParser.yyCount) {
            packratParser2 = packratParser;
            n = this.yyCount - packratParser.yyCount;
        } else {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        do {
            stringBuffer.append((char)packratParser2.yyChar);
            packratParser2 = packratParser2.parser;
        } while (++n2 < n);
        return stringBuffer.toString();
    }

    public final String file() {
        return this.yyFile;
    }

    public final int line() {
        return this.yyLine;
    }

    public final int column() {
        return this.yyColumn;
    }

    public final Location location() {
        return new Location(this.yyFile, this.yyLine, this.yyColumn);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.yyFile);
        stringBuffer.append(':');
        stringBuffer.append(Integer.toString(this.yyLine));
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(this.yyColumn));
        stringBuffer.append(": ");
        PackratParser packratParser = this;
        int n = 0;
        while (0 <= packratParser.yyChar) {
            stringBuffer.append((char)packratParser.yyChar);
            packratParser = packratParser.parser;
            if (20 <= ++n && 0 <= packratParser.yyChar) {
                stringBuffer.append(" ...");
            }
            if (n < 20) continue;
        }
        return stringBuffer.toString();
    }
}

