/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.Element;
import xtc.parser.GenericValue;
import xtc.parser.Grammar;
import xtc.parser.NonTerminal;
import xtc.parser.NullValue;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.Type;
import xtc.tree.Visitor;

public class Generifier
extends Visitor {
    public static final String GENERIC = "xtc.parser.Generifier.Generic";
    protected final Analyzer analyzer;
    protected boolean seenChoice;
    protected List children;

    public Generifier(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.children = new ArrayList();
    }

    protected Binding bind(Element element) {
        Binding binding = new Binding(this.analyzer.variable(), element);
        this.children.add(binding.name);
        return binding;
    }

    public void visit(Grammar grammar) {
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        Iterator iterator = grammar.productions.iterator();
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            if (!Generifier.isGeneric(production)) continue;
            this.analyzer.process(production);
        }
    }

    public void visit(Production production) {
        this.seenChoice = false;
        production.element = (Element)production.element.accept(this);
        production.type = Type.genericT();
        Generifier.markGeneric(production);
    }

    public Element visit(OrderedChoice orderedChoice) {
        int n = orderedChoice.options.size();
        for (int i = 0; i < n; ++i) {
            orderedChoice.options.set(i, ((Element)orderedChoice.options.get(i)).accept(this));
        }
        this.seenChoice = true;
        return orderedChoice;
    }

    public Element visit(Sequence sequence) {
        int n = this.children.size();
        int n2 = sequence.length();
        for (int i = 0; i < n2; ++i) {
            sequence.elements.set(i, sequence.get(i).accept(this));
        }
        if (this.seenChoice) {
            this.seenChoice = false;
        } else if (0 == this.children.size()) {
            sequence.elements.add(NullValue.VALUE);
        } else {
            sequence.elements.add(new GenericValue(new ArrayList(this.children)));
        }
        if (0 == n) {
            this.children.clear();
        } else {
            this.children.subList(n, this.children.size()).clear();
        }
        return sequence;
    }

    public Element visit(Binding binding) {
        this.children.add(binding.name);
        return binding;
    }

    public Element visit(StringMatch stringMatch) {
        return this.bind(stringMatch);
    }

    public Element visit(NonTerminal nonTerminal) {
        Production production = this.analyzer.lookup(nonTerminal);
        if (Type.isVoidT(production.type)) {
            return nonTerminal;
        }
        return this.bind(nonTerminal);
    }

    public Element visit(StringLiteral stringLiteral) {
        return this.bind(stringLiteral);
    }

    public Element visit(Element element) {
        return element;
    }

    public static void markGeneric(Production production) {
        production.setProperty(GENERIC, Boolean.TRUE);
    }

    public static boolean isGeneric(Production production) {
        return "generic".equals(production.type) || production.getBooleanProperty(GENERIC);
    }
}

