/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.HashMap;
import java.util.Map;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.ListValue;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.SingletonListValue;
import xtc.parser.StringMatch;
import xtc.parser.UnaryOperator;
import xtc.tree.Visitor;

public class EquivalenceTester
extends Visitor {
    protected Map nts = new HashMap();
    protected Map vars = new HashMap();
    protected Element e2;

    public boolean areEquivalent(Production production, Production production2) {
        if (production.isTransient != production2.isTransient) {
            return false;
        }
        if (!production.type.equals(production2.type)) {
            return false;
        }
        this.nts.put(production2.nonTerminal, production.nonTerminal);
        boolean bl = this.areEquivalent(production.element, production2.element);
        this.nts.remove(production2.nonTerminal);
        return bl;
    }

    public boolean areEquivalent(Element element, Element element2) {
        if (null == element || null == element2) {
            return element == element2;
        }
        if (!element.getClass().equals(element2.getClass())) {
            return false;
        }
        this.e2 = element2;
        return (Boolean)element.accept(this);
    }

    public Boolean visit(OrderedChoice orderedChoice) {
        OrderedChoice orderedChoice2 = (OrderedChoice)this.e2;
        int n = orderedChoice.options.size();
        if (n != orderedChoice2.options.size()) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < n; ++i) {
            if (this.areEquivalent((Element)orderedChoice.options.get(i), (Element)orderedChoice2.options.get(i))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean visit(Repetition repetition) {
        Repetition repetition2 = (Repetition)this.e2;
        if (repetition.once != repetition2.once) {
            return Boolean.FALSE;
        }
        return EquivalenceTester.box(this.areEquivalent(repetition.element, repetition2.element));
    }

    public Boolean visit(Sequence sequence) {
        Sequence sequence2 = (Sequence)this.e2;
        int n = sequence.elements.size();
        if (n != sequence2.elements.size()) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < n; ++i) {
            if (this.areEquivalent((Element)sequence.elements.get(i), (Element)sequence2.elements.get(i))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean visit(Binding binding) {
        Binding binding2 = (Binding)this.e2;
        if (binding.name.equals(binding2.name)) {
            return EquivalenceTester.box(this.areEquivalent(binding.element, binding2.element));
        }
        String string = (String)this.vars.get(binding2.name);
        if (null == string) {
            this.vars.put(binding2.name, binding.name);
            boolean bl = this.areEquivalent(binding.element, binding2.element);
            this.vars.remove(binding2.name);
            return EquivalenceTester.box(bl);
        }
        if (!binding.name.equals(string)) {
            return Boolean.FALSE;
        }
        return EquivalenceTester.box(this.areEquivalent(binding.element, binding2.element));
    }

    public Boolean visit(StringMatch stringMatch) {
        StringMatch stringMatch2 = (StringMatch)this.e2;
        return EquivalenceTester.box(stringMatch.text.equals(stringMatch2.text) && this.areEquivalent(stringMatch.element, stringMatch2.element));
    }

    public Boolean visit(NonTerminal nonTerminal) {
        NonTerminal nonTerminal2 = (NonTerminal)this.e2;
        return EquivalenceTester.box(nonTerminal.equals(nonTerminal2) || nonTerminal.equals(this.nts.get(nonTerminal2)));
    }

    public Boolean visit(CharSwitch charSwitch) {
        CharSwitch charSwitch2 = (CharSwitch)this.e2;
        int n = charSwitch.cases.size();
        if (n != charSwitch2.cases.size()) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < n; ++i) {
            CharCase charCase = (CharCase)charSwitch.cases.get(i);
            CharCase charCase2 = (CharCase)charSwitch2.cases.get(i);
            if (!this.areEquivalent(charCase.klass, charCase2.klass)) {
                return Boolean.FALSE;
            }
            if (this.areEquivalent(charCase.element, charCase2.element)) continue;
            return Boolean.FALSE;
        }
        if (null == charSwitch.base) {
            return EquivalenceTester.box(null == charSwitch2.base);
        }
        if (null == charSwitch2.base) {
            return Boolean.FALSE;
        }
        return EquivalenceTester.box(this.areEquivalent(charSwitch.base, charSwitch2.base));
    }

    public Boolean visit(SingletonListValue singletonListValue) {
        SingletonListValue singletonListValue2 = (SingletonListValue)this.e2;
        return EquivalenceTester.box(singletonListValue.value.equals(singletonListValue2.value) || singletonListValue.value.equals(this.vars.get(singletonListValue2.value)));
    }

    public Boolean visit(ListValue listValue) {
        ListValue listValue2 = (ListValue)this.e2;
        return EquivalenceTester.box(!(!listValue.list.equals(listValue2.list) && !listValue.list.equals(this.vars.get(listValue2.list)) || !listValue.value.equals(listValue2.value) && !listValue.value.equals(this.vars.get(listValue2.value))));
    }

    public Boolean visit(UnaryOperator unaryOperator) {
        UnaryOperator unaryOperator2 = (UnaryOperator)this.e2;
        return EquivalenceTester.box(this.areEquivalent(unaryOperator.element, unaryOperator2.element));
    }

    public Boolean visit(Element element) {
        return EquivalenceTester.box(element.equals(this.e2));
    }

    protected static final Boolean box(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }
}

