/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import xtc.parser.Analyzer;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.Grammar;
import xtc.parser.MetaData;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Rats;
import xtc.parser.Sequence;
import xtc.parser.UnaryOperator;
import xtc.tree.Node;
import xtc.tree.Visitor;

public class DeadProductionEliminator
extends Visitor {
    protected final Analyzer analyzer;
    protected final Map metaData;

    public DeadProductionEliminator(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.metaData = new HashMap();
    }

    protected void clearCounts() {
        Iterator iterator = this.metaData.values().iterator();
        while (iterator.hasNext()) {
            MetaData metaData = (MetaData)iterator.next();
            metaData.usageCount = 0;
            metaData.selfCount = 0;
        }
    }

    public void visit(Grammar grammar) {
        boolean bl;
        Object object;
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        this.metaData.clear();
        Iterator iterator = grammar.productions.iterator();
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            object = (MetaData)production.getProperty("xtc.parser.MetaData");
            this.metaData.put(production.nonTerminal, object);
        }
        do {
            this.clearCounts();
            bl = false;
            iterator = grammar.productions.iterator();
            while (iterator.hasNext()) {
                this.analyzer.process((Production)iterator.next());
            }
            if (!Rats.optimizeGrammar) continue;
            iterator = grammar.productions.iterator();
            while (iterator.hasNext()) {
                object = (Production)iterator.next();
                MetaData metaData = (MetaData)((Node)object).getProperty("xtc.parser.MetaData");
                if (this.analyzer.isTopLevel(((Production)object).nonTerminal) || metaData.usageCount != metaData.selfCount) continue;
                if (Rats.optionVerbose) {
                    System.out.println("[Removing dead production " + ((Production)object).nonTerminal.name + "]");
                }
                this.analyzer.remove((Production)object);
                this.metaData.remove(((Production)object).nonTerminal);
                iterator.remove();
                bl = true;
            }
        } while (bl);
    }

    public void visit(Production production) {
        production.element.accept(this);
    }

    public void visit(OrderedChoice orderedChoice) {
        Iterator iterator = orderedChoice.options.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).accept(this);
        }
    }

    public void visit(Sequence sequence) {
        Iterator iterator = sequence.elements.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).accept(this);
        }
    }

    public void visit(NonTerminal nonTerminal) {
        MetaData metaData = (MetaData)this.metaData.get(nonTerminal);
        ++metaData.usageCount;
        if (this.analyzer.current().nonTerminal.equals(nonTerminal)) {
            ++metaData.selfCount;
        }
    }

    public void visit(CharCase charCase) {
        if (null != charCase.element) {
            charCase.element.accept(this);
        }
    }

    public void visit(CharSwitch charSwitch) {
        Iterator iterator = charSwitch.cases.iterator();
        while (iterator.hasNext()) {
            ((CharCase)iterator.next()).accept(this);
        }
    }

    public void visit(UnaryOperator unaryOperator) {
        unaryOperator.element.accept(this);
    }

    public void visit(Element element) {
    }
}

