/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xtc.parser.Action;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharClass;
import xtc.parser.CharLiteral;
import xtc.parser.CharRange;
import xtc.parser.CharSwitch;
import xtc.parser.Copier;
import xtc.parser.Element;
import xtc.parser.Grammar;
import xtc.parser.NonTerminal;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.Terminal;
import xtc.parser.Type;
import xtc.parser.ValueElement;
import xtc.tree.Utility;

public class Analyzer
extends Utility {
    public static final String SEPARATOR = "$";
    public static final String SHARED = "$Shared";
    public static final String VARIABLE = "v$";
    public static final String CHOICE = "$Choice";
    public static final String STAR = "$Star";
    public static final String PLUS = "$Plus";
    public static final String OPTION = "$Option";
    public static final int MAX_COUNT = 22;
    protected final Copier xerox = new Copier();
    protected Grammar grammar;
    protected Map pMap = new HashMap();
    protected Set pTop = new HashSet();
    protected Production pCurrent;
    protected Set pWorking = new HashSet();
    protected Set pMarked = new HashSet();
    protected Set pProcessed = new HashSet();
    protected List pNew = new ArrayList();
    protected int varCount;
    protected int choiceCount;
    protected int starCount;
    protected int plusCount;
    protected int optionCount;
    protected int sharedCount = 1;

    public void reset() {
        this.grammar = null;
        this.pCurrent = null;
        this.pMap.clear();
        this.pTop.clear();
        this.pWorking.clear();
        this.pMarked.clear();
        this.pProcessed.clear();
        this.pNew.clear();
        this.varCount = 1;
        this.choiceCount = 1;
        this.starCount = 1;
        this.plusCount = 1;
        this.optionCount = 1;
        this.sharedCount = 1;
    }

    public void init(Grammar grammar) {
        if (this.grammar != grammar) {
            this.grammar = grammar;
            this.pMap.clear();
            Iterator iterator = grammar.productions.iterator();
            while (iterator.hasNext()) {
                Production production = (Production)iterator.next();
                this.pMap.put(production.nonTerminal, production);
            }
            this.pTop.clear();
            iterator = grammar.topLevel.iterator();
            while (iterator.hasNext()) {
                this.pTop.add(iterator.next());
            }
        }
        this.pMarked.clear();
        this.pProcessed.clear();
        this.pCurrent = null;
    }

    public boolean isDefined(NonTerminal nonTerminal) {
        return this.pMap.containsKey(nonTerminal);
    }

    public boolean isTopLevel(NonTerminal nonTerminal) {
        return this.pTop.contains(nonTerminal);
    }

    public Production lookup(NonTerminal nonTerminal) {
        return (Production)this.pMap.get(nonTerminal);
    }

    public void process(Production production) {
        this.pWorking.clear();
        this.varCount = 1;
        this.choiceCount = 1;
        this.starCount = 1;
        this.plusCount = 1;
        this.optionCount = 1;
        this.pCurrent = production;
        production.accept(this.visitor());
    }

    public Production current() {
        return this.pCurrent;
    }

    public void workingOn(NonTerminal nonTerminal) {
        this.pWorking.add(nonTerminal);
    }

    public void notWorkingOn(NonTerminal nonTerminal) {
        this.pWorking.remove(nonTerminal);
    }

    public boolean isBeingWorkedOn(NonTerminal nonTerminal) {
        return this.pWorking.contains(nonTerminal);
    }

    public Set working() {
        return this.pWorking;
    }

    public void mark(NonTerminal nonTerminal) {
        this.pMarked.add(nonTerminal);
    }

    public void unmark(NonTerminal nonTerminal) {
        this.pMarked.remove(nonTerminal);
    }

    public boolean isMarked(NonTerminal nonTerminal) {
        return this.pMarked.contains(nonTerminal);
    }

    public Set marked() {
        return this.pMarked;
    }

    public void processed(NonTerminal nonTerminal) {
        this.pProcessed.add(nonTerminal);
    }

    public boolean isProcessed(NonTerminal nonTerminal) {
        return this.pProcessed.contains(nonTerminal);
    }

    public void startAdding() {
        this.pNew.clear();
    }

    public void add(Production production) {
        production.setProperty("xtc.Constants.Synthetic", Boolean.TRUE);
        this.pNew.add(production);
        this.pMap.put(production.nonTerminal, production);
    }

    public int addNewProductionsAt(int n) {
        int n2 = this.pNew.size();
        if (0 != n2) {
            this.grammar.productions.addAll(n, this.pNew);
        }
        return n2;
    }

    public void remove(Production production) {
        this.pMap.remove(production.nonTerminal);
        this.pTop.remove(production.nonTerminal);
    }

    public String variable() {
        String string = VARIABLE + Integer.toString(this.varCount);
        ++this.varCount;
        return string;
    }

    public boolean isSynthetic(String string) {
        return string.startsWith(VARIABLE);
    }

    public NonTerminal choice() {
        NonTerminal nonTerminal = new NonTerminal(this.pCurrent.nonTerminal.name + CHOICE + Integer.toString(this.choiceCount));
        ++this.choiceCount;
        return nonTerminal;
    }

    public NonTerminal star() {
        NonTerminal nonTerminal = new NonTerminal(this.pCurrent.nonTerminal.name + STAR + Integer.toString(this.starCount));
        ++this.starCount;
        return nonTerminal;
    }

    public NonTerminal plus() {
        NonTerminal nonTerminal = new NonTerminal(this.pCurrent.nonTerminal.name + PLUS + Integer.toString(this.plusCount));
        ++this.plusCount;
        return nonTerminal;
    }

    public NonTerminal option() {
        NonTerminal nonTerminal = new NonTerminal(this.pCurrent.nonTerminal.name + OPTION + Integer.toString(this.optionCount));
        ++this.optionCount;
        return nonTerminal;
    }

    public NonTerminal shared() {
        NonTerminal nonTerminal = new NonTerminal(SHARED + Integer.toString(this.sharedCount));
        ++this.sharedCount;
        return nonTerminal;
    }

    public Element strip(Element element) {
        Sequence sequence;
        if (element instanceof OrderedChoice) {
            OrderedChoice orderedChoice = (OrderedChoice)element;
            if (1 == orderedChoice.options.size()) {
                element = this.strip((Element)orderedChoice.options.get(0));
            }
        } else if (element instanceof Sequence && 1 == (sequence = (Sequence)element).length()) {
            element = this.strip(sequence.get(0));
        }
        return element;
    }

    public Element copy(Element element) {
        return (Element)element.accept(this.xerox);
    }

    public boolean hasTerminalPrefix(Sequence sequence) {
        Element element;
        return 1 <= sequence.length() && ((element = sequence.get(0)) instanceof CharLiteral || element instanceof StringLiteral || element instanceof CharClass && ((CharClass)element).count() <= 22);
    }

    private int normalLength(Sequence sequence) {
        int n = sequence.length();
        boolean bl = true;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Element element = sequence.get(i);
            if (element instanceof CharLiteral) {
                bl = false;
                ++n2;
                continue;
            }
            if (element instanceof StringLiteral) {
                bl = false;
                n2 += ((StringLiteral)element).text.length();
                continue;
            }
            if (element instanceof CharClass) {
                ++n2;
                continue;
            }
            n2 += n - i;
            break;
        }
        return bl ? -1 : n2;
    }

    public Sequence normalizeTerminals(Sequence sequence) {
        int n = this.normalLength(sequence);
        if (-1 == n) {
            return sequence;
        }
        int n2 = sequence.length();
        Sequence sequence2 = new Sequence(new ArrayList(n));
        for (int i = 0; i < n2; ++i) {
            Element element = sequence.get(i);
            if (element instanceof CharLiteral) {
                sequence2.elements.add(new CharClass(((CharLiteral)element).c));
                continue;
            }
            if (element instanceof StringLiteral) {
                StringLiteral stringLiteral = (StringLiteral)element;
                for (int j = 0; j < stringLiteral.text.length(); ++j) {
                    sequence2.elements.add(new CharClass(stringLiteral.text.charAt(j)));
                }
                continue;
            }
            if (element instanceof CharClass) {
                sequence2.elements.add(element);
                continue;
            }
            sequence2.elements.addAll(sequence.elements.subList(i, n2));
            break;
        }
        return sequence2;
    }

    public Element joinTerminals(Sequence sequence, Element element) {
        Element element2;
        Element element3;
        if (null == element) {
            return sequence;
        }
        if (element instanceof Sequence && 1 == ((Sequence)(element3 = (Sequence)element)).length() && (element2 = ((Sequence)element3).get(0)) instanceof OrderedChoice) {
            element = element2;
        }
        if (element instanceof Sequence) {
            Element element4;
            Element element5;
            element3 = (Sequence)element;
            element2 = ((Sequence)element3).isEmpty() ? null : ((Sequence)element3).get(0);
            Element element6 = element5 = sequence.isEmpty() ? null : sequence.get(0);
            if (element5 instanceof CharClass && element2 instanceof CharClass && element5.equals(element2)) {
                Sequence sequence2 = new Sequence(this.joinTerminals(sequence.subSequence(1), ((Sequence)element3).subSequence(1)));
                sequence2.elements.add(0, element5);
                return sequence2;
            }
            if (element5 instanceof CharClass && ((CharClass)element5).count() <= 22) {
                element4 = (CharClass)element5;
                if (element2 instanceof CharClass) {
                    CharClass charClass = (CharClass)element2;
                    if (charClass.count() <= 22) {
                        return this.joinTerminals(sequence, new Sequence(new CharSwitch(charClass, (Element)((Sequence)element3).subSequence(1))));
                    }
                } else if (element2 instanceof CharSwitch) {
                    CharSwitch charSwitch = (CharSwitch)element2;
                    CharClass charClass = new CharClass(((CharClass)element4).ranges);
                    CharCase charCase = charSwitch.hasCase(charClass);
                    if (((CharClass)element4).exclusive) {
                        if (null != charCase && 1 == charSwitch.cases.size()) {
                            charSwitch.base = this.joinTerminals(sequence.subSequence(1), charSwitch.base);
                            return element;
                        }
                    } else {
                        if (null != charCase) {
                            charCase.element = this.joinTerminals(sequence.subSequence(1), charCase.element);
                            return element;
                        }
                        if (!charSwitch.overlaps(charClass) && null == charSwitch.base) {
                            charSwitch.cases.add(new CharCase(charClass, (Element)sequence.subSequence(1)));
                            return element;
                        }
                    }
                }
            }
            element4 = new OrderedChoice(new ArrayList());
            element4.options.add(element);
            element4.options.add(sequence);
            return element4;
        }
        if (element instanceof OrderedChoice) {
            element3 = (OrderedChoice)element;
            int n = ((OrderedChoice)element3).options.size();
            Element element7 = this.joinTerminals(sequence, (Element)((OrderedChoice)element3).options.get(n - 1));
            if (element7 instanceof OrderedChoice) {
                ((OrderedChoice)element3).options.remove(n - 1);
                ((OrderedChoice)element3).options.addAll(((OrderedChoice)element7).options);
            } else {
                ((OrderedChoice)element3).options.set(n - 1, element7);
            }
            return element3;
        }
        return this.joinTerminals(sequence, new Sequence(element));
    }

    public boolean haveCommonPrefix(Sequence sequence, Sequence sequence2) {
        Element element;
        Element element2 = sequence.isEmpty() ? null : sequence.get(0);
        Element element3 = element = sequence2.isEmpty() ? null : sequence2.get(0);
        if (element2 instanceof Binding) {
            return element2.equals(element);
        }
        if (null != element2) {
            return element2.equals(element);
        }
        return false;
    }

    public Sequence normalizePrefix(Sequence sequence, Sequence sequence2) {
        return sequence2;
    }

    public Element joinPrefixes(Sequence sequence, Element element) {
        Element element2;
        Element element3;
        if (null == element) {
            return sequence;
        }
        if (element instanceof Sequence && 1 == ((Sequence)(element3 = (Sequence)element)).length() && (element2 = ((Sequence)element3).get(0)) instanceof OrderedChoice) {
            element = element2;
        }
        if (element instanceof Sequence) {
            Element element4;
            element3 = (Sequence)element;
            element2 = ((Sequence)element3).isEmpty() ? null : ((Sequence)element3).get(0);
            Element element5 = element4 = sequence.isEmpty() ? null : sequence.get(0);
            if (null != element4 && element4.equals(element2)) {
                Sequence sequence2 = new Sequence(this.joinPrefixes(sequence.subSequence(1), ((Sequence)element3).subSequence(1)));
                sequence2.elements.add(0, element4);
                return sequence2;
            }
            OrderedChoice orderedChoice = new OrderedChoice(new ArrayList());
            orderedChoice.options.add(element);
            orderedChoice.options.add(sequence);
            return orderedChoice;
        }
        if (element instanceof OrderedChoice) {
            element3 = (OrderedChoice)element;
            int n = ((OrderedChoice)element3).options.size();
            Element element6 = this.joinPrefixes(sequence, (Element)((OrderedChoice)element3).options.get(n - 1));
            if (element6 instanceof OrderedChoice) {
                ((OrderedChoice)element3).options.remove(n - 1);
                ((OrderedChoice)element3).options.addAll(((OrderedChoice)element6).options);
            } else {
                ((OrderedChoice)element3).options.set(n - 1, element6);
            }
            return element3;
        }
        return this.joinPrefixes(sequence, new Sequence(element));
    }

    public String matchingText(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.matchingText(element, stringBuffer)) {
            return stringBuffer.toString();
        }
        return null;
    }

    private boolean matchingText(Element element, StringBuffer stringBuffer) {
        if (element instanceof OrderedChoice) {
            OrderedChoice orderedChoice = (OrderedChoice)element;
            if (1 == orderedChoice.options.size()) {
                return this.matchingText((Element)orderedChoice.options.get(0), stringBuffer);
            }
            return false;
        }
        if (element instanceof Repetition || element instanceof Option) {
            return false;
        }
        if (element instanceof Sequence) {
            Sequence sequence = (Sequence)element;
            int n = sequence.length();
            for (int i = 0; i < n; ++i) {
                if (this.matchingText(sequence.get(i), stringBuffer)) continue;
                return false;
            }
            return true;
        }
        if (element instanceof Predicate) {
            return true;
        }
        if (element instanceof Binding) {
            return this.matchingText(((Binding)element).element, stringBuffer);
        }
        if (element instanceof StringMatch) {
            return this.matchingText(((StringMatch)element).element, stringBuffer);
        }
        if (element instanceof NonTerminal) {
            Production production = this.lookup((NonTerminal)element);
            return this.matchingText(production.element, stringBuffer);
        }
        if (element instanceof StringLiteral) {
            stringBuffer.append(((StringLiteral)element).text);
            return true;
        }
        if (element instanceof CharLiteral) {
            stringBuffer.append(((CharLiteral)element).c);
            return true;
        }
        if (element instanceof CharClass) {
            CharClass charClass = (CharClass)element;
            if (1 == charClass.ranges.size()) {
                CharRange charRange = (CharRange)charClass.ranges.get(0);
                if (charRange.first == charRange.last) {
                    stringBuffer.append(charRange.first);
                    return true;
                }
            }
            return false;
        }
        if (element instanceof Terminal) {
            return false;
        }
        if (element instanceof Action || element instanceof ValueElement) {
            return true;
        }
        if (element instanceof ParserAction) {
            return false;
        }
        return false;
    }

    public Binding bind(Sequence sequence) {
        Binding binding = null;
        Element element = null;
        int n = -1;
        int n2 = sequence.length();
        for (int i = 0; i < n2; ++i) {
            Element element2 = sequence.get(i);
            if (element2 instanceof OrderedChoice || element2 instanceof Repetition || element2 instanceof Option || element2 instanceof Sequence) {
                binding = null;
                n = -1;
                break;
            }
            if (element2 instanceof Predicate) continue;
            if (element2 instanceof Binding) {
                if (-1 == n) {
                    binding = (Binding)element2;
                    n = i;
                    continue;
                }
                binding = null;
                n = -1;
                break;
            }
            if (element2 instanceof NonTerminal) {
                Production production = this.lookup((NonTerminal)element2);
                if (Type.isVoidT(production.type)) continue;
                if (-1 == n) {
                    element = element2;
                    n = i;
                    continue;
                }
                binding = null;
                n = -1;
                break;
            }
            if (element2 instanceof Terminal || element2 instanceof StringMatch) {
                if (-1 == n) {
                    element = element2;
                    n = i;
                    continue;
                }
                binding = null;
                n = -1;
                break;
            }
            binding = null;
            n = -1;
            break;
        }
        if (null != binding) {
            return binding;
        }
        if (-1 == n) {
            return null;
        }
        binding = new Binding(this.variable(), element);
        sequence.elements.set(n, binding);
        return binding;
    }
}

