/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.IOException;
import java.io.Reader;
import xtc.parser.Column;
import xtc.parser.ParseError;
import xtc.tree.Location;
import xtc.tree.Node;
import xtc.util.Utilities;

public abstract class PackratParser {
    public static final int INIT_SIZE = 4096;
    public static final int INCR_SIZE = 4096;
    protected Reader yyReader;
    protected int yyCount;
    protected boolean yyEOF;
    protected char[] yyData;
    protected Column[] yyColumns;

    public PackratParser(Reader reader, String string) {
        this(reader, string, 4095);
    }

    public PackratParser(Reader reader, String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative size: " + n);
        }
        this.yyReader = reader;
        this.yyCount = 0;
        this.yyEOF = false;
        this.yyData = new char[n + 1];
        this.yyColumns = new Column[n + 1];
        Column column = this.newColumn();
        column.file = string;
        column.seenCR = false;
        column.line = 1;
        column.column = 0;
        this.yyColumns[0] = column;
    }

    public final void resetTo(int n) {
        int n2;
        if (0 > n) {
            throw new IndexOutOfBoundsException("Negative index: " + n);
        }
        if (0 == n) {
            return;
        }
        if (n >= this.yyCount) {
            throw new IndexOutOfBoundsException("Invalid index: " + n);
        }
        Column column = this.column(n);
        Column column2 = this.newColumn();
        column2.file = column.file;
        column2.seenCR = column.seenCR;
        column2.line = column.line;
        column2.column = column.column;
        this.yyColumns[0] = column2;
        int n3 = this.yyCount - n;
        System.arraycopy(this.yyData, n, this.yyData, 0, n3);
        for (n2 = n3; n2 < this.yyCount; ++n2) {
            this.yyData[n2] = '\u0000';
        }
        for (n2 = 1; n2 < this.yyCount; ++n2) {
            this.yyColumns[n2] = null;
        }
        this.yyCount = n3;
    }

    private void growBy(int n) {
        char[] cArray = this.yyData;
        this.yyData = new char[cArray.length + n];
        System.arraycopy(cArray, 0, this.yyData, 0, cArray.length);
        Column[] columnArray = this.yyColumns;
        this.yyColumns = new Column[columnArray.length + n];
        System.arraycopy(columnArray, 0, this.yyColumns, 0, columnArray.length);
    }

    protected abstract Column newColumn();

    protected final Column column(int n) {
        Column column;
        if (this.yyColumns.length == n) {
            this.growBy(4096);
        }
        if (null != (column = this.yyColumns[n])) {
            return column;
        }
        Column column2 = null;
        for (int i = n; i >= 0 && null == (column2 = this.yyColumns[i]); --i) {
        }
        int n2 = column2.line;
        int n3 = column2.column;
        boolean bl = column2.seenCR;
        block6: for (int i = i; i < n; ++i) {
            switch (this.yyData[i]) {
                case '\t': {
                    n3 = (n3 >> 3) + 1 << 3;
                    bl = false;
                    continue block6;
                }
                case '\n': {
                    if (!bl) {
                        ++n2;
                        n3 = 0;
                    }
                    bl = false;
                    continue block6;
                }
                case '\r': {
                    ++n2;
                    n3 = 0;
                    bl = true;
                    continue block6;
                }
                default: {
                    ++n3;
                    bl = false;
                }
            }
        }
        column = this.newColumn();
        column.file = column2.file;
        column.seenCR = bl;
        column.line = n2;
        column.column = n3;
        this.yyColumns[n] = column;
        return column;
    }

    protected final int character(int n) throws IOException {
        int n2;
        if (this.yyEOF) {
            if (n < this.yyCount - 1) {
                return this.yyData[n];
            }
            if (n < this.yyCount) {
                return -1;
            }
            throw new IndexOutOfBoundsException("Parser index: " + n);
        }
        if (n < this.yyCount) {
            return this.yyData[n];
        }
        if (n != this.yyCount) {
            throw new IndexOutOfBoundsException("Parser index: " + n);
        }
        int n3 = this.yyReader.read();
        int n4 = n2 = -1 == n3 ? 1 : 4096;
        if (this.yyData.length <= this.yyCount) {
            this.growBy(n2);
        }
        if (-1 == n3) {
            this.yyEOF = true;
        } else {
            this.yyData[n] = (char)n3;
        }
        ++this.yyCount;
        return n3;
    }

    protected final String difference(int n, int n2) {
        return n == n2 ? "" : new String(this.yyData, n, n2 - n);
    }

    public final boolean isEOF(int n) {
        return this.yyEOF && n == this.yyCount - 1;
    }

    public final String lineAt(int n) throws IOException {
        if (0 > n) {
            throw new IndexOutOfBoundsException("Negative index");
        }
        if (0 < n && 10 == this.character(n) && 13 == this.character(n - 1)) {
            --n;
        }
        int n2 = n;
        int n3 = n;
        int n4 = this.character(n3);
        while (-1 != n4 && 13 != n4 && 10 != n4) {
            n4 = this.character(++n3);
        }
        while (0 != n2 && 13 != (n4 = this.character(n2 - 1)) && 10 != n4) {
            --n2;
        }
        return this.difference(n2, n3);
    }

    public final Location location(int n) {
        Column column = this.column(n);
        return new Location(column.file, column.line, column.column);
    }

    protected final void setLocation(Node node, int n) {
        if (null != node && null == node.location) {
            Column column = this.column(n);
            node.location = new Location(column.file, column.line, column.column);
        }
    }

    protected final String peek(int n) {
        int n2;
        int n3 = n2 = this.yyEOF ? this.yyCount - 1 : this.yyCount;
        if (n >= n2) {
            return "";
        }
        n2 = Math.min(n + 20, n2);
        return new String(this.yyData, n, n2 - n);
    }

    public String format(ParseError parseError) throws IOException {
        return Utilities.fmt((String)parseError.msg, (Location)(-1 == parseError.index ? null : this.location(parseError.index)), null, -1 == parseError.index ? null : this.lineAt(parseError.index));
    }

    public void print(ParseError parseError) throws IOException {
        Utilities.msg((String)parseError.msg, (Location)(-1 == parseError.index ? null : this.location(parseError.index)), null, -1 == parseError.index ? null : this.lineAt(parseError.index));
    }
}

