/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Iterator;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.Generifier;
import xtc.parser.Grammar;
import xtc.parser.ListValue;
import xtc.parser.NonTerminal;
import xtc.parser.NullValue;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.Rats;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.SingletonListValue;
import xtc.parser.StringValue;
import xtc.parser.TextTester;
import xtc.parser.TextValue;
import xtc.parser.Type;
import xtc.parser.UnaryOperator;
import xtc.tree.Node;
import xtc.tree.Visitor;

public class Transformer
extends Visitor {
    protected final Analyzer analyzer;
    protected boolean isTextOnly;
    protected boolean isGeneric;
    protected boolean isVoid;
    protected boolean isTopLevel;
    protected boolean transformInPlace;
    protected boolean isLastElement;
    protected boolean isPredicate;
    protected boolean isBound;

    public Transformer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    protected boolean repeatable() {
        return Rats.optimizeRepeated && this.analyzer.current().isTransient && (this.isVoid || this.isTextOnly);
    }

    public void visit(Grammar grammar) {
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        for (int i = 0; i < grammar.productions.size(); ++i) {
            Production production = (Production)grammar.productions.get(i);
            this.isTextOnly = TextTester.isTextOnly(production);
            this.isGeneric = Generifier.isGeneric(production);
            this.isVoid = Type.isVoidT(production.type);
            this.transformInPlace = false;
            this.isTopLevel = true;
            this.isLastElement = false;
            this.isPredicate = false;
            this.isBound = false;
            this.analyzer.startAdding();
            this.analyzer.process(production);
            i += this.analyzer.addNewProductionsAt(i + 1);
        }
    }

    public void visit(Production production) {
        production.element = (Element)production.element.accept(this);
    }

    public Element visit(OrderedChoice orderedChoice) {
        Node node;
        Object object;
        boolean bl = this.isTopLevel;
        this.isTopLevel = false;
        boolean bl2 = this.isLastElement;
        this.isLastElement = false;
        boolean bl3 = this.isBound;
        this.isBound = false;
        boolean bl4 = this.transformInPlace;
        this.transformInPlace = false;
        if (bl && !this.isGeneric && 1 == orderedChoice.options.size()) {
            object = (Element)orderedChoice.options.get(0);
            if (!this.repeatable() && object instanceof Repetition || object instanceof Option) {
                if (Rats.optionVerbose) {
                    System.out.print("[Transforming top-level ");
                    if (object instanceof Repetition) {
                        System.out.print("repitition");
                    } else {
                        System.out.print("option");
                    }
                    System.out.println(" in production " + this.analyzer.current().nonTerminal.name + " in place]");
                }
                this.transformInPlace = true;
                return (Element)((Node)object).accept(this);
            }
        }
        object = null;
        int n = orderedChoice.options.size();
        for (int i = 0; i < n; ++i) {
            node = Sequence.ensure((Element)((Element)orderedChoice.options.get(i)).accept(this));
            if (!(bl4 || !node.isEmpty() && node.get(node.length() - 1) instanceof OrderedChoice)) {
                Object object2;
                if (this.isTextOnly) {
                    if (bl || bl3) {
                        object2 = this.analyzer.matchingText((Element)node);
                        if (null == object2 || !Rats.optimizeTerminals) {
                            node.elements.add(TextValue.VALUE);
                        } else {
                            node.elements.add(new StringValue((String)object2));
                        }
                        object = Type.stringT();
                    } else if (bl2 && !this.isPredicate) {
                        node.elements.add(TextValue.VALUE);
                        object = Type.stringT();
                    } else {
                        node.elements.add(NullValue.VALUE);
                        object = Type.voidT();
                    }
                } else if (this.isGeneric) {
                    object = Type.genericT();
                } else if (this.isVoid && !bl3) {
                    node.elements.add(NullValue.VALUE);
                    object = Type.voidT();
                } else if (!bl2) {
                    object2 = this.analyzer.bind((Sequence)node);
                    if (null != object2) {
                        ((Binding)object2).name = "yyValue";
                        object = null == object ? Type.type(((Binding)object2).element, this.analyzer) : Type.unify((String)object, Type.type(((Binding)object2).element, this.analyzer));
                    } else {
                        object = Type.rootT();
                    }
                }
            }
            orderedChoice.options.set(i, node);
        }
        if (bl || bl4 || bl2 && !this.isPredicate && !bl3) {
            return orderedChoice;
        }
        NonTerminal nonTerminal = this.analyzer.choice();
        node = new Production(this.analyzer.current().isTransient, (String)object, nonTerminal, orderedChoice);
        if (this.isTextOnly && Type.isStringT((String)object)) {
            TextTester.markTextOnly((Production)node);
        } else if (this.isGeneric) {
            Generifier.markGeneric((Production)node);
        }
        this.analyzer.add((Production)node);
        return nonTerminal;
    }

    public Element visit(Repetition repetition) {
        Node node;
        Object object;
        Element element;
        ArrayList<Element> arrayList;
        Element element2;
        Element element3;
        this.isTopLevel = false;
        this.isLastElement = false;
        boolean bl = this.isBound;
        this.isBound = false;
        boolean bl2 = this.transformInPlace;
        boolean bl3 = this.transformInPlace = this.isTextOnly || this.isVoid && !bl;
        if (!this.transformInPlace && repetition.element instanceof Sequence) {
            element3 = null;
            if (!this.isGeneric) {
                this.analyzer.bind((Sequence)repetition.element);
            }
            if (null == element3 || "yyValue".equals(((Binding)element3).name)) {
                element2 = new OrderedChoice(new ArrayList(1));
                ((OrderedChoice)element2).options.add(repetition.element);
                ((OrderedChoice)element2).location = repetition.element.location;
                repetition.element = element2;
            }
        }
        element3 = (Element)repetition.element.accept(this);
        if (this.repeatable() && !bl) {
            repetition.element = Sequence.ensure(element3);
            return repetition;
        }
        if (bl2) {
            element2 = this.analyzer.current().nonTerminal;
        } else {
            NonTerminal nonTerminal = element2 = repetition.once ? this.analyzer.plus() : this.analyzer.star();
        }
        if (element3 instanceof OrderedChoice) {
            arrayList = ((OrderedChoice)element3).options;
        } else {
            arrayList = new ArrayList<Element>(1);
            arrayList.add(element3);
        }
        ArrayList<Sequence> arrayList2 = new ArrayList<Sequence>(arrayList.size() + (repetition.once ? arrayList.size() : 1));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            element = repetition.once ? new Sequence((Element)iterator.next()) : Sequence.ensure((Element)iterator.next());
            if (this.isTextOnly) {
                element.elements.add(element2);
                if (bl || bl2) {
                    element.elements.add(TextValue.VALUE);
                } else {
                    element.elements.add(NullValue.VALUE);
                }
            } else if (this.isVoid && !bl) {
                element.elements.add(element2);
                element.elements.add(NullValue.VALUE);
            } else {
                object = this.analyzer.bind((Sequence)element);
                node = new Binding(this.analyzer.variable(), element2);
                element.elements.add(node);
                element.elements.add(new ListValue(null == object ? "yyValue" : ((Binding)object).name, node.name));
            }
            arrayList2.add((Sequence)element);
        }
        if (repetition.once) {
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                element = new Sequence((Element)iterator.next());
                if (this.isTextOnly) {
                    if (bl || bl2) {
                        element.elements.add(TextValue.VALUE);
                    } else {
                        element.elements.add(NullValue.VALUE);
                    }
                } else if (this.isVoid && !bl) {
                    element.elements.add(NullValue.VALUE);
                } else {
                    object = this.analyzer.bind((Sequence)element);
                    element.elements.add(new SingletonListValue(null == object ? "yyValue" : ((Binding)object).name));
                }
                arrayList2.add((Sequence)element);
            }
        } else {
            element = new Sequence(new ArrayList());
            if (this.isTextOnly) {
                if (bl || bl2) {
                    element.elements.add(TextValue.VALUE);
                } else {
                    element.elements.add(NullValue.VALUE);
                }
            } else if (this.isVoid && !bl) {
                element.elements.add(NullValue.VALUE);
            } else {
                element.elements.add(EmptyListValue.VALUE);
            }
            arrayList2.add((Sequence)element);
        }
        element = new OrderedChoice(arrayList2);
        if (bl2) {
            return element;
        }
        object = this.isTextOnly ? (bl || bl2 ? Type.stringT() : Type.voidT()) : (this.isVoid && !bl ? Type.voidT() : Type.listT());
        node = new Production(this.analyzer.current().isTransient, (String)object, (NonTerminal)element2, element);
        if (this.isTextOnly && Type.isStringT((String)object)) {
            TextTester.markTextOnly((Production)node);
        }
        this.analyzer.add((Production)node);
        return element2;
    }

    public Element visit(Option option) {
        Element element;
        Sequence sequence;
        ArrayList<Element> arrayList;
        NonTerminal nonTerminal;
        this.isTopLevel = false;
        this.isLastElement = false;
        boolean bl = this.isBound;
        this.isBound = false;
        boolean bl2 = this.transformInPlace;
        this.transformInPlace = true;
        Element element2 = (Element)option.element.accept(this);
        NonTerminal nonTerminal2 = nonTerminal = bl2 ? this.analyzer.current().nonTerminal : this.analyzer.option();
        if (element2 instanceof OrderedChoice) {
            arrayList = ((OrderedChoice)element2).options;
        } else {
            arrayList = new ArrayList<Element>(1);
            arrayList.add(element2);
        }
        ArrayList<Sequence> arrayList2 = new ArrayList<Sequence>(arrayList.size() + 1);
        String string = null;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            sequence = Sequence.ensure((Element)iterator.next());
            if (this.isTextOnly) {
                if (bl || bl2) {
                    sequence.elements.add(TextValue.VALUE);
                    string = Type.stringT();
                } else {
                    sequence.elements.add(NullValue.VALUE);
                    string = Type.voidT();
                }
            } else if (this.isGeneric) {
                string = Type.genericT();
            } else if (this.isVoid && !bl) {
                sequence.elements.add(NullValue.VALUE);
                string = Type.voidT();
            } else {
                element = this.analyzer.bind(sequence);
                if (null != element) {
                    element.name = "yyValue";
                    string = null == string ? Type.type(element.element, this.analyzer) : Type.unify(string, Type.type(element.element, this.analyzer));
                } else {
                    string = Type.rootT();
                }
            }
            arrayList2.add(sequence);
        }
        sequence = new Sequence(new ArrayList());
        if (this.isTextOnly && (bl || bl2)) {
            sequence.elements.add(TextValue.VALUE);
        } else if (!this.isGeneric) {
            sequence.elements.add(NullValue.VALUE);
        }
        arrayList2.add(sequence);
        element = new OrderedChoice(arrayList2);
        if (bl2) {
            return element;
        }
        Production production = new Production(this.analyzer.current().isTransient, string, nonTerminal, element);
        if (this.isTextOnly && Type.isStringT(string)) {
            TextTester.markTextOnly(production);
        } else if (this.isGeneric) {
            Generifier.markGeneric(production);
        }
        this.analyzer.add(production);
        return nonTerminal;
    }

    public Element visit(Sequence sequence) {
        this.isTopLevel = false;
        this.isBound = false;
        this.transformInPlace = false;
        int n = sequence.length();
        for (int i = 0; i < n; ++i) {
            this.isLastElement = i == n - 1;
            sequence.elements.set(i, sequence.get(i).accept(this));
        }
        this.isLastElement = false;
        return sequence;
    }

    public Element visit(Predicate predicate) {
        boolean bl = this.isPredicate;
        this.isPredicate = true;
        this.isTopLevel = false;
        this.isLastElement = false;
        this.isBound = false;
        this.transformInPlace = false;
        predicate.element = Sequence.ensure((Element)predicate.element.accept(this));
        this.isPredicate = bl;
        return predicate;
    }

    public Element visit(SemanticPredicate semanticPredicate) {
        this.isTopLevel = false;
        this.isLastElement = false;
        this.isBound = false;
        this.transformInPlace = false;
        semanticPredicate.element = (Element)semanticPredicate.element.accept(this);
        return semanticPredicate;
    }

    public CharCase visit(CharCase charCase) {
        this.isTopLevel = false;
        this.isLastElement = false;
        this.isBound = false;
        this.transformInPlace = false;
        if (null != charCase.element) {
            charCase.element = (Element)charCase.element.accept(this);
        }
        return charCase;
    }

    public Element visit(CharSwitch charSwitch) {
        this.isTopLevel = false;
        this.isLastElement = false;
        this.isBound = false;
        this.transformInPlace = false;
        int n = charSwitch.cases.size();
        for (int i = 0; i < n; ++i) {
            charSwitch.cases.set(i, ((CharCase)charSwitch.cases.get(i)).accept(this));
        }
        if (null != charSwitch.base) {
            charSwitch.base = (Element)charSwitch.base.accept(this);
        }
        return charSwitch;
    }

    public Element visit(UnaryOperator unaryOperator) {
        this.isTopLevel = false;
        this.isLastElement = false;
        this.isBound = true;
        this.transformInPlace = false;
        unaryOperator.element = (Element)unaryOperator.element.accept(this);
        return unaryOperator;
    }

    public Element visit(ParserAction parserAction) {
        this.isTopLevel = false;
        this.isLastElement = false;
        this.isBound = false;
        this.transformInPlace = false;
        parserAction.element = (Element)parserAction.element.accept(this);
        return parserAction;
    }

    public Element visit(Element element) {
        this.isTopLevel = false;
        this.isLastElement = false;
        this.isBound = false;
        this.transformInPlace = false;
        return element;
    }
}

