/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.Grammar;
import xtc.parser.NonTerminal;
import xtc.parser.NullValue;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.Rats;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.StringMatch;
import xtc.parser.Type;
import xtc.parser.UnaryOperator;
import xtc.parser.ValueElement;
import xtc.tree.Visitor;

public class ProductionVoider
extends Visitor {
    protected final Analyzer analyzer;

    public ProductionVoider(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void visit(Grammar grammar) {
        Tester tester = new Tester(this.analyzer);
        grammar.accept(tester);
        Set set = tester.voidable();
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        Iterator iterator = grammar.productions.iterator();
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            if (!set.contains(production.nonTerminal)) continue;
            if (Rats.optionVerbose) {
                System.out.println("[Voiding production " + production.nonTerminal.name + "]");
            }
            this.analyzer.process(production);
            production.type = Type.voidT();
        }
    }

    public void visit(Production production) {
        production.element.accept(this);
    }

    public Element visit(OrderedChoice orderedChoice) {
        int n = orderedChoice.options.size();
        for (int i = 0; i < n; ++i) {
            orderedChoice.options.set(i, ((Element)orderedChoice.options.get(i)).accept(this));
        }
        return orderedChoice;
    }

    public Element visit(Sequence sequence) {
        int n = sequence.length();
        for (int i = 0; i < n; ++i) {
            sequence.elements.set(i, sequence.get(i).accept(this));
        }
        return sequence;
    }

    public Element visit(Binding binding) {
        if (this.analyzer.isSynthetic(binding.name)) {
            return binding.element;
        }
        return binding;
    }

    public CharCase visit(CharCase charCase) {
        if (null != charCase.element) {
            charCase.element = (Element)charCase.element.accept(this);
        }
        return charCase;
    }

    public Element visit(CharSwitch charSwitch) {
        int n = charSwitch.cases.size();
        for (int i = 0; i < n; ++i) {
            charSwitch.cases.set(i, ((CharCase)charSwitch.cases.get(i)).accept(this));
        }
        if (null != charSwitch.base) {
            charSwitch.base = (Element)charSwitch.base.accept(this);
        }
        return charSwitch;
    }

    public Element visit(ValueElement valueElement) {
        return NullValue.VALUE;
    }

    public Element visit(UnaryOperator unaryOperator) {
        unaryOperator.element = (Element)unaryOperator.element.accept(this);
        return unaryOperator;
    }

    public Element visit(Element element) {
        return element;
    }

    public static class Tester
    extends Visitor {
        protected final Analyzer analyzer;
        protected boolean secondPhase;
        protected boolean voidable;
        protected boolean isBound;

        public Tester(Analyzer analyzer) {
            this.analyzer = analyzer;
        }

        public Set voidable() {
            return new HashSet(this.analyzer.marked());
        }

        public void visit(Grammar grammar) {
            Production production;
            this.analyzer.register(this);
            this.analyzer.init(grammar);
            this.secondPhase = false;
            Iterator iterator = grammar.productions.iterator();
            while (iterator.hasNext()) {
                production = (Production)iterator.next();
                if (this.analyzer.isTopLevel(production.nonTerminal) || Type.isVoidT(production.type)) continue;
                this.voidable = true;
                this.analyzer.process(production);
                if (!this.voidable) continue;
                this.analyzer.mark(production.nonTerminal);
            }
            this.secondPhase = true;
            iterator = grammar.productions.iterator();
            while (iterator.hasNext()) {
                production = (Production)iterator.next();
                this.isBound = false;
                this.analyzer.process(production);
            }
        }

        public void visit(Production production) {
            production.element.accept(this);
        }

        public void visit(OrderedChoice orderedChoice) {
            this.isBound = false;
            Iterator iterator = orderedChoice.options.iterator();
            while (iterator.hasNext()) {
                ((Element)iterator.next()).accept(this);
            }
        }

        public void visit(Sequence sequence) {
            this.isBound = false;
            Iterator iterator = sequence.elements.iterator();
            while (iterator.hasNext()) {
                ((Element)iterator.next()).accept(this);
            }
        }

        public void visit(SemanticPredicate semanticPredicate) {
        }

        public void visit(Binding binding) {
            if ("yyValue".equals(binding.name)) {
                this.voidable = false;
            }
            this.isBound = true;
            binding.element.accept(this);
        }

        public void visit(StringMatch stringMatch) {
            this.isBound = true;
            stringMatch.element.accept(this);
        }

        public void visit(NonTerminal nonTerminal) {
            if (this.secondPhase && this.isBound) {
                this.analyzer.unmark(nonTerminal);
            }
            this.isBound = false;
        }

        public void visit(CharCase charCase) {
            if (null != charCase.element) {
                charCase.element.accept(this);
            }
        }

        public void visit(CharSwitch charSwitch) {
            this.isBound = false;
            Iterator iterator = charSwitch.cases.iterator();
            while (iterator.hasNext()) {
                ((CharCase)iterator.next()).accept(this);
            }
            if (null != charSwitch.base) {
                charSwitch.base.accept(this);
            }
        }

        public void visit(Action action) {
            this.isBound = false;
            this.voidable = false;
        }

        public void visit(ParserAction parserAction) {
            this.isBound = false;
            this.voidable = false;
        }

        public void visit(UnaryOperator unaryOperator) {
            this.isBound = false;
            unaryOperator.element.accept(this);
        }

        public void visit(Element element) {
            this.isBound = false;
        }
    }
}

