/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.Iterator;
import java.util.List;
import xtc.parser.Action;
import xtc.parser.AnyChar;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharClass;
import xtc.parser.CharLiteral;
import xtc.parser.CharRange;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.FollowedBy;
import xtc.parser.GenericValue;
import xtc.parser.Grammar;
import xtc.parser.ListValue;
import xtc.parser.NonTerminal;
import xtc.parser.NotFollowedBy;
import xtc.parser.NullValue;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.SingletonListValue;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.StringValue;
import xtc.parser.TextValue;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.util.Utilities;

public class PrettyPrinter
extends Visitor {
    public static final boolean MARK_CHOICE = true;
    protected final Printer printer;
    protected boolean newline;
    protected boolean parenChoice;
    protected boolean parenSequence;

    public PrettyPrinter(Printer printer) {
        this.printer = printer;
        printer.register(this);
    }

    public void visit(Grammar grammar) {
        this.printer.sep();
        this.printer.indent().p("// xtc ").pln("1.3.0");
        this.printer.indent().pln("// Packrat grammar pretty printer");
        this.printer.sep();
        this.printer.pln();
        boolean bl = false;
        if (null != grammar.pName) {
            bl = true;
            this.printer.indent().p("package ").p(grammar.pName).pln(';');
            this.printer.pln();
        }
        if (null != grammar.header) {
            bl = true;
            this.printer.indent().p("header ");
            grammar.header.accept(this);
            this.printer.pln();
        }
        if (!"Parser".equals(grammar.cName)) {
            bl = true;
            this.printer.indent().p("class ").p(grammar.cName).pln(';');
            this.printer.pln();
        }
        if (null != grammar.body) {
            bl = true;
            this.printer.indent().p("body ");
            grammar.body.accept(this);
            this.printer.pln();
        }
        if (null != grammar.footer) {
            bl = true;
            this.printer.indent().p("footer ");
            grammar.footer.accept(this);
            this.printer.pln();
        }
        if (bl) {
            this.printer.sep();
            this.printer.pln();
        }
        this.printer.indent().p("top ");
        Iterator iterator = grammar.topLevel.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            if (bl2) {
                bl2 = false;
            } else {
                this.printer.p(", ");
            }
            ((NonTerminal)iterator.next()).accept(this);
        }
        this.printer.pln(';').pln();
        iterator = grammar.productions.iterator();
        while (iterator.hasNext()) {
            ((Production)iterator.next()).accept(this);
        }
        this.printer.sep().pln();
    }

    public void visit(Production production) {
        if (production.hasProperty("xtc.parser.DuplicateProductionFolder.Duplicates")) {
            List list = (List)production.getProperty("xtc.parser.DuplicateProductionFolder.Duplicates");
            this.printer.indent().pln("/*");
            this.printer.indent().p(" * The following production is the result of ").pln("folding duplicates");
            this.printer.indent().p(" * ").pln(Utilities.format(list));
            this.printer.indent().pln(" */");
        }
        this.printer.indent();
        if (production.isTransient) {
            this.printer.p("transient ");
        }
        this.printer.p(production.type).p(' ');
        production.nonTerminal.accept(this);
        this.printer.p(" = ");
        this.parenChoice = false;
        this.parenSequence = false;
        production.element.accept(this);
        this.printer.incr().indent().pln(';').decr();
        this.printer.pln();
    }

    public void visit(OrderedChoice orderedChoice) {
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        if (bl) {
            this.printer.p("( ");
        }
        this.printer.p("/* Choice */ ");
        this.printer.pln().incr();
        Iterator iterator = orderedChoice.options.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            if (bl3) {
                bl3 = false;
                this.printer.indent();
            } else {
                this.printer.indent().p("/ ");
            }
            this.parenChoice = true;
            this.parenSequence = false;
            this.newline = false;
            ((Element)iterator.next()).accept(this);
            if (this.newline) continue;
            this.printer.pln();
        }
        this.printer.decr();
        if (bl) {
            this.printer.indent().p(')');
        }
        this.parenChoice = bl;
        this.parenSequence = bl2;
        this.newline = false;
    }

    public void visit(Repetition repetition) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        repetition.element.accept(this);
        if (repetition.once) {
            this.printer.p('+');
        } else {
            this.printer.p('*');
        }
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(Option option) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        option.element.accept(this);
        this.printer.p('?');
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(Sequence sequence) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        Iterator iterator = sequence.elements.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            if (bl3) {
                bl3 = false;
                if (bl2) {
                    this.printer.p('(');
                }
            } else {
                this.printer.p(' ');
            }
            ((Element)iterator.next()).accept(this);
        }
        if (bl2) {
            this.printer.p(')');
        }
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(FollowedBy followedBy) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.p('&');
        followedBy.element.accept(this);
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(NotFollowedBy notFollowedBy) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.p('!');
        notFollowedBy.element.accept(this);
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(SemanticPredicate semanticPredicate) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.p('&');
        semanticPredicate.element.accept(this);
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(Binding binding) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.p(binding.name).p(':');
        binding.element.accept(this);
    }

    public void visit(StringMatch stringMatch) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.p('\"').escape(stringMatch.text, 4).p("\":");
        stringMatch.element.accept(this);
    }

    public void visit(NonTerminal nonTerminal) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.p(nonTerminal.name);
    }

    public void visit(StringLiteral stringLiteral) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.p('\"').escape(stringLiteral.text, 4).p('\"');
    }

    public void visit(AnyChar anyChar) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.p('.');
    }

    public void visit(CharLiteral charLiteral) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.p('\'').escape(charLiteral.c, 4).p('\'');
    }

    public void visit(CharRange charRange) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        if (charRange.first == charRange.last) {
            this.printer.escape(charRange.first, 6);
        } else {
            this.printer.escape(charRange.first, 6).p('-').escape(charRange.last, 6);
        }
    }

    public void visit(CharClass charClass) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        if (charClass.exclusive) {
            this.printer.p("/* Exclusive */ !");
        }
        this.printer.p('[');
        Iterator iterator = charClass.ranges.iterator();
        while (iterator.hasNext()) {
            ((CharRange)iterator.next()).accept(this);
        }
        this.printer.p(']');
        if (charClass.exclusive) {
            this.printer.p(" .");
        }
    }

    public void visit(CharCase charCase) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        charCase.klass.accept(this);
        this.printer.p(' ');
        if (null == charCase.element) {
            this.printer.p("&{ false }");
        } else {
            charCase.element.accept(this);
        }
    }

    public void visit(CharSwitch charSwitch) {
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.printer.pln("( /* Switch */").incr();
        Iterator iterator = charSwitch.cases.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            if (bl3) {
                bl3 = false;
                this.printer.indent();
            } else {
                this.printer.indent().p("/ ");
            }
            this.parenChoice = true;
            this.parenSequence = false;
            this.newline = false;
            ((CharCase)iterator.next()).accept(this);
            if (this.newline) continue;
            this.printer.pln();
        }
        if (null != charSwitch.base) {
            this.printer.indent().p("/ . ");
            this.parenChoice = true;
            this.parenSequence = false;
            this.newline = false;
            charSwitch.base.accept(this);
            if (!this.newline) {
                this.printer.pln();
            }
        }
        this.printer.decr().indent().p(')');
        this.parenChoice = bl;
        this.parenSequence = bl2;
        this.newline = false;
    }

    protected void action(Action action, boolean bl) {
        if (this.newline) {
            this.printer.indent();
        }
        if (0 == action.code.size()) {
            this.newline = false;
        } else if (1 == action.code.size()) {
            this.newline = false;
            if (bl) {
                this.printer.p('^');
            }
            this.printer.p("{ ").p((String)action.code.get(0)).p(" }");
        } else {
            this.newline = true;
            if (bl) {
                this.printer.p('^');
            }
            this.printer.pln('{').incr();
            Iterator iterator = action.code.iterator();
            while (iterator.hasNext()) {
                this.printer.indent().pln((String)iterator.next());
            }
            this.printer.decr().indent().pln('}');
        }
    }

    public void visit(Action action) {
        this.action(action, false);
    }

    public void visit(ParserAction parserAction) {
        this.action((Action)parserAction.element, true);
    }

    public void visit(NullValue nullValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.p("/* value = null; */");
    }

    public void visit(StringValue stringValue) {
        if (this.newline) {
            this.printer.indent();
        }
        if (-1 == stringValue.text.indexOf("*/")) {
            this.newline = false;
            this.printer.p("/* value = \"").escape(stringValue.text, 4).p("\"; */");
        } else {
            this.newline = true;
            this.printer.p("// value = \"").escape(stringValue.text, 4).pln("\";");
        }
    }

    public void visit(TextValue textValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.p("/* value = <text>; */");
    }

    public void visit(EmptyListValue emptyListValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.p("/* value = []; */");
    }

    public void visit(SingletonListValue singletonListValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.p("/* value = [").p(singletonListValue.value).p("]; */");
    }

    public void visit(ListValue listValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.p("/* value = ").p(listValue.value).p(':').p(listValue.list).p("; */");
    }

    public void visit(GenericValue genericValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.p("/* value = GNode[");
        Iterator iterator = genericValue.children.iterator();
        while (iterator.hasNext()) {
            this.printer.p((String)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p("]; */");
    }
}

