/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.Iterator;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.CostEstimator;
import xtc.parser.Element;
import xtc.parser.Grammar;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Rats;
import xtc.parser.Sequence;
import xtc.parser.TextTester;
import xtc.parser.Type;
import xtc.parser.UnaryOperator;
import xtc.tree.Visitor;

public class Inliner
extends Visitor {
    public static final int MAX_COST = 1;
    public static final boolean INLINE_PERSISTENT = true;
    protected final Analyzer analyzer;
    protected boolean inlined;
    protected boolean isBound;

    public Inliner(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    protected boolean isBasic(Production production) {
        return Type.isVoidT(production.type) || TextTester.isTextOnly(production);
    }

    protected void inlined(Production production) {
        this.inlined = true;
        if (Rats.optionVerbose) {
            System.out.println("[Inlining production " + production.nonTerminal.name + " into " + this.analyzer.current().nonTerminal.name + "]");
        }
    }

    public Boolean visit(Grammar grammar) {
        if (Rats.optimizeCost) {
            grammar.accept(new CostEstimator(this.analyzer));
        }
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        this.inlined = false;
        Iterator iterator = grammar.productions.iterator();
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            if (!this.isBasic(production)) continue;
            this.analyzer.process(production);
        }
        return this.inlined ? Boolean.TRUE : Boolean.FALSE;
    }

    public void visit(Production production) {
        this.isBound = false;
        production.element = (Element)production.element.accept(this);
    }

    public Element visit(OrderedChoice orderedChoice) {
        this.isBound = false;
        int n = orderedChoice.options.size();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)orderedChoice.options.get(i);
            if (Rats.optimizeChoices) {
                Production production;
                element = this.analyzer.strip(element);
                if (this.analyzer.current().isTransient && element instanceof NonTerminal && this.isBasic(production = this.analyzer.lookup((NonTerminal)element)) && production.isTransient) {
                    element = this.analyzer.copy(production.element);
                    this.inlined(production);
                }
            }
            element = (Element)element.accept(this);
            orderedChoice.options.set(i, element);
        }
        return orderedChoice;
    }

    public Element visit(Sequence sequence) {
        this.isBound = false;
        int n = sequence.length();
        for (int i = 0; i < n; ++i) {
            sequence.elements.set(i, sequence.get(i).accept(this));
        }
        return sequence;
    }

    public Element visit(Binding binding) {
        this.isBound = true;
        binding.element = (Element)binding.element.accept(this);
        return binding;
    }

    public Element visit(NonTerminal nonTerminal) {
        if (this.isBound) {
            this.isBound = false;
            return nonTerminal;
        }
        Production production = this.analyzer.lookup(nonTerminal);
        if (Rats.optimizeCost && 1 >= CostEstimator.cost(production)) {
            this.inlined(production);
            return this.analyzer.copy(production.element);
        }
        return nonTerminal;
    }

    public CharCase visit(CharCase charCase) {
        this.isBound = false;
        if (null != charCase.element) {
            charCase.element = (Element)charCase.element.accept(this);
        }
        return charCase;
    }

    public Element visit(CharSwitch charSwitch) {
        this.isBound = false;
        int n = charSwitch.cases.size();
        for (int i = 0; i < n; ++i) {
            charSwitch.cases.set(i, ((CharCase)charSwitch.cases.get(i)).accept(this));
        }
        if (null != charSwitch.base) {
            charSwitch.base = (Element)charSwitch.base.accept(this);
        }
        return charSwitch;
    }

    public Element visit(UnaryOperator unaryOperator) {
        this.isBound = false;
        unaryOperator.element = (Element)unaryOperator.element.accept(this);
        return unaryOperator;
    }

    public Element visit(Element element) {
        this.isBound = false;
        return element;
    }
}

