/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import xtc.parser.Analyzer;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.EquivalenceTester;
import xtc.parser.Grammar;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Rats;
import xtc.parser.Sequence;
import xtc.parser.UnaryOperator;
import xtc.tree.Visitor;
import xtc.util.Utilities;

public class DuplicateProductionFolder
extends Visitor {
    public static final String DUPLICATES = "xtc.parser.DuplicateProductionFolder.Duplicates";
    protected final Analyzer analyzer;
    protected final Map folded;

    public DuplicateProductionFolder(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.folded = new HashMap();
    }

    public void visit(Grammar grammar) {
        boolean bl;
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        EquivalenceTester equivalenceTester = new EquivalenceTester();
        boolean bl2 = false;
        do {
            Production production;
            this.folded.clear();
            bl = false;
            int n = grammar.productions.size();
            for (int i = 0; i < n; ++i) {
                production = (Production)grammar.productions.get(i);
                if (this.analyzer.isTopLevel(production.nonTerminal) || this.analyzer.isMarked(production.nonTerminal)) continue;
                NonTerminal nonTerminal = null;
                Production production2 = null;
                List<String> list = null;
                for (int j = i + 1; j < n; ++j) {
                    Production production3 = (Production)grammar.productions.get(j);
                    if (this.analyzer.isTopLevel(production3.nonTerminal) || !equivalenceTester.areEquivalent(production, production3)) continue;
                    bl2 = true;
                    bl = true;
                    if (null == nonTerminal) {
                        nonTerminal = this.analyzer.shared();
                        production2 = production;
                        if (production.hasProperty(DUPLICATES)) {
                            list = (List)production.getProperty(DUPLICATES);
                        } else {
                            list = new ArrayList<String>();
                            list.add(production.nonTerminal.name);
                        }
                        this.folded.put(production.nonTerminal, nonTerminal);
                    }
                    if (production3.hasProperty(DUPLICATES)) {
                        list.addAll((List)production3.getProperty(DUPLICATES));
                    } else {
                        list.add(production3.nonTerminal.name);
                    }
                    this.analyzer.mark(production3.nonTerminal);
                    this.folded.put(production3.nonTerminal, nonTerminal);
                }
                if (null == nonTerminal) continue;
                production2 = new Production(production2.isTransient, production2.type, nonTerminal, production2.element);
                production2.setProperty(DUPLICATES, list);
                this.analyzer.remove(production);
                grammar.productions.remove(i);
                this.analyzer.startAdding();
                this.analyzer.add(production2);
                this.analyzer.addNewProductionsAt(i);
            }
            if (!bl) break;
            Iterator iterator = grammar.productions.iterator();
            while (iterator.hasNext()) {
                ((Production)iterator.next()).accept(this);
            }
            iterator = grammar.productions.iterator();
            while (iterator.hasNext()) {
                production = (Production)iterator.next();
                if (!this.analyzer.isMarked(production.nonTerminal)) continue;
                this.analyzer.unmark(production.nonTerminal);
                this.analyzer.remove(production);
                iterator.remove();
            }
        } while (bl);
        if (Rats.optionVerbose && bl2) {
            Iterator iterator = grammar.productions.iterator();
            while (iterator.hasNext()) {
                Production production = (Production)iterator.next();
                if (!production.hasProperty(DUPLICATES)) continue;
                System.out.println("[Folding " + Utilities.format((List)production.getProperty(DUPLICATES)) + " into " + production.nonTerminal.name + "]");
            }
        }
    }

    public void visit(Production production) {
        production.element = (Element)production.element.accept(this);
    }

    public Element visit(OrderedChoice orderedChoice) {
        int n = orderedChoice.options.size();
        for (int i = 0; i < n; ++i) {
            orderedChoice.options.set(i, ((Element)orderedChoice.options.get(i)).accept(this));
        }
        return orderedChoice;
    }

    public Element visit(Sequence sequence) {
        int n = sequence.length();
        for (int i = 0; i < n; ++i) {
            sequence.elements.set(i, sequence.get(i).accept(this));
        }
        return sequence;
    }

    public Element visit(NonTerminal nonTerminal) {
        NonTerminal nonTerminal2 = (NonTerminal)this.folded.get(nonTerminal);
        return null == nonTerminal2 ? nonTerminal : nonTerminal2;
    }

    public CharCase visit(CharCase charCase) {
        if (null != charCase.element) {
            charCase.element = (Element)charCase.element.accept(this);
        }
        return charCase;
    }

    public Element visit(CharSwitch charSwitch) {
        int n = charSwitch.cases.size();
        for (int i = 0; i < n; ++i) {
            charSwitch.cases.set(i, ((CharCase)charSwitch.cases.get(i)).accept(this));
        }
        if (null != charSwitch.base) {
            charSwitch.base = (Element)charSwitch.base.accept(this);
        }
        return charSwitch;
    }

    public Element visit(UnaryOperator unaryOperator) {
        unaryOperator.element = (Element)unaryOperator.element.accept(this);
        return unaryOperator;
    }

    public Element visit(Element element) {
        return element;
    }
}

