/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.Iterator;
import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.GenericValue;
import xtc.parser.Grammar;
import xtc.parser.ListValue;
import xtc.parser.NonTerminal;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.SingletonListValue;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.Terminal;
import xtc.parser.TextValue;
import xtc.parser.ValueElement;
import xtc.tree.Visitor;

public class CostEstimator
extends Visitor {
    public static final String COST = "xtc.parser.CostEstimator.Cost";
    protected final Analyzer analyzer;

    public CostEstimator(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void visit(Grammar grammar) {
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        Iterator iterator = grammar.productions.iterator();
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            if (production.hasProperty(COST)) continue;
            this.analyzer.process(production);
        }
    }

    public Integer visit(Production production) {
        this.analyzer.workingOn(production.nonTerminal);
        Integer n = (Integer)production.element.accept(this);
        this.analyzer.notWorkingOn(production.nonTerminal);
        production.setProperty(COST, n);
        return n;
    }

    public Integer visit(OrderedChoice orderedChoice) {
        int n = 0;
        Iterator iterator = orderedChoice.options.iterator();
        while (iterator.hasNext()) {
            n = CostEstimator.add(n, CostEstimator.unbox(((Element)iterator.next()).accept(this)));
        }
        return CostEstimator.box(n);
    }

    public Integer visit(Repetition repetition) {
        return CostEstimator.box(Integer.MAX_VALUE);
    }

    public Integer visit(Option option) {
        return CostEstimator.box(CostEstimator.add(1, CostEstimator.unbox(option.element.accept(this))));
    }

    public Integer visit(Sequence sequence) {
        int n = 0;
        Iterator iterator = sequence.elements.iterator();
        while (iterator.hasNext()) {
            n = CostEstimator.add(n, CostEstimator.unbox(((Element)iterator.next()).accept(this)));
        }
        return CostEstimator.box(n);
    }

    public Integer visit(Predicate predicate) {
        return CostEstimator.box(CostEstimator.add(1, CostEstimator.unbox(predicate.element.accept(this))));
    }

    public Integer visit(Binding binding) {
        return (Integer)binding.element.accept(this);
    }

    public Integer visit(StringMatch stringMatch) {
        return CostEstimator.box(CostEstimator.add(1, CostEstimator.unbox(stringMatch.element.accept(this))));
    }

    public Integer visit(NonTerminal nonTerminal) {
        if (this.analyzer.isBeingWorkedOn(nonTerminal)) {
            return CostEstimator.box(Integer.MAX_VALUE);
        }
        Production production = this.analyzer.lookup(nonTerminal);
        return CostEstimator.box(CostEstimator.add(1, CostEstimator.unbox(production.hasProperty(COST) ? production.getProperty(COST) : production.accept(this))));
    }

    public Integer visit(StringLiteral stringLiteral) {
        return CostEstimator.box(stringLiteral.text.length());
    }

    public Integer visit(CharCase charCase) {
        if (null == charCase.element) {
            return CostEstimator.box(0);
        }
        return (Integer)charCase.element.accept(this);
    }

    public Integer visit(CharSwitch charSwitch) {
        int n = 0;
        Iterator iterator = charSwitch.cases.iterator();
        while (iterator.hasNext()) {
            n = Math.max(n, CostEstimator.unbox(((Element)iterator.next()).accept(this)) + 1);
        }
        if (null == charSwitch.base) {
            n = Math.max(n, CostEstimator.unbox(charSwitch.base.accept(this)) + 1);
        }
        return CostEstimator.box(n);
    }

    public Integer visit(Terminal terminal) {
        return CostEstimator.box(1);
    }

    public Integer visit(Action action) {
        return CostEstimator.box(1);
    }

    public Integer visit(ParserAction parserAction) {
        return CostEstimator.box(Integer.MAX_VALUE);
    }

    public Integer visit(TextValue textValue) {
        return CostEstimator.box(1);
    }

    public Integer visit(SingletonListValue singletonListValue) {
        return CostEstimator.box(1);
    }

    public Integer visit(ListValue listValue) {
        return CostEstimator.box(1);
    }

    public Integer visit(GenericValue genericValue) {
        return CostEstimator.box(2);
    }

    public Integer visit(ValueElement valueElement) {
        return CostEstimator.box(0);
    }

    protected static int add(int n, int n2) {
        if (Integer.MAX_VALUE == n || Integer.MAX_VALUE == n2) {
            return Integer.MAX_VALUE;
        }
        long l = n + n2;
        if (Integer.MAX_VALUE < l) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    protected static Integer box(int n) {
        return new Integer(n);
    }

    protected static int unbox(Object object) {
        return (Integer)object;
    }

    public static int cost(Production production) {
        return production.hasProperty(COST) ? (Integer)production.getProperty(COST) : Integer.MAX_VALUE;
    }
}

