/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.AnyChar;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharClass;
import xtc.parser.CharLiteral;
import xtc.parser.CharRange;
import xtc.parser.CharSwitch;
import xtc.parser.CharTerminal;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.FollowedBy;
import xtc.parser.GenericValue;
import xtc.parser.Grammar;
import xtc.parser.ListValue;
import xtc.parser.MetaData;
import xtc.parser.NonTerminal;
import xtc.parser.NotFollowedBy;
import xtc.parser.NullValue;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.Rats;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.SingletonListValue;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.StringValue;
import xtc.parser.TextValue;
import xtc.parser.Type;
import xtc.tree.Attribute;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.util.Utilities;

public class CodeGenerator
extends Visitor {
    public static final String ATT_DEBUG = "debug";
    public static final String ATT_LOCATION = "location";
    public static final String ATT_CONSTANT_BINDING = "constantBinding";
    public static final String ATT_NO_MATCHING_ERRORS = "noMatchingErrors";
    public static final String ATT_MAIN_METHOD = "mainMethod";
    public static final int CHUNK_SIZE = 10;
    public static final String PREFIX_METHOD = "p";
    public static final String PREFIX_FIELD = "f";
    public static final String PREFIX = "yy";
    public static final String PARSE_CHAR = "character";
    public static final String FILE = "yyFile";
    public static final String LINE = "yyLine";
    public static final String COLUMN = "yyColumn";
    public static final String CHAR = "yyC";
    public static final String PARSER = "yyParser";
    public static final String NESTED_CHOICE = "yyChoice";
    public static final String REPETITION = "yyRepetition";
    public static final String REPEATED = "yyRepeated";
    public static final String RESULT = "yyResult";
    public static final String PARSE_ERROR = "yyError";
    public static final String PRED_RESULT = "yyPredResult";
    public static final String MATCHED = "yyPredMatched";
    public static final String VALUE = "yyValue";
    protected final Analyzer analyzer;
    protected final Printer printer;
    protected int alignment = 0;
    protected boolean attributeDebug;
    protected boolean attributeLocation;
    protected boolean attributeConstantBinding;
    protected boolean attributeNoMatchingErrors;
    protected boolean attributeMainMethod;
    protected String mainMethodNonterminal = null;
    protected String cName;
    protected boolean chunked;
    protected Map chunkMap;
    protected int chunkCount;
    protected boolean firstElement;
    protected boolean savedFirstElement;
    protected String baseParser;
    protected boolean useBaseParser;
    protected String savedBaseParser;
    protected boolean savedUseBaseParser;
    protected int choiceLevel;
    protected int repetitionLevel;
    protected int savedRepetitionLevel;
    protected boolean repeatOnce;
    protected boolean seenTest;
    protected boolean endsWithParseError;
    protected Iterator elementIter;
    protected String resultName;
    protected String bindingName;
    protected Element bindingElement;
    protected boolean predicate;
    protected boolean notFollowedBy;
    protected Iterator predicateIter;

    public CodeGenerator(Analyzer analyzer, Printer printer) {
        this.analyzer = analyzer;
        this.printer = printer;
    }

    public String fieldName(NonTerminal nonTerminal) {
        if (this.chunked) {
            return "yyChunk" + this.chunkMap.get(nonTerminal) + "." + PREFIX_FIELD + nonTerminal.name;
        }
        return PREFIX_FIELD + nonTerminal.name;
    }

    public String methodName(NonTerminal nonTerminal) {
        return PREFIX_METHOD + nonTerminal.name;
    }

    protected void alignment(boolean bl) {
        this.alignment = 0;
        if (bl) {
            this.alignment = Math.max(this.alignment, this.cName.length() + 1);
        }
        this.alignment = Math.max(this.alignment, "ParseError".length() + 1);
    }

    protected void mainMethod(String string) {
        int n = Math.max(7, this.cName.length() + 1);
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Parse the specified files.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param args The file names.");
        this.printer.indent().pln(" */");
        this.printer.indent().pln("public static void main(String[] args) {").incr();
        this.printer.indent().pln("if ((null == args) || (0 == args.length)) {").incr();
        this.printer.indent().pln("System.out.println(\"Usage: <file-name>+\");");
        this.printer.pln();
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("for (int i=0; i<args.length; i++) {").incr();
        this.printer.indent().p("System.out.println(\"Processing \" + args[i] + ").pln("\" ...\");");
        this.printer.pln();
        this.printer.indent().p("Reader").align(n + 2).pln("in = null;");
        this.printer.indent().pln("try {").incr();
        this.printer.indent().p("in").align(n + 3).pln("= new BufferedReader(new FileReader(args[i]));");
        this.printer.indent().p(this.cName).align(n).p("p  = new ").p(this.cName).pln("(in, args[i]);");
        this.printer.indent().p("Result").align(n).p("r  = p.p").p(string).pln("();");
        this.printer.pln();
        this.printer.indent().pln("if (r.hasValue()) {").incr();
        this.printer.indent().pln("SemanticValue v   = (SemanticValue)r;");
        this.printer.pln();
        this.printer.indent().pln("if (v.value instanceof GNode) {").incr();
        this.printer.indent().p("new Printer(System.out).incr().").pln("p((GNode)v.value).flush();");
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("System.out.println(\"  \" + v.value);");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("ParseError    err = (ParseError)r;");
        this.printer.indent().p("System.out.println(\"  \" + err.parser.location() + ").pln("\": \" + err.msg);");
        this.printer.decr().indent().pln("}");
        this.printer.pln();
        this.printer.decr().indent().pln("} catch (Throwable x) {").incr();
        this.printer.indent().pln("while (null != x.getCause()) {").incr();
        this.printer.indent().pln("x = x.getCause();");
        this.printer.decr().indent().pln("}");
        this.printer.indent().pln("System.out.println(\"  \" + x.toString());");
        this.printer.decr().indent().pln("} finally {").incr();
        this.printer.indent().pln("try {").incr();
        this.printer.indent().pln("in.close();");
        this.printer.decr().indent().pln("} catch (Throwable x) {");
        this.printer.indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.pln();
    }

    public void visit(Grammar grammar) {
        Object object;
        Object object2;
        this.analyzer.register(this);
        this.printer.register(this);
        this.analyzer.init(grammar);
        this.cName = grammar.cName;
        HashSet hashSet = null != grammar.attributes ? new HashSet(grammar.attributes) : new HashSet();
        this.attributeDebug = hashSet.contains(new Attribute(ATT_DEBUG));
        this.attributeLocation = hashSet.contains(new Attribute(ATT_LOCATION));
        this.attributeConstantBinding = hashSet.contains(new Attribute(ATT_CONSTANT_BINDING));
        this.attributeNoMatchingErrors = hashSet.contains(new Attribute(ATT_NO_MATCHING_ERRORS));
        Attribute attribute = new Attribute(ATT_MAIN_METHOD);
        this.attributeMainMethod = hashSet.contains(attribute);
        if (this.attributeMainMethod) {
            this.mainMethodNonterminal = (String)((Attribute)grammar.attributes.get((int)grammar.attributes.indexOf((Object)attribute))).value;
            if (null == this.mainMethodNonterminal) {
                this.mainMethodNonterminal = ((NonTerminal)grammar.topLevel.get((int)0)).name;
            }
        }
        this.chunked = false;
        this.chunkMap = null;
        this.chunkCount = 0;
        this.printer.sep();
        this.printer.indent().pln("// This file has been generated by");
        this.printer.indent().p("// Rats! Parser Generator, Version ").p("1.3.0").p(", ").pln("(C) 2004 Robert Grimm");
        Date date = new Date();
        this.printer.indent().p("// on ").p(DateFormat.getDateInstance(0).format(date)).p(" at ").p(DateFormat.getTimeInstance(2).format(date)).pln('.');
        this.printer.indent().pln("// Edit at your own risk.");
        this.printer.sep();
        this.printer.pln();
        if (null != grammar.pName) {
            this.printer.indent().p("package ").p(grammar.pName).pln(';');
            this.printer.pln();
        }
        this.printer.indent().pln("import java.io.Reader;");
        if (this.attributeMainMethod) {
            this.printer.indent().pln("import java.io.BufferedReader;");
            this.printer.indent().pln("import java.io.FileReader;");
        }
        this.printer.indent().pln("import java.io.IOException;");
        this.printer.pln();
        if (grammar.getBooleanProperty("xtc.parser.Generifier.Generic")) {
            this.printer.indent().pln("import java.util.ArrayList;");
            this.printer.pln();
        }
        this.printer.indent().pln("import xtc.util.Pair;");
        this.printer.pln();
        if (this.attributeLocation || grammar.getBooleanProperty("xtc.parser.Generifier.Generic") || this.attributeMainMethod) {
            if (this.attributeLocation) {
                this.printer.indent().pln("import xtc.tree.Node;");
            }
            if (grammar.getBooleanProperty("xtc.parser.Generifier.Generic") || this.attributeMainMethod) {
                this.printer.indent().pln("import xtc.tree.GNode;");
            }
            if (this.attributeMainMethod) {
                this.printer.indent().pln("import xtc.tree.Printer;");
            }
            this.printer.pln();
        }
        this.printer.indent().pln("import xtc.parser.PackratParser;");
        this.printer.indent().pln("import xtc.parser.Result;");
        this.printer.indent().pln("import xtc.parser.SemanticValue;");
        this.printer.indent().pln("import xtc.parser.ParseError;");
        this.printer.pln();
        if (null != grammar.header) {
            this.action(grammar.header);
            this.printer.pln();
        }
        this.printer.indent().pln("/**");
        if (null != grammar.location) {
            this.printer.indent().p(" * Packrat parser for grammar ").p(grammar.location.file).pln('.');
        } else {
            this.printer.indent().pln(" * Packrat parser.");
        }
        this.printer.indent().pln(" *");
        this.printer.indent().p(" * This class has been generated by the ").pln("<i>Rats&#033;</i> parser generator,");
        this.printer.indent().p(" * version ").p("1.3.0").pln(", (C) 2004 Robert Grimm.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("public final class ").p(this.cName).pln(" extends PackratParser {").incr();
        this.printer.pln();
        if (this.attributeDebug) {
            this.printer.indent().p("/** Flag for whether to emit debugging information while ").pln("parsing. */");
            this.printer.indent().pln("public static final boolean DEBUG = true;");
            this.printer.pln();
        }
        int n = 0;
        Iterator iterator = grammar.productions.iterator();
        while (iterator.hasNext()) {
            object2 = (Production)iterator.next();
            object = (MetaData)((Node)object2).getProperty("xtc.parser.MetaData");
            if (1 >= ((MetaData)object).usageCount || ((Production)object2).isTransient) continue;
            ++n;
        }
        if (Rats.optimizeChunks && 10 <= n) {
            this.chunked = true;
            this.chunkMap = new HashMap(n * 4 / 3);
            object2 = null;
            object = null;
            int n2 = 10;
            boolean bl = true;
            iterator = grammar.productions.iterator();
            while (iterator.hasNext()) {
                Production production = (Production)iterator.next();
                MetaData metaData = (MetaData)production.getProperty("xtc.parser.MetaData");
                if (1 >= metaData.usageCount || Rats.optimizeTransient && production.isTransient) continue;
                if (10 <= n2) {
                    ++this.chunkCount;
                    object2 = new Integer(this.chunkCount);
                    object = Integer.toString(this.chunkCount);
                    n2 = 0;
                    if (bl) {
                        bl = false;
                        this.printer.sep();
                    } else {
                        this.printer.decr().indent().pln('}');
                    }
                    this.printer.pln();
                    this.printer.indent().p("/** Chunk ").p((String)object).pln(" of memoized results. */");
                    this.printer.indent().p("static final class Chunk").p((String)object).pln(" {").incr();
                }
                NonTerminal nonTerminal = production.nonTerminal;
                this.chunkMap.put(nonTerminal, object2);
                ++n2;
                this.printer.indent().p("Result ").p(PREFIX_FIELD).p(nonTerminal.name).pln(';');
            }
            this.printer.decr().indent().pln('}');
            this.printer.pln();
        }
        this.printer.sep().pln();
        if (this.chunked) {
            for (int i = 1; i <= this.chunkCount; ++i) {
                this.printer.indent().p("private Chunk").p(i).p(' ').p(PREFIX).p("Chunk").p(i).pln(';');
            }
        } else {
            iterator = grammar.productions.iterator();
            while (iterator.hasNext()) {
                object2 = (Production)iterator.next();
                object = (MetaData)((Node)object2).getProperty("xtc.parser.MetaData");
                if (Rats.optimizeChunks && 1 >= ((MetaData)object).usageCount || Rats.optimizeTransient && ((Production)object2).isTransient) continue;
                this.printer.indent().p("private Result ").p(this.fieldName(((Production)object2).nonTerminal)).pln(';');
            }
        }
        this.printer.pln();
        this.printer.sep().pln();
        this.printer.indent().pln("/** Create a new packrat parser for the specified file. */");
        this.printer.indent().p("public ").p(this.cName).pln("(Reader reader, String file) {").incr();
        this.printer.indent().pln("super(reader, file);");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().p("/** Create a new packrat parser, moving ahead one ").pln("character. */");
        this.printer.indent().p("protected ").p(this.cName).p('(').p(this.cName).pln(" previous) {").incr();
        this.printer.indent().pln("super(previous);");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.sep().pln();
        this.printer.indent().pln("protected PackratParser next() {").incr();
        this.printer.indent().p("return new ").p(this.cName).pln("(this);");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        iterator = grammar.productions.iterator();
        while (iterator.hasNext()) {
            this.analyzer.process((Production)iterator.next());
        }
        if (null != grammar.body) {
            this.printer.sep().pln();
            this.action(grammar.body);
            this.printer.pln();
        }
        if (this.attributeMainMethod) {
            this.mainMethod(this.mainMethodNonterminal);
        }
        this.printer.decr().indent().pln('}');
        if (null != grammar.footer) {
            this.printer.pln().sep().pln();
            this.action(grammar.footer);
        }
    }

    public void visit(Production production) {
        Object object;
        MetaData metaData = (MetaData)production.getProperty("xtc.parser.MetaData");
        String string = this.fieldName(production.nonTerminal);
        String string2 = this.methodName(production.nonTerminal);
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Parse ");
        if (production.getBooleanProperty("xtc.Constants.Synthetic")) {
            this.printer.p("synthetic ");
        }
        this.printer.p("nonterminal ").p(production.nonTerminal.name).pln('.');
        if (production.hasProperty("xtc.parser.DuplicateProductionFolder.Duplicates")) {
            object = (List)production.getProperty("xtc.parser.DuplicateProductionFolder.Duplicates");
            this.printer.indent().pln(" * This nonterminal represents the duplicate productions ").indent().p(" * ").p(Utilities.format((List)object)).pln('.');
        }
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @return The result.");
        this.printer.indent().pln(" * @throws IOException Signals an I/O error.");
        this.printer.indent().pln(" */");
        this.printer.indent();
        if (this.analyzer.isTopLevel(production.nonTerminal)) {
            this.printer.p("public");
        } else {
            this.printer.p("private");
        }
        this.printer.p(" Result ").p(string2).pln("() throws IOException {").incr();
        if (!(Rats.optimizeChunks && 1 >= metaData.usageCount || Rats.optimizeTransient && production.isTransient)) {
            if (this.chunked) {
                object = this.chunkMap.get(production.nonTerminal).toString();
                this.printer.indent().p("if (null == ").p(PREFIX).p("Chunk").p((String)object).p(") ").p(PREFIX).p("Chunk").p((String)object).p(" = new Chunk").p((String)object).pln("();");
            }
            this.printer.indent().p("if (null == ").p(string).p(") ").p(string).p(" = ").p(string2).pln("$1();");
            this.printer.indent().p("return ").p(string).pln(';');
            this.printer.decr().indent().pln('}');
            this.printer.pln();
            this.printer.indent().p("/** Actually parse ");
            if (production.hasProperty("xtc.Constants.Synthetic")) {
                this.printer.p("synthetic ");
            }
            this.printer.p("nonterminal ").p(production.nonTerminal.name).pln(". */");
            this.printer.indent().p("private Result ").p(string2).pln("$1() throws IOException {").incr();
            if (this.attributeDebug) {
                this.printer.indent().p("if (DEBUG) System.out.println(\"").p(string2).pln("$1: \" + toString());");
                this.printer.pln();
            }
        } else if (this.attributeDebug) {
            this.printer.indent().p("if (DEBUG) System.out.println(\"").p(string2).pln(": \" + toString());");
            this.printer.pln();
        }
        this.alignment(metaData.requiresParser || 0 < metaData.repetitions.size());
        if (metaData.requiresParser) {
            this.printer.indent().p(this.cName).align(this.alignment).p(PARSER).pln(';');
        }
        this.printer.indent().p("Result").align(this.alignment).p(RESULT).pln(';');
        this.printer.indent().p("ParseError").align(this.alignment).p(PARSE_ERROR).pln(" = ParseError.DUMMY;");
        if (metaData.requiresPredicate) {
            this.printer.indent().p("Result").align(this.alignment).p(PRED_RESULT).pln(';');
        }
        if (metaData.requiresMatched) {
            this.printer.indent().p("boolean").align(this.alignment).p(MATCHED).pln(';');
        }
        for (int i = 0; i < metaData.repetitions.size(); ++i) {
            this.printer.indent().p(this.cName).align(this.alignment).p(REPETITION).p(i + 1).pln(';');
            if (!((Boolean)metaData.repetitions.get(i)).booleanValue()) continue;
            this.printer.indent().p("boolean").align(this.alignment).p(REPEATED).p(i + 1).pln(';');
        }
        if (Type.isVoidT(production.type)) {
            this.printer.indent().p(Type.voidRefT()).align(Type.voidRefT().length(), this.alignment);
        } else {
            this.printer.indent().p(production.type).align(production.type.length(), this.alignment);
        }
        this.printer.p(VALUE).pln(';');
        if (metaData.requiresChar) {
            this.printer.indent().p(Type.charT()).align(this.alignment).p(CHAR).pln(';');
        }
        this.resultName = RESULT;
        this.baseParser = "this";
        this.useBaseParser = true;
        this.choiceLevel = -1;
        this.repetitionLevel = 0;
        this.savedRepetitionLevel = 0;
        this.repeatOnce = false;
        this.seenTest = false;
        this.endsWithParseError = false;
        production.element.accept(this);
        if (this.seenTest) {
            this.printer.pln();
            this.printer.indent().pln("// Done.");
            if (this.endsWithParseError) {
                this.parseError();
            }
            this.printer.indent().p("return ").p(PARSE_ERROR).pln(';');
        }
        this.printer.decr().indent().pln('}');
        this.printer.pln();
    }

    protected void result(String string, boolean bl) {
        this.printer.pln();
        this.firstElement = false;
        if (this.useBaseParser) {
            if (bl) {
                this.printer.indent().p(PARSER).p(" = ").p(this.baseParser).pln(';');
                this.printer.indent().p(this.resultName).p(" = ").p(PARSER).p('.').p(string).pln("();");
            } else {
                this.printer.indent().p(this.resultName).p(" = ").p(this.baseParser).p('.').p(string).pln("();");
            }
            if (!this.notFollowedBy() && !PARSE_CHAR.equals(string)) {
                this.printer.indent().p(PARSE_ERROR).p("  = ").p(PARSE_ERROR).p(".select(").p(this.resultName).pln(".parseError());");
            }
            this.useBaseParser = false;
        } else {
            if (bl) {
                this.printer.indent().p(PARSER).p(" = (").p(this.cName).p(')').p(this.resultName).pln(".parser;");
                this.printer.indent().p(this.resultName).p(" = ").p(PARSER).p('.').p(string).pln("();");
            } else {
                this.printer.indent().p(this.resultName).p(" = ((").p(this.cName).p(')').p(this.resultName).p(".parser).").p(string).pln("();");
            }
            if (!this.notFollowedBy() && !PARSE_CHAR.equals(string)) {
                this.printer.indent().p(PARSE_ERROR).p("  = ").p(PARSE_ERROR).p(".select(").p(this.resultName).pln(".parseError());");
            }
        }
    }

    protected void valueTest() {
        this.printer.indent().p("if (").p(this.resultName).pln(".hasValue()) {").incr();
    }

    protected void valueTest(String string) {
        this.printer.indent().p("if (").p(this.resultName).pln(".hasValue() &&").indent().p("   \"").escape(string, 4).p("\".equals(").p(this.resultName).pln(".semanticValue())) {").incr();
    }

    protected void tested() {
        this.seenTest = true;
    }

    protected void nextElement() {
        if (this.predicate) {
            if (this.predicateIter.hasNext()) {
                ((Element)this.predicateIter.next()).accept(this);
                return;
            }
            if (this.savedRepetitionLevel < this.repetitionLevel) {
                this.printer.pln();
                this.printer.indent().p(REPETITION).p(this.repetitionLevel).p(" = (").p(this.cName).p(')').p(this.resultName).pln(".parser;");
                if (this.repeatOnce) {
                    this.printer.indent().p(REPEATED).p(this.repetitionLevel).pln("   = true;");
                }
                this.printer.indent().pln("continue;");
                return;
            }
            if (this.notFollowedBy) {
                this.printer.pln();
                this.printer.indent().p(MATCHED).pln(" = true;");
                return;
            }
            this.predicate = false;
            this.baseParser = this.savedBaseParser;
            this.useBaseParser = this.savedUseBaseParser;
            this.resultName = RESULT;
        }
        if (this.elementIter.hasNext()) {
            ((Element)this.elementIter.next()).accept(this);
        } else if (0 < this.repetitionLevel) {
            this.printer.pln();
            this.printer.indent().p(REPETITION).p(this.repetitionLevel).p(" = (").p(this.cName).p(')').p(this.resultName).pln(".parser;");
            if (this.repeatOnce) {
                this.printer.indent().p(REPEATED).p(this.repetitionLevel).pln("   = true;");
            }
            this.printer.indent().pln("continue;");
        } else {
            this.returnValue();
        }
    }

    private void location() {
        if (!this.attributeLocation || Type.isNotANode(this.analyzer.current().type)) {
            return;
        }
        this.printer.indent().p("if (").p(VALUE).pln(" instanceof Node) {").incr();
        this.printer.indent().p("((Node)").p(VALUE).p(").").p("setLocation(").p(FILE).p(", ").p(LINE).p(", ").p(COLUMN).pln(");");
        this.printer.decr().indent().pln('}');
    }

    protected void returnValue() {
        this.printer.pln();
        if (this.useBaseParser) {
            this.location();
            this.printer.indent().p("return new SemanticValue(").p(VALUE).p(", ").p(this.baseParser).p(", ").p(PARSE_ERROR).pln(");");
            this.useBaseParser = false;
        } else {
            this.location();
            if (Rats.optimizeValues) {
                this.printer.indent().p("return ").p(RESULT).p(".createValue(").p(VALUE).p(", ").p(PARSE_ERROR).pln(");");
            } else {
                this.printer.indent().p("return new SemanticValue(").p(VALUE).p(", ").p(RESULT).p(".parser, ").p(PARSE_ERROR).pln(");");
            }
        }
    }

    protected void parseError() {
        this.printer.indent().p(PARSE_ERROR).p(" = ").p(PARSE_ERROR).p(".select(\"").p(Utilities.toDescription(this.analyzer.current().nonTerminal.name)).pln(" expected\", this);");
    }

    protected void parseError(String string) {
        this.printer.indent().p(PARSE_ERROR).p(" = ").p(PARSE_ERROR).p(".select(\"\\\"").p(Utilities.escape(string, 5)).p("\\\" expected\", ").p(PARSER).pln(");");
    }

    protected String nestedChoice() {
        return NESTED_CHOICE + Integer.toString(this.choiceLevel);
    }

    public void visit(OrderedChoice orderedChoice) {
        String string = this.baseParser;
        boolean bl = this.useBaseParser;
        ++this.choiceLevel;
        if (0 != this.choiceLevel) {
            this.printer.pln();
            if (this.useBaseParser) {
                this.printer.indent().p("final ").p(this.cName).p(' ').p(this.nestedChoice()).p(" = ").p(string).pln(';');
            } else {
                this.printer.indent().p("final ").p(this.cName).p(' ').p(this.nestedChoice()).p(" = (").p(this.cName).p(')').p(this.resultName).pln(".parser;");
            }
        }
        Iterator iterator = orderedChoice.options.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.elementIter = ((Sequence)iterator.next()).elements.iterator();
            this.firstElement = 0 == this.choiceLevel;
            this.baseParser = 0 == this.choiceLevel ? "this" : this.nestedChoice();
            this.useBaseParser = true;
            this.seenTest = false;
            ++n;
            this.printer.pln();
            if (0 == this.choiceLevel) {
                this.printer.indent().p("// Option ").p(n).pln('.');
            } else {
                this.printer.indent().p("// Nested option ").p(n).pln('.');
            }
            this.nextElement();
        }
        --this.choiceLevel;
        this.useBaseParser = bl;
        this.baseParser = string;
    }

    public void visit(Repetition repetition) {
        Iterator iterator;
        this.firstElement = false;
        String string = this.baseParser;
        boolean bl = this.useBaseParser;
        boolean bl2 = this.repeatOnce;
        this.repeatOnce = repetition.once;
        ++this.repetitionLevel;
        this.printer.pln();
        this.printer.indent().p(REPETITION).p(this.repetitionLevel).p(" = ");
        if (this.useBaseParser) {
            this.printer.p(string).pln(';');
        } else {
            this.printer.p('(').p(this.cName).p(')').p(this.resultName).pln(".parser;");
        }
        if (this.repeatOnce) {
            this.printer.indent().p(REPEATED).p(this.repetitionLevel).pln("   = false;");
        }
        if (this.predicate) {
            iterator = this.predicateIter;
            this.predicateIter = ((Sequence)repetition.element).elements.iterator();
        } else {
            iterator = this.elementIter;
            this.elementIter = ((Sequence)repetition.element).elements.iterator();
        }
        this.printer.indent().pln("while (true) {").incr();
        this.baseParser = REPETITION + Integer.toString(this.repetitionLevel);
        this.useBaseParser = true;
        this.nextElement();
        this.printer.indent().pln("break;");
        this.printer.decr().indent().pln('}');
        if (this.predicate) {
            this.predicateIter = iterator;
        } else {
            this.elementIter = iterator;
        }
        if (this.repeatOnce) {
            this.printer.pln();
            this.printer.indent().p("if (").p(REPEATED).p(this.repetitionLevel).pln(") {").incr();
        }
        --this.repetitionLevel;
        this.repeatOnce = bl2;
        this.baseParser = REPETITION + Integer.toString(this.repetitionLevel + 1);
        this.useBaseParser = true;
        if (!repetition.once) {
            this.seenTest = false;
        }
        this.nextElement();
        if (repetition.once) {
            this.printer.decr().indent().pln('}');
            this.tested();
        }
        this.baseParser = string;
        this.useBaseParser = bl;
    }

    public void visit(FollowedBy followedBy) {
        if (this.predicate) {
            throw new IllegalStateException("Predicate within predicate");
        }
        this.predicate = true;
        this.notFollowedBy = false;
        this.savedFirstElement = this.firstElement;
        this.savedBaseParser = this.baseParser;
        if (!this.useBaseParser) {
            this.baseParser = "((" + this.cName + ")" + RESULT + ".parser)";
        }
        this.savedUseBaseParser = this.useBaseParser;
        this.savedRepetitionLevel = this.repetitionLevel;
        this.useBaseParser = true;
        this.resultName = PRED_RESULT;
        this.predicateIter = ((Sequence)followedBy.element).elements.iterator();
        this.nextElement();
        this.tested();
    }

    protected boolean notFollowedBy() {
        return this.predicate && this.notFollowedBy;
    }

    public void visit(NotFollowedBy notFollowedBy) {
        if (this.predicate) {
            throw new IllegalStateException("Predicate within predicate");
        }
        this.predicate = true;
        this.notFollowedBy = true;
        this.savedFirstElement = this.firstElement;
        this.savedBaseParser = this.baseParser;
        if (!this.useBaseParser) {
            this.baseParser = "((" + this.cName + ")" + RESULT + ".parser)";
        }
        this.savedUseBaseParser = this.useBaseParser;
        this.useBaseParser = true;
        this.savedRepetitionLevel = this.repetitionLevel;
        this.resultName = PRED_RESULT;
        this.predicateIter = ((Sequence)notFollowedBy.element).elements.iterator();
        this.printer.pln();
        this.printer.indent().p(MATCHED).pln(" = false;");
        this.nextElement();
        this.predicate = false;
        this.firstElement = this.savedFirstElement;
        this.baseParser = this.savedBaseParser;
        this.useBaseParser = this.savedUseBaseParser;
        this.resultName = RESULT;
        this.printer.pln();
        this.printer.indent().p("if (! ").p(MATCHED).pln(") {").incr();
        this.nextElement();
        this.printer.decr().indent().pln("} else {").incr();
        this.parseError();
        this.printer.decr().indent().pln('}');
        this.tested();
    }

    public void visit(SemanticPredicate semanticPredicate) {
        this.printer.pln().indent().p("if (");
        Action action = (Action)semanticPredicate.element;
        if (1 == action.code.size()) {
            this.printer.p((String)action.code.get(0)).pln(") {").incr();
        } else {
            boolean bl = true;
            Iterator iterator = action.code.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    this.printer.p((String)iterator.next()).incr();
                    bl = false;
                } else {
                    this.printer.pln().indent().p((String)iterator.next());
                }
                this.printer.pln(") {");
            }
        }
        this.nextElement();
        this.printer.decr().indent().pln('}');
        if (!this.notFollowedBy()) {
            this.endsWithParseError = true;
        }
        this.tested();
    }

    public void visit(Binding binding) {
        String string = this.bindingName;
        Element element = this.bindingElement;
        this.bindingName = binding.name;
        this.bindingElement = binding.element;
        binding.element.accept(this);
        this.bindingName = string;
        this.bindingElement = element;
    }

    protected boolean hasBinding() {
        return null != this.bindingName;
    }

    protected void binding() {
        if (this.bindingElement instanceof NonTerminal) {
            String string = this.analyzer.lookup((NonTerminal)((NonTerminal)this.bindingElement)).type;
            this.binding1(string, this.bindingName, string, this.resultName + ".semanticValue()");
        } else if (this.bindingElement instanceof CharTerminal) {
            if (VALUE.equals(this.bindingName)) {
                this.binding1(Type.charRefT(), this.bindingName, null, "new Character(" + this.resultName + ".charValue())");
            } else {
                this.binding1(Type.charT(), this.bindingName, null, this.resultName + ".charValue()");
            }
        } else if (this.bindingElement instanceof StringLiteral) {
            this.binding1(Type.stringT(), this.bindingName, null, "\"" + Utilities.escape(((StringLiteral)this.bindingElement).text, 4) + "\"");
        } else if (this.bindingElement instanceof StringMatch) {
            this.binding1(Type.stringT(), this.bindingName, null, "\"" + Utilities.escape(((StringMatch)this.bindingElement).text, 4) + "\"");
        } else {
            throw new IllegalStateException("Unrecognized binding element " + this.bindingElement);
        }
    }

    private void binding1(String string, String string2, String string3, String string4) {
        this.printer.indent();
        if (VALUE.equals(string2)) {
            this.printer.p(VALUE).p(" = ");
        } else {
            if (this.attributeConstantBinding) {
                this.printer.p("final ");
            }
            this.printer.p(string).p(' ').p(string2).p(" = ");
        }
        if (null != string3) {
            this.printer.p('(').p(string3).p(')');
        }
        this.printer.p(string4).pln(';');
    }

    protected void clearBinding() {
        this.bindingName = null;
        this.bindingElement = null;
    }

    public void visit(StringMatch stringMatch) {
        boolean bl = this.firstElement;
        NonTerminal nonTerminal = (NonTerminal)stringMatch.element;
        this.result(this.methodName(nonTerminal), !this.notFollowedBy() && (!Rats.optimizeErrors || !bl));
        this.valueTest(stringMatch.text);
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        if (this.notFollowedBy()) {
            this.printer.decr().indent().pln('}');
        } else if (this.attributeNoMatchingErrors || Rats.optimizeErrors && bl) {
            this.printer.decr().indent().pln('}');
            this.endsWithParseError = true;
        } else {
            this.printer.decr().indent().pln("} else {").incr();
            this.parseError(stringMatch.text);
            this.printer.decr().indent().pln('}');
        }
        this.tested();
    }

    public void visit(NonTerminal nonTerminal) {
        this.result(this.methodName(nonTerminal), false);
        this.valueTest();
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        this.printer.decr().indent().pln('}');
        this.tested();
    }

    public void visit(AnyChar anyChar) {
        this.result(PARSE_CHAR, false);
        this.valueTest();
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        this.printer.decr().indent().pln('}');
        if (!this.notFollowedBy()) {
            this.endsWithParseError = true;
        }
        this.tested();
    }

    public void visit(CharLiteral charLiteral) {
        String string;
        this.result(PARSE_CHAR, false);
        this.valueTest();
        if (this.hasBinding()) {
            this.binding();
            string = this.bindingName;
            this.clearBinding();
        } else {
            this.printer.indent().p(CHAR).p(" = ").p(this.resultName).pln(".charValue();");
            string = CHAR;
        }
        this.printer.pln();
        this.printer.indent().p("if ('").escape(charLiteral.c, 4).p("' == ").p(string).pln(") {").incr();
        this.nextElement();
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        if (!this.notFollowedBy()) {
            this.endsWithParseError = true;
        }
        this.tested();
    }

    public void visit(CharClass charClass) {
        String string;
        this.result(PARSE_CHAR, false);
        this.valueTest();
        if (this.hasBinding()) {
            this.binding();
            string = this.bindingName;
            this.clearBinding();
        } else {
            this.printer.indent().p(CHAR).p(" = ").p(this.resultName).pln(".charValue();");
            string = CHAR;
        }
        this.printer.pln();
        int n = charClass.ranges.size();
        Iterator iterator = charClass.ranges.iterator();
        if (1 == n) {
            this.printer.indent().p("if ");
        } else {
            this.printer.indent().p("if (");
        }
        while (iterator.hasNext()) {
            CharRange charRange = (CharRange)iterator.next();
            if (charClass.exclusive) {
                if (charRange.first == charRange.last) {
                    this.printer.p("('").escape(charRange.first, 4).p("' != ").p(string).p(')');
                } else {
                    this.printer.p('(').p(string).p(" < '").escape(charRange.first, 4).p(") || ('").escape(charRange.last, 4).p("' < ").p(string).p("))");
                }
            } else if (charRange.first == charRange.last) {
                this.printer.p("('").escape(charRange.first, 4).p("' == ").p(string).p(')');
            } else {
                this.printer.p("(('").escape(charRange.first, 4).p("' <= ").p(string).p(") && (").p(string).p(" <= '").escape(charRange.last, 4).p("'))");
            }
            if (!iterator.hasNext()) continue;
            if (charClass.exclusive) {
                this.printer.pln(" &&");
            } else {
                this.printer.pln(" ||");
            }
            this.printer.indent().p("    ");
        }
        if (1 == n) {
            this.printer.pln(" {").incr();
        } else {
            this.printer.pln(") {").incr();
        }
        this.nextElement();
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        if (!this.notFollowedBy()) {
            this.endsWithParseError = true;
        }
        this.tested();
    }

    public void visit(StringLiteral stringLiteral) {
        int n;
        boolean bl = this.firstElement;
        int n2 = stringLiteral.text.length();
        for (n = 0; n < n2; ++n) {
            char c = stringLiteral.text.charAt(n);
            this.result(PARSE_CHAR, 0 == n && !this.notFollowedBy() && (!Rats.optimizeErrors || !bl));
            this.valueTest();
            this.printer.indent().p(CHAR).p(" = ").p(this.resultName).pln(".charValue();");
            this.printer.pln();
            this.printer.indent().p("if ('").escape(c, 4).p("' == ").p(CHAR).pln(") {").incr();
        }
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        for (n = 0; n < n2; ++n) {
            if (this.notFollowedBy()) {
                this.printer.decr().indent().pln('}');
                this.printer.decr().indent().pln('}');
                continue;
            }
            if (this.attributeNoMatchingErrors || Rats.optimizeErrors && bl) {
                this.printer.decr().indent().pln('}');
                this.printer.decr().indent().pln('}');
                this.endsWithParseError = true;
                continue;
            }
            this.printer.decr().indent().pln("} else {").incr();
            this.parseError(stringLiteral.text);
            this.printer.decr().indent().pln('}');
            this.printer.decr().indent().pln("} else {").incr();
            this.parseError(stringLiteral.text);
            this.printer.decr().indent().pln('}');
        }
        this.tested();
    }

    public void visit(CharSwitch charSwitch) {
        String string;
        this.result(PARSE_CHAR, false);
        this.valueTest();
        if (this.hasBinding()) {
            this.binding();
            string = this.bindingName;
            this.clearBinding();
        } else {
            this.printer.indent().p(CHAR).p(" = ").p(this.resultName).pln(".charValue();");
            string = CHAR;
        }
        this.printer.pln();
        this.printer.indent().p("switch (").p(string).pln(") {").incr();
        Iterator iterator = charSwitch.cases.iterator();
        while (iterator.hasNext()) {
            CharCase charCase = (CharCase)iterator.next();
            Iterator iterator2 = charCase.klass.ranges.iterator();
            while (iterator2.hasNext()) {
                CharRange charRange = (CharRange)iterator2.next();
                for (char c = charRange.first; c <= charRange.last; c = (char)(c + '\u0001')) {
                    this.printer.indentLess().p("case '").escape(c, 4).pln("':");
                }
            }
            if (null == charCase.element) {
                this.printer.indent().pln("/* No match. */");
                this.printer.indent().pln("break;");
            } else {
                this.printer.indent().p('{').incr();
                this.seenTest = false;
                if (charCase.element instanceof OrderedChoice) {
                    charCase.element.accept(this);
                } else {
                    this.elementIter = ((Sequence)charCase.element).elements.iterator();
                    this.nextElement();
                }
                this.printer.decr().indent().pln('}');
                if (this.seenTest) {
                    this.printer.indent().pln("break;");
                }
            }
            this.printer.pln();
        }
        if (null == charSwitch.base) {
            this.printer.indentLess().pln("default:");
            this.printer.indent().pln("/* No match. */");
        } else {
            this.printer.indentLess().pln("default:");
            this.printer.indent().p('{').incr();
            if (charSwitch.base instanceof OrderedChoice) {
                charSwitch.base.accept(this);
            } else {
                this.elementIter = ((Sequence)charSwitch.base).elements.iterator();
                this.nextElement();
            }
            this.printer.decr().indent().pln('}');
        }
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.endsWithParseError = true;
        this.tested();
    }

    protected void action(Action action) {
        Iterator iterator = action.code.iterator();
        while (iterator.hasNext()) {
            this.printer.indent().pln(iterator.next().toString());
        }
    }

    public void visit(Action action) {
        this.printer.pln();
        this.action(action);
        this.nextElement();
    }

    public void visit(ParserAction parserAction) {
        this.printer.pln();
        if (this.useBaseParser) {
            this.printer.indent().p(PARSER).p(" = ").p(this.baseParser).pln(';');
            this.useBaseParser = false;
        } else {
            this.printer.indent().p(PARSER).p(" = (").p(this.cName).p(')').p(this.resultName).pln(".parser;");
        }
        this.printer.pln();
        this.action((Action)parserAction.element);
        this.printer.pln();
        if (!this.notFollowedBy()) {
            this.printer.indent().p(PARSE_ERROR).p(" = ").p(PARSE_ERROR).p(".select(").p(this.resultName).pln(".parseError());");
        }
        this.valueTest();
        String string = Type.isVoidT(this.analyzer.current().type) ? Type.voidRefT() : this.analyzer.current().type;
        this.printer.indent().p(VALUE).p(" = (").p(string).p(')').p(RESULT).p(".semanticValue();");
        this.nextElement();
        this.printer.decr().indent().pln('}');
        this.tested();
    }

    public void visit(NullValue nullValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).pln(" = null;");
        this.nextElement();
    }

    public void visit(StringValue stringValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = \"").escape(stringValue.text, 4).pln("\";");
        this.nextElement();
    }

    public void visit(TextValue textValue) {
        if (this.predicate) {
            throw new IllegalStateException("Text value within predicate");
        }
        this.printer.pln();
        if (this.firstElement) {
            this.printer.indent().p(VALUE).pln(" = \"\";");
        } else if (this.useBaseParser) {
            this.printer.indent().p(VALUE).p(" = getDifference(").p(this.baseParser).pln(");");
        } else {
            this.printer.indent().p(VALUE).p(" = getDifference(").p(RESULT).pln(".parser);");
        }
        this.nextElement();
    }

    public void visit(EmptyListValue emptyListValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).pln(" = Pair.EMPTY;");
        this.nextElement();
    }

    public void visit(SingletonListValue singletonListValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = new Pair(").p(singletonListValue.value).pln(");");
        this.nextElement();
    }

    public void visit(ListValue listValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = new Pair(").p(listValue.value).p(", ").p(listValue.list).pln(");");
        this.nextElement();
    }

    public void visit(GenericValue genericValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = new GNode(\"").p(this.analyzer.current().nonTerminal.name).p("\", new ArrayList(").p(genericValue.children.size()).pln("));");
        Iterator iterator = genericValue.children.iterator();
        while (iterator.hasNext()) {
            this.printer.indent().p(VALUE).p(".add(").p((String)iterator.next()).pln(");");
        }
        this.nextElement();
    }
}

