/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharClass;
import xtc.parser.CharRange;
import xtc.parser.Element;
import xtc.parser.Grammar;
import xtc.parser.InternalElement;
import xtc.parser.LeftRecurser;
import xtc.parser.NonTerminal;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.Terminal;
import xtc.parser.Type;
import xtc.tree.Attribute;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.util.Utilities;

public class Checker
extends Visitor {
    protected final Analyzer analyzer;
    protected String[] source;
    protected boolean error;
    protected boolean predicate;

    public Checker(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    protected void msg(String string, Node node) {
        String string2 = null != this.analyzer.current() ? this.analyzer.current().nonTerminal.name : null;
        System.err.println();
        Utilities.msg(string, node.location, string2, this.source);
        this.error = true;
    }

    public Boolean visit(Grammar grammar) {
        int n;
        Node node;
        int n2;
        int n3;
        LeftRecurser leftRecurser = new LeftRecurser(this.analyzer);
        grammar.accept(leftRecurser);
        Set set = leftRecurser.recursive();
        this.source = (String[])grammar.getProperty("xtc.Constants.Source");
        this.error = false;
        this.predicate = false;
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        if (null != grammar.attributes) {
            n3 = grammar.attributes.size();
            for (n2 = 0; n2 < n3; ++n2) {
                node = (Attribute)grammar.attributes.get(n2);
                if (!("location".equals(((Attribute)node).name) || "constantBinding".equals(((Attribute)node).name) || "debug".equals(((Attribute)node).name) || "noMatchingErrors".equals(((Attribute)node).name) || "mainMethod".equals(((Attribute)node).name))) {
                    this.msg("unrecognized option " + ((Attribute)node).name, node);
                } else {
                    for (n = 0; n < n2; ++n) {
                        if (!((Attribute)node).equals(grammar.attributes.get(n))) continue;
                        this.msg("duplicate option " + ((Attribute)node).name, node);
                        break;
                    }
                }
                if (!"mainMethod".equals(((Attribute)node).name)) continue;
                if (null == ((Attribute)node).value) {
                    if (1 == grammar.topLevel.size()) continue;
                    this.msg("mainMethod option without nonterminal value", node);
                    continue;
                }
                if (grammar.topLevel.contains(new NonTerminal((String)((Attribute)node).value))) continue;
                this.msg("non-top-level nonterminal " + ((Attribute)node).value, node);
            }
        }
        n3 = grammar.topLevel.size();
        block2: for (n2 = 0; n2 < n3; ++n2) {
            node = (NonTerminal)grammar.topLevel.get(n2);
            if (!this.analyzer.isDefined((NonTerminal)node)) {
                this.msg("undefined top-level nonterminal " + ((NonTerminal)node).name, node);
                continue;
            }
            if (Type.isVoidT(this.analyzer.lookup((NonTerminal)node).type)) {
                this.msg("void top-level nonterminal " + ((NonTerminal)node).name, node);
                continue;
            }
            for (n = 0; n < n2; ++n) {
                if (!((NonTerminal)node).equals(grammar.topLevel.get(n))) continue;
                this.msg("duplicate top-level nonterminal " + ((NonTerminal)node).name, node);
                continue block2;
            }
        }
        n3 = grammar.productions.size();
        block4: for (n2 = 0; n2 < n3; ++n2) {
            node = (Production)grammar.productions.get(n2);
            this.analyzer.process((Production)node);
            if (set.contains(((Production)node).nonTerminal)) {
                this.msg("left-recursive definition for nonterminal " + ((Production)node).nonTerminal.name, node);
            }
            for (n = 0; n < n2; ++n) {
                Production production = (Production)grammar.productions.get(n);
                if (!((Production)node).nonTerminal.equals(production.nonTerminal)) continue;
                this.msg("duplicate definition for nonterminal " + ((Production)node).nonTerminal.name, node);
                continue block4;
            }
        }
        return this.error ? Boolean.TRUE : Boolean.FALSE;
    }

    public void visit(Production production) {
        if (Type.isPrimitive(production.type)) {
            this.msg("primitive type " + production.type + " for production " + production.nonTerminal.name, production);
        }
        production.element.accept(this);
    }

    public void visit(OrderedChoice orderedChoice) {
        Iterator iterator = orderedChoice.options.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).accept(this);
        }
    }

    public void visit(Repetition repetition) {
        if (this.analyzer.strip(repetition.element) instanceof Action) {
            this.msg("repeated action", repetition);
        }
        repetition.element.accept(this);
    }

    public void visit(Option option) {
        if (this.analyzer.strip(option.element) instanceof Action) {
            this.msg("optional action", option);
        }
        option.element.accept(this);
    }

    public void visit(Sequence sequence) {
        Iterator iterator = sequence.elements.iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).accept(this);
        }
    }

    public void visit(Predicate predicate) {
        if (this.predicate) {
            this.msg("syntactic predicate within syntactic predicate", predicate);
        }
        boolean bl = this.predicate;
        this.predicate = true;
        predicate.element.accept(this);
        this.predicate = bl;
    }

    public void visit(SemanticPredicate semanticPredicate) {
        if (!(semanticPredicate.element instanceof Action)) {
            this.msg("malformed semantic predicate", semanticPredicate);
        } else {
            Action action = (Action)semanticPredicate.element;
            if (null == action.code || 0 >= action.code.size()) {
                this.msg("empty test for semantic predicate", semanticPredicate);
            }
        }
        semanticPredicate.element.accept(this);
    }

    public void visit(Binding binding) {
        Element element = this.analyzer.strip(binding.element);
        if (element instanceof NonTerminal) {
            NonTerminal nonTerminal = (NonTerminal)element;
            Production production = this.analyzer.lookup(nonTerminal);
            if (null != production && Type.isVoidT(production.type)) {
                this.msg("binding for void nonterminal " + nonTerminal.name, binding);
            }
        } else if (element instanceof Action) {
            this.msg("binding for action", binding);
        } else if (element instanceof ParserAction) {
            this.msg("binding for parser action", binding);
        }
        binding.element.accept(this);
    }

    public void visit(StringMatch stringMatch) {
        Element element = this.analyzer.strip(stringMatch.element);
        if (element instanceof Sequence) {
            this.msg("match for sequence", stringMatch);
        } else if (element instanceof NonTerminal) {
            NonTerminal nonTerminal = (NonTerminal)element;
            Production production = this.analyzer.lookup(nonTerminal);
            if (null != production && Type.isVoidT(production.type)) {
                this.msg("match for void nonterminal " + nonTerminal.name, stringMatch);
            }
        } else if (element instanceof Terminal) {
            this.msg("match for terminal", stringMatch);
        } else if (element instanceof Action) {
            this.msg("match for action", stringMatch);
        }
        stringMatch.element.accept(this);
    }

    public void visit(NonTerminal nonTerminal) {
        if (!this.analyzer.isDefined(nonTerminal)) {
            this.msg("undefined nonterminal " + nonTerminal.name, nonTerminal);
        }
    }

    public void visit(Terminal terminal) {
    }

    public void visit(StringLiteral stringLiteral) {
        if (0 == stringLiteral.text.length()) {
            this.msg("empty string literal", stringLiteral);
        }
    }

    public void visit(CharClass charClass) {
        int n = charClass.ranges.size();
        if (0 >= n) {
            this.msg("empty character class", charClass);
        } else {
            ArrayList arrayList = new ArrayList(charClass.ranges);
            Collections.sort(arrayList);
            for (int i = 0; i < n - 1; ++i) {
                boolean bl;
                CharRange charRange = (CharRange)arrayList.get(i);
                CharRange charRange2 = (CharRange)arrayList.get(i + 1);
                if (charRange.last < charRange2.first) continue;
                boolean bl2 = charRange.first == charRange.last;
                boolean bl3 = bl = charRange2.first == charRange2.last;
                if (bl2) {
                    if (bl) {
                        this.msg("duplicate character '" + Utilities.escape(charRange.last, 6) + "' in character class", charClass);
                        continue;
                    }
                    this.msg("character '" + Utilities.escape(charRange.last, 6) + "' already contained in range " + Utilities.escape(charRange2.first, 6) + "-" + Utilities.escape(charRange2.last, 6), charClass);
                    continue;
                }
                if (bl) {
                    this.msg("character '" + Utilities.escape(charRange2.first, 6) + "' already contained in range " + Utilities.escape(charRange.first, 6) + "-" + Utilities.escape(charRange.last, 6), charClass);
                    continue;
                }
                this.msg("ranges " + Utilities.escape(charRange.first, 6) + "-" + Utilities.escape(charRange.last, 6) + " and " + Utilities.escape(charRange2.first, 6) + "-" + Utilities.escape(charRange2.last, 6) + " overlap", charClass);
            }
        }
    }

    public void visit(Action action) {
    }

    public void visit(ParserAction parserAction) {
        if (!(parserAction.element instanceof Action)) {
            this.msg("malformed parser action", parserAction);
        }
        if (this.predicate) {
            this.msg("parser action within syntactic predicate", parserAction);
        }
        parserAction.element.accept(this);
    }

    public void visit(InternalElement internalElement) {
        this.msg("internal element", (Element)((Object)internalElement));
    }
}

