/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import xtc.parser.CharRange;
import xtc.parser.CharTerminal;
import xtc.util.Utilities;

public class CharClass
extends CharTerminal {
    public boolean exclusive;
    public List ranges;

    public CharClass(List list) {
        this(false, list);
    }

    public CharClass(boolean bl, List list) {
        this.exclusive = bl;
        this.ranges = list;
    }

    public CharClass(char c) {
        this.exclusive = false;
        this.ranges = new ArrayList(1);
        this.ranges.add(new CharRange(c));
    }

    public CharClass(String string) {
        this.exclusive = false;
        this.ranges = new ArrayList();
        Parser parser = new Parser(string);
        while (parser.hasNext()) {
            char c = parser.next();
            char c2 = parser.hasRange() ? parser.next() : c;
            this.ranges.add(new CharRange(c, c2));
        }
    }

    public CharClass normalize() {
        Collections.sort(this.ranges);
        for (int i = 0; i < this.ranges.size() - 1; ++i) {
            CharRange charRange = (CharRange)this.ranges.get(i);
            CharRange charRange2 = (CharRange)this.ranges.get(i + 1);
            if (charRange.last >= charRange2.last) {
                this.ranges.remove(i + 1);
                --i;
                continue;
            }
            if (charRange.last < charRange2.first - '\u0001') continue;
            this.ranges.set(i, new CharRange(charRange.first, charRange2.last));
            this.ranges.remove(i + 1);
            --i;
        }
        return this;
    }

    public boolean overlaps(CharClass charClass) {
        Iterator iterator = charClass.ranges.iterator();
        while (iterator.hasNext()) {
            CharRange charRange = (CharRange)iterator.next();
            Iterator iterator2 = this.ranges.iterator();
            while (iterator2.hasNext()) {
                CharRange charRange2 = (CharRange)iterator2.next();
                if (!charRange.contains(charRange2.first) && !charRange.contains(charRange2.last) && !charRange2.contains(charRange.first) && !charRange2.contains(charRange.last)) continue;
                return true;
            }
        }
        return false;
    }

    public int count() {
        int n = 0;
        Iterator iterator = this.ranges.iterator();
        while (iterator.hasNext()) {
            n += ((CharRange)iterator.next()).count();
        }
        return n;
    }

    public int hashCode() {
        int n = 0;
        Iterator iterator = this.ranges.iterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CharClass)) {
            return false;
        }
        CharClass charClass = (CharClass)object;
        if (this.exclusive != charClass.exclusive) {
            return false;
        }
        if (this.ranges.size() != charClass.ranges.size()) {
            return false;
        }
        return this.ranges.containsAll(charClass.ranges);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.exclusive) {
            stringBuffer.append('!');
        }
        stringBuffer.append('[');
        Iterator iterator = this.ranges.iterator();
        while (iterator.hasNext()) {
            CharRange charRange = (CharRange)iterator.next();
            if (charRange.first == charRange.last) {
                Utilities.escape(charRange.first, stringBuffer, 6);
                continue;
            }
            Utilities.escape(charRange.first, stringBuffer, 6);
            stringBuffer.append('-');
            Utilities.escape(charRange.last, stringBuffer, 6);
        }
        stringBuffer.append(']');
        if (this.exclusive) {
            stringBuffer.append(" .");
        }
        return stringBuffer.toString();
    }

    public static class Parser {
        protected String s;
        protected int idx;

        public Parser(String string) {
            this.s = string;
            this.idx = 0;
        }

        public boolean hasNext() {
            return this.idx < this.s.length();
        }

        public boolean hasRange() {
            if (this.idx >= this.s.length()) {
                return false;
            }
            char c = this.s.charAt(this.idx);
            if ('-' == c) {
                ++this.idx;
                return true;
            }
            return false;
        }

        public char next() {
            char c = this.s.charAt(this.idx);
            ++this.idx;
            if ('\\' != c) {
                return c;
            }
            c = this.s.charAt(this.idx);
            ++this.idx;
            switch (c) {
                case 'b': {
                    return '\b';
                }
                case 't': {
                    return '\t';
                }
                case 'n': {
                    return '\n';
                }
                case 'f': {
                    return '\f';
                }
                case 'r': {
                    return '\r';
                }
                case '\"': {
                    return '\"';
                }
                case '\'': {
                    return '\'';
                }
                case '-': {
                    return '-';
                }
                case '[': {
                    return '[';
                }
                case '\\': {
                    return '\\';
                }
                case ']': {
                    return ']';
                }
                case 'u': {
                    int n;
                    this.idx += 4;
                    try {
                        n = Integer.parseInt(this.s.substring(this.idx - 4, this.idx), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Illegal Unicode escape ('\\u" + this.s.substring(this.idx - 4, this.idx) + "')");
                    }
                    return (char)n;
                }
            }
            throw new IllegalArgumentException("Illegal character escape ('\\" + c + "')");
        }
    }
}

